/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRotationPolicyCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MeteredStream;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.FilePermission;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class MultifileTextWriter
implements ServerShutdownListener,
TextWriter,
ConfigurationChangeListener<SizeLimitLogRotationPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String UTF8_ENCODING = "UTF-8";
    private CopyOnWriteArrayList<RotationPolicy> rotationPolicies = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<RetentionPolicy> retentionPolicies = new CopyOnWriteArrayList();
    private FileNamingPolicy namingPolicy;
    private FilePermission filePermissions;
    private LogPublisherErrorHandler errorHandler;
    private ArrayList<ActionType> actions;
    private String name;
    private String encoding;
    private int bufferSize;
    private boolean autoFlush;
    private boolean append;
    private long interval;
    private boolean stopRequested;
    private long sizeLimit = 0L;
    private Thread rotaterThread;
    private Calendar lastRotationTime = TimeThread.getCalendar();
    private Calendar lastCleanTime = TimeThread.getCalendar();
    private long lastCleanCount = 0L;
    private long totalFilesRotated = 0L;
    private long totalFilesCleaned = 0L;
    private MeteredStream outputStream;
    private BufferedWriter writer;

    public MultifileTextWriter(String name, long interval, FileNamingPolicy namingPolicy, FilePermission filePermissions, LogPublisherErrorHandler errorHandler, String encoding, boolean autoFlush, boolean append, int bufferSize) throws IOException, DirectoryException {
        File file = namingPolicy.getInitialName();
        this.constructWriter(file, filePermissions, encoding, append, bufferSize);
        this.name = name;
        this.interval = interval;
        this.namingPolicy = namingPolicy;
        this.filePermissions = filePermissions;
        this.errorHandler = errorHandler;
        this.encoding = UTF8_ENCODING;
        this.autoFlush = autoFlush;
        this.append = append;
        this.bufferSize = bufferSize;
        this.stopRequested = false;
        this.rotaterThread = new RotaterThread(this);
        this.rotaterThread.start();
        DirectoryServer.registerShutdownListener(this);
    }

    private void constructWriter(File file, FilePermission filePermissions, String encoding, boolean append, int bufferSize) throws IOException, DirectoryException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream stream = new FileOutputStream(file, append);
        this.outputStream = new MeteredStream(stream, file.length());
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)this.outputStream, encoding);
        Object bw = null;
        this.writer = bufferSize <= 0 ? new BufferedWriter(osw) : new BufferedWriter(osw, bufferSize);
        if (FilePermission.canSetPermissions()) {
            try {
                if (!FilePermission.setPermissions(file, filePermissions)) {
                    Message message = LoggerMessages.WARN_LOGGER_UNABLE_SET_PERMISSIONS.get(filePermissions.toString(), file.toString());
                    ErrorLogger.logError(message);
                }
            }
            catch (Exception e) {
                Message message = LoggerMessages.WARN_LOGGER_SET_PERMISSION_FAILED.get(file.toString(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
        }
    }

    public void addRotationPolicy(RotationPolicy policy) {
        this.rotationPolicies.add(policy);
        if (policy instanceof SizeBasedRotationPolicy) {
            SizeBasedRotationPolicy sizePolicy = (SizeBasedRotationPolicy)policy;
            if (this.sizeLimit == 0L || this.sizeLimit > sizePolicy.currentConfig.getFileSizeLimit()) {
                this.sizeLimit = sizePolicy.currentConfig.getFileSizeLimit();
            }
            sizePolicy.currentConfig.addSizeLimitChangeListener(this);
        }
    }

    public void addRetentionPolicy(RetentionPolicy policy) {
        this.retentionPolicies.add(policy);
    }

    public void removeAllRotationPolicies() {
        for (RotationPolicy policy : this.rotationPolicies) {
            if (!(policy instanceof SizeBasedRotationPolicy)) continue;
            this.sizeLimit = 0L;
            SizeBasedRotationPolicy sizePolicy = (SizeBasedRotationPolicy)policy;
            sizePolicy.currentConfig.removeSizeLimitChangeListener(this);
        }
        this.rotationPolicies.clear();
    }

    public void removeAllRetentionPolicies() {
        this.retentionPolicies.clear();
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setFilePermissions(FilePermission filePermissions) {
        this.filePermissions = filePermissions;
    }

    public FileNamingPolicy getNamingPolicy() {
        return this.namingPolicy;
    }

    public void setNamingPolicy(FileNamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        if (this.rotaterThread.getState() == Thread.State.TIMED_WAITING) {
            this.rotaterThread.interrupt();
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRotationPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRotationPolicyCfg config) {
        long newSizeLimit = Integer.MAX_VALUE;
        for (RotationPolicy policy : this.rotationPolicies) {
            if (!(policy instanceof SizeBasedRotationPolicy)) continue;
            SizeBasedRotationPolicy sizePolicy = (SizeBasedRotationPolicy)policy;
            if (sizePolicy.currentConfig.dn().equals(config.dn())) {
                if (newSizeLimit <= config.getFileSizeLimit()) continue;
                newSizeLimit = config.getFileSizeLimit();
                continue;
            }
            if (newSizeLimit <= sizePolicy.currentConfig.getFileSizeLimit()) continue;
            newSizeLimit = sizePolicy.currentConfig.getFileSizeLimit();
        }
        this.sizeLimit = newSizeLimit;
        return new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
    }

    @Override
    public String getShutdownListenerName() {
        return "MultifileTextWriter Thread " + this.name;
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.stopRequested = true;
        while (this.rotaterThread != null && this.rotaterThread.isAlive()) {
            try {
                this.rotaterThread.interrupt();
                this.rotaterThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DirectoryServer.deregisterShutdownListener(this);
        this.removeAllRotationPolicies();
        this.removeAllRetentionPolicies();
    }

    private boolean isShuttingDown() {
        return this.stopRequested;
    }

    @Override
    public void shutdown() {
        this.processServerShutdown(null);
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            this.errorHandler.handleCloseError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecord(String record) {
        int length;
        int size = length = record.length();
        for (int i = 0; i < length; ++i) {
            char c = record.charAt(i);
            if (c == (byte)(c & 0x7F)) continue;
            try {
                size = record.getBytes(UTF8_ENCODING).length;
            }
            catch (Exception e) {
                size = length * 2;
            }
            break;
        }
        MultifileTextWriter multifileTextWriter = this;
        synchronized (multifileTextWriter) {
            if (this.sizeLimit > 0L && this.outputStream.written + (long)size + 1L >= this.sizeLimit) {
                this.rotate();
            }
            try {
                this.writer.write(record);
                this.writer.newLine();
            }
            catch (Exception e) {
                this.errorHandler.handleWriteError(record, e);
            }
            if (this.autoFlush) {
                this.flush();
            }
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.errorHandler.handleFlushError(e);
        }
    }

    public synchronized void rotate() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.errorHandler.handleCloseError(e);
        }
        File currentFile = this.namingPolicy.getInitialName();
        File newFile = this.namingPolicy.getNextName();
        currentFile.renameTo(newFile);
        try {
            this.constructWriter(currentFile, this.filePermissions, this.encoding, this.append, this.bufferSize);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.errorHandler.handleOpenError(currentFile, e);
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Log file %s rotated and renamed to %s", currentFile, newFile);
        }
        ++this.totalFilesRotated;
        this.lastRotationTime = TimeThread.getCalendar();
    }

    public void setPostRotationActions(ArrayList<ActionType> actions) {
        this.actions = actions;
    }

    @Override
    public long getBytesWritten() {
        return this.outputStream.written;
    }

    public Calendar getLastCleanTime() {
        return this.lastCleanTime;
    }

    public long getLastCleanCount() {
        return this.lastCleanCount;
    }

    public Calendar getLastRotationTime() {
        return this.lastRotationTime;
    }

    public long getTotalFilesRotated() {
        return this.totalFilesRotated;
    }

    public long getTotalFilesCleaned() {
        return this.totalFilesCleaned;
    }

    private class RotaterThread
    extends DirectoryThread {
        MultifileTextWriter writer;

        public RotaterThread(MultifileTextWriter writer) {
            super(MultifileTextWriter.this.name);
            this.writer = writer;
        }

        @Override
        public void run() {
            while (!MultifileTextWriter.this.isShuttingDown()) {
                block10: {
                    try {
                        RotaterThread.sleep(MultifileTextWriter.this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block10;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                for (RotationPolicy rotationPolicy : MultifileTextWriter.this.rotationPolicies) {
                    if (!rotationPolicy.rotateFile(this.writer)) continue;
                    MultifileTextWriter.this.rotate();
                }
                for (RetentionPolicy retentionPolicy : MultifileTextWriter.this.retentionPolicies) {
                    try {
                        File[] files;
                        for (File file : files = retentionPolicy.deleteFiles(this.writer.getNamingPolicy())) {
                            file.delete();
                            MultifileTextWriter.this.totalFilesCleaned++;
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugInfo(retentionPolicy.toString() + " cleaned up log file %s", file.toString());
                        }
                        if (files.length <= 0) continue;
                        MultifileTextWriter.this.lastCleanTime = TimeThread.getCalendar();
                        MultifileTextWriter.this.lastCleanCount = files.length;
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        MultifileTextWriter.this.errorHandler.handleDeleteError(retentionPolicy, de);
                    }
                }
            }
        }
    }
}

