/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.TextWriter;

public class ParallelTextWriter
implements ServerShutdownListener,
TextWriter {
    private final TextWriter writer;
    private final ConcurrentLinkedQueue<String> queue;
    private final Semaphore queueSemaphore = new Semaphore(0, false);
    private String name;
    private AtomicBoolean stopRequested;
    private WriterThread writerThread;
    private boolean autoFlush;

    public ParallelTextWriter(String name, boolean autoFlush, TextWriter writer) {
        this.name = name;
        this.autoFlush = autoFlush;
        this.writer = writer;
        this.queue = new ConcurrentLinkedQueue();
        this.writerThread = null;
        this.stopRequested = new AtomicBoolean(false);
        this.writerThread = new WriterThread();
        this.writerThread.start();
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void writeRecord(String record) {
        if (this.writer != null && !this.stopRequested.get()) {
            this.queue.add(record);
            this.queueSemaphore.release();
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public long getBytesWritten() {
        return this.writer.getBytesWritten();
    }

    public TextWriter getWrappedWriter() {
        return this.writer;
    }

    @Override
    public String getShutdownListenerName() {
        return "ParallelTextWriter Thread " + this.name;
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdown(false);
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    public void shutdown(boolean shutdownWrapped) {
        this.stopRequested.set(true);
        while (this.writerThread != null && this.writerThread.isAlive()) {
            try {
                this.writerThread.interrupt();
                this.writerThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!this.queue.isEmpty()) {
            String message = this.queue.poll();
            this.writer.writeRecord(message);
        }
        if (shutdownWrapped && this.writer != null) {
            this.writer.shutdown();
        }
        DirectoryServer.deregisterShutdownListener(this);
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    private class WriterThread
    extends DirectoryThread {
        public WriterThread() {
            super(ParallelTextWriter.this.name);
        }

        @Override
        public void run() {
            while (!ParallelTextWriter.this.stopRequested.get()) {
                try {
                    String message;
                    if (!ParallelTextWriter.this.queueSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) continue;
                    for (int i = ParallelTextWriter.this.queueSemaphore.drainPermits() + 1; i > 0 && (message = (String)ParallelTextWriter.this.queue.poll()) != null; --i) {
                        ParallelTextWriter.this.writer.writeRecord(message);
                    }
                    if (!ParallelTextWriter.this.autoFlush) continue;
                    ParallelTextWriter.this.flush();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

