/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opends.messages.LoggerMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.SizeLimitLogRetentionPolicyCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.FileComparator;
import org.opends.server.loggers.FileNamingPolicy;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class SizeBasedRetentionPolicy
implements RetentionPolicy<SizeLimitLogRetentionPolicyCfg>,
ConfigurationChangeListener<SizeLimitLogRetentionPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final File[] EMPTY_FILE_LIST = new File[0];
    private long size = 0L;
    private FileComparator comparator;
    private SizeLimitLogRetentionPolicyCfg config;

    @Override
    public void initializeLogRetentionPolicy(SizeLimitLogRetentionPolicyCfg config) {
        this.size = config.getDiskSpaceUsed();
        this.comparator = new FileComparator();
        this.config = config;
        config.addSizeLimitChangeListener(this);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SizeLimitLogRetentionPolicyCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SizeLimitLogRetentionPolicyCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.size = config.getDiskSpaceUsed();
        this.config = config;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public File[] deleteFiles(FileNamingPolicy fileNamingPolicy) throws DirectoryException {
        int j;
        File[] files = fileNamingPolicy.listFiles();
        if (files == null) {
            Message message = LoggerMessages.ERR_LOGGER_ERROR_LISTING_FILES.get(fileNamingPolicy.getInitialName().toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        long totalLength = 0L;
        for (File file : files) {
            totalLength += file.length();
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Total size of files: %d, Max: %d", totalLength, this.size);
        }
        if (totalLength <= this.size) {
            return EMPTY_FILE_LIST;
        }
        long freeSpaceNeeded = totalLength - this.size;
        Arrays.sort(files, this.comparator);
        long freedSpace = 0L;
        for (j = files.length - 1; j >= 0 && (freedSpace += files[j].length()) < freeSpaceNeeded; --j) {
        }
        File[] filesToDelete = new File[files.length - j];
        System.arraycopy(files, j, filesToDelete, 0, filesToDelete.length);
        return filesToDelete;
    }

    public String toString() {
        return "Size Based Retention Policy " + this.config.dn().toString();
    }
}

