/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import org.opends.messages.Category;
import org.opends.messages.Message;
import org.opends.messages.Severity;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.TextWriter;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.util.TimeThread;

public class ThreadFilterTextErrorLogPublisher
extends ErrorLogPublisher<ErrorLogPublisherCfg> {
    private Thread thread;
    private TextWriter writer;

    public ThreadFilterTextErrorLogPublisher(Thread thread, TextWriter writer) {
        this.thread = thread;
        this.writer = writer;
    }

    @Override
    public void initializeLogPublisher(ErrorLogPublisherCfg config) throws ConfigException, InitializationException {
    }

    @Override
    public void close() {
        this.writer.shutdown();
    }

    @Override
    public void logError(Message message) {
        if (message != null) {
            Severity severity = message.getDescriptor().getSeverity();
            Category category = message.getDescriptor().getCategory();
            int msgId = message.getDescriptor().getId();
            Thread currentThread = Thread.currentThread();
            if (this.thread.equals(currentThread) || this.thread.getThreadGroup().equals(currentThread.getThreadGroup())) {
                StringBuilder sb = new StringBuilder();
                sb.append("[");
                sb.append(TimeThread.getLocalTime());
                sb.append("] category=").append((Object)category).append(" severity=").append((Object)severity).append(" msgID=").append(msgId).append(" msg=").append(message);
                this.writer.writeRecord(sb.toString());
            }
        }
    }

    @Override
    public DN getDN() {
        return null;
    }
}

