/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.LinkedList;
import java.util.List;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.MonitorProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ObjectClass;

public class BackendMonitor
extends MonitorProvider<MonitorProviderCfg> {
    private AttributeType backendIDType;
    private AttributeType baseDNType;
    private AttributeType entryCountType;
    private AttributeType baseDNEntryCountType;
    private AttributeType isPrivateType;
    private AttributeType writabilityModeType;
    private Backend backend;
    private String monitorName;
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public BackendMonitor(Backend backend) {
        this.backend = backend;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) {
        this.monitorName = this.backend.getBackendID() + " Backend";
        this.backendIDType = DirectoryConfig.getAttributeType("ds-backend-id", true);
        this.baseDNType = DirectoryConfig.getAttributeType("ds-backend-base-dn", true);
        this.entryCountType = DirectoryConfig.getAttributeType("ds-backend-entry-count", true);
        this.baseDNEntryCountType = DirectoryConfig.getAttributeType("ds-base-dn-entry-count", true);
        this.isPrivateType = DirectoryConfig.getAttributeType("ds-backend-is-private", true);
        this.writabilityModeType = DirectoryConfig.getAttributeType("ds-backend-writability-mode", true);
    }

    @Override
    public String getMonitorInstanceName() {
        return this.monitorName;
    }

    @Override
    public ObjectClass getMonitorObjectClass() {
        return DirectoryConfig.getObjectClass("ds-backend-monitor-entry", true);
    }

    @Override
    public List<Attribute> getMonitorData() {
        DN[] baseDNs;
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(Attributes.create(this.backendIDType, this.backend.getBackendID()));
        AttributeBuilder builder = new AttributeBuilder(this.baseDNType);
        for (DN dn : baseDNs = this.backend.getBaseDNs()) {
            builder.add(AttributeValues.create(this.baseDNType, dn.toString()));
        }
        attrs.add(builder.toAttribute());
        attrs.add(Attributes.create(this.isPrivateType, BooleanSyntax.createBooleanValue(this.backend.isPrivateBackend())));
        long backendCount = this.backend.getEntryCount();
        attrs.add(Attributes.create(this.entryCountType, String.valueOf(backendCount)));
        builder = new AttributeBuilder(this.baseDNEntryCountType);
        if (baseDNs.length != 1) {
            for (DN dn : baseDNs) {
                long entryCount;
                block6: {
                    entryCount = -1L;
                    try {
                        entryCount = this.backend.numSubordinates(dn, true) + 1L;
                    }
                    catch (Exception ex) {
                        if (!DebugLogger.debugEnabled()) break block6;
                        TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                    }
                }
                String s = entryCount + " " + dn.toString();
                builder.add(AttributeValues.create(this.baseDNEntryCountType, s));
            }
        } else {
            String s = backendCount + " " + baseDNs[0].toString();
            builder.add(AttributeValues.create(this.baseDNEntryCountType, s));
        }
        attrs.add(builder.toAttribute());
        attrs.add(Attributes.create(this.writabilityModeType, String.valueOf((Object)this.backend.getWritabilityMode())));
        return attrs;
    }
}

