/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.meta.ReferentialIntegrityPluginCfgDefn;
import org.opends.server.admin.std.server.PluginCfg;
import org.opends.server.admin.std.server.ReferentialIntegrityPluginCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.SubordinateModifyDNOperation;
import org.opends.server.util.StaticUtils;

public class ReferentialIntegrityPlugin
extends DirectoryServerPlugin<ReferentialIntegrityPluginCfg>
implements ConfigurationChangeListener<ReferentialIntegrityPluginCfg>,
ServerShutdownListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReferentialIntegrityPluginCfg currentConfiguration;
    private LinkedHashSet<AttributeType> attributeTypes = new LinkedHashSet();
    private Set<DN> baseDNs = new LinkedHashSet<DN>();
    private long interval;
    private boolean stopRequested = false;
    private static final String name = "Referential Integrity Background Update Thread";
    private String logFileName;
    private File logFile;
    private Thread backGroundThread = null;
    public static final String MODIFYDN_DNS = "modifyDNs";
    public static final String DELETE_DNS = "deleteDNs";
    private BufferedReader reader;
    private BufferedWriter writer;
    private LinkedHashMap<AttributeType, SearchFilter> attrFiltMap = new LinkedHashMap();

    @Override
    public final void initializePlugin(Set<PluginType> pluginTypes, ReferentialIntegrityPluginCfg pluginCfg) throws ConfigException {
        pluginCfg.addReferentialIntegrityChangeListener(this);
        LinkedList<Message> unacceptableReasons = new LinkedList<Message>();
        if (!this.isConfigurationAcceptable(pluginCfg, unacceptableReasons)) {
            throw new ConfigException(unacceptableReasons.getFirst());
        }
        this.applyConfigurationChange(pluginCfg);
        this.setUpLogFile(pluginCfg.getLogFile());
        this.interval = pluginCfg.getUpdateInterval();
        if (this.interval > 0L) {
            this.setUpBackGroundProcessing();
        }
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReferentialIntegrityPluginCfg newConfiguration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        LinkedHashSet<DN> newConfiguredBaseDNs = new LinkedHashSet<DN>();
        for (DN baseDN : newConfiguration.getBaseDN()) {
            newConfiguredBaseDNs.add(baseDN);
        }
        LinkedHashSet<AttributeType> newAttributeTypes = new LinkedHashSet<AttributeType>();
        for (AttributeType type : newConfiguration.getAttributeType()) {
            newAttributeTypes.add(type);
        }
        LinkedHashMap<AttributeType, SearchFilter> newAttrFiltMap = new LinkedHashMap<AttributeType, SearchFilter>();
        for (String attrFilt : newConfiguration.getCheckReferencesFilterCriteria()) {
            int sepInd = attrFilt.lastIndexOf(":");
            String attr = attrFilt.substring(0, sepInd);
            String filtStr = attrFilt.substring(sepInd + 1);
            AttributeType attrType = DirectoryServer.getAttributeType(attr.toLowerCase());
            try {
                SearchFilter filter = SearchFilter.createFilterFromString(filtStr);
                newAttrFiltMap.put(attrType, filter);
            }
            catch (DirectoryException de) {
                ErrorLogger.logError(de.getMessageObject());
            }
        }
        String newLogFileName = newConfiguration.getLogFile();
        if (this.logFileName != null && !this.logFileName.equals(newLogFileName)) {
            adminActionRequired = true;
            messages.add(PluginMessages.INFO_PLUGIN_REFERENT_LOGFILE_CHANGE_REQUIRES_RESTART.get(this.logFileName, newLogFileName));
        }
        this.baseDNs = newConfiguredBaseDNs;
        this.attributeTypes = newAttributeTypes;
        this.attrFiltMap = newAttrFiltMap;
        long newInterval = newConfiguration.getUpdateInterval();
        if (newConfiguration.isEnabled() && newInterval != this.interval) {
            this.processIntervalChange(newInterval, messages);
        }
        this.currentConfiguration = newConfiguration;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationAcceptable(PluginCfg configuration, List<Message> unacceptableReasons) {
        boolean isAcceptable = true;
        ReferentialIntegrityPluginCfg pluginCfg = (ReferentialIntegrityPluginCfg)configuration;
        block5: for (PluginCfgDefn.PluginType t : pluginCfg.getPluginType()) {
            switch (t) {
                case POSTOPERATIONDELETE: 
                case POSTOPERATIONMODIFYDN: 
                case SUBORDINATEMODIFYDN: 
                case SUBORDINATEDELETE: 
                case PREOPERATIONMODIFY: 
                case PREOPERATIONADD: {
                    continue block5;
                }
            }
            isAcceptable = false;
            unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_PLUGIN_TYPE.get(t.toString()));
        }
        Set<DN> cfgBaseDNs = pluginCfg.getBaseDN();
        if (cfgBaseDNs == null || cfgBaseDNs.isEmpty()) {
            cfgBaseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        SortedSet<AttributeType> theAttributeTypes = pluginCfg.getAttributeType();
        for (AttributeType type : theAttributeTypes) {
            if (!this.isAttributeSyntaxValid(type)) {
                isAcceptable = false;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_INVALID_ATTRIBUTE_SYNTAX.get(type.getNameOrOID(), type.getSyntax().getSyntaxName()));
            }
            for (DN baseDN : cfgBaseDNs) {
                Backend b = DirectoryServer.getBackend(baseDN);
                if (b == null || b.isIndexed(type, IndexType.EQUALITY)) continue;
                isAcceptable = false;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_ATTR_UNINDEXED.get(pluginCfg.dn().toString(), type.getNameOrOID(), b.getBackendID()));
            }
        }
        for (String attrFilt : pluginCfg.getCheckReferencesFilterCriteria()) {
            int sepInd = attrFilt.lastIndexOf(":");
            String attr = attrFilt.substring(0, sepInd).trim();
            String filtStr = attrFilt.substring(sepInd + 1).trim();
            AttributeType attrType = DirectoryServer.getAttributeType(attr.toLowerCase());
            if (attrType == null || !theAttributeTypes.contains(attrType)) {
                isAcceptable = false;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_ATTR_NOT_LISTED.get(attr));
            }
            try {
                SearchFilter.createFilterFromString(filtStr);
            }
            catch (DirectoryException de) {
                isAcceptable = false;
                unacceptableReasons.add(PluginMessages.ERR_PLUGIN_REFERENT_BAD_FILTER.get(filtStr, de.getMessage()));
            }
        }
        return isAcceptable;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReferentialIntegrityPluginCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        if (modifyDNOperation.getResultCode() != ResultCode.SUCCESS) {
            return PluginResult.PostOperation.continueOperationProcessing();
        }
        LinkedHashMap<DN, DN> modDNmap = (LinkedHashMap<DN, DN>)modifyDNOperation.getAttachment(MODIFYDN_DNS);
        if (modDNmap == null) {
            modDNmap = new LinkedHashMap<DN, DN>();
            modifyDNOperation.setAttachment(MODIFYDN_DNS, modDNmap);
        }
        DN oldEntryDN = modifyDNOperation.getOriginalEntry().getDN();
        DN newEntryDN = modifyDNOperation.getUpdatedEntry().getDN();
        modDNmap.put(oldEntryDN, newEntryDN);
        this.processModifyDN(modDNmap, this.interval != 0L);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        if (deleteOperation.getResultCode() != ResultCode.SUCCESS) {
            return PluginResult.PostOperation.continueOperationProcessing();
        }
        HashSet<DN> deleteDNset = (HashSet<DN>)deleteOperation.getAttachment(DELETE_DNS);
        if (deleteDNset == null) {
            deleteDNset = new HashSet<DN>();
            deleteOperation.setAttachment(MODIFYDN_DNS, deleteDNset);
        }
        deleteDNset.add(deleteOperation.getEntryDN());
        this.processDelete(deleteDNset, this.interval != 0L);
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.SubordinateModifyDN processSubordinateModifyDN(SubordinateModifyDNOperation modifyDNOperation, Entry oldEntry, Entry newEntry, List<Modification> modifications) {
        LinkedHashMap<DN, DN> modDNmap = (LinkedHashMap<DN, DN>)modifyDNOperation.getAttachment(MODIFYDN_DNS);
        if (modDNmap == null) {
            modDNmap = new LinkedHashMap<DN, DN>();
            modifyDNOperation.setAttachment(MODIFYDN_DNS, modDNmap);
        }
        modDNmap.put(oldEntry.getDN(), newEntry.getDN());
        return PluginResult.SubordinateModifyDN.continueOperationProcessing();
    }

    @Override
    public PluginResult.SubordinateDelete processSubordinateDelete(DeleteOperation deleteOperation, Entry entry) {
        HashSet<DN> deleteDNset = (HashSet<DN>)deleteOperation.getAttachment(DELETE_DNS);
        if (deleteDNset == null) {
            deleteDNset = new HashSet<DN>();
            deleteOperation.setAttachment(DELETE_DNS, deleteDNset);
        }
        deleteDNset.add(entry.getDN());
        return PluginResult.SubordinateDelete.continueOperationProcessing();
    }

    private boolean isAttributeSyntaxValid(AttributeType attribute) {
        return attribute.getSyntaxOID().equals("1.3.6.1.4.1.1466.115.121.1.12") || attribute.getSyntaxOID().equals("1.3.6.1.4.1.1466.115.121.1.34");
    }

    private void processIntervalChange(long newInterval, ArrayList<Message> msgs) {
        if (this.interval == 0L) {
            DirectoryServer.registerShutdownListener(this);
            this.interval = newInterval;
            msgs.add(PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_STARTING.get(Long.toString(this.interval)));
            this.setUpBackGroundProcessing();
        } else if (newInterval == 0L) {
            Message message = PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_STOPPING.get();
            msgs.add(message);
            this.processServerShutdown(message);
            this.interval = newInterval;
        } else {
            this.interval = newInterval;
            this.backGroundThread.interrupt();
            msgs.add(PluginMessages.INFO_PLUGIN_REFERENT_BACKGROUND_PROCESSING_UPDATE_INTERVAL_CHANGED.get(Long.toString(this.interval), Long.toString(newInterval)));
        }
    }

    private void processModifyDN(Map<DN, DN> modDNMap, boolean log) {
        if (modDNMap != null) {
            if (log) {
                this.writeLog(modDNMap);
            } else {
                for (DN baseDN : this.getBaseDNsToSearch()) {
                    this.doBaseDN(baseDN, modDNMap);
                }
            }
        }
    }

    private void processDelete(Set<DN> deleteDNset, boolean log) {
        if (log) {
            this.writeLog(deleteDNset);
        } else {
            for (DN baseDN : this.getBaseDNsToSearch()) {
                this.doBaseDN(baseDN, deleteDNset);
            }
        }
    }

    private void processModifyDN(DN oldEntryDN, DN newEntryDN) {
        for (DN baseDN : this.getBaseDNsToSearch()) {
            this.searchBaseDN(baseDN, oldEntryDN, newEntryDN);
        }
    }

    private Set<DN> getBaseDNsToSearch() {
        if (this.baseDNs.isEmpty()) {
            return DirectoryServer.getPublicNamingContexts().keySet();
        }
        return this.baseDNs;
    }

    private void searchBaseDN(DN baseDN, DN oldEntryDN, DN newEntryDN) {
        HashSet<SearchFilter> componentFilters = new HashSet<SearchFilter>();
        for (AttributeType attributeType : this.attributeTypes) {
            componentFilters.add(SearchFilter.createEqualityFilter(attributeType, AttributeValues.create(attributeType, oldEntryDN.toString())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        InternalSearchOperation operation = conn.processSearch(baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createORFilter(componentFilters), null);
        switch (operation.getResultCode()) {
            case SUCCESS: {
                break;
            }
            case NO_SUCH_OBJECT: {
                ErrorLogger.logError(PluginMessages.INFO_PLUGIN_REFERENT_SEARCH_NO_SUCH_OBJECT.get(baseDN.toString()));
                return;
            }
            default: {
                Message message1 = PluginMessages.ERR_PLUGIN_REFERENT_SEARCH_FAILED.get(String.valueOf(operation.getErrorMessage()));
                ErrorLogger.logError(message1);
                return;
            }
        }
        for (SearchResultEntry entry : operation.getSearchEntries()) {
            this.deleteAddAttributesEntry(entry, oldEntryDN, newEntryDN);
        }
    }

    private void doBaseDN(DN baseDN, Map<DN, DN> modifyDNmap) {
        for (Map.Entry<DN, DN> mapEntry : modifyDNmap.entrySet()) {
            this.searchBaseDN(baseDN, mapEntry.getKey(), mapEntry.getValue());
        }
    }

    private void doBaseDN(DN baseDN, Set<DN> deleteDNset) {
        for (DN deletedEntryDN : deleteDNset) {
            this.searchBaseDN(baseDN, deletedEntryDN, null);
        }
    }

    private void deleteAddAttributesEntry(Entry e, DN oldEntryDN, DN newEntryDN) {
        LinkedList<Modification> mods = new LinkedList<Modification>();
        DN entryDN = e.getDN();
        for (AttributeType type : this.attributeTypes) {
            AttributeValue value;
            if (!e.hasAttribute(type) || !e.hasValue(type, null, value = AttributeValues.create(type, oldEntryDN.toString()))) continue;
            mods.add(new Modification(ModificationType.DELETE, Attributes.create(type, value)));
            if (newEntryDN == null) continue;
            mods.add(new Modification(ModificationType.ADD, Attributes.create(type, newEntryDN.toString())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyOperation modifyOperation = conn.processModify(entryDN, mods);
        if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
            ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_MODIFY_FAILED.get(entryDN.toString(), String.valueOf(modifyOperation.getErrorMessage())));
        }
    }

    private void setUpLogFile(String logFileName) throws ConfigException {
        this.logFileName = logFileName;
        this.logFile = StaticUtils.getFileForPath(logFileName);
        try {
            if (!this.logFile.exists()) {
                this.logFile.createNewFile();
            }
        }
        catch (IOException io) {
            throw new ConfigException(PluginMessages.ERR_PLUGIN_REFERENT_CREATE_LOGFILE.get(io.getMessage()), (Throwable)io);
        }
    }

    private void setupWriter() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.logFile, true));
    }

    private void setupReader() throws IOException {
        this.reader = new BufferedReader(new FileReader(this.logFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(Map<DN, DN> modDNmap) {
        File file = this.logFile;
        synchronized (file) {
            try {
                this.setupWriter();
                for (Map.Entry<DN, DN> mapEntry : modDNmap.entrySet()) {
                    this.writer.write(mapEntry.getKey().toNormalizedString() + "\t" + mapEntry.getValue().toNormalizedString());
                    this.writer.newLine();
                }
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_CLOSE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog(Set<DN> deleteDNset) {
        File file = this.logFile;
        synchronized (file) {
            try {
                this.setupWriter();
                for (DN deletedEntryDN : deleteDNset) {
                    this.writer.write(deletedEntryDN.toNormalizedString());
                    this.writer.newLine();
                }
                this.writer.flush();
                this.writer.close();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_CLOSE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLog() {
        File file = this.logFile;
        synchronized (file) {
            try {
                String line;
                if (this.logFile.length() == 0L) {
                    return;
                }
                this.setupReader();
                while ((line = this.reader.readLine()) != null) {
                    try {
                        String[] a = line.split("[\t]");
                        DN origDn = DN.decode(a[0]);
                        if (a.length == 1) {
                            this.processDelete(Collections.singleton(origDn), false);
                            continue;
                        }
                        DN movedDN = DN.decode(a[1]);
                        this.processModifyDN(origDn, movedDN);
                    }
                    catch (DirectoryException ex) {
                        Message message = PluginMessages.ERR_PLUGIN_REFERENT_CANNOT_DECODE_STRING_AS_DN.get(ex.getMessage());
                        ErrorLogger.logError(message);
                    }
                }
                this.reader.close();
                this.logFile.delete();
                this.logFile.createNewFile();
            }
            catch (IOException io) {
                ErrorLogger.logError(PluginMessages.ERR_PLUGIN_REFERENT_REPLACE_LOGFILE.get(io.getMessage()));
            }
        }
    }

    @Override
    public String getShutdownListenerName() {
        return name;
    }

    @Override
    public final void finalizePlugin() {
        this.currentConfiguration.removeReferentialIntegrityChangeListener(this);
        if (this.interval > 0L) {
            this.processServerShutdown(null);
        }
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.stopRequested = true;
        while (this.backGroundThread != null && this.backGroundThread.isAlive()) {
            try {
                this.backGroundThread.interrupt();
                this.backGroundThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        DirectoryServer.deregisterShutdownListener(this);
        this.backGroundThread = null;
    }

    private long getInterval() {
        return this.interval * 1000L;
    }

    private void setUpBackGroundProcessing() {
        if (this.backGroundThread == null) {
            DirectoryServer.registerShutdownListener(this);
            this.stopRequested = false;
            this.backGroundThread = new BackGroundThread();
            this.backGroundThread.start();
        }
    }

    private boolean isShuttingDown() {
        return this.stopRequested;
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        Modification mod;
        ModificationType modType;
        if (!this.currentConfiguration.isCheckReferences()) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        List<Modification> mods = modifyOperation.getModifications();
        Entry entry = modifyOperation.getModifiedEntry();
        DN entryDN = entry.getDN();
        DN entryBaseDN = this.getEntryBaseDN(entryDN);
        if (entryBaseDN == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        Iterator<Modification> i$ = mods.iterator();
        while (i$.hasNext() && ((modType = (mod = i$.next()).getModificationType()) == ModificationType.ADD || modType == ModificationType.REPLACE)) {
            PluginResult.PreOperation result;
            Set<String> attrOptions;
            AttributeType attrType = mod.getAttribute().getAttributeType();
            Attribute modifiedAttribute = entry.getExactAttribute(attrType, attrOptions = mod.getAttribute().getOptions());
            if (modifiedAttribute == null || (result = this.isIntegrityMaintained(modifiedAttribute, entryDN, entryBaseDN)).getResultCode() == ResultCode.SUCCESS) continue;
            return result;
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        if (!this.currentConfiguration.isCheckReferences()) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        Entry entry = addOperation.getEntryToAdd();
        DN entryDN = entry.getDN();
        DN entryBaseDN = this.getEntryBaseDN(entryDN);
        if (entryBaseDN == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        for (AttributeType attrType : this.attributeTypes) {
            PluginResult.PreOperation result;
            List<Attribute> attrs = entry.getAttribute(attrType, false);
            if (attrs == null || (result = this.isIntegrityMaintained(attrs, entryDN, entryBaseDN)).getResultCode() == ResultCode.SUCCESS) continue;
            return result;
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    private PluginResult.PreOperation isIntegrityMaintained(List<Attribute> attrs, DN entryDN, DN entryBaseDN) {
        for (Attribute attr : attrs) {
            PluginResult.PreOperation result = this.isIntegrityMaintained(attr, entryDN, entryBaseDN);
            if (result == PluginResult.PreOperation.continueOperationProcessing()) continue;
            return result;
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    private PluginResult.PreOperation isIntegrityMaintained(Attribute attr, DN entryDN, DN entryBaseDN) {
        Iterator<AttributeValue> attrValIt = attr.iterator();
        try {
            while (attrValIt.hasNext()) {
                AttributeValue attrVal = attrValIt.next();
                Entry valueEntry = null;
                DN valueEntryDN = DN.decode(attrVal.getNormalizedValue());
                if (this.currentConfiguration.getCheckReferencesScopeCriteria() == ReferentialIntegrityPluginCfgDefn.CheckReferencesScopeCriteria.NAMING_CONTEXT) {
                    if (valueEntryDN.matchesBaseAndScope(entryBaseDN, SearchScope.SUBORDINATE_SUBTREE)) {
                        return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_REFERENT_NAMINGCONTEXT_MISMATCH.get(valueEntryDN.toString(), attr.getName(), entryDN.toString()));
                    }
                    valueEntry = DirectoryServer.getEntry(valueEntryDN);
                } else {
                    valueEntry = DirectoryServer.getEntry(valueEntryDN);
                }
                if (valueEntry == null) {
                    return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_REFERENT_ENTRY_MISSING.get(valueEntryDN.toString(), attr.getName(), entryDN.toString()));
                }
                SearchFilter filter = this.attrFiltMap.get(attr.getAttributeType());
                if (filter == null || filter.matchesEntry(valueEntry)) continue;
                return PluginResult.PreOperation.stopProcessing(ResultCode.CONSTRAINT_VIOLATION, PluginMessages.ERR_PLUGIN_REFERENT_FILTER_MISMATCH.get(valueEntry.getDN().toString(), attr.getName(), entryDN.toString(), filter.toString()));
            }
        }
        catch (DirectoryException de) {
            return PluginResult.PreOperation.stopProcessing(ResultCode.OTHER, PluginMessages.ERR_PLUGIN_REFERENT_EXCEPTION.get(de.getLocalizedMessage()));
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    private DN getEntryBaseDN(DN dn) {
        DN namingContext = null;
        if (this.baseDNs.isEmpty()) {
            this.baseDNs = DirectoryServer.getPublicNamingContexts().keySet();
        }
        for (DN baseDN : this.baseDNs) {
            if (!dn.matchesBaseAndScope(baseDN, SearchScope.SUBORDINATE_SUBTREE)) continue;
            namingContext = baseDN;
            break;
        }
        return namingContext;
    }

    private class BackGroundThread
    extends DirectoryThread {
        public BackGroundThread() {
            super(ReferentialIntegrityPlugin.name);
        }

        @Override
        public void run() {
            while (!ReferentialIntegrityPlugin.this.isShuttingDown()) {
                block4: {
                    try {
                        BackGroundThread.sleep(ReferentialIntegrityPlugin.this.getInterval());
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block4;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                ReferentialIntegrityPlugin.this.processLog();
            }
        }
    }
}

