/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.opends.messages.Message;
import org.opends.messages.PluginMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.PluginCfgDefn;
import org.opends.server.admin.std.meta.SambaPasswordPluginCfgDefn;
import org.opends.server.admin.std.server.SambaPasswordPluginCfg;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.extensions.PasswordModifyExtendedOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.operation.PostOperationExtendedOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.StaticUtils;

public final class SambaPasswordPlugin
extends DirectoryServerPlugin<SambaPasswordPluginCfg>
implements ConfigurationChangeListener<SambaPasswordPluginCfg> {
    private SambaPasswordPluginCfg config;
    private static final String SAMBA_LM_PASSWORD_ATTRIBUTE_NAME = "sambaLMPassword";
    private static final String SAMBA_NT_PASSWORD_ATTRIBUTE_NAME = "sambaNTPassword";
    private static final String SAMBA_SAM_ACCOUNT_OC_NAME = "sambaSAMAccount";
    private static final String SAMBA_PWD_LAST_SET_NAME = "sambaPwdLastSet";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String PWMOD_EXTOP_OID = "1.3.6.1.4.1.4203.1.11.1";
    private static final String MAGIC_STR = "KGS!@#$%";
    private static final TimeStampProvider DEFAULT_TIMESTAMP_PROVIDER = new TimeStampProvider(){

        @Override
        public long getCurrentTime() {
            return System.currentTimeMillis() / 1000L;
        }
    };
    private TimeStampProvider timeStampProvider = DEFAULT_TIMESTAMP_PROVIDER;

    private static byte[] addParity(byte[] key56) {
        int i;
        byte[] key64 = new byte[8];
        int[] key7 = new int[7];
        int[] key8 = new int[8];
        for (i = 0; i < 7; ++i) {
            key7[i] = key56[i] & 0xFF;
        }
        key8[0] = key7[0];
        key8[1] = key7[0] << 7 & 0xFF | key7[1] >> 1;
        key8[2] = key7[1] << 6 & 0xFF | key7[2] >> 2;
        key8[3] = key7[2] << 5 & 0xFF | key7[3] >> 3;
        key8[4] = key7[3] << 4 & 0xFF | key7[4] >> 4;
        key8[5] = key7[4] << 3 & 0xFF | key7[5] >> 5;
        key8[6] = key7[5] << 2 & 0xFF | key7[6] >> 6;
        key8[7] = key7[6] << 1;
        for (i = 0; i < 8; ++i) {
            key64[i] = (byte)SambaPasswordPlugin.setOddParity(key8[i]);
        }
        return key64;
    }

    private static String lmHash(String password) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        int length;
        byte[] oemPass = password.toUpperCase().getBytes("US-ASCII");
        if (oemPass.length < (length = 14)) {
            length = oemPass.length;
        }
        byte[] key1 = new byte[7];
        byte[] key2 = new byte[7];
        if (length <= 7) {
            System.arraycopy(oemPass, 0, key1, 0, length);
        } else {
            System.arraycopy(oemPass, 0, key1, 0, 7);
            System.arraycopy(oemPass, 7, key2, 0, length - 7);
        }
        SecretKeySpec lowKey = new SecretKeySpec(SambaPasswordPlugin.addParity(key1), "DES");
        SecretKeySpec highKey = new SecretKeySpec(SambaPasswordPlugin.addParity(key2), "DES");
        Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
        des.init(1, lowKey);
        byte[] lowHash = des.doFinal(MAGIC_STR.getBytes());
        des.init(1, highKey);
        byte[] highHash = des.doFinal(MAGIC_STR.getBytes());
        byte[] lmHash = new byte[16];
        System.arraycopy(lowHash, 0, lmHash, 0, 8);
        System.arraycopy(highHash, 0, lmHash, 8, 8);
        return StaticUtils.toLowerCase(StaticUtils.bytesToHexNoSpace(lmHash));
    }

    private static String ntHash(String password) throws NoSuchProviderException, UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] unicodePassword = password.getBytes("UnicodeLittleUnmarked");
        MD4MessageDigest md4 = new MD4MessageDigest();
        return StaticUtils.toLowerCase(StaticUtils.bytesToHexNoSpace(md4.digest(unicodePassword)));
    }

    private static int setOddParity(int parity) {
        boolean hasEvenBits;
        boolean bl = hasEvenBits = (parity >>> 7 ^ parity >>> 6 ^ parity >>> 5 ^ parity >>> 4 ^ parity >>> 3 ^ parity >>> 2 ^ parity >>> 1 & 1) == 0;
        if (hasEvenBits) {
            return parity | 1;
        }
        return parity & 0xFE;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SambaPasswordPluginCfg newConfig) {
        this.config = newConfig;
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationExtendedOperation extendedOperation) {
        block14: {
            if (!extendedOperation.getRequestOID().equals(PWMOD_EXTOP_OID)) {
                return PluginResult.PostOperation.continueOperationProcessing();
            }
            if (extendedOperation.getResultCode() != ResultCode.SUCCESS) {
                return PluginResult.PostOperation.continueOperationProcessing();
            }
            DN authDN = extendedOperation.getAuthorizationDN();
            DN sambaAdminDN = this.config.getSambaAdministratorDN();
            if (sambaAdminDN != null && !sambaAdminDN.isNullDN() && authDN.equals(sambaAdminDN)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("This operation will be skipped because it was performed by Samba admin user: " + sambaAdminDN);
                }
                return PluginResult.PostOperation.continueOperationProcessing();
            }
            DN dn = (DN)extendedOperation.getAttachment(PasswordModifyExtendedOperation.AUTHZ_DN_ATTACHMENT);
            if (dn == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("SambaPasswordPlugin: missing DN attachment");
                }
                return PluginResult.PostOperation.continueOperationProcessing();
            }
            String password = extendedOperation.getAttachment(PasswordModifyExtendedOperation.CLEAR_PWD_ATTACHMENT).toString();
            if (password == null) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("SambaPasswordPlugin: skipping syncing pre-encoded password");
                }
                return PluginResult.PostOperation.continueOperationProcessing();
            }
            List encPasswords = (List)extendedOperation.getAttachment(PasswordModifyExtendedOperation.ENCODED_PWD_ATTACHMENT);
            try {
                Entry entry = DirectoryServer.getEntry(dn);
                if (!this.isSynchronizable(entry)) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("The entry is not Samba object.");
                    }
                    return PluginResult.PostOperation.continueOperationProcessing();
                }
                InternalClientConnection connection = InternalClientConnection.getRootConnection();
                List<Modification> modifications = this.getModifications(password);
                List<LDAPAssertionRequestControl> controls = null;
                if (!encPasswords.isEmpty()) {
                    AttributeType pwdAttribute = (AttributeType)extendedOperation.getAttachment(PasswordModifyExtendedOperation.PWD_ATTRIBUTE_ATTACHMENT);
                    LDAPFilter filter = RawFilter.createEqualityFilter(pwdAttribute.getNameOrOID(), (ByteString)encPasswords.get(0));
                    LDAPAssertionRequestControl assertionControl = new LDAPAssertionRequestControl(true, filter);
                    controls = Collections.singletonList(assertionControl);
                }
                ModifyOperation modifyOperation = connection.processModify(dn, modifications, controls);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo(modifyOperation.getResultCode().toString());
                }
            }
            catch (DirectoryException e) {
                if (!DebugLogger.debugEnabled()) break block14;
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
            }
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        List<AttributeValue> passwords = modifyOperation.getNewPasswords();
        if (passwords == null) {
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        if (modifyOperation.isSynchronizationOperation()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Synchronization operation. Skipping.");
            }
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        DN authDN = modifyOperation.getAuthorizationDN();
        DN sambaAdminDN = this.config.getSambaAdministratorDN();
        if (sambaAdminDN != null && !sambaAdminDN.isNullDN() && authDN.equals(sambaAdminDN)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("This operation will be skipped because it was performed by Samba admin user: " + sambaAdminDN);
            }
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        if (!this.isSynchronizable(modifyOperation.getCurrentEntry())) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Skipping '" + modifyOperation.getEntryDN().toString() + "' because it does not have Samba object class.");
            }
            return PluginResult.PreOperation.continueOperationProcessing();
        }
        this.processModification(modifyOperation, passwords);
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public void initializePlugin(Set<PluginType> pluginTypes, SambaPasswordPluginCfg configuration) throws ConfigException, InitializationException {
        LinkedList<Message> messages = new LinkedList<Message>();
        if (!this.isConfigurationAcceptable(configuration, messages)) {
            for (Message m : messages) {
                ErrorLogger.logError(m);
            }
            throw new ConfigException(messages.poll());
        }
        configuration.addSambaPasswordChangeListener(this);
        this.config = configuration;
    }

    public boolean isConfigurationAcceptable(SambaPasswordPluginCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SambaPasswordPluginCfg newConfig, List<Message> messages) {
        SortedSet<PluginCfgDefn.PluginType> pluginTypes = newConfig.getPluginType();
        block3: for (PluginCfgDefn.PluginType t : pluginTypes) {
            switch (t) {
                case PREOPERATIONMODIFY: 
                case POSTOPERATIONEXTENDED: {
                    continue block3;
                }
            }
            messages.add(PluginMessages.ERR_PLUGIN_SAMBA_SYNC_INVALID_PLUGIN_TYPE.get(String.valueOf((Object)t)));
            return false;
        }
        return true;
    }

    private List<Modification> getModifications(String password) {
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        try {
            Attribute attribute;
            if (this.config.getPwdSyncPolicy().contains((Object)SambaPasswordPluginCfgDefn.PwdSyncPolicy.SYNC_NT_PASSWORD)) {
                attribute = Attributes.create(SAMBA_NT_PASSWORD_ATTRIBUTE_NAME, SambaPasswordPlugin.ntHash(password));
                modifications.add(new Modification(ModificationType.REPLACE, attribute));
            }
            if (this.config.getPwdSyncPolicy().contains((Object)SambaPasswordPluginCfgDefn.PwdSyncPolicy.SYNC_LM_PASSWORD)) {
                attribute = Attributes.create(SAMBA_LM_PASSWORD_ATTRIBUTE_NAME, SambaPasswordPlugin.lmHash(password));
                modifications.add(new Modification(ModificationType.REPLACE, attribute));
            }
            Attribute pwdLastSet = Attributes.create(SAMBA_PWD_LAST_SET_NAME, String.valueOf(this.timeStampProvider.getCurrentTime()));
            modifications.add(new Modification(ModificationType.REPLACE, pwdLastSet));
        }
        catch (Exception e) {
            PluginMessages.ERR_PLUGIN_SAMBA_SYNC_ENCODING.get(e.getMessage());
            if (DebugLogger.debugEnabled()) {
                TRACER.debugError(e.getMessage(), e);
            }
            modifications = null;
        }
        return modifications;
    }

    private boolean isSynchronizable(Entry entry) {
        Schema schema = DirectoryServer.getSchema();
        ObjectClass sambaOc = schema.getObjectClass(StaticUtils.toLowerCase(SAMBA_SAM_ACCOUNT_OC_NAME));
        if (sambaOc == null) {
            return false;
        }
        return entry.hasObjectClass(sambaOc);
    }

    private void processModification(PreOperationModifyOperation modifyOperation, List<AttributeValue> passwords) {
        block3: {
            String password = passwords.get(passwords.size() - 1).toString();
            try {
                for (Modification modification : this.getModifications(password)) {
                    modifyOperation.addModification(modification);
                }
            }
            catch (DirectoryException e) {
                PluginMessages.ERR_PLUGIN_SAMBA_SYNC_MODIFICATION_PROCESSING.get(e.getMessage());
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugError(e.getMessage());
            }
        }
    }

    void setTimeStampProvider(TimeStampProvider timeStampProvider) {
        this.timeStampProvider = timeStampProvider == null ? DEFAULT_TIMESTAMP_PROVIDER : timeStampProvider;
    }

    static interface TimeStampProvider {
        public long getCurrentTime();
    }

    static final class MD4MessageDigest
    extends MessageDigest {
        private final byte[] xBuf = new byte[4];
        private int xBufOff;
        private long byteCount;
        private static final int DIGEST_LENGTH = 16;
        private int H1;
        private int H2;
        private int H3;
        private int H4;
        private final int[] X = new int[16];
        private int xOff;
        private static final int S11 = 3;
        private static final int S12 = 7;
        private static final int S13 = 11;
        private static final int S14 = 19;
        private static final int S21 = 3;
        private static final int S22 = 5;
        private static final int S23 = 9;
        private static final int S24 = 13;
        private static final int S31 = 3;
        private static final int S32 = 9;
        private static final int S33 = 11;
        private static final int S34 = 15;

        MD4MessageDigest() {
            super("MD4");
            this.engineReset();
        }

        @Override
        public byte[] engineDigest() {
            byte[] digestBytes = new byte[16];
            this.finish();
            this.unpackWord(this.H1, digestBytes, 0);
            this.unpackWord(this.H2, digestBytes, 4);
            this.unpackWord(this.H3, digestBytes, 8);
            this.unpackWord(this.H4, digestBytes, 12);
            this.engineReset();
            return digestBytes;
        }

        @Override
        public void engineReset() {
            int i;
            this.byteCount = 0L;
            this.xBufOff = 0;
            for (i = 0; i < this.xBuf.length; ++i) {
                this.xBuf[i] = 0;
            }
            this.H1 = 1732584193;
            this.H2 = -271733879;
            this.H3 = -1732584194;
            this.H4 = 271733878;
            this.xOff = 0;
            for (i = 0; i != this.X.length; ++i) {
                this.X[i] = 0;
            }
        }

        @Override
        public void engineUpdate(byte input) {
            this.xBuf[this.xBufOff++] = input;
            if (this.xBufOff == this.xBuf.length) {
                this.processWord(this.xBuf, 0);
                this.xBufOff = 0;
            }
            ++this.byteCount;
        }

        @Override
        public void engineUpdate(byte[] in, int inOff, int len) {
            while (this.xBufOff != 0 && len > 0) {
                this.update(in[inOff]);
                ++inOff;
                --len;
            }
            while (len > this.xBuf.length) {
                this.processWord(in, inOff);
                inOff += this.xBuf.length;
                len -= this.xBuf.length;
                this.byteCount += (long)this.xBuf.length;
            }
            while (len > 0) {
                this.update(in[inOff]);
                ++inOff;
                --len;
            }
        }

        private int F(int u, int v, int w) {
            return u & v | ~u & w;
        }

        private void finish() {
            long bitLength = this.byteCount << 3;
            this.engineUpdate((byte)-128);
            while (this.xBufOff != 0) {
                this.engineUpdate((byte)0);
            }
            this.processLength(bitLength);
            this.processBlock();
        }

        private int G(int u, int v, int w) {
            return u & v | u & w | v & w;
        }

        private int H(int u, int v, int w) {
            return u ^ v ^ w;
        }

        private void processBlock() {
            int a = this.H1;
            int b = this.H2;
            int c = this.H3;
            int d = this.H4;
            a = this.rotateLeft(a + this.F(b, c, d) + this.X[0], 3);
            d = this.rotateLeft(d + this.F(a, b, c) + this.X[1], 7);
            c = this.rotateLeft(c + this.F(d, a, b) + this.X[2], 11);
            b = this.rotateLeft(b + this.F(c, d, a) + this.X[3], 19);
            a = this.rotateLeft(a + this.F(b, c, d) + this.X[4], 3);
            d = this.rotateLeft(d + this.F(a, b, c) + this.X[5], 7);
            c = this.rotateLeft(c + this.F(d, a, b) + this.X[6], 11);
            b = this.rotateLeft(b + this.F(c, d, a) + this.X[7], 19);
            a = this.rotateLeft(a + this.F(b, c, d) + this.X[8], 3);
            d = this.rotateLeft(d + this.F(a, b, c) + this.X[9], 7);
            c = this.rotateLeft(c + this.F(d, a, b) + this.X[10], 11);
            b = this.rotateLeft(b + this.F(c, d, a) + this.X[11], 19);
            a = this.rotateLeft(a + this.F(b, c, d) + this.X[12], 3);
            d = this.rotateLeft(d + this.F(a, b, c) + this.X[13], 7);
            c = this.rotateLeft(c + this.F(d, a, b) + this.X[14], 11);
            b = this.rotateLeft(b + this.F(c, d, a) + this.X[15], 19);
            a = this.rotateLeft(a + this.G(b, c, d) + this.X[0] + 1518500249, 3);
            d = this.rotateLeft(d + this.G(a, b, c) + this.X[4] + 1518500249, 5);
            c = this.rotateLeft(c + this.G(d, a, b) + this.X[8] + 1518500249, 9);
            b = this.rotateLeft(b + this.G(c, d, a) + this.X[12] + 1518500249, 13);
            a = this.rotateLeft(a + this.G(b, c, d) + this.X[1] + 1518500249, 3);
            d = this.rotateLeft(d + this.G(a, b, c) + this.X[5] + 1518500249, 5);
            c = this.rotateLeft(c + this.G(d, a, b) + this.X[9] + 1518500249, 9);
            b = this.rotateLeft(b + this.G(c, d, a) + this.X[13] + 1518500249, 13);
            a = this.rotateLeft(a + this.G(b, c, d) + this.X[2] + 1518500249, 3);
            d = this.rotateLeft(d + this.G(a, b, c) + this.X[6] + 1518500249, 5);
            c = this.rotateLeft(c + this.G(d, a, b) + this.X[10] + 1518500249, 9);
            b = this.rotateLeft(b + this.G(c, d, a) + this.X[14] + 1518500249, 13);
            a = this.rotateLeft(a + this.G(b, c, d) + this.X[3] + 1518500249, 3);
            d = this.rotateLeft(d + this.G(a, b, c) + this.X[7] + 1518500249, 5);
            c = this.rotateLeft(c + this.G(d, a, b) + this.X[11] + 1518500249, 9);
            b = this.rotateLeft(b + this.G(c, d, a) + this.X[15] + 1518500249, 13);
            a = this.rotateLeft(a + this.H(b, c, d) + this.X[0] + 1859775393, 3);
            d = this.rotateLeft(d + this.H(a, b, c) + this.X[8] + 1859775393, 9);
            c = this.rotateLeft(c + this.H(d, a, b) + this.X[4] + 1859775393, 11);
            b = this.rotateLeft(b + this.H(c, d, a) + this.X[12] + 1859775393, 15);
            a = this.rotateLeft(a + this.H(b, c, d) + this.X[2] + 1859775393, 3);
            d = this.rotateLeft(d + this.H(a, b, c) + this.X[10] + 1859775393, 9);
            c = this.rotateLeft(c + this.H(d, a, b) + this.X[6] + 1859775393, 11);
            b = this.rotateLeft(b + this.H(c, d, a) + this.X[14] + 1859775393, 15);
            a = this.rotateLeft(a + this.H(b, c, d) + this.X[1] + 1859775393, 3);
            d = this.rotateLeft(d + this.H(a, b, c) + this.X[9] + 1859775393, 9);
            c = this.rotateLeft(c + this.H(d, a, b) + this.X[5] + 1859775393, 11);
            b = this.rotateLeft(b + this.H(c, d, a) + this.X[13] + 1859775393, 15);
            a = this.rotateLeft(a + this.H(b, c, d) + this.X[3] + 1859775393, 3);
            d = this.rotateLeft(d + this.H(a, b, c) + this.X[11] + 1859775393, 9);
            c = this.rotateLeft(c + this.H(d, a, b) + this.X[7] + 1859775393, 11);
            b = this.rotateLeft(b + this.H(c, d, a) + this.X[15] + 1859775393, 15);
            this.H1 += a;
            this.H2 += b;
            this.H3 += c;
            this.H4 += d;
            this.xOff = 0;
            for (int i = 0; i != this.X.length; ++i) {
                this.X[i] = 0;
            }
        }

        private void processLength(long bitLength) {
            if (this.xOff > 14) {
                this.processBlock();
            }
            this.X[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
            this.X[15] = (int)(bitLength >>> 32);
        }

        private void processWord(byte[] in, int inOff) {
            this.X[this.xOff++] = in[inOff] & 0xFF | (in[inOff + 1] & 0xFF) << 8 | (in[inOff + 2] & 0xFF) << 16 | (in[inOff + 3] & 0xFF) << 24;
            if (this.xOff == 16) {
                this.processBlock();
            }
        }

        private int rotateLeft(int x, int n) {
            return x << n | x >>> 32 - n;
        }

        private void unpackWord(int word, byte[] out, int outOff) {
            out[outOff] = (byte)word;
            out[outOff + 1] = (byte)(word >>> 8);
            out[outOff + 2] = (byte)(word >>> 16);
            out[outOff + 3] = (byte)(word >>> 24);
        }
    }
}

