/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.SearchScope;

class HTTPAuthenticationConfig {
    private boolean basicAuthenticationSupported;
    private boolean customHeadersAuthenticationSupported;
    private String customHeaderUsername;
    private String customHeaderPassword;
    private DN searchBaseDN;
    private SearchScope searchScope;
    private String searchFilterTemplate;

    HTTPAuthenticationConfig() {
    }

    public boolean isBasicAuthenticationSupported() {
        return this.basicAuthenticationSupported;
    }

    public void setBasicAuthenticationSupported(boolean supported) {
        this.basicAuthenticationSupported = supported;
    }

    public boolean isCustomHeadersAuthenticationSupported() {
        return this.customHeadersAuthenticationSupported;
    }

    public void setCustomHeadersAuthenticationSupported(boolean supported) {
        this.customHeadersAuthenticationSupported = supported;
    }

    public String getCustomHeaderUsername() {
        return this.customHeaderUsername;
    }

    public void setCustomHeaderUsername(String customHeaderUsername) {
        this.customHeaderUsername = customHeaderUsername;
    }

    public String getCustomHeaderPassword() {
        return this.customHeaderPassword;
    }

    public void setCustomHeaderPassword(String customHeaderPassword) {
        this.customHeaderPassword = customHeaderPassword;
    }

    public DN getSearchBaseDN() {
        return this.searchBaseDN;
    }

    public void setSearchBaseDN(DN searchBaseDN) {
        this.searchBaseDN = searchBaseDN;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public void setSearchScope(SearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public String getSearchFilterTemplate() {
        return this.searchFilterTemplate;
    }

    public void setSearchFilterTemplate(String searchFilterTemplate) {
        this.searchFilterTemplate = searchFilterTemplate;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("basicAuth: ");
        if (!this.basicAuthenticationSupported) {
            sb.append("not ");
        }
        sb.append("supported, ");
        sb.append("customHeadersAuth: ");
        if (this.customHeadersAuthenticationSupported) {
            sb.append("usernameHeader=\"").append(this.customHeaderUsername).append("\",");
            sb.append("passwordHeader=\"").append(this.customHeaderPassword).append("\"");
        } else {
            sb.append("not supported, ");
        }
        sb.append("searchBaseDN: \"").append(this.searchBaseDN).append("\"");
        sb.append("searchScope: \"").append(this.searchScope).append("\"");
        sb.append("searchFilterTemplate: \"").append(this.searchFilterTemplate).append("\"");
        return sb.toString();
    }
}

