/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.http;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.Attribute;

public class HTTPStatistics
extends LDAPStatistics {
    private Map<String, AtomicInteger> requestMethodsTotalCount = new HashMap<String, AtomicInteger>();
    private Map<String, AtomicLong> requestMethodsTotalTime = new HashMap<String, AtomicLong>();
    private AtomicInteger requestsTotalCount = new AtomicInteger(0);

    public HTTPStatistics(String instanceName) {
        super(instanceName);
        List<String> supportedHttpMethods = Arrays.asList("delete", "get", "patch", "post", "put");
        for (String method : supportedHttpMethods) {
            this.requestMethodsTotalCount.put(method, new AtomicInteger(0));
            this.requestMethodsTotalTime.put(method, new AtomicLong(0L));
        }
    }

    @Override
    public void clearStatistics() {
        this.requestMethodsTotalCount.clear();
        this.requestMethodsTotalTime.clear();
        this.requestsTotalCount.set(0);
        super.clearStatistics();
    }

    @Override
    public List<Attribute> getMonitorData() {
        int totalCount = this.requestsTotalCount.get();
        HashMap<String, Integer> totalCountsSnapshot = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> entry : this.requestMethodsTotalCount.entrySet()) {
            totalCountsSnapshot.put(entry.getKey(), entry.getValue().get());
        }
        HashMap<String, Long> totalTimesSnapshot = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> entry1 : this.requestMethodsTotalTime.entrySet()) {
            totalTimesSnapshot.put(entry1.getKey(), entry1.getValue().get());
        }
        List<Attribute> results = super.getMonitorData();
        this.addAll(results, totalCountsSnapshot, "ds-mon-http-", "-requests-total-count");
        this.addAll(results, totalTimesSnapshot, "ds-mon-resident-time-http-", "-requests-total-time");
        results.add(this.createAttribute("ds-mon-http-requests-total-count", Integer.toString(totalCount)));
        return results;
    }

    private void addAll(List<Attribute> results, Map<String, ?> toOutput, String prefix, String suffix) {
        for (Map.Entry<String, ?> entry : toOutput.entrySet()) {
            String httpMethod = entry.getKey();
            String nb = entry.getValue().toString();
            results.add(this.createAttribute(prefix + httpMethod + suffix, nb));
        }
    }

    public void addRequest(String httpMethod) throws NullPointerException {
        AtomicInteger nb = this.requestMethodsTotalCount.get(httpMethod.toLowerCase());
        if (nb != null) {
            nb.incrementAndGet();
        }
        this.requestsTotalCount.incrementAndGet();
    }

    public void updateRequestMonitoringData(String httpMethod, long time) throws NullPointerException {
        AtomicLong nb = this.requestMethodsTotalTime.get(httpMethod.toLowerCase());
        if (nb != null) {
            nb.addAndGet(time);
        }
    }
}

