/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.core.AddOperation;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperationBasis;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Modification;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

public class JmxClientConnection
extends ClientConnection
implements NotificationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicInteger nextMessageID;
    private AtomicLong nextOperationID;
    private LinkedList<Operation> operationList;
    private long connectionID;
    protected String jmxConnectionID = null;
    private JmxConnectionHandler jmxConnectionHandler;
    private boolean disconnectStarted = false;

    public JmxClientConnection(JmxConnectionHandler jmxConnectionHandler, AuthenticationInfo authInfo) {
        this.setNetworkGroup(NetworkGroup.getAdminNetworkGroup());
        this.nextMessageID = new AtomicInteger(1);
        this.nextOperationID = new AtomicLong(0L);
        this.jmxConnectionHandler = jmxConnectionHandler;
        jmxConnectionHandler.registerClientConnection(this);
        this.setAuthenticationInfo(authInfo);
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
        if (this.connectionID < 0L) {
            this.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, ProtocolMessages.ERR_CONNHANDLER_REJECTED_BY_SERVER.get());
        }
        this.operationList = new LinkedList();
        jmxConnectionHandler.getRMIConnector().jmxRmiConnectorNoClientCertificate.addNotificationListener(this, null, null);
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        if (!(notif instanceof JMXConnectionNotification)) {
            return;
        }
        JMXConnectionNotification jcn = (JMXConnectionNotification)notif;
        if (!jcn.getType().equals("jmx.remote.connection.closed") && !jcn.getType().equals("jmx.remote.connection.failed")) {
            return;
        }
        if (!jcn.getConnectionId().equals(this.jmxConnectionID)) {
            return;
        }
        this.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextOperationID() {
        long opID = this.nextOperationID.getAndIncrement();
        if (opID < 0L) {
            AtomicLong atomicLong = this.nextOperationID;
            synchronized (atomicLong) {
                if (this.nextOperationID.get() < 0L) {
                    this.nextOperationID.set(1L);
                    return 0L;
                }
                return this.nextOperationID.getAndIncrement();
            }
        }
        return opID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextMessageID() {
        int msgID = this.nextMessageID.getAndIncrement();
        if (msgID < 0) {
            AtomicInteger atomicInteger = this.nextMessageID;
            synchronized (atomicInteger) {
                if (this.nextMessageID.get() < 0) {
                    this.nextMessageID.set(2);
                    return 1;
                }
                return this.nextMessageID.getAndIncrement();
            }
        }
        return msgID;
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    public ConnectionHandler<?> getConnectionHandler() {
        return this.jmxConnectionHandler;
    }

    @Override
    public String getProtocol() {
        return "jmx";
    }

    @Override
    public String getClientAddress() {
        return "jmx";
    }

    @Override
    public int getClientPort() {
        return -1;
    }

    @Override
    public String getServerAddress() {
        return "jmx";
    }

    @Override
    public int getServerPort() {
        return -1;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public boolean isConnectionValid() {
        return !this.disconnectStarted;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    public String getSecurityMechanism() {
        return "NULL";
    }

    @Override
    public void sendResponse(Operation operation) {
    }

    public AddOperation processAdd(ByteString rawEntryDN, ArrayList<RawAttribute> rawAttributes) {
        AddOperationBasis addOperation = new AddOperationBasis(this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawEntryDN, rawAttributes);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_ADD_INSUFFICIENT_PRIVILEGES.get();
            addOperation.setErrorMessage(new MessageBuilder(message));
            addOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            addOperation.run();
        }
        return addOperation;
    }

    public AddOperation processAdd(DN entryDN, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        AddOperationBasis addOperation = new AddOperationBasis(this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), entryDN, objectClasses, userAttributes, operationalAttributes);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_ADD_INSUFFICIENT_PRIVILEGES.get();
            addOperation.setErrorMessage(new MessageBuilder(message));
            addOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            addOperation.run();
        }
        return addOperation;
    }

    public DeleteOperation processDelete(DN entryDN) {
        DeleteOperationBasis deleteOperation = new DeleteOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), entryDN);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_DELETE_INSUFFICIENT_PRIVILEGES.get();
            deleteOperation.setErrorMessage(new MessageBuilder(message));
            deleteOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            deleteOperation.run();
        }
        return deleteOperation;
    }

    public CompareOperation processCompare(ByteString rawEntryDN, String attributeType, ByteString assertionValue) {
        CompareOperationBasis compareOperation = new CompareOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawEntryDN, attributeType, assertionValue);
        if (!this.hasPrivilege(Privilege.JMX_READ, null)) {
            Message message = ProtocolMessages.ERR_JMX_SEARCH_INSUFFICIENT_PRIVILEGES.get();
            compareOperation.setErrorMessage(new MessageBuilder(message));
            compareOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            compareOperation.run();
        }
        return compareOperation;
    }

    public DeleteOperation processDelete(ByteString rawEntryDN) {
        DeleteOperationBasis deleteOperation = new DeleteOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawEntryDN);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_DELETE_INSUFFICIENT_PRIVILEGES.get();
            deleteOperation.setErrorMessage(new MessageBuilder(message));
            deleteOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            deleteOperation.run();
        }
        return deleteOperation;
    }

    public ExtendedOperation processExtendedOperation(String requestOID, ByteString requestValue) {
        ExtendedOperationBasis extendedOperation = new ExtendedOperationBasis(this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), requestOID, requestValue);
        extendedOperation.run();
        return extendedOperation;
    }

    public ModifyOperation processModify(ByteString rawEntryDN, ArrayList<RawModification> rawModifications) {
        ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawEntryDN, rawModifications);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_MODIFY_INSUFFICIENT_PRIVILEGES.get();
            modifyOperation.setErrorMessage(new MessageBuilder(message));
            modifyOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            modifyOperation.run();
        }
        return modifyOperation;
    }

    public ModifyOperation processModify(DN entryDN, List<Modification> modifications) {
        ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), entryDN, modifications);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_MODIFY_INSUFFICIENT_PRIVILEGES.get();
            modifyOperation.setErrorMessage(new MessageBuilder(message));
            modifyOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            modifyOperation.run();
        }
        return modifyOperation;
    }

    public ModifyDNOperation processModifyDN(ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN) {
        return this.processModifyDN(rawEntryDN, rawNewRDN, deleteOldRDN, null);
    }

    public ModifyDNOperation processModifyDN(ByteString rawEntryDN, ByteString rawNewRDN, boolean deleteOldRDN, ByteString rawNewSuperior) {
        ModifyDNOperationBasis modifyDNOperation = new ModifyDNOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawEntryDN, rawNewRDN, deleteOldRDN, rawNewSuperior);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_MODDN_INSUFFICIENT_PRIVILEGES.get();
            modifyDNOperation.setErrorMessage(new MessageBuilder(message));
            modifyDNOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            modifyDNOperation.run();
        }
        return modifyDNOperation;
    }

    public ModifyDNOperation processModifyDN(DN entryDN, RDN newRDN, boolean deleteOldRDN, DN newSuperior) {
        ModifyDNOperationBasis modifyDNOperation = new ModifyDNOperationBasis((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), entryDN, newRDN, deleteOldRDN, newSuperior);
        if (!this.hasPrivilege(Privilege.JMX_WRITE, null)) {
            Message message = ProtocolMessages.ERR_JMX_MODDN_INSUFFICIENT_PRIVILEGES.get();
            modifyDNOperation.setErrorMessage(new MessageBuilder(message));
            modifyDNOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            modifyDNOperation.run();
        }
        return modifyDNOperation;
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, LDAPFilter filter) {
        return this.processSearch(rawBaseDN, scope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, LDAPFilter filter, LinkedHashSet<String> attributes) {
        InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, null);
        if (!this.hasPrivilege(Privilege.JMX_READ, null)) {
            Message message = ProtocolMessages.ERR_JMX_SEARCH_INSUFFICIENT_PRIVILEGES.get();
            searchOperation.setErrorMessage(new MessageBuilder(message));
            searchOperation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
        } else {
            searchOperation.run();
        }
        return searchOperation;
    }

    public InternalSearchOperation processSearch(ByteString rawBaseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, LDAPFilter filter, LinkedHashSet<String> attributes, InternalSearchListener searchListener) {
        InternalSearchOperation searchOperation = new InternalSearchOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), rawBaseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes, searchListener);
        searchOperation.run();
        return searchOperation;
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) throws DirectoryException {
        ((InternalSearchOperation)searchOperation).addSearchEntry(searchEntry);
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchReference) throws DirectoryException {
        ((InternalSearchOperation)searchOperation).addSearchReference(searchReference);
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        return false;
    }

    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        block6: {
            block5: {
                if (this.disconnectStarted) {
                    return;
                }
                this.disconnectStarted = true;
                this.jmxConnectionHandler.unregisterClientConnection(this);
                DirectoryServer.connectionClosed(this);
                this.finalizeConnectionInternal();
                try {
                    UnbindOperationBasis unbindOp = new UnbindOperationBasis(this, this.nextOperationID(), this.nextMessageID(), null);
                    unbindOp.run();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            try {
                PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                pluginManager.invokePostDisconnectPlugins(this, disconnectReason, message);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block6;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        return this.operationList;
    }

    @Override
    public Operation getOperationInProgress(int messageID) {
        return null;
    }

    @Override
    public boolean removeOperationInProgress(int messageID) {
        return false;
    }

    @Override
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        return new CancelResult(ResultCode.CANNOT_CANCEL, Message.raw("Jmx operations cannot be cancelled", new Object[0]));
    }

    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
    }

    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.connectionID);
        buffer.append("\" connectTime=\"");
        buffer.append(this.getConnectTimeString());
        buffer.append("\" jmxConnID=\"");
        buffer.append(this.jmxConnectionID);
        buffer.append("\" authDN=\"");
        DN authDN = this.getAuthenticationInfo().getAuthenticationDN();
        if (authDN != null) {
            authDN.toString(buffer);
        }
        buffer.append("\"");
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("JmxClientConnection(connID=");
        buffer.append(this.connectionID);
        buffer.append(", authDN=\"");
        buffer.append(this.getAuthenticationInfo().getAuthenticationDN());
        buffer.append("\")");
    }

    protected void finalize() {
        this.disconnect(DisconnectReason.OTHER, false, null);
    }

    @Override
    public long getNumberOfOperations() {
        return 0L;
    }

    @Override
    public int getSSF() {
        return 0;
    }
}

