/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.core.AbandonOperationBasis;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationBasis;
import org.opends.server.core.UnbindOperationBasis;
import org.opends.server.core.networkgroups.NetworkGroup;
import org.opends.server.extensions.ConnectionSecurityProvider;
import org.opends.server.extensions.RedirectingByteChannel;
import org.opends.server.extensions.TLSByteChannel;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1ByteChannelReader;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.Operation;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public final class LDAPClientConnection
extends ClientConnection
implements TLSCapableConnection {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final ThreadLocal<ASN1WriterHolder> ASN1_WRITER_CACHE = new ThreadLocal<ASN1WriterHolder>(){

        @Override
        protected ASN1WriterHolder initialValue() {
            return new ASN1WriterHolder();
        }
    };
    private final AtomicLong lastCompletionTime;
    private final AtomicLong nextOperationID;
    private final AtomicReference<Selector> writeSelector;
    private volatile boolean connectionValid;
    private boolean disconnectRequested;
    private final boolean keepStats;
    private final ConcurrentHashMap<Integer, Operation> operationsInProgress;
    private final AtomicLong operationsPerformed;
    private final int clientPort;
    private int ldapVersion;
    private final int serverPort;
    private final LDAPConnectionHandler connectionHandler;
    private final LDAPStatistics statTracker;
    private boolean useNanoTime = false;
    private final long connectionID;
    private final Object opsInProgressLock;
    private final SocketChannel clientChannel;
    private final ByteChannel timeoutClientChannel;
    private final String clientAddress;
    private final String protocol;
    private final String serverAddress;
    private ASN1ByteChannelReader asn1Reader;
    private final int bufferSize;
    private final RedirectingByteChannel saslChannel;
    private final RedirectingByteChannel tlsChannel;
    private volatile ConnectionSecurityProvider activeProvider = null;
    private volatile ConnectionSecurityProvider tlsPendingProvider = null;
    private volatile ConnectionSecurityProvider saslPendingProvider = null;

    private ASN1WriterHolder getASN1Writer() {
        ASN1WriterHolder holder = ASN1_WRITER_CACHE.get();
        if (holder.maxBufferSize != DirectoryServer.getMaxInternalBufferSize()) {
            holder = new ASN1WriterHolder();
            ASN1_WRITER_CACHE.set(holder);
        }
        return holder;
    }

    LDAPClientConnection(LDAPConnectionHandler connectionHandler, SocketChannel clientChannel, String protocol) throws DirectoryException {
        this.connectionHandler = connectionHandler;
        if (connectionHandler.isAdminConnectionHandler()) {
            this.setNetworkGroup(NetworkGroup.getAdminNetworkGroup());
        }
        this.clientChannel = clientChannel;
        this.timeoutClientChannel = new TimeoutWriteByteChannel();
        this.opsInProgressLock = new Object();
        this.ldapVersion = 3;
        this.lastCompletionTime = new AtomicLong(TimeThread.getTime());
        this.nextOperationID = new AtomicLong(0L);
        this.connectionValid = true;
        this.disconnectRequested = false;
        this.operationsInProgress = new ConcurrentHashMap();
        this.operationsPerformed = new AtomicLong(0L);
        this.keepStats = connectionHandler.keepStats();
        this.protocol = protocol;
        this.writeSelector = new AtomicReference();
        this.clientAddress = clientChannel.socket().getInetAddress().getHostAddress();
        this.clientPort = clientChannel.socket().getPort();
        this.serverAddress = clientChannel.socket().getLocalAddress().getHostAddress();
        this.serverPort = clientChannel.socket().getLocalPort();
        this.statTracker = this.connectionHandler.getStatTracker();
        if (this.keepStats) {
            this.statTracker.updateConnect();
            this.useNanoTime = DirectoryServer.getUseNanoTime();
        }
        this.bufferSize = connectionHandler.getBufferSize();
        this.tlsChannel = RedirectingByteChannel.getRedirectingByteChannel(this.timeoutClientChannel);
        this.saslChannel = RedirectingByteChannel.getRedirectingByteChannel(this.tlsChannel);
        this.asn1Reader = ASN1.getReader(this.saslChannel, this.bufferSize, connectionHandler.getMaxRequestSize());
        if (connectionHandler.useSSL()) {
            this.enableSSL(connectionHandler.getTLSByteChannel(this.timeoutClientChannel));
        }
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
    }

    @Override
    public long getConnectionID() {
        return this.connectionID;
    }

    @Override
    public ConnectionHandler<?> getConnectionHandler() {
        return this.connectionHandler;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.clientChannel;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getClientAddress() {
        return this.clientAddress;
    }

    @Override
    public int getClientPort() {
        return this.clientPort;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.clientChannel.socket().getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.clientChannel.socket().getLocalAddress();
    }

    @Override
    public boolean isConnectionValid() {
        return this.connectionValid;
    }

    @Override
    public boolean isSecure() {
        if (this.activeProvider != null) {
            return this.activeProvider.isSecure();
        }
        return false;
    }

    @Override
    public void sendResponse(Operation operation) {
        LDAPMessage message;
        if (this.keepStats) {
            long time = this.useNanoTime ? operation.getProcessingNanoTime() : operation.getProcessingTime();
            this.statTracker.updateOperationMonitoringData(operation.getOperationType(), time);
        }
        if (this.removeOperationInProgress(operation.getMessageID()) && (message = this.operationToResponseLDAPMessage(operation)) != null) {
            this.sendLDAPMessage(message);
        }
    }

    private LDAPMessage operationToResponseLDAPMessage(Operation operation) {
        ProtocolOp protocolOp;
        List<String> referralURLs;
        ResultCode resultCode = operation.getResultCode();
        if (resultCode == null) {
            ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CLIENT_SEND_RESPONSE_NO_RESULT_CODE.get(operation.getOperationType().toString(), operation.getConnectionID(), operation.getOperationID()));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        MessageBuilder errorMessage = operation.getErrorMessage();
        DN matchedDN = operation.getMatchedDN();
        if (this.ldapVersion == 2) {
            List<String> opReferrals;
            referralURLs = null;
            if (resultCode == ResultCode.REFERRAL) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                errorMessage.append(ProtocolMessages.ERR_LDAPV2_REFERRAL_RESULT_CHANGED.get());
            }
            if ((opReferrals = operation.getReferralURLs()) != null && !opReferrals.isEmpty()) {
                StringBuilder referralsStr = new StringBuilder();
                Iterator<String> iterator = opReferrals.iterator();
                referralsStr.append(iterator.next());
                while (iterator.hasNext()) {
                    referralsStr.append(", ");
                    referralsStr.append(iterator.next());
                }
                errorMessage.append(ProtocolMessages.ERR_LDAPV2_REFERRALS_OMITTED.get(String.valueOf(referralsStr)));
            }
        } else {
            referralURLs = operation.getReferralURLs();
        }
        switch (operation.getOperationType()) {
            case ADD: {
                protocolOp = new AddResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case BIND: {
                ByteString serverSASLCredentials = ((BindOperationBasis)operation).getServerSASLCredentials();
                protocolOp = new BindResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs, serverSASLCredentials);
                break;
            }
            case COMPARE: {
                protocolOp = new CompareResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case DELETE: {
                protocolOp = new DeleteResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case EXTENDED: {
                if (this.ldapVersion == 2) {
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAPV2_SKIPPING_EXTENDED_RESPONSE.get(this.getConnectionID(), operation.getOperationID(), String.valueOf(operation)));
                    return null;
                }
                ExtendedOperationBasis extOp = (ExtendedOperationBasis)operation;
                protocolOp = new ExtendedResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs, extOp.getResponseOID(), extOp.getResponseValue());
                break;
            }
            case MODIFY: {
                protocolOp = new ModifyResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case MODIFY_DN: {
                protocolOp = new ModifyDNResponseProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            case SEARCH: {
                protocolOp = new SearchResultDoneProtocolOp(resultCode.getIntValue(), errorMessage.toMessage(), matchedDN, referralURLs);
                break;
            }
            default: {
                ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CLIENT_SEND_RESPONSE_INVALID_OP.get(String.valueOf((Object)operation.getOperationType()), this.getConnectionID(), operation.getOperationID(), String.valueOf(operation)));
                return null;
            }
        }
        List<Control> controls = this.ldapVersion == 2 ? null : operation.getResponseControls();
        return new LDAPMessage(operation.getMessageID(), protocolOp, controls);
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchEntry) {
        SearchResultEntryProtocolOp protocolOp = new SearchResultEntryProtocolOp(searchEntry, this.ldapVersion);
        this.sendLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), protocolOp, searchEntry.getControls()));
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchReference) {
        if (this.ldapVersion == 2) {
            Message message = ProtocolMessages.ERR_LDAPV2_SKIPPING_SEARCH_REFERENCE.get(this.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchReference));
            ErrorLogger.logError(message);
            return false;
        }
        SearchResultReferenceProtocolOp protocolOp = new SearchResultReferenceProtocolOp(searchReference);
        this.sendLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), protocolOp, searchReference.getControls()));
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        IntermediateResponseProtocolOp protocolOp = new IntermediateResponseProtocolOp(intermediateResponse.getOID(), intermediateResponse.getValue());
        Operation operation = intermediateResponse.getOperation();
        LDAPMessage message = new LDAPMessage(operation.getMessageID(), protocolOp, intermediateResponse.getControls());
        this.sendLDAPMessage(message);
        return this.connectionValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendLDAPMessage(LDAPMessage message) {
        ASN1WriterHolder holder = this.getASN1Writer();
        try {
            message.write(holder.writer);
            holder.buffer.copyTo(this.saslChannel);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugProtocolElement(DebugLogLevel.VERBOSE, message.toString());
            }
            if (this.keepStats) {
                this.statTracker.updateMessageWritten(message);
            }
        }
        catch (ClosedChannelException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.disconnect(DisconnectReason.IO_ERROR, false, ProtocolMessages.ERR_IO_ERROR_ON_CLIENT_CONNECTION.get(StaticUtils.getExceptionMessage(e)));
            StaticUtils.close(holder.writer);
            return;
        }
        catch (Exception e2) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e2);
            }
            this.disconnect(DisconnectReason.SERVER_ERROR, false, ProtocolMessages.ERR_UNEXPECTED_EXCEPTION_ON_CLIENT_CONNECTION.get(StaticUtils.getExceptionMessage(e2)));
            {
                catch (Throwable throwable) {
                    StaticUtils.close(holder.writer);
                    throw throwable;
                }
            }
            StaticUtils.close(holder.writer);
            return;
        }
        StaticUtils.close(holder.writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean sendNotification, Message message) {
        block22: {
            block21: {
                Object object = this.opsInProgressLock;
                synchronized (object) {
                    if (this.disconnectRequested) {
                        return;
                    }
                    this.disconnectRequested = true;
                }
                if (this.keepStats) {
                    this.statTracker.updateDisconnect();
                }
                if (this.connectionID >= 0L) {
                    DirectoryServer.connectionClosed(this);
                }
                this.connectionValid = false;
                if (message != null) {
                    MessageBuilder msgBuilder = new MessageBuilder();
                    msgBuilder.append(disconnectReason.getClosureMessage());
                    msgBuilder.append(": ");
                    msgBuilder.append(message);
                    this.cancelAllOperations(new CancelRequest(true, msgBuilder.toMessage()));
                } else {
                    this.cancelAllOperations(new CancelRequest(true, disconnectReason.getClosureMessage()));
                }
                this.finalizeConnectionInternal();
                Selector selector = this.writeSelector.get();
                StaticUtils.close(selector);
                if (sendNotification && this.ldapVersion != 2) {
                    try {
                        int resultCode;
                        switch (disconnectReason) {
                            case PROTOCOL_ERROR: {
                                resultCode = 2;
                                break;
                            }
                            case SERVER_SHUTDOWN: {
                                resultCode = 52;
                                break;
                            }
                            case SERVER_ERROR: {
                                resultCode = DirectoryServer.getServerErrorResultCode().getIntValue();
                                break;
                            }
                            case ADMIN_LIMIT_EXCEEDED: 
                            case IDLE_TIME_LIMIT_EXCEEDED: 
                            case MAX_REQUEST_SIZE_EXCEEDED: 
                            case IO_TIMEOUT: {
                                resultCode = 11;
                                break;
                            }
                            case CONNECTION_REJECTED: {
                                resultCode = 19;
                                break;
                            }
                            case INVALID_CREDENTIALS: {
                                resultCode = 49;
                                break;
                            }
                            default: {
                                resultCode = 80;
                            }
                        }
                        Message errMsg = message == null ? ProtocolMessages.INFO_LDAP_CLIENT_GENERIC_NOTICE_OF_DISCONNECTION.get() : message;
                        ExtendedResponseProtocolOp notificationOp = new ExtendedResponseProtocolOp(resultCode, errMsg, null, null, "1.3.6.1.4.1.1466.20036", null);
                        this.sendLDAPMessage(new LDAPMessage(0, notificationOp, null));
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block21;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            ConnectionFinalizerJob r = new ConnectionFinalizerJob(this.asn1Reader, this.clientChannel);
            this.connectionHandler.registerConnectionFinalizer(r);
            AccessLogger.logDisconnect(this, disconnectReason, message);
            try {
                PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
                pluginManager.invokePostDisconnectPlugins(this, disconnectReason, message);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block22;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        return this.operationsInProgress.values();
    }

    @Override
    public Operation getOperationInProgress(int messageID) {
        return this.operationsInProgress.get(messageID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperationInProgress(Operation operation) throws DirectoryException {
        int messageID = operation.getMessageID();
        try {
            Object object = this.opsInProgressLock;
            synchronized (object) {
                if (this.disconnectRequested) {
                    Message message = ProtocolMessages.WARN_CLIENT_DISCONNECT_IN_PROGRESS.get();
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
                Operation op = this.operationsInProgress.putIfAbsent(messageID, operation);
                if (op != null) {
                    Message message = ProtocolMessages.WARN_LDAP_CLIENT_DUPLICATE_MESSAGE_ID.get(messageID);
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
            }
            this.connectionHandler.getQueueingStrategy().enqueueRequest(operation);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            this.operationsInProgress.remove(messageID);
            this.lastCompletionTime.set(TimeThread.getTime());
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.WARN_LDAP_CLIENT_CANNOT_ENQUEUE.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    @Override
    public boolean removeOperationInProgress(int messageID) {
        Operation operation = this.operationsInProgress.remove(messageID);
        if (operation == null) {
            return false;
        }
        if (operation.getOperationType() == OperationType.ABANDON && this.keepStats && operation.getResultCode() == ResultCode.CANCELED) {
            this.statTracker.updateAbandonedOperation();
        }
        this.lastCompletionTime.set(TimeThread.getTime());
        return true;
    }

    @Override
    public CancelResult cancelOperation(int messageID, CancelRequest cancelRequest) {
        Operation op = this.operationsInProgress.get(messageID);
        if (op == null) {
            for (PersistentSearch ps : this.getPersistentSearches()) {
                if (ps.getMessageID() != messageID) continue;
                CancelResult cancelResult = ps.cancel();
                return cancelResult;
            }
            return new CancelResult(ResultCode.NO_SUCH_OPERATION, null);
        }
        CancelResult cancelResult = op.cancel(cancelRequest);
        return cancelResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            block10: {
                try {
                    for (Operation o : this.operationsInProgress.values()) {
                        try {
                            o.abort(cancelRequest);
                            if (!this.keepStats) continue;
                            this.statTracker.updateAbandonedOperation();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    if (!this.operationsInProgress.isEmpty() || !this.getPersistentSearches().isEmpty()) {
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                    this.operationsInProgress.clear();
                    for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                        persistentSearch.cancel();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block10;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int messageID) {
        Object object = this.opsInProgressLock;
        synchronized (object) {
            block12: {
                try {
                    Iterator<Object> i$ = this.operationsInProgress.keySet().iterator();
                    while (i$.hasNext()) {
                        int msgID;
                        block11: {
                            msgID = (Integer)i$.next();
                            if (msgID == messageID) continue;
                            Operation o = this.operationsInProgress.get(msgID);
                            if (o != null) {
                                try {
                                    o.abort(cancelRequest);
                                    if (this.keepStats) {
                                        this.statTracker.updateAbandonedOperation();
                                    }
                                }
                                catch (Exception e) {
                                    if (!DebugLogger.debugEnabled()) break block11;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                                }
                            }
                        }
                        this.operationsInProgress.remove(msgID);
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                    for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                        if (persistentSearch.getMessageID() == messageID) continue;
                        persistentSearch.cancel();
                        this.lastCompletionTime.set(TimeThread.getTime());
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block12;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    @Override
    public Selector getWriteSelector() {
        Selector selector;
        block4: {
            selector = this.writeSelector.get();
            if (selector == null) {
                try {
                    selector = Selector.open();
                    if (!this.writeSelector.compareAndSet(null, selector)) {
                        selector.close();
                        selector = this.writeSelector.get();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return selector;
    }

    @Override
    public long getMaxBlockedWriteTimeLimit() {
        return this.connectionHandler.getMaxBlockedWriteTimeLimit();
    }

    @Override
    public long getNumberOfOperations() {
        return this.operationsPerformed.get();
    }

    ASN1ByteChannelReader getASN1Reader() {
        return this.asn1Reader;
    }

    int processDataRead() {
        if (this.bindOrStartTLSInProgress.get()) {
            return 0;
        }
        try {
            int result = this.asn1Reader.processChannelData();
            if (result < 0) {
                this.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null);
                return -1;
            }
            return result;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (this.asn1Reader.hasRemainingData() || e instanceof SSLException) {
                Message m = ProtocolMessages.ERR_LDAP_CLIENT_IO_ERROR_DURING_READ.get(String.valueOf(e));
                this.disconnect(DisconnectReason.IO_ERROR, true, m);
            } else {
                Message m = ProtocolMessages.ERR_LDAP_CLIENT_IO_ERROR_BEFORE_READ.get();
                this.disconnect(DisconnectReason.CLIENT_DISCONNECT, true, m);
            }
            return -1;
        }
    }

    boolean processLDAPMessage(LDAPMessage message) {
        if (this.keepStats) {
            this.statTracker.updateMessageRead(message);
            this.getNetworkGroup().updateMessageRead(message);
        }
        this.operationsPerformed.getAndIncrement();
        List<Control> opControls = message.getControls();
        try {
            if (this.bindOrStartTLSInProgress.get() || this.saslBindInProgress.get() && message.getProtocolOpType() != 96) {
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_ENQUEUE_BIND_IN_PROGRESS.get());
            }
            switch (message.getProtocolOpType()) {
                case 80: {
                    boolean result = this.processAbandonRequest(message, opControls);
                    return result;
                }
                case 104: {
                    boolean result = this.processAddRequest(message, opControls);
                    return result;
                }
                case 96: {
                    boolean result;
                    this.bindOrStartTLSInProgress.set(true);
                    if (message.getBindRequestProtocolOp().getAuthenticationType() == AuthenticationType.SASL) {
                        this.saslBindInProgress.set(true);
                    }
                    if (!(result = this.processBindRequest(message, opControls))) {
                        this.bindOrStartTLSInProgress.set(false);
                        if (message.getBindRequestProtocolOp().getAuthenticationType() == AuthenticationType.SASL) {
                            this.saslBindInProgress.set(false);
                        }
                    }
                    return result;
                }
                case 110: {
                    boolean result = this.processCompareRequest(message, opControls);
                    return result;
                }
                case 74: {
                    boolean result = this.processDeleteRequest(message, opControls);
                    return result;
                }
                case 119: {
                    boolean result;
                    if (message.getExtendedRequestProtocolOp().getOID().equals("1.3.6.1.4.1.1466.20037")) {
                        this.bindOrStartTLSInProgress.set(true);
                    }
                    if (!(result = this.processExtendedRequest(message, opControls)) && message.getExtendedRequestProtocolOp().getOID().equals("1.3.6.1.4.1.1466.20037")) {
                        this.bindOrStartTLSInProgress.set(false);
                    }
                    return result;
                }
                case 102: {
                    boolean result = this.processModifyRequest(message, opControls);
                    return result;
                }
                case 108: {
                    boolean result = this.processModifyDNRequest(message, opControls);
                    return result;
                }
                case 99: {
                    boolean result = this.processSearchRequest(message, opControls);
                    return result;
                }
                case 66: {
                    boolean result = this.processUnbindRequest(message, opControls);
                    return result;
                }
            }
            Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_INVALID_REQUEST_TYPE.get(message.getProtocolOpName(), message.getMessageID());
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_PROCESSING_FAILURE.get(message.getProtocolOpName(), message.getMessageID(), String.valueOf(e));
            this.disconnect(DisconnectReason.SERVER_ERROR, true, msg);
            return false;
        }
    }

    private boolean processAbandonRequest(LDAPMessage message, List<Control> controls) {
        block3: {
            if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
                return false;
            }
            AbandonRequestProtocolOp protocolOp = message.getAbandonRequestProtocolOp();
            AbandonOperationBasis abandonOp = new AbandonOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getIDToAbandon());
            try {
                this.addOperationInProgress(abandonOp);
            }
            catch (DirectoryException de) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
        }
        return this.connectionValid;
    }

    private boolean processAddRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        AddRequestProtocolOp protocolOp = message.getAddRequestProtocolOp();
        AddOperationBasis addOp = new AddOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(addOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            AddResponseProtocolOp responseOp = new AddResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, addOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processBindRequest(LDAPMessage message, List<Control> controls) {
        block12: {
            BindOperationBasis bindOp;
            String versionString;
            BindRequestProtocolOp protocolOp = message.getBindRequestProtocolOp();
            this.ldapVersion = protocolOp.getProtocolVersion();
            switch (this.ldapVersion) {
                case 2: {
                    versionString = "2";
                    if (!this.connectionHandler.allowLDAPv2()) {
                        BindResponseProtocolOp responseOp = new BindResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CLIENTS_NOT_ALLOWED.get());
                        this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CLIENTS_NOT_ALLOWED.get());
                        return false;
                    }
                    if (controls == null || controls.isEmpty()) break;
                    BindResponseProtocolOp responseOp = new BindResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
                    this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
                    return false;
                }
                case 3: {
                    versionString = "3";
                    break;
                }
                default: {
                    BindResponseProtocolOp responseOp = new BindResponseProtocolOp(2, ProtocolMessages.ERR_LDAP_UNSUPPORTED_PROTOCOL_VERSION.get(this.ldapVersion));
                    this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAP_UNSUPPORTED_PROTOCOL_VERSION.get(this.ldapVersion));
                    return false;
                }
            }
            ByteString bindDN = protocolOp.getDN();
            switch (protocolOp.getAuthenticationType()) {
                case SIMPLE: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, protocolOp.getSimplePassword());
                    break;
                }
                case SASL: {
                    bindOp = new BindOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, versionString, bindDN, protocolOp.getSASLMechanism(), protocolOp.getSASLCredentials());
                    break;
                }
                default: {
                    Message msg = ProtocolMessages.ERR_LDAP_INVALID_BIND_AUTH_TYPE.get(message.getMessageID(), String.valueOf((Object)protocolOp.getAuthenticationType()));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
                    return false;
                }
            }
            try {
                this.addOperationInProgress(bindOp);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                BindResponseProtocolOp responseOp = new BindResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
                this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, bindOp.getResponseControls()));
                if (de.getResultCode() != ResultCode.PROTOCOL_ERROR) break block12;
                Message msg = ProtocolMessages.ERR_LDAP_DISCONNECT_DUE_TO_BIND_PROTOCOL_ERROR.get(message.getMessageID(), de.getMessageObject());
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, msg);
            }
        }
        return this.connectionValid;
    }

    private boolean processCompareRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        CompareRequestProtocolOp protocolOp = message.getCompareRequestProtocolOp();
        CompareOperationBasis compareOp = new CompareOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getAttributeType(), protocolOp.getAssertionValue());
        try {
            this.addOperationInProgress(compareOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            CompareResponseProtocolOp responseOp = new CompareResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, compareOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processDeleteRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        DeleteRequestProtocolOp protocolOp = message.getDeleteRequestProtocolOp();
        DeleteOperationBasis deleteOp = new DeleteOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN());
        try {
            this.addOperationInProgress(deleteOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            DeleteResponseProtocolOp responseOp = new DeleteResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, deleteOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processExtendedRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2) {
            Message msg = ProtocolMessages.ERR_LDAPV2_EXTENDED_REQUEST_NOT_ALLOWED.get(this.getConnectionID(), message.getMessageID());
            ErrorLogger.logError(msg);
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, msg);
            return false;
        }
        ExtendedRequestProtocolOp protocolOp = message.getExtendedRequestProtocolOp();
        ExtendedOperationBasis extendedOp = new ExtendedOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getOID(), protocolOp.getValue());
        try {
            this.addOperationInProgress(extendedOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ExtendedResponseProtocolOp responseOp = new ExtendedResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, extendedOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processModifyRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        ModifyRequestProtocolOp protocolOp = message.getModifyRequestProtocolOp();
        ModifyOperationBasis modifyOp = new ModifyOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getDN(), protocolOp.getModifications());
        try {
            this.addOperationInProgress(modifyOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyResponseProtocolOp responseOp = new ModifyResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, modifyOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processModifyDNRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        ModifyDNRequestProtocolOp protocolOp = message.getModifyDNRequestProtocolOp();
        ModifyDNOperationBasis modifyDNOp = new ModifyDNOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getEntryDN(), protocolOp.getNewRDN(), protocolOp.deleteOldRDN(), protocolOp.getNewSuperior());
        try {
            this.addOperationInProgress(modifyDNOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            ModifyDNResponseProtocolOp responseOp = new ModifyDNResponseProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, modifyDNOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processSearchRequest(LDAPMessage message, List<Control> controls) {
        if (this.ldapVersion == 2 && controls != null && !controls.isEmpty()) {
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(2, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp));
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, ProtocolMessages.ERR_LDAPV2_CONTROLS_NOT_ALLOWED.get());
            return false;
        }
        SearchRequestProtocolOp protocolOp = message.getSearchRequestProtocolOp();
        SearchOperationBasis searchOp = new SearchOperationBasis((ClientConnection)this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls, protocolOp.getBaseDN(), protocolOp.getScope(), protocolOp.getDereferencePolicy(), protocolOp.getSizeLimit(), protocolOp.getTimeLimit(), protocolOp.getTypesOnly(), protocolOp.getFilter(), protocolOp.getAttributes());
        try {
            this.addOperationInProgress(searchOp);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            SearchResultDoneProtocolOp responseOp = new SearchResultDoneProtocolOp(de.getResultCode().getIntValue(), de.getMessageObject(), de.getMatchedDN(), de.getReferralURLs());
            this.sendLDAPMessage(new LDAPMessage(message.getMessageID(), responseOp, searchOp.getResponseControls()));
        }
        return this.connectionValid;
    }

    private boolean processUnbindRequest(LDAPMessage message, List<Control> controls) {
        UnbindOperationBasis unbindOp = new UnbindOperationBasis(this, this.nextOperationID.getAndIncrement(), message.getMessageID(), controls);
        unbindOp.run();
        return false;
    }

    @Override
    public String getMonitorSummary() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("connID=\"");
        buffer.append(this.connectionID);
        buffer.append("\" connectTime=\"");
        buffer.append(this.getConnectTimeString());
        buffer.append("\" source=\"");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append("\" destination=\"");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.connectionHandler.getListenPort());
        buffer.append("\" ldapVersion=\"");
        buffer.append(this.ldapVersion);
        buffer.append("\" authDN=\"");
        DN authDN = this.getAuthenticationInfo().getAuthenticationDN();
        if (authDN != null) {
            authDN.toString(buffer);
        }
        buffer.append("\" security=\"");
        if (this.isSecure()) {
            buffer.append(this.activeProvider.getName());
        } else {
            buffer.append("none");
        }
        buffer.append("\" opsInProgress=\"");
        buffer.append(this.operationsInProgress.size());
        buffer.append("\"");
        int countPSearch = this.getPersistentSearches().size();
        if (countPSearch > 0) {
            buffer.append(" persistentSearches=\"");
            buffer.append(countPSearch);
            buffer.append("\"");
        }
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAP client connection from ");
        buffer.append(this.clientAddress);
        buffer.append(":");
        buffer.append(this.clientPort);
        buffer.append(" to ");
        buffer.append(this.serverAddress);
        buffer.append(":");
        buffer.append(this.serverPort);
    }

    @Override
    public boolean prepareTLS(MessageBuilder unavailableReason) {
        if (this.isSecure() && "TLS".equals(this.activeProvider.getName())) {
            unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_EXISTING_SECURITY_PROVIDER.get(this.activeProvider.getName()));
            return false;
        }
        if (!this.connectionHandler.allowStartTLS()) {
            unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_STARTTLS_NOT_ALLOWED.get());
            return false;
        }
        try {
            TLSByteChannel tlsByteChannel = this.connectionHandler.getTLSByteChannel(this.timeoutClientChannel);
            this.setTLSPendingProvider(tlsByteChannel);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            unavailableReason.append(ProtocolMessages.ERR_LDAP_TLS_CANNOT_CREATE_TLS_PROVIDER.get(StaticUtils.stackTraceToSingleLineString(de)));
            return false;
        }
        return true;
    }

    @Override
    public long getIdleTime() {
        if (this.operationsInProgress.isEmpty() && this.getPersistentSearches().isEmpty()) {
            return TimeThread.getTime() - this.lastCompletionTime.get();
        }
        return 0L;
    }

    public void setTLSPendingProvider(ConnectionSecurityProvider provider) {
        this.tlsPendingProvider = provider;
    }

    public void setSASLPendingProvider(ConnectionSecurityProvider provider) {
        this.saslPendingProvider = provider;
    }

    private void enableTLS() {
        this.activeProvider = this.tlsPendingProvider;
        this.tlsChannel.redirect(this.tlsPendingProvider);
        this.tlsPendingProvider = null;
    }

    private void enableSSL(ConnectionSecurityProvider sslProvider) {
        this.activeProvider = sslProvider;
        this.tlsChannel.redirect(sslProvider);
    }

    private void enableSASL() {
        this.activeProvider = this.saslPendingProvider;
        this.saslChannel.redirect(this.saslPendingProvider);
        this.saslPendingProvider = null;
    }

    public Certificate[] getClientCertificateChain() {
        if (this.activeProvider != null) {
            return this.activeProvider.getClientCertificateChain();
        }
        return new Certificate[0];
    }

    @Override
    public ByteChannel getChannel() {
        return this.tlsChannel;
    }

    @Override
    public int getSSF() {
        if (this.activeProvider != null) {
            return this.activeProvider.getSSF();
        }
        return 0;
    }

    @Override
    public void finishBindOrStartTLS() {
        if (this.tlsPendingProvider != null) {
            this.enableTLS();
        }
        if (this.saslPendingProvider != null) {
            this.enableSASL();
        }
        super.finishBindOrStartTLS();
    }

    private static final class ASN1WriterHolder {
        private final ASN1Writer writer;
        private final ByteStringBuilder buffer = new ByteStringBuilder();
        private final int maxBufferSize = DirectoryServer.getMaxInternalBufferSize();

        private ASN1WriterHolder() {
            this.writer = ASN1.getWriter(this.buffer, this.maxBufferSize);
        }
    }

    private class TimeoutWriteByteChannel
    implements ByteChannel {
        private final Lock writeLock = new ReentrantLock();

        private TimeoutWriteByteChannel() {
        }

        @Override
        public int read(ByteBuffer byteBuffer) throws IOException {
            int bytesRead = LDAPClientConnection.this.clientChannel.read(byteBuffer);
            if (bytesRead > 0 && LDAPClientConnection.this.keepStats) {
                LDAPClientConnection.this.statTracker.updateBytesRead(bytesRead);
            }
            return bytesRead;
        }

        @Override
        public boolean isOpen() {
            return LDAPClientConnection.this.clientChannel.isOpen();
        }

        @Override
        public void close() throws IOException {
            LDAPClientConnection.this.clientChannel.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer byteBuffer) throws IOException {
            this.writeLock.lock();
            try {
                int n;
                block21: {
                    int bytesToWrite = byteBuffer.remaining();
                    int bytesWritten = LDAPClientConnection.this.clientChannel.write(byteBuffer);
                    if (bytesWritten > 0 && LDAPClientConnection.this.keepStats) {
                        LDAPClientConnection.this.statTracker.updateBytesWritten(bytesWritten);
                    }
                    if (!byteBuffer.hasRemaining()) {
                        int n2 = bytesToWrite;
                        return n2;
                    }
                    long startTime = System.currentTimeMillis();
                    long waitTime = LDAPClientConnection.this.getMaxBlockedWriteTimeLimit();
                    if (waitTime <= 0L) {
                        waitTime = 300000L;
                    }
                    long stopTime = startTime + waitTime;
                    Selector selector = LDAPClientConnection.this.getWriteSelector();
                    if (selector == null) {
                        while (byteBuffer.hasRemaining() && System.currentTimeMillis() < stopTime) {
                            bytesWritten = LDAPClientConnection.this.clientChannel.write(byteBuffer);
                            if (bytesWritten < 0) {
                                throw new ClosedChannelException();
                            }
                            if (bytesWritten <= 0 || !LDAPClientConnection.this.keepStats) continue;
                            LDAPClientConnection.this.statTracker.updateBytesWritten(bytesWritten);
                        }
                        if (byteBuffer.hasRemaining()) {
                            throw new ClosedChannelException();
                        }
                        int n3 = bytesToWrite;
                        return n3;
                    }
                    SelectionKey key = LDAPClientConnection.this.clientChannel.register(selector, 4);
                    try {
                        selector.select(waitTime);
                        while (byteBuffer.hasRemaining()) {
                            long currentTime = System.currentTimeMillis();
                            if (currentTime >= stopTime) {
                                throw new ClosedChannelException();
                            }
                            waitTime = stopTime - currentTime;
                            Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                            while (iterator.hasNext()) {
                                SelectionKey k = iterator.next();
                                if (!k.isWritable()) continue;
                                bytesWritten = LDAPClientConnection.this.clientChannel.write(byteBuffer);
                                if (bytesWritten < 0) {
                                    throw new ClosedChannelException();
                                }
                                if (bytesWritten > 0 && LDAPClientConnection.this.keepStats) {
                                    LDAPClientConnection.this.statTracker.updateBytesWritten(bytesWritten);
                                }
                                iterator.remove();
                            }
                            if (!byteBuffer.hasRemaining()) continue;
                            selector.select(waitTime);
                        }
                        n = bytesToWrite;
                        if (!key.isValid()) break block21;
                        key.cancel();
                    }
                    catch (Throwable throwable) {
                        if (key.isValid()) {
                            key.cancel();
                            selector.selectNow();
                        }
                        throw throwable;
                    }
                    selector.selectNow();
                }
                return n;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static final class ConnectionFinalizerJob
    implements Runnable {
        private final ASN1Reader asn1Reader;
        private final SocketChannel socketChannel;

        private ConnectionFinalizerJob(ASN1Reader asn1Reader, SocketChannel socketChannel) {
            this.asn1Reader = asn1Reader;
            this.socketChannel = socketChannel;
        }

        @Override
        public void run() {
            block5: {
                block4: {
                    try {
                        this.asn1Reader.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block4;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                try {
                    this.socketChannel.close();
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block5;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

