/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.QueueingStrategy;
import org.opends.server.core.WorkQueueStrategy;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.extensions.NullTrustManagerProvider;
import org.opends.server.extensions.TLSByteChannel;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.ClientConnectionMonitorProvider;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.StaticUtils;

public final class LDAPConnectionHandler
extends ConnectionHandler<LDAPConnectionHandlerCfg>
implements ConfigurationChangeListener<LDAPConnectionHandlerCfg>,
ServerShutdownListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String DEFAULT_FRIENDLY_NAME = "LDAP Connection Handler";
    private static final String SSL_CONTEXT_INSTANCE_NAME = "TLS";
    private LDAPConnectionHandlerCfg currentConfig;
    private Set<InetAddress> listenAddresses;
    private int listenPort;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private int backlog;
    private boolean allowReuseAddress;
    private int numRequestHandlers;
    private volatile boolean shutdownRequested;
    private boolean enabled;
    private Collection<AddressMask> allowedClients;
    private Collection<AddressMask> deniedClients;
    private int requestHandlerIndex;
    private List<HostPort> listeners;
    private LDAPRequestHandler[] requestHandlers;
    private LDAPStatistics statTracker;
    private ClientConnectionMonitorProvider connMonitor;
    private Selector selector;
    private String handlerName;
    private String protocol;
    private final QueueingStrategy queueingStrategy;
    private final Object waitListen = new Object();
    private String friendlyName;
    private SSLContext sslContext;
    private SSLEngine sslEngine;
    private final Object connectionFinalizerLock = new Object();
    private ScheduledExecutorService connectionFinalizer;
    private List<Runnable> connectionFinalizerActiveJobQueue;
    private List<Runnable> connectionFinalizerPendingJobQueue;

    public LDAPConnectionHandler() {
        this(new WorkQueueStrategy(), null);
    }

    public LDAPConnectionHandler(QueueingStrategy strategy, String friendlyName) {
        super(friendlyName != null ? friendlyName : "LDAP Connection Handler Thread");
        this.friendlyName = friendlyName;
        this.queueingStrategy = strategy;
    }

    public boolean allowLDAPv2() {
        return this.currentConfig.isAllowLDAPV2();
    }

    public boolean allowStartTLS() {
        return this.currentConfig.isAllowStartTLS() && !this.currentConfig.isUseSSL();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDAPConnectionHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.currentConfig.isAllowLDAPV2() != config.isAllowLDAPV2() && config.isAllowLDAPV2()) {
            this.statTracker.clearStatistics();
        }
        this.currentConfig = config;
        this.enabled = config.isEnabled();
        this.allowedClients = config.getAllowedClient();
        this.deniedClients = config.getDeniedClient();
        try {
            this.configureSSL(config);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            messages.add(e.getMessageObject());
            return new ConfigChangeResult(e.getResultCode(), adminActionRequired, messages);
        }
        if (config.isAllowLDAPV2()) {
            DirectoryServer.registerSupportedLDAPVersion(2, this);
        } else {
            DirectoryServer.deregisterSupportedLDAPVersion(2, this);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private void configureSSL(LDAPConnectionHandlerCfg config) throws DirectoryException {
        String string = this.protocol = config.isUseSSL() ? "LDAPS" : "LDAP";
        if (config.isUseSSL() || config.isAllowStartTLS()) {
            this.sslContext = this.createSSLContext(config);
            this.sslEngine = this.createSSLEngine(config, this.sslContext);
        } else {
            this.sslContext = null;
            this.sslEngine = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeConnectionHandler(Message finalizeReason) {
        block8: {
            this.shutdownRequested = true;
            this.currentConfig.removeLDAPChangeListener(this);
            if (this.connMonitor != null) {
                DirectoryServer.deregisterMonitorProvider(this.connMonitor);
            }
            if (this.statTracker != null) {
                DirectoryServer.deregisterMonitorProvider(this.statTracker);
            }
            DirectoryServer.deregisterSupportedLDAPVersion(2, this);
            DirectoryServer.deregisterSupportedLDAPVersion(3, this);
            try {
                this.selector.wakeup();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (LDAPRequestHandler requestHandler : this.requestHandlers) {
            requestHandler.processServerShutdown(finalizeReason);
        }
        Object object = this.connectionFinalizerLock;
        synchronized (object) {
            this.connectionFinalizer.shutdown();
            this.connectionFinalizer = null;
            ConnectionFinalizerRunnable r = new ConnectionFinalizerRunnable();
            r.run();
            r.run();
        }
    }

    @Override
    public Map<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", "This alert type will be used to notify administrators of consecutive failures that have occurred in the LDAP connection handler that have caused it to become disabled.");
        alerts.put("org.opends.server.LDAPHandlerUncaughtError", "This alert type will be used to notify administrators of uncaught errors in the LDAP connection handler that have caused it to become disabled.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return LDAPConnectionHandler.class.getName();
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        LinkedList<ClientConnection> connectionList = new LinkedList<ClientConnection>();
        for (LDAPRequestHandler requestHandler : this.requestHandlers) {
            connectionList.addAll(requestHandler.getClientConnections());
        }
        return connectionList;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getConnectionHandlerName() {
        return this.handlerName;
    }

    @Override
    public Collection<String> getEnabledSSLCipherSuites() {
        SSLEngine engine = this.sslEngine;
        if (engine != null) {
            return Arrays.asList(engine.getEnabledCipherSuites());
        }
        return super.getEnabledSSLCipherSuites();
    }

    @Override
    public Collection<String> getEnabledSSLProtocols() {
        SSLEngine engine = this.sslEngine;
        if (engine != null) {
            return Arrays.asList(engine.getEnabledProtocols());
        }
        return super.getEnabledSSLProtocols();
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public long getMaxBlockedWriteTimeLimit() {
        return this.currentConfig.getMaxBlockedWriteTimeLimit();
    }

    public int getMaxRequestSize() {
        return (int)this.currentConfig.getMaxRequestSize();
    }

    public int getBufferSize() {
        return (int)this.currentConfig.getBufferSize();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        return this.sslClientAuthPolicy;
    }

    public LDAPStatistics getStatTracker() {
        return this.statTracker;
    }

    @Override
    public void initializeConnectionHandler(LDAPConnectionHandlerCfg config) throws ConfigException, InitializationException {
        int i;
        if (this.friendlyName == null) {
            this.friendlyName = config.dn().getRDN().getAttributeValue(0).toString();
        }
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_OPEN_SELECTOR_FAILED.get(String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.currentConfig = config;
        this.enabled = config.isEnabled();
        this.requestHandlerIndex = 0;
        this.allowedClients = config.getAllowedClient();
        this.deniedClients = config.getDeniedClient();
        try {
            this.configureSSL(config);
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new InitializationException(e.getMessageObject());
        }
        this.allowReuseAddress = config.isAllowTCPReuseAddress();
        this.backlog = config.getAcceptBacklog();
        this.listenAddresses = config.getListenAddress();
        this.listenPort = config.getListenPort();
        this.numRequestHandlers = this.getNumRequestHandlers(config.getNumRequestHandlers(), this.friendlyName);
        this.listeners = new LinkedList<HostPort>();
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(this.friendlyName);
        for (InetAddress a : this.listenAddresses) {
            this.listeners.add(new HostPort(a.getHostAddress(), this.listenPort));
            nameBuffer.append(" ");
            nameBuffer.append(a.getHostAddress());
        }
        nameBuffer.append(" port ");
        nameBuffer.append(this.listenPort);
        this.handlerName = nameBuffer.toString();
        Message errorMessage = this.checkAnyListenAddressInUse(this.listenAddresses, this.listenPort, this.allowReuseAddress, config.dn());
        if (errorMessage != null) {
            ErrorLogger.logError(errorMessage);
            throw new InitializationException(errorMessage);
        }
        System.setProperty(this.protocol + "_port", String.valueOf(this.listenPort));
        this.connectionFinalizer = Executors.newSingleThreadScheduledExecutor(new DirectoryThread.Factory("LDAP Connection Finalizer for connection handler " + this.toString()));
        this.connectionFinalizerActiveJobQueue = new ArrayList<Runnable>();
        this.connectionFinalizerPendingJobQueue = new ArrayList<Runnable>();
        this.connectionFinalizer.scheduleWithFixedDelay(new ConnectionFinalizerRunnable(), 100L, 100L, TimeUnit.MILLISECONDS);
        this.requestHandlers = new LDAPRequestHandler[this.numRequestHandlers];
        for (i = 0; i < this.numRequestHandlers; ++i) {
            this.requestHandlers[i] = new LDAPRequestHandler(this, i);
        }
        for (i = 0; i < this.numRequestHandlers; ++i) {
            this.requestHandlers[i].start();
        }
        DirectoryServer.registerSupportedLDAPVersion(3, this);
        if (config.isAllowLDAPV2()) {
            DirectoryServer.registerSupportedLDAPVersion(2, this);
        }
        this.statTracker = new LDAPStatistics(this.handlerName + " Statistics");
        DirectoryServer.registerMonitorProvider(this.statTracker);
        this.connMonitor = new ClientConnectionMonitorProvider(this);
        DirectoryServer.registerMonitorProvider(this.connMonitor);
        config.addLDAPChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        Message errorMessage;
        LDAPConnectionHandlerCfg config = (LDAPConnectionHandlerCfg)configuration;
        if ((this.currentConfig == null || !this.currentConfig.isEnabled() && config.isEnabled()) && (errorMessage = this.checkAnyListenAddressInUse(config.getListenAddress(), config.getListenPort(), config.isAllowTCPReuseAddress(), config.dn())) != null) {
            unacceptableReasons.add(errorMessage);
            return false;
        }
        if (config.isEnabled() && (config.isUseSSL() || config.isAllowStartTLS())) {
            try {
                SSLContext sslContext = this.createSSLContext(config);
                this.createSSLEngine(config, sslContext);
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                unacceptableReasons.add(e.getMessageObject());
                return false;
            }
        }
        return true;
    }

    private Message checkAnyListenAddressInUse(Collection<InetAddress> listenAddresses, int listenPort, boolean allowReuseAddress, DN configEntryDN) {
        for (InetAddress a : listenAddresses) {
            try {
                if (!StaticUtils.isAddressInUse(a, listenPort, allowReuseAddress)) continue;
                throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                return ProtocolMessages.ERR_CONNHANDLER_CANNOT_BIND.get("LDAP", String.valueOf(configEntryDN), a.getHostAddress(), listenPort, StaticUtils.getExceptionMessage(e));
            }
        }
        return null;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDAPConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        return this.isConfigurationAcceptable(config, unacceptableReasons);
    }

    public boolean keepStats() {
        return this.currentConfig.isKeepStats();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
        try {
            for (LDAPRequestHandler requestHandler : this.requestHandlers) {
                try {
                    requestHandler.processServerShutdown(reason);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.waitListen;
        synchronized (object) {
            super.start();
            try {
                this.waitListen.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(this.handlerName);
        boolean listening = false;
        boolean starting = true;
        while (!this.shutdownRequested) {
            if (!this.enabled) {
                if (listening) {
                    this.cleanUpSelector();
                    listening = false;
                    ErrorLogger.logError(ProtocolMessages.NOTE_CONNHANDLER_STOPPED_LISTENING.get(this.handlerName));
                }
                if (starting) {
                    Object object = this.waitListen;
                    synchronized (object) {
                        starting = false;
                        this.waitListen.notify();
                    }
                }
                StaticUtils.sleep(1000L);
                continue;
            }
            try {
                this.cleanUpSelector();
                int numRegistered = this.registerChannels();
                Object object = this.waitListen;
                synchronized (object) {
                    this.waitListen.notify();
                }
                if (numRegistered == 0) {
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_NO_ACCEPTORS.get(String.valueOf(this.currentConfig.dn())));
                    this.enabled = false;
                    continue;
                }
                listening = true;
                boolean lastIterationFailed = false;
                while (this.enabled && !this.shutdownRequested) {
                    try {
                        this.serveIncomingConnections();
                        lastIterationFailed = false;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ProtocolMessages.ERR_CONNHANDLER_CANNOT_ACCEPT_CONNECTION.get(this.friendlyName, String.valueOf(this.currentConfig.dn()), StaticUtils.getExceptionMessage(e)));
                        if (lastIterationFailed) {
                            Message message = ProtocolMessages.ERR_CONNHANDLER_CONSECUTIVE_ACCEPT_FAILURES.get(this.friendlyName, String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", message);
                            this.cleanUpSelector();
                            this.enabled = false;
                            continue;
                        }
                        lastIterationFailed = true;
                    }
                }
                if (!this.shutdownRequested) continue;
                this.cleanUpSelector();
                this.selector.close();
                listening = false;
                this.enabled = false;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_UNCAUGHT_ERROR.get(String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerUncaughtError", message);
                this.cleanUpSelector();
                this.enabled = false;
            }
        }
    }

    private void serveIncomingConnections() throws IOException, DirectoryException {
        int selectorState = this.selector.select();
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            ServerSocketChannel serverChannel;
            SocketChannel clientChannel;
            SelectionKey key = iterator.next();
            iterator.remove();
            if (key.isAcceptable() && (clientChannel = (serverChannel = (ServerSocketChannel)key.channel()).accept()) != null) {
                this.acceptConnection(clientChannel);
            }
            if (selectorState != 0 || !this.enabled || this.shutdownRequested || !DebugLogger.debugEnabled()) continue;
            TRACER.debugWarning("Selector.select() returned 0. Selected Keys: %d, Interest Ops: %d, Ready Ops: %d ", this.selector.selectedKeys().size(), key.interestOps(), key.readyOps());
        }
    }

    private int registerChannels() {
        int numRegistered = 0;
        for (InetAddress a : this.listenAddresses) {
            try {
                ServerSocketChannel channel = ServerSocketChannel.open();
                channel.socket().setReuseAddress(this.allowReuseAddress);
                channel.socket().bind(new InetSocketAddress(a, this.listenPort), this.backlog);
                channel.configureBlocking(false);
                channel.register(this.selector, 16);
                ++numRegistered;
                ErrorLogger.logError(ProtocolMessages.NOTE_CONNHANDLER_STARTED_LISTENING.get(this.handlerName));
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_CREATE_CHANNEL_FAILED.get(String.valueOf(this.currentConfig.dn()), a.getHostAddress(), this.listenPort, StaticUtils.stackTraceToSingleLineString(e)));
            }
        }
        return numRegistered;
    }

    private void acceptConnection(SocketChannel clientChannel) throws DirectoryException {
        try {
            clientChannel.socket().setKeepAlive(this.currentConfig.isUseTCPKeepAlive());
            clientChannel.socket().setTcpNoDelay(this.currentConfig.isUseTCPNoDelay());
        }
        catch (SocketException se) {
            StaticUtils.close(clientChannel);
        }
        LDAPClientConnection clientConnection = new LDAPClientConnection(this, clientChannel, this.getProtocol());
        if (clientConnection.getConnectionID() < 0L) {
            clientConnection.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, ProtocolMessages.ERR_CONNHANDLER_REJECTED_BY_SERVER.get());
            return;
        }
        InetAddress clientAddr = clientConnection.getRemoteAddress();
        if (!this.deniedClients.isEmpty() && AddressMask.maskListContains(clientAddr, this.deniedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_CONNHANDLER_DENIED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return;
        }
        if (!this.allowedClients.isEmpty() && !AddressMask.maskListContains(clientAddr, this.allowedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_CONNHANDLER_DISALLOWED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return;
        }
        try {
            PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
            PluginResult.PostConnect pluginResult = pluginManager.invokePostConnectPlugins(clientConnection);
            if (!pluginResult.continueProcessing()) {
                clientConnection.disconnect(pluginResult.getDisconnectReason(), pluginResult.sendDisconnectNotification(), pluginResult.getErrorMessage());
                return;
            }
            LDAPRequestHandler requestHandler = this.requestHandlers[this.requestHandlerIndex++];
            if (this.requestHandlerIndex >= this.numRequestHandlers) {
                this.requestHandlerIndex = 0;
            }
            requestHandler.registerClient(clientConnection);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.INFO_CONNHANDLER_UNABLE_TO_REGISTER_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            clientConnection.disconnect(DisconnectReason.SERVER_ERROR, this.currentConfig.isSendRejectionNotice(), message);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.handlerName);
    }

    public boolean useSSL() {
        return this.currentConfig.isUseSSL();
    }

    private void cleanUpSelector() {
        block8: {
            try {
                for (SelectionKey key : this.selector.keys()) {
                    block7: {
                        try {
                            key.cancel();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block7;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    try {
                        key.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public QueueingStrategy getQueueingStrategy() {
        return this.queueingStrategy;
    }

    public TLSByteChannel getTLSByteChannel(ByteChannel channel) throws DirectoryException {
        SSLEngine sslEngine = this.createSSLEngine(this.currentConfig, this.sslContext);
        return new TLSByteChannel(channel, sslEngine);
    }

    private SSLEngine createSSLEngine(LDAPConnectionHandlerCfg config, SSLContext sslContext) throws DirectoryException {
        try {
            SortedSet<String> ciphers;
            SSLEngine sslEngine = sslContext.createSSLEngine();
            sslEngine.setUseClientMode(false);
            SortedSet<String> protocols = config.getSSLProtocol();
            if (!protocols.isEmpty()) {
                sslEngine.setEnabledProtocols(protocols.toArray(new String[0]));
            }
            if (!(ciphers = config.getSSLCipherSuite()).isEmpty()) {
                sslEngine.setEnabledCipherSuites(ciphers.toArray(new String[0]));
            }
            switch (config.getSSLClientAuthPolicy()) {
                case DISABLED: {
                    sslEngine.setNeedClientAuth(false);
                    sslEngine.setWantClientAuth(false);
                    break;
                }
                case REQUIRED: {
                    sslEngine.setWantClientAuth(true);
                    sslEngine.setNeedClientAuth(true);
                    break;
                }
                default: {
                    sslEngine.setNeedClientAuth(false);
                    sslEngine.setWantClientAuth(true);
                }
            }
            return sslEngine;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ResultCode resCode = DirectoryServer.getServerErrorResultCode();
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(resCode, message, e);
        }
    }

    private void disableAndWarnIfUseSSL(LDAPConnectionHandlerCfg config) {
        if (config.isUseSSL()) {
            Message message = ProtocolMessages.WARN_DISABLE_CONNECTION.get(this.friendlyName);
            ErrorLogger.logError(message);
            this.enabled = false;
        }
    }

    private SSLContext createSSLContext(LDAPConnectionHandlerCfg config) throws DirectoryException {
        try {
            KeyManager[] keyManagers;
            Message message;
            DN keyMgrDN = config.getKeyManagerProviderDN();
            KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider(keyMgrDN);
            if (keyManagerProvider == null) {
                message = ProtocolMessages.WARN_NULL_KEY_PROVIDER_MANAGER.get(keyMgrDN.toString(), this.friendlyName);
                ErrorLogger.logError(message);
                this.disableAndWarnIfUseSSL(config);
                keyManagerProvider = new NullKeyManagerProvider();
            } else if (!keyManagerProvider.containsAtLeastOneKey()) {
                message = ProtocolMessages.WARN_INVALID_KEYSTORE.get(this.friendlyName);
                ErrorLogger.logError(message);
                this.disableAndWarnIfUseSSL(config);
            }
            String alias = config.getSSLCertNickname();
            if (alias == null) {
                keyManagers = keyManagerProvider.getKeyManagers();
            } else {
                if (!keyManagerProvider.containsKeyWithAlias(alias)) {
                    Message message2 = ProtocolMessages.WARN_KEYSTORE_DOES_NOT_CONTAIN_ALIAS.get(alias, this.friendlyName);
                    ErrorLogger.logError(message2);
                    this.disableAndWarnIfUseSSL(config);
                }
                keyManagers = SelectableCertificateKeyManager.wrap(keyManagerProvider.getKeyManagers(), alias);
            }
            DN trustMgrDN = config.getTrustManagerProviderDN();
            TrustManagerProvider trustManagerProvider = DirectoryServer.getTrustManagerProvider(trustMgrDN);
            if (trustManagerProvider == null) {
                trustManagerProvider = new NullTrustManagerProvider();
            }
            SSLContext sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE_NAME);
            sslContext.init(keyManagers, trustManagerProvider.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            ResultCode resCode = DirectoryServer.getServerErrorResultCode();
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(resCode, message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnectionFinalizer(Runnable r) {
        Object object = this.connectionFinalizerLock;
        synchronized (object) {
            if (this.connectionFinalizer != null) {
                this.connectionFinalizerPendingJobQueue.add(r);
            } else {
                r.run();
            }
        }
    }

    private final class ConnectionFinalizerRunnable
    implements Runnable {
        private ConnectionFinalizerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue.isEmpty()) {
                for (Runnable r : LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue) {
                    r.run();
                }
                LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue.clear();
            }
            Object object = LDAPConnectionHandler.this.connectionFinalizerLock;
            synchronized (object) {
                List tmp = LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue;
                LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue = LDAPConnectionHandler.this.connectionFinalizerPendingJobQueue;
                LDAPConnectionHandler.this.connectionFinalizerPendingJobQueue = tmp;
            }
        }
    }
}

