/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import java.io.Serializable;
import java.util.Date;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public class ChangeNumber
implements Serializable,
Comparable<ChangeNumber> {
    public static final int BYTE_ENCODING_LENGTH = 14;
    public static final int STRING_ENCODING_LENGTH = 28;
    private static final long serialVersionUID = -8802722277749190740L;
    private final long timeStamp;
    private final int seqnum;
    private final int serverId;

    public static ChangeNumber valueOf(String s) {
        return new ChangeNumber(s);
    }

    public static ChangeNumber valueOf(ByteSequence bs) {
        ByteSequenceReader reader = bs.asReader();
        long timeStamp = reader.getLong();
        int serverId = reader.getShort() & 0xFFFF;
        int seqnum = reader.getInt();
        return new ChangeNumber(timeStamp, seqnum, serverId);
    }

    public ChangeNumber(String str) {
        String temp = str.substring(0, 16);
        this.timeStamp = Long.parseLong(temp, 16);
        temp = str.substring(16, 20);
        this.serverId = Integer.parseInt(temp, 16);
        temp = str.substring(20, 28);
        this.seqnum = Integer.parseInt(temp, 16);
    }

    public ChangeNumber(long time, int seq, int serverId2) {
        this.serverId = serverId2;
        this.timeStamp = time;
        this.seqnum = seq;
    }

    public long getTime() {
        return this.timeStamp;
    }

    public long getTimeSec() {
        return this.timeStamp / 1000L;
    }

    public int getSeqnum() {
        return this.seqnum;
    }

    public int getServerId() {
        return this.serverId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeNumber) {
            ChangeNumber cn = (ChangeNumber)obj;
            return this.seqnum == cn.seqnum && this.serverId == cn.serverId && this.timeStamp == cn.timeStamp;
        }
        return false;
    }

    public int hashCode() {
        return this.seqnum + this.serverId + Long.valueOf(this.timeStamp).hashCode();
    }

    public ByteString toByteString() {
        return this.toByteString(new ByteStringBuilder(14)).toByteString();
    }

    public ByteStringBuilder toByteString(ByteStringBuilder builder) {
        return builder.append(this.timeStamp).append((short)(this.serverId & 0xFFFF)).append(this.seqnum);
    }

    public String toString() {
        return String.format("%016x%04x%08x", this.timeStamp, this.serverId, this.seqnum);
    }

    public String toStringUI() {
        Date date = new Date(this.timeStamp);
        return String.format("%016x%04x%08x (sid=%d,tsd=%s,ts=%d,seqnum=%d)", this.timeStamp, this.serverId, this.seqnum, this.serverId, date.toString(), this.timeStamp, this.seqnum);
    }

    public static int compare(ChangeNumber CN1, ChangeNumber CN2) {
        if (CN1 == null) {
            if (CN2 == null) {
                return 0;
            }
            return -1;
        }
        if (CN2 == null) {
            return 1;
        }
        if (CN1.timeStamp < CN2.timeStamp) {
            return -1;
        }
        if (CN2.timeStamp < CN1.timeStamp) {
            return 1;
        }
        if (CN1.seqnum < CN2.seqnum) {
            return -1;
        }
        if (CN2.seqnum < CN1.seqnum) {
            return 1;
        }
        if (CN1.serverId < CN2.serverId) {
            return -1;
        }
        if (CN2.serverId < CN1.serverId) {
            return 1;
        }
        return 0;
    }

    public static int diffSeqNum(ChangeNumber op1, ChangeNumber op2) {
        if (op1 == null) {
            return 0;
        }
        if (op2 == null) {
            return op1.getSeqnum();
        }
        if (op2.newerOrEquals(op1)) {
            return 0;
        }
        int seqnum1 = op1.getSeqnum();
        long time1 = op1.getTime();
        int seqnum2 = op2.getSeqnum();
        long time2 = op2.getTime();
        if (time2 <= time1) {
            if (seqnum2 <= seqnum1) {
                return seqnum1 - seqnum2;
            }
            return Integer.MAX_VALUE - (seqnum2 - seqnum1) + 1;
        }
        return 0;
    }

    public Boolean older(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) < 0;
    }

    public Boolean olderOrEqual(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) <= 0;
    }

    public boolean newerOrEquals(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) >= 0;
    }

    public boolean newer(ChangeNumber CN) {
        return ChangeNumber.compare(this, CN) > 0;
    }

    @Override
    public int compareTo(ChangeNumber cn) {
        return ChangeNumber.compare(this, cn);
    }
}

