/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class HistoricalCsnOrderingMatchingRule
extends AbstractMatchingRule
implements OrderingMatchingRule {
    private static final long serialVersionUID = -3424403930225609943L;

    @Override
    public int compareValues(ByteSequence value1, ByteSequence value2) {
        return value1.compareTo(value2);
    }

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "historicalCsnOrderingMatch";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.4";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.40";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        try {
            int csnIndex = value.toString().indexOf(58) + 1;
            String csn = value.subSequence(csnIndex, csnIndex + 28).toString();
            ByteStringBuilder builder = new ByteStringBuilder(14);
            builder.append(StaticUtils.hexStringToByteArray(csn.substring(16, 20)));
            builder.append(StaticUtils.hexStringToByteArray(csn.substring(0, 16)));
            builder.append(StaticUtils.hexStringToByteArray(csn.substring(20, 28)));
            return builder.toByteString();
        }
        catch (Exception e) {
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, ReplicationMessages.WARN_INVALID_SYNC_HIST_VALUE.get(String.valueOf(value)), e);
        }
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        return 1;
    }
}

