/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.SubtreeDeleteControl;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.ByteString;
import org.opends.server.types.Operation;
import org.opends.server.types.operation.PostOperationDeleteOperation;

public class DeleteMsg
extends LDAPUpdateMsg {
    private String initiatorsName;
    private boolean isSubtreeDelete = false;

    public DeleteMsg(PostOperationDeleteOperation operation) {
        super((OperationContext)operation.getAttachment("replicationContext"), operation.getRawEntryDN().toString());
        try {
            if (operation.getRequestControl(SubtreeDeleteControl.DECODER) != null) {
                this.isSubtreeDelete = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DeleteMsg(String dn, ChangeNumber changeNumber, String entryUUID) {
        super(new DeleteContext(changeNumber, entryUUID), dn);
    }

    public DeleteMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{24, 3};
        int pos = this.decodeHeader(allowedPduTypes, in);
        if (this.protocolVersion >= 4) {
            this.decodeBody_V4(in, pos);
        } else {
            this.isSubtreeDelete = true;
        }
    }

    @Override
    public Operation createOperation(InternalClientConnection connection, String newDn) {
        DeleteOperationBasis del = new DeleteOperationBasis((ClientConnection)connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, ByteString.valueOf(newDn));
        if (this.isSubtreeDelete) {
            del.addRequestControl(new SubtreeDeleteControl(false));
        }
        DeleteContext ctx = new DeleteContext(this.getChangeNumber(), this.getEntryUUID());
        del.setAttachment("replicationContext", ctx);
        return del;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        return this.encodeHeader_V1((byte)3, 0);
    }

    @Override
    public byte[] getBytes_V23() throws UnsupportedEncodingException {
        return this.encodeHeader((byte)24, 0, (short)3);
    }

    @Override
    public byte[] getBytes_V45(short reqProtocolVersion) throws UnsupportedEncodingException {
        int bodyLength = 0;
        byte[] byteEntryAttrLen = String.valueOf(this.encodedEclIncludes.length).getBytes("UTF-8");
        bodyLength += byteEntryAttrLen.length + 1;
        bodyLength += this.encodedEclIncludes.length + 1;
        byte[] byteInitiatorsName = null;
        if (this.initiatorsName != null) {
            byteInitiatorsName = this.initiatorsName.getBytes("UTF-8");
            bodyLength += byteInitiatorsName.length + 1;
        } else {
            ++bodyLength;
        }
        byte[] encodedMsg = this.encodeHeader((byte)24, ++bodyLength, reqProtocolVersion);
        int pos = encodedMsg.length - bodyLength;
        if (byteInitiatorsName != null) {
            pos = DeleteMsg.addByteArray(byteInitiatorsName, encodedMsg, pos);
        } else {
            encodedMsg[pos++] = 0;
        }
        pos = DeleteMsg.addByteArray(byteEntryAttrLen, encodedMsg, pos);
        pos = DeleteMsg.addByteArray(this.encodedEclIncludes, encodedMsg, pos);
        encodedMsg[pos++] = this.isSubtreeDelete ? (byte)1 : 0;
        return encodedMsg;
    }

    private void decodeBody_V4(byte[] in, int pos) throws DataFormatException, UnsupportedEncodingException {
        int length = DeleteMsg.getNextLength(in, pos);
        if (length != 0) {
            this.initiatorsName = new String(in, pos, length, "UTF-8");
            pos += length + 1;
        } else {
            this.initiatorsName = null;
            ++pos;
        }
        length = DeleteMsg.getNextLength(in, pos);
        int eclAttrLen = Integer.valueOf(new String(in, pos, length, "UTF-8"));
        pos += length + 1;
        this.encodedEclIncludes = new byte[eclAttrLen];
        try {
            System.arraycopy(in, pos, this.encodedEclIncludes, 0, eclAttrLen);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (ArrayStoreException e) {
            throw new DataFormatException(e.getMessage());
        }
        catch (NullPointerException e) {
            throw new DataFormatException(e.getMessage());
        }
        this.isSubtreeDelete = in[pos += eclAttrLen + 1] == 1;
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "DeleteMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.entryUUID + " assuredFlag: " + this.assuredFlag;
        }
        if (this.protocolVersion >= 2) {
            return "DeleteMsg content:  protocolVersion: " + this.protocolVersion + " dn: " + this.dn + " changeNumber: " + this.changeNumber + " uniqueId: " + this.entryUUID + " assuredFlag: " + this.assuredFlag + " assuredMode: " + (Object)((Object)this.assuredMode) + " safeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    @Override
    public int size() {
        return this.encodedEclIncludes.length + this.headerSize();
    }

    public void setInitiatorsName(String iname) {
        this.initiatorsName = iname;
    }

    public String getInitiatorsName() {
        return this.initiatorsName;
    }

    public void setSubtreeDelete(boolean subtreeDelete) {
        this.isSubtreeDelete = subtreeDelete;
    }

    public boolean isSubtreeDelete() {
        return this.isSubtreeDelete;
    }
}

