/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.EntryHistorical;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.RawModification;

public abstract class ModifyCommonMsg
extends LDAPUpdateMsg {
    protected byte[] encodedMods = new byte[0];

    public ModifyCommonMsg() {
    }

    public ModifyCommonMsg(OperationContext ctx, String dn) {
        super(ctx, dn);
    }

    public ModifyCommonMsg(ChangeNumber cn, String entryUUID, String dn) {
        super(cn, entryUUID, dn);
    }

    public void setMods(List<Modification> mods) {
        this.encodedMods = this.encodeMods(mods);
    }

    public List<Modification> getMods() throws ASN1Exception, LDAPException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        ASN1Reader reader = ASN1.getReader(this.encodedMods);
        while (reader.hasNextElement()) {
            mods.add(LDAPModification.decode(reader).toModification());
        }
        return mods;
    }

    protected byte[] encodeMods(List<Modification> mods) {
        if (mods == null || mods.size() == 0) {
            return new byte[0];
        }
        ByteStringBuilder byteBuilder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(byteBuilder);
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            AttributeType type = attr.getAttributeType();
            if (type != null && AttributeUsage.DSA_OPERATION.equals((Object)type.getUsage()) || EntryHistorical.isHistoricalAttribute(attr)) continue;
            LDAPModification ldapmod = new LDAPModification(mod.getModificationType(), new LDAPAttribute(mod.getAttribute()));
            try {
                ldapmod.write(writer);
            }
            catch (Exception exception) {}
        }
        return byteBuilder.toByteArray();
    }

    protected List<Modification> decodeMods(byte[] in) throws ASN1Exception, LDAPException {
        ArrayList<Modification> mods = new ArrayList<Modification>();
        ASN1Reader reader = ASN1.getReader(in);
        while (reader.hasNextElement()) {
            mods.add(LDAPModification.decode(reader).toModification());
        }
        return mods;
    }

    protected ArrayList<RawModification> decodeRawMods(byte[] in) throws LDAPException, ASN1Exception {
        ArrayList<RawModification> ldapmods = new ArrayList<RawModification>();
        ASN1Reader asn1Reader = ASN1.getReader(in);
        while (asn1Reader.hasNextElement()) {
            ldapmods.add(LDAPModification.decode(asn1Reader));
        }
        return ldapmods;
    }
}

