/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.StartMsg;

public class ServerStartECLMsg
extends StartMsg {
    private String serverURL;
    private int maxReceiveQueue;
    private int maxSendQueue;
    private int maxReceiveDelay;
    private int maxSendDelay;
    private int windowSize;
    private ServerState serverState = null;
    private long heartbeatInterval = 0L;
    private boolean sslEncryption;

    public ServerStartECLMsg(String serverURL, int maxReceiveDelay, int maxReceiveQueue, int maxSendDelay, int maxSendQueue, int windowSize, long heartbeatInterval, ServerState serverState, long generationId, boolean sslEncryption, byte groupId) {
        super((short)-1, generationId);
        this.serverURL = serverURL;
        this.maxReceiveDelay = maxReceiveDelay;
        this.maxReceiveQueue = maxReceiveQueue;
        this.maxSendDelay = maxSendDelay;
        this.maxSendQueue = maxSendQueue;
        this.windowSize = windowSize;
        this.heartbeatInterval = heartbeatInterval;
        this.sslEncryption = sslEncryption;
        this.serverState = serverState;
        this.groupId = groupId;
    }

    public ServerStartECLMsg(byte[] in) throws DataFormatException {
        byte[] allowedPduTypes = new byte[]{30};
        this.headerLength = this.decodeHeader(allowedPduTypes, in);
        try {
            int pos = this.headerLength;
            int length = ServerStartECLMsg.getNextLength(in, pos);
            this.serverURL = new String(in, pos, length, "UTF-8");
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.maxReceiveDelay = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.maxReceiveQueue = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.maxSendDelay = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.maxSendQueue = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.windowSize = Integer.valueOf(new String(in, pos, length, "UTF-8"));
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.heartbeatInterval = Integer.valueOf(new String(in, pos, length, "UTF-8")).intValue();
            pos += length + 1;
            length = ServerStartECLMsg.getNextLength(in, pos);
            this.sslEncryption = Boolean.valueOf(new String(in, pos, length, "UTF-8"));
            this.serverState = new ServerState(in, pos += length + 1, in.length - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public int getMaxReceiveDelay() {
        return this.maxReceiveDelay;
    }

    public int getMaxReceiveQueue() {
        return this.maxReceiveQueue;
    }

    public int getMaxSendDelay() {
        return this.maxSendDelay;
    }

    public int getMaxSendQueue() {
        return this.maxSendQueue;
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    @Override
    public byte[] getBytes(short sessionProtocolVersion) {
        try {
            byte[] byteServerUrl = this.serverURL.getBytes("UTF-8");
            byte[] byteMaxRecvDelay = String.valueOf(this.maxReceiveDelay).getBytes("UTF-8");
            byte[] byteMaxRecvQueue = String.valueOf(this.maxReceiveQueue).getBytes("UTF-8");
            byte[] byteMaxSendDelay = String.valueOf(this.maxSendDelay).getBytes("UTF-8");
            byte[] byteMaxSendQueue = String.valueOf(this.maxSendQueue).getBytes("UTF-8");
            byte[] byteWindowSize = String.valueOf(this.windowSize).getBytes("UTF-8");
            byte[] byteHeartbeatInterval = String.valueOf(this.heartbeatInterval).getBytes("UTF-8");
            byte[] byteSSLEncryption = String.valueOf(this.sslEncryption).getBytes("UTF-8");
            byte[] byteServerState = this.serverState.getBytes();
            int length = byteServerUrl.length + 1 + byteMaxRecvDelay.length + 1 + byteMaxRecvQueue.length + 1 + byteMaxSendDelay.length + 1 + byteMaxSendQueue.length + 1 + byteWindowSize.length + 1 + byteHeartbeatInterval.length + 1 + byteSSLEncryption.length + 1 + byteServerState.length + 1;
            byte[] resultByteArray = this.encodeHeader((byte)30, length, sessionProtocolVersion);
            int pos = this.headerLength;
            pos = ServerStartECLMsg.addByteArray(byteServerUrl, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteMaxRecvDelay, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteMaxRecvQueue, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteMaxSendDelay, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteMaxSendQueue, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteWindowSize, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteHeartbeatInterval, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteSSLEncryption, resultByteArray, pos);
            pos = ServerStartECLMsg.addByteArray(byteServerState, resultByteArray, pos);
            return resultByteArray;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public boolean getSSLEncryption() {
        return this.sslEncryption;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + " content: " + "\nprotocolVersion: " + this.protocolVersion + "\ngenerationId: " + this.generationId + "\ngroupId: " + this.groupId + "\nheartbeatInterval: " + this.heartbeatInterval + "\nmaxReceiveDelay: " + this.maxReceiveDelay + "\nmaxReceiveQueue: " + this.maxReceiveQueue + "\nmaxSendDelay: " + this.maxSendDelay + "\nmaxSendQueue: " + this.maxSendQueue + "\nserverState: " + this.serverState + "\nserverURL: " + this.serverURL + "\nsslEncryption: " + this.sslEncryption + "\nwindowSize: " + this.windowSize;
    }
}

