/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.DatabaseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationDB;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

public class DbHandler
implements Runnable {
    private final LinkedList<UpdateMsg> msgQueue = new LinkedList();
    int queueMaxSize = 5000;
    int queueLowmark = 1000;
    int queueHimark = 4000;
    int queueMaxBytes = 100 * this.queueMaxSize;
    int queueLowmarkBytes = 100 * this.queueLowmark;
    int queueHimarkBytes = 100 * this.queueHimark;
    int queueByteSize = 0;
    private ReplicationDB db;
    private ChangeNumber firstChange = null;
    private ChangeNumber lastChange = null;
    private int serverId;
    private String baseDn;
    private DbMonitorProvider dbMonitor = new DbMonitorProvider();
    private DirectoryThread thread;
    private final Object flushLock = new Object();
    private ReplicationServer replicationServer;
    private long latestTrimDate = 0L;
    private long trimAge;

    public DbHandler(int id, String baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv, int queueSize) throws DatabaseException {
        this.replicationServer = replicationServer;
        this.serverId = id;
        this.baseDn = baseDn;
        this.trimAge = replicationServer.getTrimAge();
        this.queueMaxSize = queueSize;
        this.queueLowmark = queueSize / 5;
        this.queueHimark = queueSize * 4 / 5;
        this.queueMaxBytes = 200 * this.queueMaxSize;
        this.queueLowmarkBytes = 200 * this.queueLowmark;
        this.queueHimarkBytes = 200 * this.queueLowmark;
        this.db = new ReplicationDB(id, baseDn, replicationServer, dbenv);
        this.firstChange = this.db.readFirstChange();
        this.lastChange = this.db.readLastChange();
        this.thread = new DirectoryThread(this, "Replication server RS(" + replicationServer.getServerId() + ") changelog checkpointer for Replica DS(" + id + ") for domain \"" + baseDn + "\"");
        this.thread.start();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor);
        DirectoryServer.registerMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMsg update) {
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            if (size > this.queueHimark || this.queueByteSize > this.queueHimarkBytes) {
                this.msgQueue.notify();
            }
            while (size > this.queueMaxSize || this.queueByteSize > this.queueMaxBytes) {
                try {
                    this.msgQueue.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                size = this.msgQueue.size();
            }
            this.queueByteSize += update.size();
            this.msgQueue.add(update);
            if (this.lastChange == null || this.lastChange.older(update.getChangeNumber()).booleanValue()) {
                this.lastChange = update.getChangeNumber();
            }
            if (this.firstChange == null) {
                this.firstChange = update.getChangeNumber();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UpdateMsg> getChanges(int number) {
        LinkedList<UpdateMsg> changes = new LinkedList<UpdateMsg>();
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            int size = this.msgQueue.size();
            for (int current = 0; current < number && current < size; ++current) {
                UpdateMsg msg = this.msgQueue.get(current);
                changes.add(msg);
            }
        }
        return changes;
    }

    public ChangeNumber getFirstChange() {
        return this.firstChange;
    }

    public ChangeNumber getLastChange() {
        return this.lastChange;
    }

    public long getChangesCount() {
        try {
            return this.lastChange.getSeqnum() - this.firstChange.getSeqnum() + 1;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public ReplicationIterator generateIterator(ChangeNumber changeNumber) throws DatabaseException, Exception {
        if (changeNumber == null) {
            this.flush();
        }
        return new ReplicationIterator(this.serverId, this.db, changeNumber, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueue(int number) {
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            for (int current = 0; current < number && !this.msgQueue.isEmpty(); ++current) {
                UpdateMsg msg = this.msgQueue.remove();
                this.queueByteSize -= msg.size();
            }
            if (this.msgQueue.size() < this.queueLowmark && this.queueByteSize < this.queueLowmarkBytes) {
                this.msgQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.thread.isShutdownInitiated()) {
            return;
        }
        LinkedList<UpdateMsg> linkedList = this.msgQueue;
        synchronized (linkedList) {
            this.msgQueue.notifyAll();
        }
        this.thread.initiateShutdown();
        while (this.msgQueue.size() != 0) {
            this.flush();
        }
        this.db.shutdown();
        DirectoryServer.deregisterMonitorProvider(this.dbMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.thread.startWork();
        try {
            while (!this.thread.isShutdownInitiated()) {
                try {
                    this.flush();
                    this.trim();
                    object = this.msgQueue;
                    synchronized (object) {
                        if (this.msgQueue.size() < this.queueLowmark && this.queueByteSize < this.queueLowmarkBytes) {
                            try {
                                this.msgQueue.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }
                }
                catch (Exception end) {
                    MessageBuilder mb = new MessageBuilder();
                    mb.append(ReplicationMessages.ERR_EXCEPTION_CHANGELOG_TRIM_FLUSH.get());
                    mb.append(" ");
                    mb.append(StaticUtils.stackTraceToSingleLineString(end));
                    ErrorLogger.logError(mb.toMessage());
                    this.thread.initiateShutdown();
                    if (this.replicationServer == null) break;
                    this.replicationServer.shutdown();
                    break;
                }
            }
            this.flush();
        }
        finally {
            this.thread.stopWork();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    public long getLatestTrimDate() {
        return this.latestTrimDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trim() throws DatabaseException, Exception {
        if (this.trimAge == 0L) {
            return;
        }
        this.latestTrimDate = TimeThread.getTime() - this.trimAge;
        ChangeNumber trimDate = new ChangeNumber(this.latestTrimDate, 0, 0);
        ChangeNumber lastBeforeTrimDate = this.db.getPreviousChangeNumber(trimDate);
        if (lastBeforeTrimDate != null) {
            trimDate = lastBeforeTrimDate;
        }
        int i = 0;
        while (i < 100) {
            Object object = this.flushLock;
            synchronized (object) {
                ReplicationDB.ReplServerDBCursor cursor = this.db.openDeleteCursor();
                try {
                    for (int j = 0; j < 50; ++j) {
                        if (this.thread.isShutdownInitiated()) {
                            return;
                        }
                        ChangeNumber changeNumber = cursor.nextChangeNumber();
                        if (changeNumber == null) {
                            return;
                        }
                        if (!changeNumber.equals(this.lastChange) && changeNumber.older(trimDate).booleanValue()) {
                            cursor.delete();
                            continue;
                        }
                        this.firstChange = changeNumber;
                        return;
                    }
                }
                catch (Exception e) {
                    cursor.abort();
                    this.thread.initiateShutdown();
                    throw e;
                }
                finally {
                    cursor.close();
                }
            }
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        int size;
        int chunksize = 500 < this.queueMaxSize ? 500 : this.queueMaxSize;
        do {
            Object object = this.flushLock;
            synchronized (object) {
                List<UpdateMsg> changes = this.getChanges(chunksize);
                if (changes == null || (size = changes.size()) == 0) {
                    return;
                }
                this.db.addEntries(changes);
                this.clearQueue(changes.size());
            }
        } while (size >= chunksize);
    }

    public String toString() {
        return this.baseDn + " " + this.serverId + " " + this.firstChange + " " + this.lastChange;
    }

    public void setPurgeDelay(long delay) {
        this.trimAge = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws DatabaseException, Exception {
        Object object = this.flushLock;
        synchronized (object) {
            this.msgQueue.clear();
            this.queueByteSize = 0;
            this.db.clear();
            this.firstChange = this.db.readFirstChange();
            this.lastChange = this.db.readLastChange();
        }
    }

    public int getServerId() {
        return this.serverId;
    }

    public int getQueueSize() {
        return this.msgQueue.size();
    }

    public void setCounterWindowSize(int size) {
        this.db.setCounterWindowSize(size);
    }

    public int getCount(ChangeNumber from, ChangeNumber to) {
        int c = 0;
        if (to == null || !to.older(new ChangeNumber(this.latestTrimDate, 0, 0)).booleanValue()) {
            this.flush();
            c = this.db.count(from, to);
        }
        return c;
    }

    private class DbMonitorProvider
    extends MonitorProvider<MonitorProviderCfg> {
        private DbMonitorProvider() {
        }

        public ArrayList<Attribute> getMonitorData() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            attributes.add(Attributes.create("replicationServer-database", String.valueOf(DbHandler.this.serverId)));
            attributes.add(Attributes.create("domain-name", DbHandler.this.baseDn));
            if (DbHandler.this.firstChange != null) {
                Date firstTime = new Date(DbHandler.this.firstChange.getTime());
                attributes.add(Attributes.create("first-change", DbHandler.this.firstChange.toString() + " " + firstTime.toString()));
            }
            if (DbHandler.this.lastChange != null) {
                Date lastTime = new Date(DbHandler.this.lastChange.getTime());
                attributes.add(Attributes.create("last-change", DbHandler.this.lastChange.toString() + " " + lastTime.toString()));
            }
            attributes.add(Attributes.create("queue-size", String.valueOf(DbHandler.this.msgQueue.size())));
            attributes.add(Attributes.create("queue-size-bytes", String.valueOf(DbHandler.this.queueByteSize)));
            return attributes;
        }

        @Override
        public String getMonitorInstanceName() {
            ReplicationServerDomain domain = DbHandler.this.replicationServer.getReplicationServerDomain(DbHandler.this.baseDn, false);
            return "Changelog for DS(" + DbHandler.this.serverId + "),cn=" + domain.getMonitorInstanceName();
        }

        @Override
        public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
        }
    }
}

