/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.util.TimeThread;

public class MonitorData {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<Integer, ServerState> LDAPStates = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ServerState> RSStates = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, ChangeNumber> maxCNs = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Long> fmd = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Long> missingChanges = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, Long> missingChangesRS = new ConcurrentHashMap();

    public long getApproxDelay(int serverId) {
        Long afmd = this.fmd.get(serverId);
        if (afmd != null && afmd > 0L) {
            return (TimeThread.getTime() - afmd) / 1000L;
        }
        return 0L;
    }

    public long getApproxFirstMissingDate(int serverId) {
        Long res = this.fmd.get(serverId);
        if (res != null) {
            return res;
        }
        return 0L;
    }

    public long getMissingChanges(int serverId) {
        Long res = this.missingChanges.get(serverId);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    public long getMissingChangesRS(int serverId) {
        Long res = this.missingChangesRS.get(serverId);
        if (res == null) {
            return 0L;
        }
        return res;
    }

    public void completeComputing() {
        int missingChangesLsiLsj;
        ChangeNumber lsiLastCN;
        ChangeNumber lsjMaxCN;
        Long lsiMissingChanges;
        ServerState lsiState;
        String mds = "";
        for (Integer lsiSid : this.LDAPStates.keySet()) {
            lsiState = this.LDAPStates.get(lsiSid);
            lsiMissingChanges = 0L;
            if (lsiState != null) {
                for (Integer lsjSid : this.maxCNs.keySet()) {
                    lsjMaxCN = this.maxCNs.get(lsjSid);
                    lsiLastCN = lsiState.getMaxChangeNumber(lsjSid);
                    missingChangesLsiLsj = ChangeNumber.diffSeqNum(lsjMaxCN, lsiLastCN);
                    if (DebugLogger.debugEnabled()) {
                        mds = mds + "+ diff(" + lsjMaxCN + "-" + lsiLastCN + ")=" + missingChangesLsiLsj;
                    }
                    if (lsjSid.equals(lsiSid) && missingChangesLsiLsj <= 50) {
                        missingChangesLsiLsj = 0;
                        if (DebugLogger.debugEnabled()) {
                            mds = mds + " (diff replaced by 0 as for server id " + lsiSid + ")";
                        }
                    }
                    lsiMissingChanges = lsiMissingChanges + (long)missingChangesLsiLsj;
                }
            }
            if (DebugLogger.debugEnabled()) {
                mds = mds + "=" + lsiMissingChanges;
            }
            this.missingChanges.put(lsiSid, lsiMissingChanges);
        }
        Iterator i$ = this.RSStates.keySet().iterator();
        while (i$.hasNext()) {
            int lsiSid = (Integer)i$.next();
            lsiState = this.RSStates.get(lsiSid);
            lsiMissingChanges = 0L;
            if (lsiState != null) {
                for (Integer lsjSid : this.maxCNs.keySet()) {
                    lsjMaxCN = this.maxCNs.get(lsjSid);
                    lsiLastCN = lsiState.getMaxChangeNumber(lsjSid);
                    missingChangesLsiLsj = ChangeNumber.diffSeqNum(lsjMaxCN, lsiLastCN);
                    if (DebugLogger.debugEnabled()) {
                        mds = mds + "+ diff(" + lsjMaxCN + "-" + lsiLastCN + ")=" + missingChangesLsiLsj;
                    }
                    lsiMissingChanges = lsiMissingChanges + (long)missingChangesLsiLsj;
                }
            }
            if (DebugLogger.debugEnabled()) {
                mds = mds + "=" + lsiMissingChanges;
            }
            this.missingChangesRS.put(lsiSid, lsiMissingChanges);
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugInfo("Complete monitor data : Missing changes (" + lsiSid + ")=" + mds);
        }
    }

    public String toString() {
        ServerState ss;
        String mds = "Monitor data=\n";
        for (Integer sid : this.maxCNs.keySet()) {
            ChangeNumber cn = this.maxCNs.get(sid);
            mds = mds + "\nmaxCNs(" + sid + ")= " + cn.toStringUI();
        }
        for (Integer sid : this.LDAPStates.keySet()) {
            ss = this.LDAPStates.get(sid);
            mds = mds + "\nLSData(" + sid + ")=\t" + "state=[" + ss.toString() + "] afmd=" + this.getApproxFirstMissingDate(sid);
            mds = mds + " missingDelay=" + this.getApproxDelay(sid);
            mds = mds + " missingCount=" + this.missingChanges.get(sid);
        }
        for (Integer sid : this.RSStates.keySet()) {
            ss = this.RSStates.get(sid);
            mds = mds + "\nRSData(" + sid + ")=\t" + "state=[" + ss.toString() + "] missingCount=" + this.missingChangesRS.get(sid);
        }
        mds = mds + "\n--";
        return mds;
    }

    public void setMaxCNs(ServerState state) {
        for (Integer sid : state) {
            ChangeNumber newCN = state.getMaxChangeNumber(sid);
            this.setMaxCN(sid, newCN);
        }
    }

    public void setMaxCN(int serverId, ChangeNumber newCN) {
        if (newCN == null) {
            return;
        }
        ChangeNumber currentMaxCN = this.maxCNs.get(serverId);
        if (currentMaxCN == null) {
            this.maxCNs.put(serverId, newCN);
        } else if (newCN.newer(currentMaxCN)) {
            this.maxCNs.replace(serverId, newCN);
        }
    }

    public ServerState getLDAPServerState(int serverId) {
        return this.LDAPStates.get(serverId);
    }

    public void setLDAPServerState(int serverId, ServerState state) {
        this.LDAPStates.put(serverId, state);
    }

    public void setRSState(int serverId, ServerState state) {
        this.RSStates.put(serverId, state);
    }

    public void setFirstMissingDate(int serverId, Long newFmd) {
        if (newFmd == null) {
            return;
        }
        Long currentfmd = this.fmd.get(serverId);
        if (currentfmd == null) {
            this.fmd.put(serverId, newFmd);
        } else if (newFmd != 0L && (newFmd < currentfmd || currentfmd == 0L)) {
            this.fmd.replace(serverId, newFmd);
        }
    }

    public Iterator<Integer> ldapIterator() {
        return this.LDAPStates.keySet().iterator();
    }

    public Iterator<Integer> rsIterator() {
        return this.RSStates.keySet().iterator();
    }

    public ServerState getRSStates(int serverId) {
        return this.RSStates.get(serverId);
    }

    public long getRSApproxFirstMissingDate(int serverId) {
        return 0L;
    }
}

