/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationData;
import org.opends.server.replication.server.ReplicationDbEnv;
import org.opends.server.replication.server.ReplicationKey;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.util.StaticUtils;

public class ReplicationDB {
    private Database db = null;
    private ReplicationDbEnv dbenv = null;
    private ReplicationServer replicationServer;
    private int serverId;
    private String baseDn;
    private ReentrantReadWriteLock dbCloseLock;
    private int counterCurrValue = 1;
    private long counterTsLimit = 0L;
    private int counterWindowSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationDB(int serverId, String baseDn, ReplicationServer replicationServer, ReplicationDbEnv dbenv) throws DatabaseException {
        this.serverId = serverId;
        this.baseDn = baseDn;
        this.dbenv = dbenv;
        this.replicationServer = replicationServer;
        this.db = dbenv.getOrAddDb(serverId, baseDn, replicationServer.getReplicationServerDomain(baseDn, true).getGenerationId());
        this.dbCloseLock = new ReentrantReadWriteLock(true);
        Transaction txn = null;
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        int distBackToCounterRecord = 0;
        this.counterCurrValue = 1;
        Cursor cursor = this.db.openCursor(txn, null);
        try {
            OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                ChangeNumber cn = new ChangeNumber(StaticUtils.decodeUTF8(key.getData()));
                if (!ReplicationDB.isaCounter(cn)) {
                    status = cursor.getPrev(key, data, LockMode.DEFAULT);
                    ++distBackToCounterRecord;
                    continue;
                }
                this.counterCurrValue = ReplicationDB.decodeCounterValue(data.getData()) + 1;
                this.counterTsLimit = cn.getTime();
                break;
            }
            this.counterCurrValue += distBackToCounterRecord;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntries(List<UpdateMsg> changes) {
        try {
            this.dbCloseLock.readLock().lock();
            try {
                if (this.isDBClosed()) {
                    return;
                }
                for (UpdateMsg change : changes) {
                    ReplicationKey key = new ReplicationKey(change.getChangeNumber());
                    ReplicationData data = new ReplicationData(change);
                    if (this.counterCurrValue != 0 && this.counterCurrValue % this.counterWindowSize == 0) {
                        this.counterTsLimit = change.getChangeNumber().getTime();
                    }
                    if (this.counterTsLimit != 0L && change.getChangeNumber().getTime() != this.counterTsLimit) {
                        ReplicationKey counterKey = new ReplicationKey(new ChangeNumber(change.getChangeNumber().getTime(), 0, 0));
                        DatabaseEntry counterValue = ReplicationDB.encodeCounterValue(this.counterCurrValue - 1);
                        this.db.put(null, (DatabaseEntry)counterKey, counterValue);
                        this.counterTsLimit = 0L;
                    }
                    this.db.put(null, (DatabaseEntry)key, (DatabaseEntry)data);
                    ++this.counterCurrValue;
                }
            }
            finally {
                this.dbCloseLock.readLock().unlock();
            }
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.dbCloseLock.writeLock().lock();
            try {
                this.db.close();
                this.db = null;
            }
            finally {
                this.dbCloseLock.writeLock().unlock();
            }
        }
        catch (DatabaseException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.NOTE_EXCEPTION_CLOSING_DATABASE.get(this.toString()));
            mb.append(StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    public ReplServerDBCursor openReadCursor(ChangeNumber changeNumber) throws DatabaseException, Exception {
        return new ReplServerDBCursor(changeNumber);
    }

    public ReplServerDBCursor openDeleteCursor() throws DatabaseException, Exception {
        return new ReplServerDBCursor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLockedCursor(Cursor cursor) throws DatabaseException {
        try {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.dbCloseLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readFirstChange() {
        Cursor cursor = null;
        ChangeNumber cn = null;
        try {
            block9: {
                DatabaseEntry key;
                block10: {
                    OperationStatus status;
                    DatabaseEntry data;
                    block8: {
                        block7: {
                            ChangeNumber changeNumber;
                            this.dbCloseLock.readLock().lock();
                            try {
                                if (!this.isDBClosed()) break block7;
                                changeNumber = null;
                            }
                            catch (Throwable throwable) {
                                this.closeLockedCursor(cursor);
                                throw throwable;
                            }
                            this.closeLockedCursor(cursor);
                            return changeNumber;
                        }
                        key = new DatabaseEntry();
                        data = new DatabaseEntry();
                        cursor = this.db.openCursor(null, null);
                        status = cursor.getFirst(key, data, LockMode.DEFAULT);
                        if (status == OperationStatus.SUCCESS) break block8;
                        ChangeNumber changeNumber = null;
                        this.closeLockedCursor(cursor);
                        return changeNumber;
                    }
                    String str = StaticUtils.decodeUTF8(key.getData());
                    cn = new ChangeNumber(str);
                    if (!ReplicationDB.isaCounter(cn)) break block9;
                    status = cursor.getNext(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block10;
                    ChangeNumber changeNumber = null;
                    this.closeLockedCursor(cursor);
                    return changeNumber;
                }
                cn = new ChangeNumber(StaticUtils.decodeUTF8(key.getData()));
            }
            this.closeLockedCursor(cursor);
            return cn;
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber readLastChange() {
        Cursor cursor = null;
        ChangeNumber cn = null;
        try {
            block9: {
                DatabaseEntry data;
                DatabaseEntry key;
                block8: {
                    block7: {
                        ChangeNumber changeNumber;
                        this.dbCloseLock.readLock().lock();
                        try {
                            if (!this.isDBClosed()) break block7;
                            changeNumber = null;
                        }
                        catch (Throwable throwable) {
                            this.closeLockedCursor(cursor);
                            throw throwable;
                        }
                        this.closeLockedCursor(cursor);
                        return changeNumber;
                    }
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    cursor = this.db.openCursor(null, null);
                    OperationStatus status = cursor.getLast(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block8;
                    ChangeNumber changeNumber = null;
                    this.closeLockedCursor(cursor);
                    return changeNumber;
                }
                String str = StaticUtils.decodeUTF8(key.getData());
                cn = new ChangeNumber(str);
                if (!ReplicationDB.isaCounter(cn)) break block9;
                if (cursor.getPrev(key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    cn = null;
                    break block9;
                }
                str = StaticUtils.decodeUTF8(key.getData());
                cn = new ChangeNumber(str);
            }
            this.closeLockedCursor(cursor);
            return cn;
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ChangeNumber getPreviousChangeNumber(ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return null;
        }
        Cursor cursor = null;
        ChangeNumber cn = null;
        ReplicationKey key = new ReplicationKey(changeNumber);
        DatabaseEntry data = new DatabaseEntry();
        try {
            block12: {
                String str;
                block11: {
                    ChangeNumber changeNumber2;
                    this.dbCloseLock.readLock().lock();
                    try {
                        if (!this.isDBClosed()) break block11;
                        changeNumber2 = null;
                    }
                    catch (Throwable throwable) {
                        this.closeLockedCursor(cursor);
                        throw throwable;
                    }
                    this.closeLockedCursor(cursor);
                    return changeNumber2;
                }
                cursor = this.db.openCursor(null, null);
                if (cursor.getSearchKeyRange((DatabaseEntry)key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    String str2;
                    if (cursor.getPrev((DatabaseEntry)key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS && ReplicationDB.isaCounter(cn = new ChangeNumber(str2 = StaticUtils.decodeUTF8(key.getData())))) {
                        if (cursor.getPrev((DatabaseEntry)key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                            cn = null;
                            break block12;
                        } else {
                            str2 = StaticUtils.decodeUTF8(key.getData());
                            cn = new ChangeNumber(str2);
                        }
                    }
                    break block12;
                }
                if (cursor.getLast((DatabaseEntry)key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS || !ReplicationDB.isaCounter(cn = new ChangeNumber(str = StaticUtils.decodeUTF8(key.getData())))) break block12;
                if (cursor.getPrev((DatabaseEntry)key, data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    cn = null;
                    break block12;
                }
                str = StaticUtils.decodeUTF8(key.getData());
                cn = new ChangeNumber(str);
            }
            this.closeLockedCursor(cursor);
            return cn;
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
            return null;
        }
    }

    public String toString() {
        return this.serverId + this.baseDn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws Exception, DatabaseException {
        this.dbCloseLock.writeLock().lock();
        try {
            if (this.isDBClosed()) {
                return;
            }
            String dbName = this.db.getDatabaseName();
            this.dbenv.clearServerId(this.baseDn, this.serverId);
            this.db.close();
            this.db = null;
            this.dbenv.clearDb(dbName);
            this.db = this.dbenv.getOrAddDb(this.serverId, this.baseDn, -1L);
        }
        catch (Exception e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_ERROR_CLEARING_DB.get(this.toString(), e.getMessage() + " " + StaticUtils.stackTraceToSingleLineString(e)));
            ErrorLogger.logError(mb.toMessage());
        }
        finally {
            this.dbCloseLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int count(ChangeNumber start, ChangeNumber stop) {
        int counterRecord1 = 0;
        int counterRecord2 = 0;
        int distToCounterRecord1 = 0;
        int distBackToCounterRecord2 = 0;
        int count = 0;
        try {
            Cursor cursor;
            block20: {
                ChangeNumber cn;
                OperationStatus status;
                DatabaseEntry data;
                DatabaseEntry key;
                block19: {
                    block18: {
                        block17: {
                            block16: {
                                this.dbCloseLock.readLock().lock();
                                cursor = null;
                                if (!this.isDBClosed()) break block16;
                                int n = 0;
                                this.closeLockedCursor(cursor);
                                return n;
                            }
                            if (start != null || stop != null) break block17;
                            int n = (int)this.db.count();
                            this.closeLockedCursor(cursor);
                            return n;
                        }
                        key = new DatabaseEntry();
                        data = new DatabaseEntry();
                        cursor = this.db.openCursor(null, null);
                        if (start != null) {
                            key = new ReplicationKey(start);
                            status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                            if (status == OperationStatus.NOTFOUND) {
                                status = cursor.getSearchKeyRange(key, data, LockMode.DEFAULT);
                            }
                        } else {
                            status = cursor.getNext(key, data, LockMode.DEFAULT);
                        }
                        while (status == OperationStatus.SUCCESS) {
                            String csnString = StaticUtils.decodeUTF8(key.getData());
                            cn = new ChangeNumber(csnString);
                            if (cn.getServerId() != 0) {
                                if (cn.newer(stop)) break;
                                ++distToCounterRecord1;
                                status = cursor.getNext(key, data, LockMode.DEFAULT);
                                continue;
                            }
                            counterRecord1 = ReplicationDB.decodeCounterValue(data.getData());
                            break;
                        }
                        cursor.close();
                        if (counterRecord1 != 0) break block18;
                        int n = distToCounterRecord1;
                        this.closeLockedCursor(cursor);
                        return n;
                    }
                    data = new DatabaseEntry();
                    key = new ReplicationKey(stop);
                    cursor = this.db.openCursor(null, null);
                    status = cursor.getSearchKey(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) {
                        cn = new ChangeNumber(StaticUtils.decodeUTF8(key.getData()));
                        break block19;
                    }
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    status = cursor.getLast(key, data, LockMode.DEFAULT);
                    if (status == OperationStatus.SUCCESS) break block19;
                    int n = 0;
                    this.closeLockedCursor(cursor);
                    return n;
                }
                try {
                    while (status == OperationStatus.SUCCESS) {
                        cn = new ChangeNumber(StaticUtils.decodeUTF8(key.getData()));
                        if (!ReplicationDB.isaCounter(cn)) {
                            if (cn.older(start).booleanValue()) break;
                            ++distBackToCounterRecord2;
                            status = cursor.getPrev(key, data, LockMode.DEFAULT);
                            continue;
                        }
                        counterRecord2 = ReplicationDB.decodeCounterValue(data.getData());
                        break;
                    }
                    cursor.close();
                    if (counterRecord1 == 0) break block20;
                    count = counterRecord1 == counterRecord2 ? distToCounterRecord1 + distBackToCounterRecord2 : distToCounterRecord1 + (counterRecord2 - counterRecord1) + distBackToCounterRecord2;
                }
                catch (Throwable throwable) {
                    this.closeLockedCursor(cursor);
                    throw throwable;
                }
            }
            this.closeLockedCursor(cursor);
            return count;
        }
        catch (DatabaseException e) {
            this.replicationServer.handleUnexpectedDatabaseException(e);
        }
        return count;
    }

    private static boolean isaCounter(ChangeNumber cn) {
        return cn.getServerId() == 0 && cn.getSeqnum() == 0;
    }

    private static int decodeCounterValue(byte[] entry) {
        String numAckStr = StaticUtils.decodeUTF8(entry);
        return Integer.parseInt(numAckStr);
    }

    private static DatabaseEntry encodeCounterValue(int value) {
        DatabaseEntry entry = new DatabaseEntry();
        entry.setData(StaticUtils.getBytes(String.valueOf(value)));
        return entry;
    }

    public void setCounterWindowSize(int size) {
        this.counterWindowSize = size;
    }

    private boolean isDBClosed() {
        return this.db == null;
    }

    public class ReplServerDBCursor {
        private final Transaction txn;
        private final Cursor cursor;
        private final DatabaseEntry key;
        private final DatabaseEntry data;
        private boolean isClosed = false;

        private ReplServerDBCursor(ChangeNumber startingChangeNumber) throws Exception {
            this.key = startingChangeNumber != null ? new ReplicationKey(startingChangeNumber) : new DatabaseEntry();
            this.data = new DatabaseEntry();
            this.txn = null;
            ReplicationDB.this.dbCloseLock.readLock().lock();
            Cursor localCursor = null;
            try {
                if (ReplicationDB.this.isDBClosed()) {
                    this.isClosed = true;
                    this.cursor = null;
                    return;
                }
                localCursor = ReplicationDB.this.db.openCursor(this.txn, null);
                if (startingChangeNumber != null && localCursor.getSearchKey(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                    if (localCursor.getSearchKeyRange(this.key, this.data, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        throw new Exception("ChangeNumber not available");
                    }
                    DatabaseEntry aKey = new DatabaseEntry();
                    DatabaseEntry aData = new DatabaseEntry();
                    if (localCursor.getPrev(aKey, aData, LockMode.DEFAULT) != OperationStatus.SUCCESS) {
                        localCursor.close();
                        localCursor = ReplicationDB.this.db.openCursor(this.txn, null);
                    }
                }
                this.cursor = localCursor;
            }
            catch (Exception e) {
                ReplicationDB.this.closeLockedCursor(localCursor);
                throw e;
            }
        }

        private ReplServerDBCursor() throws Exception {
            this.key = new DatabaseEntry();
            this.data = new DatabaseEntry();
            ReplicationDB.this.dbCloseLock.readLock().lock();
            Transaction localTxn = null;
            Cursor localCursor = null;
            try {
                if (ReplicationDB.this.isDBClosed()) {
                    this.isClosed = true;
                    this.txn = null;
                    this.cursor = null;
                    return;
                }
                localTxn = ReplicationDB.this.dbenv.beginTransaction();
                localCursor = ReplicationDB.this.db.openCursor(localTxn, null);
                this.txn = localTxn;
                this.cursor = localCursor;
            }
            catch (Exception e) {
                ReplicationDB.this.closeLockedCursor(localCursor);
                if (localTxn != null) {
                    try {
                        localTxn.abort();
                    }
                    catch (DatabaseException databaseException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            ReplServerDBCursor replServerDBCursor = this;
            synchronized (replServerDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            ReplicationDB.this.closeLockedCursor(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.commit(Durability.COMMIT_NO_SYNC);
                }
                catch (DatabaseException e) {
                    ReplicationDB.this.replicationServer.handleUnexpectedDatabaseException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void abort() {
            ReplServerDBCursor replServerDBCursor = this;
            synchronized (replServerDBCursor) {
                if (this.isClosed) {
                    return;
                }
                this.isClosed = true;
            }
            ReplicationDB.this.closeLockedCursor(this.cursor);
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (DatabaseException e) {
                    ReplicationDB.this.replicationServer.handleUnexpectedDatabaseException(e);
                }
            }
        }

        public ChangeNumber nextChangeNumber() throws DatabaseException {
            if (this.isClosed) {
                return null;
            }
            OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
            if (status != OperationStatus.SUCCESS) {
                return null;
            }
            String csnString = StaticUtils.decodeUTF8(this.key.getData());
            return new ChangeNumber(csnString);
        }

        public UpdateMsg next() {
            if (this.isClosed) {
                return null;
            }
            UpdateMsg currentChange = null;
            while (currentChange == null) {
                try {
                    OperationStatus status = this.cursor.getNext(this.key, this.data, LockMode.DEFAULT);
                    if (status != OperationStatus.SUCCESS) {
                        return null;
                    }
                }
                catch (DatabaseException e) {
                    return null;
                }
                ChangeNumber cn = null;
                try {
                    cn = new ChangeNumber(StaticUtils.decodeUTF8(this.key.getData()));
                    if (ReplicationDB.isaCounter(cn)) continue;
                    currentChange = ReplicationData.generateChange(this.data.getData());
                }
                catch (Exception e) {
                    Message message = ReplicationMessages.ERR_REPLICATIONDB_CANNOT_PROCESS_CHANGE_RECORD.get(ReplicationDB.this.replicationServer.getServerId(), cn == null ? "" : cn.toString(), e.getMessage());
                    ErrorLogger.logError(message);
                }
            }
            return currentChange;
        }

        public void delete() throws DatabaseException {
            if (this.isClosed) {
                throw new IllegalStateException("ReplServerDBCursor already closed");
            }
            this.cursor.delete();
        }
    }
}

