/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.util.StaticUtils;

public class GuideSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.17", "Guide"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.18", "Guide"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.19", "Guide"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "Guide";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.25";
    }

    @Override
    public String getDescription() {
        return "Guide";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.toString());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            return GuideSyntax.criteriaIsValid(valueStr, valueStr, invalidReason);
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_NO_OC.get(valueStr));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(ocName, 0, ocLength, invalidReason)) {
            return false;
        }
        return GuideSyntax.criteriaIsValid(valueStr.substring(sharpPos + 1), valueStr, invalidReason);
    }

    public static boolean criteriaIsValid(String criteria, String valueStr, MessageBuilder invalidReason) {
        int endPos;
        char c = criteria.charAt(0);
        if (c == '!') {
            return GuideSyntax.criteriaIsValid(criteria.substring(1), valueStr, invalidReason);
        }
        if (c == '(') {
            int length = criteria.length();
            int depth = 1;
            for (int i = 1; i < length; ++i) {
                c = criteria.charAt(i);
                if (c == ')') {
                    if (--depth != 0) continue;
                    String subCriteria = criteria.substring(1, i);
                    if (!GuideSyntax.criteriaIsValid(subCriteria, valueStr, invalidReason)) {
                        return false;
                    }
                    if (i == length - 1) {
                        return true;
                    }
                    c = criteria.charAt(i + 1);
                    if (c == '|' || c == '&') {
                        return GuideSyntax.criteriaIsValid(criteria.substring(i + 2), valueStr, invalidReason);
                    }
                    invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), i + 1));
                    return false;
                }
                if (c != '(') continue;
                ++depth;
            }
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_MISSING_CLOSE_PAREN.get(valueStr, criteria));
            return false;
        }
        if (c == '?') {
            if (criteria.startsWith("?true")) {
                if (criteria.length() == 5) {
                    return true;
                }
                c = criteria.charAt(5);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(criteria.substring(6), valueStr, invalidReason);
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), 5));
                return false;
            }
            if (criteria.startsWith("?false")) {
                if (criteria.length() == 6) {
                    return true;
                }
                c = criteria.charAt(6);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(criteria.substring(7), valueStr, invalidReason);
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), 6));
                return false;
            }
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_QUESTION_MARK.get(valueStr, criteria));
            return false;
        }
        if (criteria.equals("true") || criteria.equals("false")) {
            return true;
        }
        int dollarPos = criteria.indexOf(36);
        if (dollarPos < 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_NO_DOLLAR.get(valueStr, criteria));
            return false;
        }
        if (dollarPos == 0) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_NO_ATTR.get(valueStr, criteria));
            return false;
        }
        if (dollarPos == criteria.length() - 1) {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_NO_MATCH_TYPE.get(valueStr, criteria));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(criteria, 0, dollarPos, invalidReason)) {
            return false;
        }
        c = criteria.charAt(dollarPos + 1);
        switch (c) {
            case 'e': {
                if (criteria.startsWith("eq", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 's': {
                if (criteria.startsWith("substr", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'g': {
                if (criteria.startsWith("ge", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'l': {
                if (criteria.startsWith("le", dollarPos + 1)) {
                    endPos = dollarPos + 3;
                    break;
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            case 'a': {
                if (criteria.startsWith("approx", dollarPos + 1)) {
                    endPos = dollarPos + 7;
                    break;
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
            default: {
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_INVALID_MATCH_TYPE.get(valueStr, criteria, dollarPos + 1));
                return false;
            }
        }
        if (endPos >= criteria.length()) {
            return true;
        }
        c = criteria.charAt(endPos);
        if (c == '|' || c == '&') {
            return GuideSyntax.criteriaIsValid(criteria.substring(endPos + 1), valueStr, invalidReason);
        }
        invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_GUIDE_ILLEGAL_CHAR.get(valueStr, criteria, Character.valueOf(c), endPos));
        return false;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

