/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.messages.Message;
import org.opends.messages.SchemaMessages;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

class IntegerFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "integerFirstComponentMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.29";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StaticUtils.toLowerCase(value, buffer, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }

    @Override
    public boolean areEqual(ByteSequence value1, ByteSequence value2) {
        try {
            int intValue1 = IntegerFirstComponentEqualityMatchingRule.extractIntValue(value1.toString());
            int intValue2 = IntegerFirstComponentEqualityMatchingRule.extractIntValue(value2.toString());
            return intValue1 == intValue2;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public int generateHashCode(ByteSequence attributeValue) {
        return 1;
    }

    private static int extractIntValue(String valueString) throws DirectoryException {
        int pos;
        int valueLength = valueString.length();
        if (valueLength == 0 || valueString.charAt(0) != '(') {
            try {
                return Integer.parseInt(valueString);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_INITIAL_PARENTHESIS.get(String.valueOf(valueString));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
            }
        }
        for (pos = 1; pos < valueLength && valueString.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= valueLength) {
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_NONSPACE.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int startPos = pos++;
        while (pos < valueLength && valueString.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos >= valueLength) {
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_NO_SPACE_AFTER_INT.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        try {
            return Integer.parseInt(valueString.substring(startPos, pos));
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_EMR_INTFIRSTCOMP_FIRST_COMPONENT_NOT_INT.get(String.valueOf(valueString));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
    }
}

