/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ByteSequence;
import org.opends.server.util.StaticUtils;

public class OIDSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.0");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.0", "OID"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "OID"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "OID";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    @Override
    public String getDescription() {
        return "OID";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return null;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String lowerValue = StaticUtils.toLowerCase(value.toString());
        return StaticUtils.isValidSchemaElement(lowerValue, 0, lowerValue.length(), invalidReason);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }
}

