/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.TextErrorLogPublisher;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.TextDebugLogPublisher;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.tasks.BackupTask;
import org.opends.server.tools.BackendToolUtils;
import org.opends.server.tools.tasks.TaskTool;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;

public class BackUpDB
extends TaskTool {
    private BooleanArgument backUpAll = null;
    private BooleanArgument compress = null;
    private BooleanArgument displayUsage = null;
    private BooleanArgument encrypt = null;
    private BooleanArgument hash = null;
    private BooleanArgument incremental = null;
    private BooleanArgument signHash = null;
    private StringArgument backendID = null;
    private StringArgument backupIDString = null;
    private StringArgument configClass = null;
    private StringArgument configFile = null;
    private StringArgument backupDirectory = null;
    private StringArgument incrementalBaseID = null;

    public static void main(String[] args) {
        int retCode = BackUpDB.mainBackUpDB(args, true, System.out, System.err);
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainBackUpDB(String[] args) {
        return BackUpDB.mainBackUpDB(args, true, System.out, System.err);
    }

    public static int mainBackUpDB(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        BackUpDB tool = new BackUpDB();
        return tool.process(args, initializeServer, outStream, errStream);
    }

    private int process(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        Message message;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LDAPConnectionArgumentParser argParser = this.createArgParser("org.opends.server.tools.BackUpDB", ToolMessages.INFO_BACKUPDB_TOOL_DESCRIPTION.get());
        try {
            this.configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            this.configClass.setHidden(true);
            argParser.addArgument(this.configClass);
            this.configFile = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            this.configFile.setHidden(true);
            argParser.addArgument(this.configFile);
            this.backendID = new StringArgument("backendid", Character.valueOf('n'), "backendID", false, true, true, ToolMessages.INFO_BACKENDNAME_PLACEHOLDER.get(), null, null, ToolMessages.INFO_BACKUPDB_DESCRIPTION_BACKEND_ID.get());
            argParser.addArgument(this.backendID);
            this.backUpAll = new BooleanArgument("backupall", Character.valueOf('a'), "backUpAll", ToolMessages.INFO_BACKUPDB_DESCRIPTION_BACKUP_ALL.get());
            argParser.addArgument(this.backUpAll);
            this.backupIDString = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, ToolMessages.INFO_BACKUPID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_BACKUPDB_DESCRIPTION_BACKUP_ID.get());
            argParser.addArgument(this.backupIDString);
            this.backupDirectory = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, ToolMessages.INFO_BACKUPDIR_PLACEHOLDER.get(), null, null, ToolMessages.INFO_BACKUPDB_DESCRIPTION_BACKUP_DIR.get());
            argParser.addArgument(this.backupDirectory);
            this.incremental = new BooleanArgument("incremental", Character.valueOf('i'), "incremental", ToolMessages.INFO_BACKUPDB_DESCRIPTION_INCREMENTAL.get());
            argParser.addArgument(this.incremental);
            this.incrementalBaseID = new StringArgument("incrementalbaseid", Character.valueOf('B'), "incrementalBaseID", false, false, true, ToolMessages.INFO_BACKUPID_PLACEHOLDER.get(), null, null, ToolMessages.INFO_BACKUPDB_DESCRIPTION_INCREMENTAL_BASE_ID.get());
            argParser.addArgument(this.incrementalBaseID);
            this.compress = new BooleanArgument("compress", Character.valueOf('c'), "compress", ToolMessages.INFO_BACKUPDB_DESCRIPTION_COMPRESS.get());
            argParser.addArgument(this.compress);
            this.encrypt = new BooleanArgument("encrypt", Character.valueOf('y'), "encrypt", ToolMessages.INFO_BACKUPDB_DESCRIPTION_ENCRYPT.get());
            argParser.addArgument(this.encrypt);
            this.hash = new BooleanArgument("hash", Character.valueOf('A'), "hash", ToolMessages.INFO_BACKUPDB_DESCRIPTION_HASH.get());
            argParser.addArgument(this.hash);
            this.signHash = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", ToolMessages.INFO_BACKUPDB_DESCRIPTION_SIGN_HASH.get());
            argParser.addArgument(this.signHash);
            this.displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(this.displayUsage);
            argParser.setUsageArgument(this.displayUsage);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message2, ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        try {
            argParser.getArguments().initArgumentsWithConfiguration();
        }
        catch (ConfigException ae) {
            // empty catch block
        }
        try {
            argParser.parseArguments(args);
            this.validateTaskArgs();
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        catch (CLIException ce) {
            err.println(StaticUtils.wrapText(ce.getMessageObject(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (this.backUpAll.isPresent()) {
            if (this.backendID.isPresent()) {
                Message message4 = ToolMessages.ERR_BACKUPDB_CANNOT_MIX_BACKUP_ALL_AND_BACKEND_ID.get(this.backUpAll.getLongIdentifier(), this.backendID.getLongIdentifier());
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        } else {
            if (!this.backendID.isPresent()) {
                Message message5 = ToolMessages.ERR_BACKUPDB_NEED_BACKUP_ALL_OR_BACKEND_ID.get(this.backUpAll.getLongIdentifier(), this.backendID.getLongIdentifier());
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
            HashSet<String> backendIDLowerCase = new HashSet<String>();
            HashSet<String> repeatedBackendIds = new HashSet<String>();
            StringBuilder repeatedBackends = new StringBuilder();
            for (String id : this.backendID.getValues()) {
                String lId = id.toLowerCase();
                if (backendIDLowerCase.contains(lId)) {
                    if (repeatedBackendIds.contains(lId)) continue;
                    repeatedBackendIds.add(lId);
                    if (repeatedBackends.length() > 0) {
                        repeatedBackends.append(", ");
                    }
                    repeatedBackends.append(id);
                    continue;
                }
                backendIDLowerCase.add(lId);
            }
            if (repeatedBackends.length() > 0) {
                Message message6 = ToolMessages.ERR_BACKUPDB_REPEATED_BACKEND_ID.get(repeatedBackends.toString());
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                err.println(argParser.getUsage());
                return 1;
            }
        }
        if (this.incrementalBaseID.isPresent() && !this.incremental.isPresent()) {
            message = ToolMessages.ERR_BACKUPDB_INCREMENTAL_BASE_REQUIRES_INCREMENTAL.get(this.incrementalBaseID.getLongIdentifier(), this.incremental.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if ((this.encrypt.isPresent() || this.signHash.isPresent()) && !argParser.connectionArgumentsPresent()) {
            message = ToolMessages.ERR_BACKUPDB_ENCRYPT_OR_SIGN_REQUIRES_ONLINE.get(this.encrypt.getLongIdentifier(), this.signHash.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        if (this.signHash.isPresent() && !this.hash.isPresent()) {
            message = ToolMessages.ERR_BACKUPDB_SIGN_REQUIRES_HASH.get(this.signHash.getLongIdentifier(), this.hash.getLongIdentifier());
            err.println(StaticUtils.wrapText(message, ServerConstants.MAX_LINE_WIDTH));
            err.println(argParser.getUsage());
            return 1;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        return this.process(argParser, initializeServer, out, err);
    }

    @Override
    public void addTaskAttributes(List<RawAttribute> attributes) {
        LinkedList<String> backendIDs;
        ArrayList<ByteString> values;
        if (this.backUpAll.getValue() != null && !this.backUpAll.getValue().equals(this.backUpAll.getDefaultValue())) {
            values = new ArrayList<ByteString>(1);
            values.add(ByteString.valueOf(this.backUpAll.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-all", values));
        }
        if (this.compress.getValue() != null && !this.compress.getValue().equals(this.compress.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.compress.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-compress", values));
        }
        if (this.encrypt.getValue() != null && !this.encrypt.getValue().equals(this.encrypt.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.encrypt.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-encrypt", values));
        }
        if (this.hash.getValue() != null && !this.hash.getValue().equals(this.hash.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.hash.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-hash", values));
        }
        if (this.incremental.getValue() != null && !this.incremental.getValue().equals(this.incremental.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.incremental.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-incremental", values));
        }
        if (this.signHash.getValue() != null && !this.signHash.getValue().equals(this.signHash.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.signHash.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-sign-hash", values));
        }
        if ((backendIDs = this.backendID.getValues()) != null && backendIDs.size() > 0) {
            values = new ArrayList(backendIDs.size());
            for (String s : backendIDs) {
                values.add(ByteString.valueOf(s));
            }
            attributes.add(new LDAPAttribute("ds-task-backup-backend-id", values));
        }
        if (this.backupIDString.getValue() != null && !this.backupIDString.getValue().equals(this.backupIDString.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.backupIDString.getValue()));
            attributes.add(new LDAPAttribute("ds-backup-id", values));
        }
        if (this.backupDirectory.getValue() != null && !this.backupDirectory.getValue().equals(this.backupDirectory.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.backupDirectory.getValue()));
            attributes.add(new LDAPAttribute("ds-backup-directory-path", values));
        }
        if (this.incrementalBaseID.getValue() != null && !this.incrementalBaseID.getValue().equals(this.incrementalBaseID.getDefaultValue())) {
            values = new ArrayList(1);
            values.add(ByteString.valueOf(this.incrementalBaseID.getValue()));
            attributes.add(new LDAPAttribute("ds-task-backup-incremental-base-id", values));
        }
    }

    @Override
    public String getTaskObjectclass() {
        return "ds-task-backup";
    }

    @Override
    public Class<?> getTaskClass() {
        return BackupTask.class;
    }

    @Override
    protected int processLocal(boolean initializeServer, PrintStream out, PrintStream err) {
        Message message;
        Message message2;
        boolean multiple;
        String backupID;
        File backupDirFile = new File(this.backupDirectory.getValue());
        if (!backupDirFile.exists()) {
            try {
                backupDirFile.mkdirs();
            }
            catch (Exception e) {
                Message message3 = ToolMessages.ERR_BACKUPDB_CANNOT_CREATE_BACKUP_DIR.get(this.backupDirectory.getValue(), StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message3, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
        }
        if (this.backupIDString.isPresent()) {
            backupID = this.backupIDString.getValue();
        } else {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            backupID = dateFormat.format(new Date());
        }
        String incrementalBase = this.incrementalBaseID.isPresent() ? this.incrementalBaseID.getValue() : null;
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        if (initializeServer) {
            try {
                DirectoryServer.bootstrapClient();
                DirectoryServer.initializeJMX();
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_SERVER_BOOTSTRAP_ERROR.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message4, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeConfiguration(this.configClass.getValue(), this.configFile.getValue());
            }
            catch (InitializationException ie) {
                Message message5 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message5, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message6 = ToolMessages.ERR_CANNOT_LOAD_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message6, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeSchema();
            }
            catch (ConfigException ce) {
                Message message7 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message7, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message8 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message8, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message9 = ToolMessages.ERR_CANNOT_LOAD_SCHEMA.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message9, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                CoreConfigManager coreConfigManager = new CoreConfigManager();
                coreConfigManager.initializeCoreConfig();
            }
            catch (ConfigException ce) {
                Message message10 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message10, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message11 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message11, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message12 = ToolMessages.ERR_CANNOT_INITIALIZE_CORE_CONFIG.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message12, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                directoryServer.initializeCryptoManager();
            }
            catch (ConfigException ce) {
                Message message13 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ce.getMessage());
                err.println(StaticUtils.wrapText(message13, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (InitializationException ie) {
                Message message14 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(ie.getMessage());
                err.println(StaticUtils.wrapText(message14, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            catch (Exception e) {
                Message message15 = ToolMessages.ERR_CANNOT_INITIALIZE_CRYPTO_MANAGER.get(StaticUtils.getExceptionMessage(e));
                err.println(StaticUtils.wrapText(message15, ServerConstants.MAX_LINE_WIDTH));
                return 1;
            }
            try {
                TextErrorLogPublisher errorLogPublisher = TextErrorLogPublisher.getToolStartupTextErrorPublisher(new TextWriter.STREAM(out));
                TextDebugLogPublisher debugLogPublisher = TextDebugLogPublisher.getStartupTextDebugPublisher(new TextWriter.STREAM(out));
                ErrorLogger.addErrorLogPublisher(errorLogPublisher);
                DebugLogger.addDebugLogPublisher(debugLogPublisher);
            }
            catch (Exception e) {
                err.println("Error installing the custom error logger: " + StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        ArrayList<Backend> backendList = new ArrayList<Backend>();
        ArrayList<BackendCfg> entryList = new ArrayList<BackendCfg>();
        ArrayList<List<DN>> dnList = new ArrayList<List<DN>>();
        BackendToolUtils.getBackends(backendList, entryList, dnList);
        int numBackends = backendList.size();
        ArrayList<Backend> backendsToArchive = new ArrayList<Backend>(numBackends);
        HashMap<String, BackendCfg> configEntries = new HashMap<String, BackendCfg>(numBackends);
        if (this.backUpAll.isPresent()) {
            for (int i = 0; i < numBackends; ++i) {
                Backend b = backendList.get(i);
                if (!b.supportsBackup()) continue;
                backendsToArchive.add(b);
                configEntries.put(b.getBackendID(), entryList.get(i));
            }
            multiple = true;
        } else {
            HashSet<String> requestedBackends = new HashSet<String>(backendList.size());
            requestedBackends.addAll(this.backendID.getValues());
            for (int i = 0; i < numBackends; ++i) {
                Backend b = backendList.get(i);
                if (!requestedBackends.contains(b.getBackendID())) continue;
                if (!b.supportsBackup()) {
                    message2 = ToolMessages.WARN_BACKUPDB_BACKUP_NOT_SUPPORTED.get(b.getBackendID());
                    ErrorLogger.logError(message2);
                    continue;
                }
                backendsToArchive.add(b);
                configEntries.put(b.getBackendID(), entryList.get(i));
                requestedBackends.remove(b.getBackendID());
            }
            if (!requestedBackends.isEmpty()) {
                for (String id : requestedBackends) {
                    message2 = ToolMessages.ERR_BACKUPDB_NO_BACKENDS_FOR_ID.get(id);
                    ErrorLogger.logError(message2);
                }
                return 1;
            }
            boolean bl = multiple = backendsToArchive.size() > 1;
        }
        if (backendsToArchive.isEmpty()) {
            Message message16 = ToolMessages.WARN_BACKUPDB_NO_BACKENDS_TO_ARCHIVE.get();
            ErrorLogger.logError(message16);
            return 1;
        }
        boolean errorsEncountered = false;
        for (Backend b : backendsToArchive) {
            StringBuilder failureReason;
            String lockFile;
            StringBuilder failureReason2;
            String lockFile2;
            BackupDirectory backupDir;
            block66: {
                block65: {
                    try {
                        String lockFile3 = LockFileManager.getBackendLockFileName(b);
                        StringBuilder failureReason3 = new StringBuilder();
                        if (!LockFileManager.acquireSharedLock(lockFile3, failureReason3)) {
                            Message message17 = ToolMessages.ERR_BACKUPDB_CANNOT_LOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason3));
                            ErrorLogger.logError(message17);
                            errorsEncountered = true;
                        }
                        break block65;
                    }
                    catch (Exception e) {
                        Message message18 = ToolMessages.ERR_BACKUPDB_CANNOT_LOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(message18);
                        errorsEncountered = true;
                    }
                    continue;
                }
                message2 = ToolMessages.NOTE_BACKUPDB_STARTING_BACKUP.get(b.getBackendID());
                ErrorLogger.logError(message2);
                BackendCfg configEntry = (BackendCfg)configEntries.get(b.getBackendID());
                String backupDirPath = multiple ? this.backupDirectory.getValue() + File.separator + b.getBackendID() : this.backupDirectory.getValue();
                backupDirFile = new File(backupDirPath);
                if (backupDirFile.exists()) {
                    String descriptorPath = backupDirPath + File.separator + "backup.info";
                    File descriptorFile = new File(descriptorPath);
                    if (descriptorFile.exists()) {
                        try {
                            backupDir = BackupDirectory.readBackupDirectoryDescriptor(backupDirPath);
                            break block66;
                        }
                        catch (ConfigException ce) {
                            message2 = ToolMessages.ERR_BACKUPDB_CANNOT_PARSE_BACKUP_DESCRIPTOR.get(descriptorPath, ce.getMessage());
                            ErrorLogger.logError(message2);
                            errorsEncountered = true;
                            try {
                                lockFile2 = LockFileManager.getBackendLockFileName(b);
                                if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason2));
                                ErrorLogger.logError(message2);
                            }
                            catch (Exception e) {
                                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
                                ErrorLogger.logError(message2);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            message2 = ToolMessages.ERR_BACKUPDB_CANNOT_PARSE_BACKUP_DESCRIPTOR.get(descriptorPath, StaticUtils.getExceptionMessage(e));
                            ErrorLogger.logError(message2);
                            errorsEncountered = true;
                            try {
                                lockFile2 = LockFileManager.getBackendLockFileName(b);
                                if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason2));
                                ErrorLogger.logError(message2);
                            }
                            catch (Exception e2) {
                                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                                ErrorLogger.logError(message2);
                            }
                            continue;
                        }
                    }
                    backupDir = new BackupDirectory(backupDirPath, configEntry.dn());
                } else {
                    try {
                        backupDirFile.mkdirs();
                    }
                    catch (Exception e) {
                        message2 = ToolMessages.ERR_BACKUPDB_CANNOT_CREATE_BACKUP_DIR.get(backupDirPath, StaticUtils.getExceptionMessage(e));
                        ErrorLogger.logError(message2);
                        errorsEncountered = true;
                        try {
                            StringBuilder failureReason4;
                            String lockFile4 = LockFileManager.getBackendLockFileName(b);
                            if (LockFileManager.releaseLock(lockFile4, failureReason4 = new StringBuilder())) continue;
                            message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason4));
                            ErrorLogger.logError(message2);
                        }
                        catch (Exception e2) {
                            message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                            ErrorLogger.logError(message2);
                        }
                        continue;
                    }
                    backupDir = new BackupDirectory(backupDirPath, configEntry.dn());
                }
            }
            BackupConfig backupConfig = new BackupConfig(backupDir, backupID, this.incremental.isPresent());
            backupConfig.setCompressData(this.compress.isPresent());
            backupConfig.setEncryptData(this.encrypt.isPresent());
            backupConfig.setHashData(this.hash.isPresent());
            backupConfig.setSignHash(this.signHash.isPresent());
            backupConfig.setIncrementalBaseID(incrementalBase);
            StringBuilder unsupportedReason = new StringBuilder();
            if (!b.supportsBackup(backupConfig, unsupportedReason)) {
                message2 = ToolMessages.ERR_BACKUPDB_CANNOT_BACKUP.get(b.getBackendID(), unsupportedReason.toString());
                ErrorLogger.logError(message2);
                errorsEncountered = true;
                try {
                    lockFile = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) continue;
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message2);
                }
                catch (Exception e2) {
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                    ErrorLogger.logError(message2);
                }
                continue;
            }
            try {
                b.createBackup(backupConfig);
            }
            catch (DirectoryException de) {
                message2 = ToolMessages.ERR_BACKUPDB_ERROR_DURING_BACKUP.get(b.getBackendID(), de.getMessageObject());
                ErrorLogger.logError(message2);
                errorsEncountered = true;
                try {
                    lockFile2 = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason2));
                    ErrorLogger.logError(message2);
                }
                catch (Exception e) {
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
                    ErrorLogger.logError(message2);
                }
                continue;
            }
            catch (Exception e) {
                message2 = ToolMessages.ERR_BACKUPDB_ERROR_DURING_BACKUP.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message2);
                errorsEncountered = true;
                try {
                    lockFile2 = LockFileManager.getBackendLockFileName(b);
                    if (LockFileManager.releaseLock(lockFile2, failureReason2 = new StringBuilder())) continue;
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason2));
                    ErrorLogger.logError(message2);
                }
                catch (Exception e2) {
                    message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e2));
                    ErrorLogger.logError(message2);
                }
                continue;
            }
            try {
                lockFile = LockFileManager.getBackendLockFileName(b);
                if (LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) continue;
                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message2);
                errorsEncountered = true;
            }
            catch (Exception e) {
                message2 = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message2);
                errorsEncountered = true;
            }
        }
        int ret = 0;
        if (errorsEncountered) {
            message = ToolMessages.NOTE_BACKUPDB_COMPLETED_WITH_ERRORS.get();
            ErrorLogger.logError(message);
            ret = 1;
        } else {
            message = ToolMessages.NOTE_BACKUPDB_COMPLETED_SUCCESSFULLY.get();
            ErrorLogger.logError(message);
        }
        return ret;
    }

    @Override
    public String getTaskId() {
        if (this.backupIDString != null) {
            return this.backupIDString.getValue();
        }
        return null;
    }
}

