/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.opends.server.admin.std.server.DebugLogPublisherCfg;
import org.opends.server.api.DebugLogPublisher;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.LogCategory;
import org.opends.server.loggers.LogLevel;
import org.opends.server.loggers.debug.DebugMessageFormatter;
import org.opends.server.loggers.debug.DebugStackTraceFormatter;
import org.opends.server.loggers.debug.TraceSettings;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.InitializationException;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ConsoleDebugLogPublisher
extends DebugLogPublisher<DebugLogPublisherCfg> {
    private PrintStream err;
    private DateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    public ConsoleDebugLogPublisher(PrintStream err) {
        this.err = err;
    }

    @Override
    public void initializeLogPublisher(DebugLogPublisherCfg config) throws ConfigException, InitializationException {
    }

    @Override
    public void traceConstructor(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.CONSTRUCTOR;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(signature, sourceLocation, args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceMethodEntry(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object obj, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.ENTER;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(signature, sourceLocation, args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceStaticMethodEntry(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object[] args, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.ENTER;
        String msg = "";
        if (args != null) {
            msg = this.buildDefaultEntryMessage(signature, sourceLocation, args);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceReturn(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Object ret, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.EXIT;
        String msg = "";
        if (ret != null) {
            StringBuilder format = new StringBuilder();
            format.append("returned={%s} ");
            format.append(signature);
            format.append("():");
            format.append(sourceLocation);
            msg = DebugMessageFormatter.format(format.toString(), new Object[]{ret});
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceThrown(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Throwable ex, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.THROWN;
        StringBuilder format = new StringBuilder();
        format.append("thrown={%s} ");
        format.append(signature);
        format.append("():");
        format.append(sourceLocation);
        String msg = DebugMessageFormatter.format(format.toString(), new Object[]{ex});
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(ex, settings.getStackDepth(), settings.isIncludeCause());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceMessage(LogLevel level, TraceSettings settings, String signature, String sourceLocation, String msg, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.MESSAGE;
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceCaught(LogLevel level, TraceSettings settings, String signature, String sourceLocation, Throwable ex, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.CAUGHT;
        StringBuilder format = new StringBuilder();
        format.append("caught={%s} ");
        format.append(signature);
        format.append("():");
        format.append(sourceLocation);
        String msg = DebugMessageFormatter.format("caught={%s}", new Object[]{ex});
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(ex, settings.getStackDepth(), settings.isIncludeCause());
        }
        this.publish(category, level, msg, stack);
    }

    @Override
    public void traceJEAccess(LogLevel level, TraceSettings settings, String signature, String sourceLocation, OperationStatus status, Database database, Transaction txn, DatabaseEntry key, DatabaseEntry data, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.DATABASE_ACCESS;
        StringBuilder builder = new StringBuilder();
        builder.append(" (");
        builder.append(status.toString());
        builder.append(")");
        builder.append(" db=");
        try {
            builder.append(database.getDatabaseName());
        }
        catch (DatabaseException de) {
            builder.append(de.toString());
        }
        if (txn != null) {
            builder.append(" txnid=");
            try {
                builder.append(txn.getId());
            }
            catch (DatabaseException de) {
                builder.append(de.toString());
            }
        } else {
            builder.append(" txnid=none");
        }
        builder.append(ServerConstants.EOL);
        if (key != null) {
            builder.append("key:");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, key.getData(), 4);
        }
        if (status == OperationStatus.SUCCESS && data != null) {
            builder.append("data(len=");
            builder.append(data.getSize());
            builder.append("):");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, data.getData(), 4);
        }
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, builder.toString(), stack);
    }

    @Override
    public void traceData(LogLevel level, TraceSettings settings, String signature, String sourceLocation, byte[] data, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.DATA;
        if (data != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(ServerConstants.EOL);
            builder.append("data(len=");
            builder.append(data.length);
            builder.append("):");
            builder.append(ServerConstants.EOL);
            StaticUtils.byteArrayToHexPlusAscii(builder, data, 4);
            String stack = null;
            if (stackTrace != null) {
                stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
            }
            this.publish(category, level, builder.toString(), stack);
        }
    }

    @Override
    public void traceProtocolElement(LogLevel level, TraceSettings settings, String signature, String sourceLocation, String decodedForm, StackTraceElement[] stackTrace) {
        LogCategory category = DebugLogCategory.PROTOCOL;
        String stack = null;
        if (stackTrace != null) {
            stack = DebugStackTraceFormatter.formatStackTrace(stackTrace, settings.getStackDepth());
        }
        this.publish(category, level, decodedForm, stack);
    }

    @Override
    public void close() {
    }

    private void publish(LogCategory category, LogLevel level, String msg, String stack) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.dateFormat.format(System.currentTimeMillis()));
        buf.append(" ");
        buf.append(category);
        buf.append(" ");
        buf.append(level);
        buf.append(" ");
        buf.append(msg);
        buf.append(ServerConstants.EOL);
        if (stack != null) {
            buf.append("\nStack Trace:\n");
            buf.append(stack);
        }
        this.err.print(buf);
    }

    private String buildDefaultEntryMessage(String signature, String sourceLocation, Object[] args) {
        StringBuilder format = new StringBuilder();
        format.append(signature);
        format.append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i != 0) {
                format.append(", ");
            }
            format.append("arg");
            format.append(i + 1);
            format.append("={%s}");
        }
        format.append("):");
        format.append(sourceLocation);
        return DebugMessageFormatter.format(format.toString(), args);
    }

    @Override
    public DN getDN() {
        return DN.NULL_DN;
    }
}

