/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.PrintStream;
import org.opends.messages.ToolMessages;
import org.opends.server.tools.LDAPToolOptions;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.SearchScope;

public class LDAPSearchOptions
extends LDAPToolOptions {
    private DereferencePolicy dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
    private SearchScope searchScope = SearchScope.WHOLE_SUBTREE;
    private int sizeLimit = 0;
    private int timeLimit = 0;
    private boolean typesOnly = false;
    private boolean countMatchingEntries = false;

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setSizeLimit(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public boolean setSearchScope(String scope, PrintStream err) {
        if (scope == null) {
            this.searchScope = SearchScope.WHOLE_SUBTREE;
        } else if (scope.equalsIgnoreCase("base")) {
            this.searchScope = SearchScope.BASE_OBJECT;
        } else if (scope.equalsIgnoreCase("one")) {
            this.searchScope = SearchScope.SINGLE_LEVEL;
        } else if (scope.equalsIgnoreCase("sub")) {
            this.searchScope = SearchScope.WHOLE_SUBTREE;
        } else if (scope.equalsIgnoreCase("subordinate")) {
            this.searchScope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            err.println(ToolMessages.ERR_SEARCH_INVALID_SEARCH_SCOPE.get(scope));
            return false;
        }
        return true;
    }

    public SearchScope getSearchScope() {
        return this.searchScope;
    }

    public boolean setDereferencePolicy(String policy, PrintStream err) {
        if (policy == null) {
            this.dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
        } else if (policy.equals("never")) {
            this.dereferencePolicy = DereferencePolicy.NEVER_DEREF_ALIASES;
        } else if (policy.equals("always")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_ALWAYS;
        } else if (policy.equals("search")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_IN_SEARCHING;
        } else if (policy.equals("find")) {
            this.dereferencePolicy = DereferencePolicy.DEREF_FINDING_BASE_OBJECT;
        } else {
            err.println("Invalid deref alias specified:" + policy);
            return false;
        }
        return true;
    }

    public DereferencePolicy getDereferencePolicy() {
        return this.dereferencePolicy;
    }

    public boolean getTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public boolean countMatchingEntries() {
        return this.countMatchingEntries;
    }

    public void setCountMatchingEntries(boolean countMatchingEntries) {
        this.countMatchingEntries = countMatchingEntries;
    }
}

