/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.MultiChoiceArgument;
import org.opends.server.util.args.StringArgument;

public class LDIFSearch {
    private static final String CLASS_NAME = "org.opends.server.tools.LDIFSearch";
    private static final String SCOPE_STRING_BASE = "base";
    private static final String SCOPE_STRING_ONE = "one";
    private static final String SCOPE_STRING_SUB = "sub";
    private static final String SCOPE_STRING_SUBORDINATE = "subordinate";

    public static void main(String[] args) {
        int exitCode = LDIFSearch.mainSearch(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainSearch(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        LDIFWriter writer;
        LDIFReader reader;
        int sizeLimitValue;
        long timeLimitMillis;
        Message message;
        String scopeStr;
        LinkedList<String> attributeNames;
        IntegerArgument timeLimit;
        IntegerArgument sizeLimit;
        BooleanArgument dontWrap;
        BooleanArgument overwriteExisting;
        StringArgument outputFile;
        StringArgument filterFile;
        StringArgument configClass;
        StringArgument configFile;
        MultiChoiceArgument scopeString;
        StringArgument baseDNString;
        StringArgument ldifFile;
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        LinkedHashSet<String> scopeStrings = new LinkedHashSet<String>(4);
        scopeStrings.add(SCOPE_STRING_BASE);
        scopeStrings.add(SCOPE_STRING_ONE);
        scopeStrings.add(SCOPE_STRING_SUB);
        scopeStrings.add(SCOPE_STRING_SUBORDINATE);
        Message toolDescription = ToolMessages.INFO_LDIFSEARCH_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(CLASS_NAME, toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
        try {
            ldifFile = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", false, true, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_LDIF_FILE.get());
            argParser.addArgument(ldifFile);
            baseDNString = new StringArgument("basedn", Character.valueOf('b'), "baseDN", false, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), "", null, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_BASEDN.get());
            argParser.addArgument(baseDNString);
            scopeString = new MultiChoiceArgument("scope", Character.valueOf('s'), "searchScope", false, false, true, ToolMessages.INFO_SCOPE_PLACEHOLDER.get(), SCOPE_STRING_SUB, null, scopeStrings, false, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_SCOPE.get());
            argParser.addArgument(scopeString);
            configFile = new StringArgument("configfile", Character.valueOf('c'), "configFile", false, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
            configFile.setHidden(true);
            argParser.addArgument(configFile);
            configClass = new StringArgument("configclass", Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), null, ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
            configClass.setHidden(true);
            argParser.addArgument(configClass);
            filterFile = new StringArgument("filterfile", Character.valueOf('f'), "filterFile", false, false, true, ToolMessages.INFO_FILTER_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_FILTER_FILE.get());
            argParser.addArgument(filterFile);
            outputFile = new StringArgument("outputfile", Character.valueOf('o'), "outputFile", false, false, true, ToolMessages.INFO_OUTPUT_FILE_PLACEHOLDER.get(), null, null, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_OUTPUT_FILE.get());
            argParser.addArgument(outputFile);
            overwriteExisting = new BooleanArgument("overwriteexisting", Character.valueOf('O'), "overwriteExisting", ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_OVERWRITE_EXISTING.get());
            argParser.addArgument(overwriteExisting);
            dontWrap = new BooleanArgument("dontwrap", Character.valueOf('T'), "dontWrap", ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_DONT_WRAP.get());
            argParser.addArgument(dontWrap);
            sizeLimit = new IntegerArgument("sizelimit", Character.valueOf('z'), "sizeLimit", false, false, true, ToolMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get(), 0, null, true, 0, false, 0, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_SIZE_LIMIT.get());
            argParser.addArgument(sizeLimit);
            timeLimit = new IntegerArgument("timelimit", Character.valueOf('t'), "timeLimit", false, false, true, ToolMessages.INFO_TIME_LIMIT_PLACEHOLDER.get(), 0, null, true, 0, false, 0, ToolMessages.INFO_LDIFSEARCH_DESCRIPTION_TIME_LIMIT.get());
            argParser.addArgument(timeLimit);
            BooleanArgument showUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(showUsage);
            argParser.setUsageArgument(showUsage);
        }
        catch (ArgumentException ae) {
            Message message2 = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            err.println(message2);
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message3 = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            err.println(message3);
            err.println(argParser.getUsage());
            return 89;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        try {
            BuildVersion.checkVersionMismatch();
        }
        catch (InitializationException e) {
            err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
            return 1;
        }
        boolean allUserAttrs = false;
        boolean allOperationalAttrs = false;
        boolean includeObjectclassAttrs = true;
        LinkedList<String> objectClassNames = new LinkedList<String>();
        LinkedList<String> filterStrings = new LinkedList<String>();
        if (filterFile.isPresent()) {
            BufferedReader in = null;
            try {
                String fileNameValue = filterFile.getValue();
                in = new BufferedReader(new FileReader(fileNameValue));
                String line = null;
                while ((line = in.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    filterStrings.add(line);
                }
            }
            catch (Exception e) {
                err.println(StaticUtils.wrapText(e.getMessage(), ServerConstants.MAX_LINE_WIDTH));
                int line = 1;
                return line;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ArrayList<String> trailingArguments = argParser.getTrailingArguments();
            if (trailingArguments == null || trailingArguments.isEmpty()) {
                attributeNames = new LinkedList();
            } else {
                attributeNames = new LinkedList();
                for (String attributeName : trailingArguments) {
                    String lowerName = StaticUtils.toLowerCase(attributeName);
                    if (lowerName.equals("*")) {
                        allUserAttrs = true;
                        continue;
                    }
                    if (lowerName.equals("+")) {
                        allOperationalAttrs = true;
                        continue;
                    }
                    if (lowerName.startsWith("@")) {
                        objectClassNames.add(lowerName.substring(1));
                        continue;
                    }
                    attributeNames.add(lowerName);
                }
            }
        } else {
            ArrayList<String> trailingArguments = argParser.getTrailingArguments();
            if (trailingArguments == null || trailingArguments.isEmpty()) {
                Message message4 = ToolMessages.ERR_LDIFSEARCH_NO_FILTER.get();
                err.println(message4);
                return 1;
            }
            Iterator<String> iterator = trailingArguments.iterator();
            filterStrings = new LinkedList();
            filterStrings.add(iterator.next());
            attributeNames = new LinkedList<String>();
            while (iterator.hasNext()) {
                String lowerName = StaticUtils.toLowerCase(iterator.next());
                if (lowerName.equals("*")) {
                    allUserAttrs = true;
                    continue;
                }
                if (lowerName.equals("+")) {
                    allOperationalAttrs = true;
                    continue;
                }
                if (lowerName.startsWith("@")) {
                    objectClassNames.add(lowerName.substring(1));
                    continue;
                }
                attributeNames.add(lowerName);
            }
        }
        if (attributeNames.isEmpty() && objectClassNames.isEmpty() && !allOperationalAttrs) {
            allUserAttrs = true;
        }
        if (!allUserAttrs) {
            if (allOperationalAttrs && objectClassNames.isEmpty() && attributeNames.isEmpty()) {
                includeObjectclassAttrs = false;
            }
            if (!attributeNames.isEmpty() && objectClassNames.isEmpty() && !attributeNames.contains("objectclass")) {
                includeObjectclassAttrs = false;
            }
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        boolean checkSchema = configFile.isPresent();
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
            if (checkSchema) {
                Message message5;
                try {
                    DirectoryServer.initializeJMX();
                }
                catch (Exception e) {
                    message5 = ToolMessages.ERR_LDIFSEARCH_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message5);
                    return 1;
                }
                try {
                    directoryServer.initializeConfiguration(configClass.getValue(), configFile.getValue());
                }
                catch (Exception e) {
                    message5 = ToolMessages.ERR_LDIFSEARCH_CANNOT_INITIALIZE_CONFIG.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message5);
                    return 1;
                }
                try {
                    directoryServer.initializeSchema();
                }
                catch (Exception e) {
                    message5 = ToolMessages.ERR_LDIFSEARCH_CANNOT_INITIALIZE_SCHEMA.get(String.valueOf(configFile.getValue()), e.getMessage());
                    err.println(message5);
                    return 1;
                }
            }
        }
        SearchScope searchScope = scopeString.isPresent() ? ((scopeStr = StaticUtils.toLowerCase(scopeString.getValue())).equals(SCOPE_STRING_BASE) ? SearchScope.BASE_OBJECT : (scopeStr.equals(SCOPE_STRING_ONE) ? SearchScope.SINGLE_LEVEL : (scopeStr.equals(SCOPE_STRING_SUBORDINATE) ? SearchScope.SUBORDINATE_SUBTREE : SearchScope.WHOLE_SUBTREE))) : SearchScope.WHOLE_SUBTREE;
        LinkedList<SearchFilter> searchFilters = new LinkedList<SearchFilter>();
        for (String filterString : filterStrings) {
            try {
                searchFilters.add(SearchFilter.createFilterFromString(filterString));
            }
            catch (Exception e) {
                Message message6 = ToolMessages.ERR_LDIFSEARCH_CANNOT_PARSE_FILTER.get(filterString, e.getMessage());
                err.println(message6);
                return 1;
            }
        }
        LinkedHashSet<AttributeType> userAttributeTypes = new LinkedHashSet<AttributeType>();
        LinkedHashSet<AttributeType> operationalAttributeTypes = new LinkedHashSet<AttributeType>();
        for (String attributeName : attributeNames) {
            AttributeType t = DirectoryServer.getAttributeType(attributeName, true);
            if (t.isOperational()) {
                operationalAttributeTypes.add(t);
                continue;
            }
            userAttributeTypes.add(t);
        }
        for (String objectClassName : objectClassNames) {
            ObjectClass c = DirectoryServer.getObjectClass(objectClassName, true);
            for (AttributeType t : c.getRequiredAttributeChain()) {
                if (t.isOperational()) {
                    operationalAttributeTypes.add(t);
                    continue;
                }
                userAttributeTypes.add(t);
            }
            for (AttributeType t : c.getOptionalAttributeChain()) {
                if (t.isOperational()) {
                    operationalAttributeTypes.add(t);
                    continue;
                }
                userAttributeTypes.add(t);
            }
        }
        LinkedList<DN> baseDNs = new LinkedList<DN>();
        if (baseDNString.isPresent()) {
            for (String dnString : baseDNString.getValues()) {
                try {
                    baseDNs.add(DN.decode(dnString));
                }
                catch (Exception e) {
                    message = ToolMessages.ERR_LDIFSEARCH_CANNOT_PARSE_BASE_DN.get(dnString, e.getMessage());
                    err.println(message);
                    return 1;
                }
            }
        } else {
            baseDNs.add(DN.nullDN());
        }
        try {
            timeLimitMillis = timeLimit.isPresent() ? 1000L * (long)timeLimit.getIntValue() : 0L;
        }
        catch (Exception e) {
            message = ToolMessages.ERR_LDIFSEARCH_CANNOT_PARSE_TIME_LIMIT.get(String.valueOf(e));
            err.println(message);
            return 1;
        }
        try {
            sizeLimitValue = sizeLimit.isPresent() ? sizeLimit.getIntValue() : 0;
        }
        catch (Exception e) {
            Message message7 = ToolMessages.ERR_LDIFSEARCH_CANNOT_PARSE_SIZE_LIMIT.get(String.valueOf(e));
            err.println(message7);
            return 1;
        }
        LDIFImportConfig importConfig = ldifFile.isPresent() ? new LDIFImportConfig(ldifFile.getValues()) : new LDIFImportConfig(System.in);
        LDIFExportConfig exportConfig = outputFile.isPresent() ? (overwriteExisting.isPresent() ? new LDIFExportConfig(outputFile.getValue(), ExistingFileBehavior.OVERWRITE) : new LDIFExportConfig(outputFile.getValue(), ExistingFileBehavior.APPEND)) : new LDIFExportConfig(out);
        exportConfig.setIncludeObjectClasses(includeObjectclassAttrs);
        if (dontWrap.isPresent()) {
            exportConfig.setWrapColumn(0);
        } else {
            exportConfig.setWrapColumn(75);
        }
        try {
            reader = new LDIFReader(importConfig);
        }
        catch (Exception e) {
            Message message8 = ToolMessages.ERR_LDIFSEARCH_CANNOT_CREATE_READER.get(String.valueOf(e));
            err.println(message8);
            return 1;
        }
        try {
            writer = new LDIFWriter(exportConfig);
        }
        catch (Exception e) {
            try {
                reader.close();
            }
            catch (Exception message8) {
                // empty catch block
            }
            Message message9 = ToolMessages.ERR_LDIFSEARCH_CANNOT_CREATE_WRITER.get(String.valueOf(e));
            err.println(message9);
            return 1;
        }
        long startTime = System.currentTimeMillis();
        long stopTime = startTime + timeLimitMillis;
        long matchCount = 0L;
        int resultCode = 0;
        while (true) {
            if (timeLimitMillis > 0L && System.currentTimeMillis() > stopTime) {
                resultCode = 3;
                Message message10 = ToolMessages.WARN_LDIFSEARCH_TIME_LIMIT_EXCEEDED.get();
                err.println(message10);
                break;
            }
            try {
                Iterator<AttributeType> iterator;
                Entry entry = reader.readEntry(checkSchema);
                if (entry == null) break;
                boolean matchesBaseAndScope = false;
                for (DN baseDN : baseDNs) {
                    if (!entry.matchesBaseAndScope(baseDN, searchScope)) continue;
                    matchesBaseAndScope = true;
                    break;
                }
                if (!matchesBaseAndScope) continue;
                boolean matchesFilter = false;
                for (SearchFilter filter : searchFilters) {
                    if (!filter.matchesEntry(entry)) continue;
                    matchesFilter = true;
                    break;
                }
                if (!matchesFilter) continue;
                if (!allUserAttrs) {
                    iterator = entry.getUserAttributes().keySet().iterator();
                    while (iterator.hasNext()) {
                        if (userAttributeTypes.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
                if (!allOperationalAttrs) {
                    iterator = entry.getOperationalAttributes().keySet().iterator();
                    while (iterator.hasNext()) {
                        if (operationalAttributeTypes.contains(iterator.next())) continue;
                        iterator.remove();
                    }
                }
                writer.writeEntry(entry);
                writer.flush();
                if (sizeLimitValue <= 0 || ++matchCount < (long)sizeLimitValue) continue;
                resultCode = 4;
                Message message11 = ToolMessages.WARN_LDIFSEARCH_SIZE_LIMIT_EXCEEDED.get();
                err.println(message11);
            }
            catch (LDIFException le) {
                if (le.canContinueReading()) {
                    Message message12 = ToolMessages.ERR_LDIFSEARCH_CANNOT_READ_ENTRY_RECOVERABLE.get(le.getMessage());
                    err.println(message12);
                    continue;
                }
                Message message13 = ToolMessages.ERR_LDIFSEARCH_CANNOT_READ_ENTRY_FATAL.get(le.getMessage());
                err.println(message13);
                resultCode = 82;
            }
            catch (Exception e) {
                Message message14 = ToolMessages.ERR_LDIFSEARCH_ERROR_DURING_PROCESSING.get(String.valueOf(e));
                err.println(message14);
                resultCode = 82;
            }
            break;
        }
        try {
            reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultCode;
    }
}

