/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.api.ErrorLogPublisher;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.tools.LDAPConnectionException;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.tasks.TaskClient;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDAPException;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.LDAPConnectionArgumentParser;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuCallback;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

public class ManageTasks
extends ConsoleApplication {
    private static ErrorLogPublisher errorLogPublisher = null;
    private static final boolean alwaysSSL = true;
    private static final int INDENT = 2;
    private StringArgument task = null;
    private BooleanArgument summary = null;
    private StringArgument cancel = null;
    private BooleanArgument noPrompt = null;
    private TaskClient taskClient;

    public static void main(String[] args) {
        int retCode = ManageTasks.mainTaskInfo(args, System.in, System.out, System.err);
        if (errorLogPublisher != null) {
            ErrorLogger.removeErrorLogPublisher(errorLogPublisher);
        }
        if (retCode != 0) {
            System.exit(StaticUtils.filterExitCode(retCode));
        }
    }

    public static int mainTaskInfo(String[] args) {
        return ManageTasks.mainTaskInfo(args, System.in, System.out, System.err);
    }

    public static int mainTaskInfo(String[] args, InputStream in, OutputStream out, OutputStream err, boolean initializeServer) {
        ManageTasks tool = new ManageTasks(in, out, err);
        return tool.process(args, initializeServer);
    }

    public static int mainTaskInfo(String[] args, InputStream in, OutputStream out, OutputStream err) {
        return ManageTasks.mainTaskInfo(args, in, out, err, true);
    }

    public ManageTasks(InputStream in, OutputStream out, OutputStream err) {
        super(in, out, err);
    }

    public int process(String[] args) {
        return this.process(args, true);
    }

    public int process(String[] args, boolean initializeServer) {
        if (initializeServer) {
            DirectoryServer.bootstrapClient();
        }
        LDAPConnectionArgumentParser argParser = new LDAPConnectionArgumentParser("org.opends.server.tools.TaskInfo", ToolMessages.INFO_TASKINFO_TOOL_DESCRIPTION.get(), false, null, true);
        try {
            StringArgument propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            argParser.addArgument(propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            argParser.addArgument(noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            this.task = new StringArgument("info", Character.valueOf('i'), "info", false, true, ToolMessages.INFO_TASK_ID_PLACEHOLDER.get(), ToolMessages.INFO_TASKINFO_TASK_ARG_DESCRIPTION.get());
            argParser.addArgument(this.task);
            this.cancel = new StringArgument("cancel", Character.valueOf('c'), "cancel", false, true, ToolMessages.INFO_TASK_ID_PLACEHOLDER.get(), ToolMessages.INFO_TASKINFO_TASK_ARG_CANCEL.get());
            argParser.addArgument(this.cancel);
            this.summary = new BooleanArgument("summary", Character.valueOf('s'), "summary", ToolMessages.INFO_TASKINFO_SUMMARY_ARG_DESCRIPTION.get());
            argParser.addArgument(this.summary);
            this.noPrompt = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_DESCRIPTION_NO_PROMPT.get());
            argParser.addArgument(this.noPrompt);
            BooleanArgument displayUsage = new BooleanArgument("help", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            argParser.addArgument(displayUsage);
            argParser.setUsageArgument(displayUsage);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            return 1;
        }
        try {
            argParser.getArguments().initArgumentsWithConfiguration();
        }
        catch (ConfigException ae) {
            // empty catch block
        }
        try {
            argParser.parseArguments(args);
            StaticUtils.checkOnlyOneArgPresent(this.task, this.summary, this.cancel);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.println(message);
            this.println(argParser.getUsageMessage());
            return 1;
        }
        if (!argParser.usageOrVersionDisplayed()) {
            try {
                BuildVersion.checkVersionMismatch();
            }
            catch (InitializationException e) {
                this.println(e.getMessageObject());
                return 1;
            }
            try {
                MenuResult<TaskEntry> r;
                LDAPConnectionConsoleInteraction ui = new LDAPConnectionConsoleInteraction(this, argParser.getArguments());
                this.taskClient = new TaskClient(argParser.connect(ui, this.getOutputStream(), this.getErrorStream()));
                if (this.isMenuDrivenMode()) {
                    Menu<Void> menu;
                    MenuResult<Void> result;
                    do {
                        this.getOutputStream().println();
                    } while (!(result = (menu = this.getSummaryMenu()).run()).isQuit());
                    return 0;
                }
                if (this.task.isPresent()) {
                    this.getOutputStream().println();
                    r = new PrintTaskInfo(this.task.getValue()).invoke(this);
                    if (r.isAgain()) {
                        return 1;
                    }
                } else if (this.summary.isPresent()) {
                    this.getOutputStream().println();
                    this.printSummaryTable();
                } else if (this.cancel.isPresent()) {
                    r = new CancelTask(this.cancel.getValue()).invoke(this);
                    if (r.isAgain()) {
                        return 1;
                    }
                } else if (!this.isInteractive()) {
                    this.getOutputStream().println();
                    this.printSummaryTable();
                    return 0;
                }
            }
            catch (LDAPConnectionException lce) {
                this.println(ToolMessages.INFO_TASKINFO_LDAP_EXCEPTION.get(lce.getMessageObject()));
                return 1;
            }
            catch (Exception e) {
                this.println(Message.raw(e.getMessage(), new Object[0]));
                return 1;
            }
        }
        return 0;
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        return !this.noPrompt.isPresent();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return !this.task.isPresent() && !this.cancel.isPresent() && !this.summary.isPresent() && !this.noPrompt.isPresent();
    }

    @Override
    public boolean isQuiet() {
        return false;
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return false;
    }

    private void printSummaryTable() throws LDAPException, IOException, ASN1Exception {
        List<TaskEntry> entries = this.taskClient.getTaskEntries();
        if (entries.size() > 0) {
            TableBuilder table = new TableBuilder();
            TreeMap<String, TaskEntry> mapIdToEntry = new TreeMap<String, TaskEntry>();
            for (TaskEntry entry : entries) {
                String taskId = entry.getId();
                if (taskId == null) continue;
                mapIdToEntry.put(taskId, entry);
            }
            table.appendHeading(ToolMessages.INFO_TASKINFO_FIELD_ID.get());
            table.appendHeading(ToolMessages.INFO_TASKINFO_FIELD_TYPE.get());
            table.appendHeading(ToolMessages.INFO_TASKINFO_FIELD_STATUS.get());
            for (String taskId : mapIdToEntry.keySet()) {
                TaskEntry entryWrapper = (TaskEntry)mapIdToEntry.get(taskId);
                table.startRow();
                table.appendCell(taskId);
                table.appendCell(entryWrapper.getType());
                table.appendCell(entryWrapper.getState());
            }
            StringWriter sw = new StringWriter();
            TextTablePrinter tablePrinter = new TextTablePrinter(sw);
            tablePrinter.setIndentWidth(2);
            tablePrinter.setTotalWidth(80);
            table.print(tablePrinter);
            this.getOutputStream().println(Message.raw(sw.getBuffer(), new Object[0]));
        } else {
            this.getOutputStream().println(ToolMessages.INFO_TASKINFO_NO_TASKS.get());
            this.getOutputStream().println();
        }
    }

    private Menu<Void> getSummaryMenu() throws LDAPException, IOException, ASN1Exception {
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<Integer> cancelableIndices = new ArrayList<Integer>();
        List<TaskEntry> entries = this.taskClient.getTaskEntries();
        MenuBuilder<Void> menuBuilder = new MenuBuilder<Void>(this);
        if (entries.size() > 0) {
            TreeMap<String, TaskEntry> mapIdToEntry = new TreeMap<String, TaskEntry>();
            for (TaskEntry entry : entries) {
                String taskId = entry.getId();
                if (taskId == null) continue;
                mapIdToEntry.put(taskId, entry);
            }
            menuBuilder.setColumnHeadings(ToolMessages.INFO_TASKINFO_FIELD_ID.get(), ToolMessages.INFO_TASKINFO_FIELD_TYPE.get(), ToolMessages.INFO_TASKINFO_FIELD_STATUS.get());
            menuBuilder.setColumnWidths(null, null, 0);
            int index = 0;
            for (String taskId : mapIdToEntry.keySet()) {
                taskIds.add(taskId);
                TaskEntry taskEntry = (TaskEntry)mapIdToEntry.get(taskId);
                menuBuilder.addNumberedOption(Message.raw(taskEntry.getId(), new Object[0]), new TaskDrilldownMenu(taskId), taskEntry.getType(), taskEntry.getState());
                ++index;
                if (!taskEntry.isCancelable()) continue;
                cancelableIndices.add(index);
            }
        } else {
            this.getOutputStream().println(ToolMessages.INFO_TASKINFO_NO_TASKS.get());
            this.getOutputStream().println();
        }
        menuBuilder.addCharOption(ToolMessages.INFO_TASKINFO_CMD_REFRESH_CHAR.get(), ToolMessages.INFO_TASKINFO_CMD_REFRESH.get(), new PrintSummaryTop());
        if (cancelableIndices.size() > 0) {
            menuBuilder.addCharOption(ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get(), ToolMessages.INFO_TASKINFO_CMD_CANCEL.get(), new CancelTaskTop(taskIds, cancelableIndices));
        }
        menuBuilder.addQuitOption();
        return menuBuilder.toMenu();
    }

    public TaskClient getTaskClient() {
        return this.taskClient;
    }

    private static class CancelTask
    extends TaskOperationCallback {
        public CancelTask(String taskId) {
            super(taskId);
        }

        @Override
        public MenuResult<TaskEntry> invoke(ManageTasks app) throws CLIException {
            try {
                TaskEntry entry = app.getTaskClient().getTaskEntry(this.taskId);
                if (entry.isCancelable()) {
                    app.getTaskClient().cancelTask(this.taskId);
                    app.println(ToolMessages.INFO_TASKINFO_CMD_CANCEL_SUCCESS.get(this.taskId));
                    return MenuResult.success(entry);
                }
                app.println(ToolMessages.ERR_TASKINFO_TASK_NOT_CANCELABLE_TASK.get(this.taskId));
                return MenuResult.again();
            }
            catch (Exception e) {
                app.println(ToolMessages.ERR_TASKINFO_CANCELING_TASK.get(this.taskId, e.getMessage()));
                return MenuResult.again();
            }
        }
    }

    private static class CancelTaskTop
    extends TopMenuCallback {
        private List<String> taskIds;
        private List<Integer> cancelableIndices;

        public CancelTaskTop(List<String> taskIds, List<Integer> cancelableIndices) {
            this.taskIds = taskIds;
            this.cancelableIndices = cancelableIndices;
        }

        @Override
        public MenuResult<Void> invoke(ManageTasks app) throws CLIException {
            if (this.taskIds != null && this.taskIds.size() > 0) {
                if (this.cancelableIndices != null && this.cancelableIndices.size() > 0) {
                    Integer index = null;
                    String line = app.readLineOfInput(ToolMessages.INFO_TASKINFO_CMD_CANCEL_NUMBER_PROMPT.get(this.cancelableIndices.get(0)));
                    if (line.length() == 0) {
                        line = String.valueOf(this.cancelableIndices.get(0));
                    }
                    try {
                        int i = Integer.parseInt(line);
                        if (!this.cancelableIndices.contains(i)) {
                            app.println(ToolMessages.ERR_TASKINFO_NOT_CANCELABLE_TASK_INDEX.get(i));
                        } else {
                            index = i - 1;
                        }
                    }
                    catch (NumberFormatException i) {
                        // empty catch block
                    }
                    if (index != null) {
                        String taskId = this.taskIds.get(index);
                        try {
                            CancelTask ct = new CancelTask(taskId);
                            MenuResult<TaskEntry> result = ct.invoke(app);
                            if (result.isSuccess()) {
                                return MenuResult.success();
                            }
                            return MenuResult.again();
                        }
                        catch (Exception e) {
                            app.println(ToolMessages.ERR_TASKINFO_CANCELING_TASK.get(taskId, e.getMessage()));
                            return MenuResult.again();
                        }
                    }
                    app.println(ToolMessages.ERR_TASKINFO_INVALID_MENU_KEY.get(line));
                    return MenuResult.again();
                }
                app.println(ToolMessages.INFO_TASKINFO_NO_CANCELABLE_TASKS.get());
                return MenuResult.cancel();
            }
            app.println(ToolMessages.INFO_TASKINFO_NO_TASKS.get());
            return MenuResult.cancel();
        }
    }

    private static class ViewTaskLogs
    extends TaskOperationCallback {
        public ViewTaskLogs(String taskId) {
            super(taskId);
        }

        @Override
        protected MenuResult<TaskEntry> invoke(ManageTasks app) throws CLIException {
            TaskEntry taskEntry = null;
            try {
                taskEntry = app.getTaskClient().getTaskEntry(this.taskId);
                List<Message> logs = taskEntry.getLogMessages();
                app.getOutputStream().println();
                TableBuilder table = new TableBuilder();
                table.appendHeading(ToolMessages.INFO_TASKINFO_FIELD_LOG.get());
                if (logs != null && logs.size() > 0) {
                    for (Message log : logs) {
                        table.startRow();
                        table.appendCell(log);
                    }
                } else {
                    table.startRow();
                    table.appendCell(ToolMessages.INFO_TASKINFO_NONE.get());
                }
                StringWriter sw = new StringWriter();
                TextTablePrinter tablePrinter = new TextTablePrinter(sw);
                tablePrinter.setTotalWidth(80);
                tablePrinter.setIndentWidth(2);
                tablePrinter.setColumnWidth(0, 0);
                table.print(tablePrinter);
                app.getOutputStream().println(Message.raw(sw.getBuffer().toString(), new Object[0]));
                app.getOutputStream().println();
            }
            catch (Exception e) {
                app.println(ToolMessages.ERR_TASKINFO_ACCESSING_LOGS.get(this.taskId, e.getMessage()));
            }
            return MenuResult.success(taskEntry);
        }
    }

    private static class PrintTaskInfo
    extends TaskOperationCallback {
        public PrintTaskInfo(String taskId) {
            super(taskId);
        }

        @Override
        public MenuResult<TaskEntry> invoke(ManageTasks app) throws CLIException {
            TaskEntry taskEntry;
            try {
                Message m;
                taskEntry = app.getTaskClient().getTaskEntry(this.taskId);
                TableBuilder table = new TableBuilder();
                table.appendHeading(ToolMessages.INFO_TASKINFO_DETAILS.get());
                table.startRow();
                table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_ID.get());
                table.appendCell(taskEntry.getId());
                table.startRow();
                table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_TYPE.get());
                table.appendCell(taskEntry.getType());
                table.startRow();
                table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_STATUS.get());
                table.appendCell(taskEntry.getState());
                if (TaskState.isRecurring(taskEntry.getTaskState())) {
                    table.startRow();
                    table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_SCHEDULED_START.get());
                    m = taskEntry.getScheduleTab();
                    table.appendCell(m);
                } else {
                    table.startRow();
                    table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_SCHEDULED_START.get());
                    m = taskEntry.getScheduledStartTime();
                    if (m == null || m.equals(Message.EMPTY)) {
                        table.appendCell(ToolMessages.INFO_TASKINFO_IMMEDIATE_EXECUTION.get());
                    } else {
                        table.appendCell(m);
                    }
                    table.startRow();
                    table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_ACTUAL_START.get());
                    table.appendCell(taskEntry.getActualStartTime());
                    table.startRow();
                    table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_COMPLETION_TIME.get());
                    table.appendCell(taskEntry.getCompletionTime());
                }
                this.writeMultiValueCells(table, ToolMessages.INFO_TASKINFO_FIELD_DEPENDENCY.get(), taskEntry.getDependencyIds());
                table.startRow();
                table.appendCell(ToolMessages.INFO_TASKINFO_FIELD_FAILED_DEPENDENCY_ACTION.get());
                m = taskEntry.getFailedDependencyAction();
                table.appendCell(m != null ? m : ToolMessages.INFO_TASKINFO_NONE.get());
                this.writeMultiValueCells(table, ToolMessages.INFO_TASKINFO_FIELD_NOTIFY_ON_COMPLETION.get(), taskEntry.getCompletionNotificationEmailAddresses(), ToolMessages.INFO_TASKINFO_NONE_SPECIFIED.get());
                this.writeMultiValueCells(table, ToolMessages.INFO_TASKINFO_FIELD_NOTIFY_ON_ERROR.get(), taskEntry.getErrorNotificationEmailAddresses(), ToolMessages.INFO_TASKINFO_NONE_SPECIFIED.get());
                StringWriter sw = new StringWriter();
                TextTablePrinter tablePrinter = new TextTablePrinter(sw);
                tablePrinter.setTotalWidth(80);
                tablePrinter.setIndentWidth(2);
                tablePrinter.setColumnWidth(1, 0);
                table.print(tablePrinter);
                app.getOutputStream().println();
                app.getOutputStream().println(Message.raw(sw.getBuffer().toString(), new Object[0]));
                table = new TableBuilder();
                table.appendHeading(ToolMessages.INFO_TASKINFO_OPTIONS.get(taskEntry.getType()));
                Map<Message, List<String>> taskSpecificAttrs = taskEntry.getTaskSpecificAttributeValuePairs();
                for (Message attrName : taskSpecificAttrs.keySet()) {
                    table.startRow();
                    table.appendCell(attrName);
                    List<String> values = taskSpecificAttrs.get(attrName);
                    if (values.size() > 0) {
                        table.appendCell(values.get(0));
                    }
                    if (values.size() <= 1) continue;
                    for (int i = 1; i < values.size(); ++i) {
                        table.startRow();
                        table.appendCell();
                        table.appendCell(values.get(i));
                    }
                }
                sw = new StringWriter();
                tablePrinter = new TextTablePrinter(sw);
                tablePrinter.setTotalWidth(80);
                tablePrinter.setIndentWidth(2);
                tablePrinter.setColumnWidth(1, 0);
                table.print(tablePrinter);
                app.getOutputStream().println(Message.raw(sw.getBuffer().toString(), new Object[0]));
                List<Message> logs = taskEntry.getLogMessages();
                if (logs != null && logs.size() > 0) {
                    table = new TableBuilder();
                    table.appendHeading(ToolMessages.INFO_TASKINFO_FIELD_LAST_LOG.get());
                    table.startRow();
                    table.appendCell(logs.get(logs.size() - 1));
                    sw = new StringWriter();
                    tablePrinter = new TextTablePrinter(sw);
                    tablePrinter.setTotalWidth(80);
                    tablePrinter.setIndentWidth(2);
                    tablePrinter.setColumnWidth(0, 0);
                    table.print(tablePrinter);
                    app.getOutputStream().println(Message.raw(sw.getBuffer().toString(), new Object[0]));
                }
                app.getOutputStream().println();
            }
            catch (Exception e) {
                app.println(ToolMessages.ERR_TASKINFO_RETRIEVING_TASK_ENTRY.get(this.taskId, e.getMessage()));
                return MenuResult.again();
            }
            return MenuResult.success(taskEntry);
        }

        private void writeMultiValueCells(TableBuilder table, Message fieldLabel, List<?> values) {
            this.writeMultiValueCells(table, fieldLabel, values, ToolMessages.INFO_TASKINFO_NONE.get());
        }

        private void writeMultiValueCells(TableBuilder table, Message fieldLabel, List<?> values, Message noneLabel) {
            table.startRow();
            table.appendCell(fieldLabel);
            if (values.isEmpty()) {
                table.appendCell(noneLabel);
            } else {
                table.appendCell(values.get(0));
            }
            if (values.size() > 1) {
                for (int i = 1; i < values.size(); ++i) {
                    table.startRow();
                    table.appendCell();
                    table.appendCell(values.get(i));
                }
            }
        }
    }

    private static class TaskDrilldownMenu
    extends TopMenuCallback {
        private String taskId;

        public TaskDrilldownMenu(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public MenuResult<Void> invoke(ManageTasks app) throws CLIException {
            block8: {
                MenuResult<TaskEntry> res = new PrintTaskInfo(this.taskId).invoke(app);
                TaskEntry taskEntry = res.getValue();
                if (taskEntry != null) {
                    while (true) {
                        try {
                            while (true) {
                                taskEntry = app.getTaskClient().getTaskEntry(this.taskId);
                                MenuBuilder<TaskEntry> menuBuilder = new MenuBuilder<TaskEntry>(app);
                                menuBuilder.addBackOption(true);
                                menuBuilder.addCharOption(ToolMessages.INFO_TASKINFO_CMD_REFRESH_CHAR.get(), ToolMessages.INFO_TASKINFO_CMD_REFRESH.get(), new PrintTaskInfo(this.taskId));
                                List<Message> logs = taskEntry.getLogMessages();
                                if (logs != null && logs.size() > 0) {
                                    menuBuilder.addCharOption(ToolMessages.INFO_TASKINFO_CMD_VIEW_LOGS_CHAR.get(), ToolMessages.INFO_TASKINFO_CMD_VIEW_LOGS.get(), new ViewTaskLogs(this.taskId));
                                }
                                if (taskEntry.isCancelable() && !taskEntry.isDone()) {
                                    menuBuilder.addCharOption(ToolMessages.INFO_TASKINFO_CMD_CANCEL_CHAR.get(), ToolMessages.INFO_TASKINFO_CMD_CANCEL.get(), new CancelTask(this.taskId));
                                }
                                menuBuilder.addQuitOption();
                                Menu menu = menuBuilder.toMenu();
                                MenuResult result = menu.run();
                                if (!result.isCancel()) {
                                    if (!result.isQuit()) continue;
                                    System.exit(0);
                                    continue;
                                }
                                break block8;
                                break;
                            }
                        }
                        catch (Exception e) {
                            app.println(Message.raw(e.getMessage(), new Object[0]));
                            continue;
                        }
                        break;
                    }
                }
                app.println(ToolMessages.ERR_TASKINFO_UNKNOWN_TASK_ENTRY.get(this.taskId));
            }
            return MenuResult.success();
        }
    }

    private static class PrintSummaryTop
    extends TopMenuCallback {
        private PrintSummaryTop() {
        }

        @Override
        public MenuResult<Void> invoke(ManageTasks app) throws CLIException {
            return MenuResult.success();
        }
    }

    private static abstract class TaskOperationCallback
    implements MenuCallback<TaskEntry> {
        protected String taskId;

        public TaskOperationCallback(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public MenuResult<TaskEntry> invoke(ConsoleApplication app) throws CLIException {
            return this.invoke((ManageTasks)app);
        }

        protected abstract MenuResult<TaskEntry> invoke(ManageTasks var1) throws CLIException;
    }

    private static abstract class TopMenuCallback
    implements MenuCallback<Void> {
        private TopMenuCallback() {
        }

        @Override
        public MenuResult<Void> invoke(ConsoleApplication app) throws CLIException {
            return this.invoke((ManageTasks)app);
        }

        protected abstract MenuResult<Void> invoke(ManageTasks var1) throws CLIException;
    }
}

