/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.opends.server.tools.upgrade.UpgradeUtils;
import org.opends.server.util.StaticUtils;

class LicenseFile {
    private static File licFile = null;
    private static boolean approved = false;

    LicenseFile() {
    }

    private static String getLegalDirectory() {
        String installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (installRootFromSystem == null) {
            installRootFromSystem = System.getenv("INSTALL_ROOT");
        }
        if (installRootFromSystem == null) {
            installRootFromSystem = "";
        }
        return installRootFromSystem + File.separatorChar + "Legal";
    }

    private static String getInstanceLegalDirectory() {
        String instanceDirname;
        StringBuilder instanceLegalDirName;
        File instanceLegalDir;
        String installDirName = System.getProperty("INSTALL_ROOT");
        if (installDirName == null) {
            installDirName = System.getenv("INSTALL_ROOT");
        }
        if (installDirName == null) {
            installDirName = ".";
        }
        if (!(instanceLegalDir = new File((instanceLegalDirName = new StringBuilder(instanceDirname = UpgradeUtils.getInstancePathFromInstallPath(installDirName)).append(File.separator).append("Legal")).toString())).exists()) {
            instanceLegalDir.mkdir();
        }
        return instanceLegalDirName.toString();
    }

    private static String getName() {
        return LicenseFile.getLegalDirectory() + File.separatorChar + "license_to_accept.txt";
    }

    private static File getFile() {
        if (licFile == null) {
            licFile = new File(LicenseFile.getName());
        }
        return licFile;
    }

    static boolean exists() {
        return LicenseFile.getFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getText() {
        FileReader reader;
        try {
            reader = new FileReader(LicenseFile.getFile());
        }
        catch (Exception e) {
            return "";
        }
        int fileLen = (int)LicenseFile.getFile().length();
        char[] charArray = new char[fileLen];
        try {
            reader.read(charArray);
        }
        catch (IOException ioe) {
            try {
                System.out.println("Could not read license file");
            }
            catch (Throwable throwable) {
                StaticUtils.close(reader);
                throw throwable;
            }
            StaticUtils.close(reader);
        }
        StaticUtils.close(reader);
        return new String(charArray);
    }

    static boolean getApproval() {
        return approved;
    }

    static void setApproval(boolean p_approved) {
        approved = p_approved;
    }

    static void createFileLicenseApproved() {
        if (LicenseFile.getApproval()) {
            try {
                new File(LicenseFile.getInstanceLegalDirectory() + File.separatorChar + "licenseAccepted").createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static boolean isAlreadyApproved() {
        File f = new File(LicenseFile.getInstanceLegalDirectory() + File.separatorChar + "licenseAccepted");
        return f.exists();
    }
}

