/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.upgrade;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.LockFileManager;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.upgrade.LicenseFile;
import org.opends.server.tools.upgrade.UpgradeCli;
import org.opends.server.tools.upgrade.UpgradeContext;
import org.opends.server.tools.upgrade.UpgradeTask;
import org.opends.server.tools.upgrade.UpgradeTasks;
import org.opends.server.tools.upgrade.UpgradeUtils;
import org.opends.server.util.BuildVersion;
import org.opends.server.util.StaticUtils;

public final class Upgrade {
    private static final Logger LOG = Logger.getLogger(UpgradeCli.class.getName());
    private static final BuildVersion UPGRADESUPPORTSVERSIONFROM = BuildVersion.valueOf("2.4.5.0000");
    static final int EXIT_CODE_SUCCESS = 0;
    static final int EXIT_CODE_ERROR = 1;
    static final int EXIT_CODE_MANUAL_INTERVENTION = 2;
    static boolean hasPostUpgradeTask = false;
    private static final NavigableMap<BuildVersion, List<UpgradeTask>> TASKS = new TreeMap<BuildVersion, List<UpgradeTask>>();
    private static final List<UpgradeTask> MANDATORY_TASKS = new LinkedList<UpgradeTask>();

    private static List<UpgradeTask> getUpgradeTasks(BuildVersion fromVersion, BuildVersion toVersion) {
        LinkedList<UpgradeTask> tasks = new LinkedList<UpgradeTask>();
        for (List subList : TASKS.subMap(fromVersion, false, toVersion, true).values()) {
            tasks.addAll(subList);
        }
        tasks.addAll(MANDATORY_TASKS);
        return tasks;
    }

    public static void upgrade(UpgradeContext context) throws ClientException {
        Upgrade.isVersionCanBeUpdated(context);
        Upgrade.checkIfServerIsRunning(context);
        context.notify(ToolMessages.INFO_UPGRADE_TITLE.get(), 5);
        context.notify(ToolMessages.INFO_UPGRADE_SUMMARY.get(context.getFromVersion().toString(), context.getToVersion().toString()), 7);
        context.notify(ToolMessages.INFO_UPGRADE_GENERAL_SEE_FOR_DETAILS.get(UpgradeUtils.getInstallationPath() + File.separator + "upgrade.log"), 7);
        Upgrade.checkLicence(context);
        List<UpgradeTask> tasks = Upgrade.getUpgradeTasks(context.getFromVersion(), context.getToVersion());
        if (tasks.isEmpty()) {
            Upgrade.changeBuildInfoVersion(context);
            return;
        }
        for (UpgradeTask task : tasks) {
            task.verify(context);
        }
        context.notify(ToolMessages.INFO_UPGRADE_REQUIREMENTS.get(), 5);
        for (UpgradeTask task : tasks) {
            task.interact(context);
        }
        int userResponse = context.confirmYN(ToolMessages.INFO_UPGRADE_DISPLAY_CONFIRM_START.get(), 0);
        if (userResponse == 1) {
            Message message = ToolMessages.INFO_UPGRADE_ABORTED_BY_USER.get();
            context.notify(message, 1);
            throw new ClientException(1, message);
        }
        try {
            context.notify(ToolMessages.INFO_UPGRADE_PERFORMING_TASKS.get(), 5);
            for (UpgradeTask task : tasks) {
                task.perform(context);
            }
            if (UpgradeTasks.countErrors == 0) {
                Upgrade.changeBuildInfoVersion(context);
                LicenseFile.createFileLicenseApproved();
            } else {
                context.notify(ToolMessages.ERR_UPGRADE_FAILS.get(UpgradeTasks.countErrors), 5);
            }
            if (hasPostUpgradeTask && UpgradeTasks.countErrors == 0) {
                context.notify(ToolMessages.INFO_UPGRADE_PERFORMING_POST_TASKS.get(), 5);
                Upgrade.performPostUpgradeTasks(context, tasks);
                context.notify(ToolMessages.INFO_UPGRADE_POST_TASKS_COMPLETE.get(), 5);
            }
        }
        catch (ClientException e) {
            context.notify(e.getMessageObject(), 8);
            throw e;
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_UPGRADE_TASKS_FAIL.get(e.getMessage());
            context.notify(message, 8);
            throw new ClientException(1, message);
        }
        finally {
            context.notify(ToolMessages.INFO_UPGRADE_GENERAL_SEE_FOR_DETAILS.get(UpgradeUtils.getInstallationPath() + File.separator + "upgrade.log"), 7);
            LOG.log(Level.CONFIG, ToolMessages.INFO_UPGRADE_PROCESS_END.get().toString());
        }
    }

    private static void performPostUpgradeTasks(UpgradeContext context, List<UpgradeTask> tasks) throws ClientException {
        boolean isOk = true;
        for (UpgradeTask task : tasks) {
            if (isOk) {
                try {
                    task.postUpgrade(context);
                }
                catch (ClientException e) {
                    context.notify(e.getMessageObject(), 1);
                    isOk = false;
                }
                continue;
            }
            task.postponePostUpgrade(context);
        }
    }

    private static void register(String versionString, UpgradeTask ... tasks) {
        BuildVersion version = BuildVersion.valueOf(versionString);
        LinkedList<UpgradeTask> taskList = (LinkedList<UpgradeTask>)TASKS.get(version);
        if (taskList == null) {
            taskList = new LinkedList<UpgradeTask>();
            TASKS.put(version, taskList);
        }
        taskList.addAll(Arrays.asList(tasks));
    }

    private static void registerLast(UpgradeTask ... tasks) {
        MANDATORY_TASKS.addAll(Arrays.asList(tasks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkIfServerIsRunning(UpgradeContext context) throws ClientException {
        String lockFile = LockFileManager.getServerLockFileName();
        StringBuilder failureReason = new StringBuilder();
        try {
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_UPGRADE_REQUIRES_SERVER_OFFLINE.get();
                context.notify(message, 7);
                throw new ClientException(1, message);
            }
        }
        finally {
            LockFileManager.releaseLock(lockFile, failureReason);
        }
    }

    private static void isVersionCanBeUpdated(UpgradeContext context) throws ClientException {
        if (context.getFromVersion().equals(context.getToVersion())) {
            Message message = ToolMessages.ERR_UPGRADE_VERSION_UP_TO_DATE.get(context.getToVersion().toString());
            context.notify(message, 7);
            throw new ClientException(0, message);
        }
        if (context.getFromVersion().compareTo(UPGRADESUPPORTSVERSIONFROM) < 0) {
            Message message = ToolMessages.INFO_UPGRADE_VERSION_IS_NOT_SUPPORTED.get(UPGRADESUPPORTSVERSIONFROM.toString(), UPGRADESUPPORTSVERSIONFROM.toString());
            context.notify(message, 7);
            throw new ClientException(1, message);
        }
    }

    private static void changeBuildInfoVersion(UpgradeContext context) throws ClientException {
        FileWriter buildInfo = null;
        try {
            buildInfo = new FileWriter(new File(UpgradeUtils.configDirectory, "buildinfo"), false);
            buildInfo.write(context.getToVersion().toString());
            context.notify(ToolMessages.INFO_UPGRADE_SUCCESSFUL.get(context.getFromVersion().toString(), context.getToVersion().toString()), 5);
        }
        catch (IOException e) {
            try {
                Message message = Message.raw(e.getMessage(), new Object[0]);
                context.notify(message, 8);
                throw new ClientException(1, message);
            }
            catch (Throwable throwable) {
                StaticUtils.close(buildInfo);
                throw throwable;
            }
        }
        StaticUtils.close(buildInfo);
    }

    private static void checkLicence(UpgradeContext context) throws ClientException {
        if (!LicenseFile.isAlreadyApproved() && LicenseFile.exists()) {
            context.notify(Message.raw("\n" + LicenseFile.getText(), new Object[0]));
            context.notify(ToolMessages.INFO_LICENSE_DETAILS_CLI_LABEL.get());
            if (!context.isAcceptLicenseMode()) {
                int answer;
                if (context.isForceUpgradeMode()) {
                    answer = 1;
                    context.notify(Message.raw(ToolMessages.INFO_LICENSE_ACCEPT.get() + " " + ToolMessages.INFO_PROMPT_NO_COMPLETE_ANSWER.get(), new Object[0]));
                } else {
                    answer = context.confirmYN(ToolMessages.INFO_LICENSE_ACCEPT.get(), 1);
                }
                if (answer == 1) {
                    System.exit(0);
                } else if (answer == 0) {
                    LicenseFile.setApproval(true);
                }
            } else {
                context.notify(Message.raw(ToolMessages.INFO_LICENSE_ACCEPT.get() + " " + ToolMessages.INFO_PROMPT_YES_COMPLETE_ANSWER.get(), new Object[0]));
                LicenseFile.setApproval(true);
            }
        }
    }

    static boolean hasPostUpgradeTask() {
        return hasPostUpgradeTask;
    }

    static void setHasPostUpgradeTask(boolean hasPostUpgradeTask) {
        Upgrade.hasPostUpgradeTask = hasPostUpgradeTask;
    }

    private Upgrade() {
    }

    static {
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_6869_SUMMARY.get(), "(objectClass=ds-cfg-collation-matching-rule)", "add: ds-cfg-collation", "ds-cfg-collation: de:1.3.6.1.4.1.42.2.27.9.4.28.1", "ds-cfg-collation: de-DE:1.3.6.1.4.1.42.2.27.9.4.28.1", "-", "delete: ds-cfg-collation", "ds-cfg-collation: de:1.3.6.1.4.1.142.2.27.9.4.28.1", "ds-cfg-collation: de-DE:1.3.6.1.4.1.142.2.27.9.4.28.1"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_7192_SUMMARY.get(), "(objectClass=ds-cfg-password-policy)", "add: objectClass", "objectClass: ds-cfg-authentication-policy", "-", "add: ds-cfg-java-class", "ds-cfg-java-class: org.opends.server.core.PasswordPolicyFactory"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_7364_SUMMARY.get(), "(ds-cfg-java-class=org.opends.server.loggers.TextAuditLogPublisher)", "add: objectClass", "objectClass: ds-cfg-file-based-audit-log-publisher", "-", "delete: objectClass", "objectClass: ds-cfg-file-based-access-log-publisher"));
        Upgrade.register("2.5.0", UpgradeTasks.renameSnmpSecurityConfig(ToolMessages.INFO_UPGRADE_TASK_7466_SUMMARY.get()));
        Upgrade.register("2.5.0", UpgradeTasks.newAttributeTypes(ToolMessages.INFO_UPGRADE_TASK_7748_1_SUMMARY.get(), "00-core.ldif", "etag"), UpgradeTasks.addConfigEntry(ToolMessages.INFO_UPGRADE_TASK_7748_2_SUMMARY.get(), "dn: cn=etag,cn=Virtual Attributes,cn=config", "changetype: add", "objectClass: top", "objectClass: ds-cfg-virtual-attribute", "objectClass: ds-cfg-entity-tag-virtual-attribute", "cn: etag", "ds-cfg-java-class: org.opends.server.extensions.EntityTagVirtualAttributeProvider", "ds-cfg-enabled: true", "ds-cfg-attribute-type: etag", "ds-cfg-conflict-behavior: real-overrides-virtual", "ds-cfg-checksum-algorithm: adler-32", "ds-cfg-excluded-attribute: ds-sync-hist"));
        Upgrade.register("2.5.0", UpgradeTasks.addConfigEntry(ToolMessages.INFO_UPGRADE_TASK_7834_SUMMARY.get(), "dn: cn=Password Expiration Time,cn=Virtual Attributes,cn=config", "changetype: add", "objectClass: top", "objectClass: ds-cfg-virtual-attribute", "objectClass: ds-cfg-password-expiration-time-virtual-attribute", "cn: Password Expiration Time", "ds-cfg-java-class: org.opends.server.extensions.PasswordExpirationTimeVirtualAttributeProvider", "ds-cfg-enabled: true", "ds-cfg-attribute-type: ds-pwp-password-expiration-time", "ds-cfg-conflict-behavior: virtual-overrides-real"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_7979_SUMMARY.get(), "(ds-cfg-java-class=org.opends.server.schema.CertificateSyntax)", "add: objectClass", "objectClass: ds-cfg-certificate-attribute-syntax", "-", "add: ds-cfg-strict-format", "ds-cfg-strict-format: false"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8124_SUMMARY.get(), "(ds-cfg-java-class=org.opends.server.schema.JPEGSyntax)", "add: objectClass", "objectClass: ds-cfg-jpeg-attribute-syntax", "-", "add: ds-cfg-strict-format", "ds-cfg-strict-format: false"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8133_SUMMARY.get(), "(ds-cfg-java-class=org.opends.server.schema.CountryStringSyntax)", "add: objectClass", "objectClass: ds-cfg-country-string-attribute-syntax", "-", "add: ds-cfg-strict-format", "ds-cfg-strict-format: false"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntryOptional(ToolMessages.INFO_UPGRADE_TASK_8214_SUMMARY.get(), ToolMessages.INFO_UPGRADE_TASK_8214_DESCRIPTION.get(), "(ds-cfg-java-class=org.opends.server.extensions.IsMemberOfVirtualAttributeProvider)", "add: ds-cfg-filter", "ds-cfg-filter: (|(objectClass=person)(objectClass=groupOfNames)(objectClass=groupOfUniqueNames)(objectClass=groupOfEntries))", "-", "delete: ds-cfg-filter", "ds-cfg-filter: (objectClass=person)"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8387_SUMMARY.get(), "(objectClass=ds-cfg-dictionary-password-validator)", "add: ds-cfg-check-substrings", "ds-cfg-check-substrings: false"));
        Upgrade.register("2.5.0", UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8389_SUMMARY.get(), "(objectClass=ds-cfg-attribute-value-password-validator)", "add: ds-cfg-check-substrings", "ds-cfg-check-substrings: false"));
        Upgrade.register("2.5.0", UpgradeTasks.addConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8487_SUMMARY.get(), "dn: cn=PBKDF2,cn=Password Storage Schemes,cn=config", "changetype: add", "objectClass: top", "objectClass: ds-cfg-password-storage-scheme", "objectClass: ds-cfg-pbkdf2-password-storage-scheme", "cn: PBKDF2", "ds-cfg-java-class: org.opends.server.extensions.PBKDF2PasswordStorageScheme", "ds-cfg-enabled: true"));
        Upgrade.register("2.5.0", UpgradeTasks.addConfigFile("http-config.json"), UpgradeTasks.addConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8613_SUMMARY.get(), "dn: cn=HTTP Connection Handler,cn=Connection Handlers,cn=config", "changetype: add", "objectClass: ds-cfg-http-connection-handler", "objectClass: ds-cfg-connection-handler", "objectClass: top", "ds-cfg-listen-port: 8080", "cn: HTTP Connection Handler", "ds-cfg-max-blocked-write-time-limit: 2 minutes", "ds-cfg-ssl-client-auth-policy: optional", "ds-cfg-use-tcp-keep-alive: true", "ds-cfg-max-request-size: 5 megabytes", "ds-cfg-use-tcp-no-delay: true", "ds-cfg-allow-tcp-reuse-address: true", "ds-cfg-accept-backlog: 128", "ds-cfg-authentication-required: true", "ds-cfg-buffer-size: 4096 bytes", "ds-cfg-config-file: config/http-config.json", "ds-cfg-listen-address: 0.0.0.0", "ds-cfg-java-class: org.opends.server.protocols.http.HTTPConnectionHandler", "ds-cfg-keep-stats: true", "ds-cfg-ssl-cert-nickname: server-cert", "ds-cfg-use-ssl: false", "ds-cfg-enabled: false"));
        Upgrade.register("2.5.0", UpgradeTasks.addConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8832_SUMMARY.get(), "dn: cn=File-Based HTTP Access Logger,cn=Loggers,cn=config", "changetype: add", "objectClass: ds-cfg-file-based-http-access-log-publisher", "objectClass: top", "objectClass: ds-cfg-http-access-log-publisher", "objectClass: ds-cfg-log-publisher", "cn: File-Based HTTP Access Logger", "ds-cfg-java-class: org.opends.server.loggers.TextHTTPAccessLogPublisher", "ds-cfg-asynchronous: true", "ds-cfg-log-file: logs/http-access", "ds-cfg-rotation-policy: cn=24 Hours Time Limit Rotation Policy,cn=Log Rotation Policies,cn=config", "ds-cfg-rotation-policy: cn=Size Limit Rotation Policy,cn=Log Rotation Policies,cn=config", "ds-cfg-retention-policy: cn=File Count Retention Policy,cn=Log Retention Policies,cn=config", "ds-cfg-log-file-permissions: 640", "ds-cfg-enabled: false"));
        Upgrade.register("2.5.0", UpgradeTasks.newAttributeTypes(ToolMessages.INFO_UPGRADE_TASK_8985_1_SUMMARY.get(), "00-core.ldif", "emailAddress"), UpgradeTasks.modifyConfigEntry(ToolMessages.INFO_UPGRADE_TASK_8985_2_SUMMARY.get(), "&(ds-cfg-java-class=org.opends.server.extensions.SubjectAttributeToUserAttributeCertificateMapper)(ds-cfg-subject-attribute-mapping=e:mail)", "delete:ds-cfg-subject-attribute-mapping", "ds-cfg-subject-attribute-mapping: e:mail", "-", "add:ds-cfg-subject-attribute-mapping", "ds-cfg-subject-attribute-mapping: emailAddress:mail"));
        Upgrade.register("2.5.0", UpgradeTasks.regressionInVersion("2.5.0.7640", UpgradeTasks.rebuildSingleIndex(ToolMessages.INFO_UPGRADE_TASK_9013_DESCRIPTION.get(), "ds-sync-hist")));
        Upgrade.register("2.6.1", UpgradeTasks.copySchemaFile("03-pwpolicyextension.ldif"));
        Upgrade.register("2.6.1", UpgradeTasks.rerunJavaPropertiesTool(ToolMessages.INFO_UPGRADE_TASK_9216_SUMMARY.get()));
        Upgrade.registerLast(UpgradeTasks.copySchemaFile("02-config.ldif"), UpgradeTasks.updateConfigUpgradeFolder(), UpgradeTasks.postUpgradeRebuildIndexes());
    }
}

