/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum AcceptRejectWarn {
    ACCEPT("accept"),
    REJECT("reject"),
    WARN("warn");

    private String policyName;

    private AcceptRejectWarn(String policyName) {
        this.policyName = policyName;
    }

    public static AcceptRejectWarn policyForName(String policyName) {
        String lowerName = policyName.toLowerCase();
        if (lowerName.equals("accept") || lowerName.equals("allow")) {
            return ACCEPT;
        }
        if (lowerName.equals("reject") || lowerName.equals("deny")) {
            return REJECT;
        }
        if (lowerName.equals("warn")) {
            return WARN;
        }
        return null;
    }

    public String toString() {
        return this.policyName;
    }
}

