/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.CompressedSchema;
import org.opends.server.api.ProtocolElement;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SubentryManager;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValueIterable;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.CollectiveVirtualAttribute;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.EntryEncodeConfig;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LockManager;
import org.opends.server.types.Modification;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.types.SubEntry;
import org.opends.server.types.VirtualAttribute;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class Entry
implements ProtocolElement {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private Map<AttributeType, List<Attribute>> operationalAttributes;
    private Map<AttributeType, List<Attribute>> userAttributes;
    private final Map<AttributeType, List<Attribute>> suppressedAttributes = new LinkedHashMap<AttributeType, List<Attribute>>();
    private Map<ObjectClass, String> objectClasses;
    private Attribute objectClassAttribute;
    private DN dn;
    private transient Object attachment = null;
    private final Schema schema = DirectoryServer.getSchema();

    public Entry(DN dn, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        this.dn = dn == null ? DN.nullDN() : dn;
        this.objectClasses = objectClasses == null ? new HashMap<ObjectClass, String>() : objectClasses;
        this.userAttributes = userAttributes == null ? new HashMap<AttributeType, List<Attribute>>() : userAttributes;
        this.operationalAttributes = operationalAttributes == null ? new HashMap<AttributeType, List<Attribute>>() : operationalAttributes;
    }

    public DN getDN() {
        return this.dn;
    }

    public void setDN(DN dn) {
        this.dn = dn == null ? DN.nullDN() : dn;
        this.attachment = null;
    }

    public Map<ObjectClass, String> getObjectClasses() {
        return this.objectClasses;
    }

    public boolean hasObjectClass(ObjectClass objectClass) {
        return this.objectClasses.containsKey(objectClass);
    }

    public ObjectClass getStructuralObjectClass() {
        ObjectClass structuralClass = null;
        for (ObjectClass oc : this.objectClasses.keySet()) {
            if (oc.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
            if (structuralClass == null) {
                structuralClass = oc;
                continue;
            }
            if (!oc.isDescendantOf(structuralClass)) continue;
            structuralClass = oc;
        }
        return structuralClass;
    }

    public void setObjectClasses(Collection<AttributeValue> objectClassNames) throws DirectoryException {
        this.attachment = null;
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>();
        for (AttributeValue v : objectClassNames) {
            String lowerName;
            String name = v.getValue().toString();
            try {
                lowerName = v.getNormalizedValue().toString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                lowerName = StaticUtils.toLowerCase(v.getValue().toString());
            }
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName);
            if (oc == null) {
                Message message = CoreMessages.ERR_ENTRY_ADD_UNKNOWN_OC.get(name, String.valueOf(this.dn));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            ocMap.put(oc, name);
        }
        this.objectClasses = ocMap;
        this.objectClassAttribute = null;
    }

    public void addObjectClass(ObjectClass oc) throws DirectoryException {
        this.attachment = null;
        if (this.objectClasses.containsKey(oc)) {
            Message message = CoreMessages.ERR_ENTRY_ADD_DUPLICATE_OC.get(oc.getNameOrOID(), String.valueOf(this.dn));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        this.objectClasses.put(oc, oc.getNameOrOID());
    }

    public List<Attribute> getAttributes() {
        int size = this.userAttributes.size() + this.operationalAttributes.size();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(size);
        for (List<Attribute> list : this.userAttributes.values()) {
            for (Attribute a : list) {
                attributes.add(a);
            }
        }
        for (List<Attribute> list : this.operationalAttributes.values()) {
            for (Attribute a : list) {
                attributes.add(a);
            }
        }
        return attributes;
    }

    public Map<AttributeType, List<Attribute>> getUserAttributes() {
        return this.userAttributes;
    }

    public Map<AttributeType, List<Attribute>> getOperationalAttributes() {
        return this.operationalAttributes;
    }

    public Attribute getObjectClassAttribute() {
        if (this.objectClasses == null || this.objectClasses.isEmpty()) {
            return null;
        }
        if (this.objectClassAttribute == null) {
            AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
            AttributeBuilder builder = new AttributeBuilder(ocType, "objectClass");
            for (Map.Entry<ObjectClass, String> e : this.objectClasses.entrySet()) {
                builder.add(AttributeValues.create(ByteString.valueOf(e.getValue()), ByteString.valueOf(e.getKey().getNormalizedPrimaryName())));
            }
            this.objectClassAttribute = builder.toAttribute();
        }
        return this.objectClassAttribute;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.hasAttribute(attributeType, null, true);
    }

    public boolean hasAttribute(AttributeType attributeType, boolean includeSubordinates) {
        return this.hasAttribute(attributeType, null, includeSubordinates);
    }

    public boolean hasAttribute(AttributeType attributeType, Set<String> options) {
        return this.hasAttribute(attributeType, options, true);
    }

    public boolean hasAttribute(AttributeType attributeType, Set<String> options, boolean includeSubordinates) {
        if (attributeType.isObjectClassType()) {
            if (!this.objectClasses.isEmpty()) {
                return options == null || options.isEmpty();
            }
            return false;
        }
        if (!includeSubordinates) {
            Attribute attribute = this.getExactAttribute(attributeType, options);
            return attribute != null && !attribute.isEmpty();
        }
        List<Attribute> attributes = attributeType.isOperational() ? this.operationalAttributes.get(attributeType) : this.userAttributes.get(attributeType);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (attribute.isEmpty() || !attribute.hasAllOptions(options)) continue;
                return true;
            }
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType subType : this.schema.getSubTypes(attributeType)) {
                attributes = subType.isOperational() ? this.operationalAttributes.get(subType) : this.userAttributes.get(subType);
                if (attributes == null) continue;
                for (Attribute attribute : attributes) {
                    if (attribute.isEmpty() || !attribute.hasAllOptions(options)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public List<Attribute> getAttribute(AttributeType attributeType) {
        return this.getAttribute(attributeType, true);
    }

    public List<Attribute> getAttribute(AttributeType attributeType, boolean includeSubordinates) {
        if (includeSubordinates && attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            if ((attrs = this.operationalAttributes.get(attributeType)) != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs != null) {
                    attributes.addAll(attrs);
                }
                if ((attrs = this.operationalAttributes.get(at)) == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        List<Attribute> attributes = this.userAttributes.get(attributeType);
        if (attributes == null) {
            attributes = this.operationalAttributes.get(attributeType);
            if (attributes == null) {
                if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty()) {
                    attributes = new ArrayList<Attribute>(1);
                    attributes.add(this.getObjectClassAttribute());
                    return attributes;
                }
                return null;
            }
            return attributes;
        }
        return attributes;
    }

    public List<Attribute> getAttribute(String lowerName) {
        for (AttributeType attr : this.userAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, true);
        }
        for (AttributeType attr : this.operationalAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, true);
        }
        if (lowerName.equals("objectclass") && !this.objectClasses.isEmpty()) {
            LinkedList<Attribute> attrList = new LinkedList<Attribute>();
            attrList.add(this.getObjectClassAttribute());
            return attrList;
        }
        return null;
    }

    public List<Attribute> getAttribute(AttributeType attributeType, Set<String> options) {
        return this.getAttribute(attributeType, true, options);
    }

    public List<Attribute> getAttribute(AttributeType attributeType, boolean includeSubordinates, Set<String> options) {
        List<Attribute> attrs;
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        if (includeSubordinates && attributeType.mayHaveSubordinateTypes()) {
            attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            if ((attrs = this.operationalAttributes.get(attributeType)) != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs != null) {
                    attributes.addAll(attrs);
                }
                if ((attrs = this.operationalAttributes.get(at)) == null) continue;
                attributes.addAll(attrs);
            }
        } else {
            attrs = this.userAttributes.get(attributeType);
            if (attrs == null) {
                attrs = this.operationalAttributes.get(attributeType);
                if (attrs == null) {
                    if (attributeType.isObjectClassType() && !this.objectClasses.isEmpty() && (options == null || options.isEmpty())) {
                        attributes.add(this.getObjectClassAttribute());
                        return attributes;
                    }
                    return null;
                }
                attributes.addAll(attrs);
            } else {
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasAllOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public List<Attribute> getAttribute(String lowerName, Set<String> options) {
        for (AttributeType attr : this.userAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, options);
        }
        for (AttributeType attr : this.operationalAttributes.keySet()) {
            if (!attr.hasNameOrOID(lowerName)) continue;
            return this.getAttribute(attr, options);
        }
        if (lowerName.equals("objectclass") && (options == null || options.isEmpty())) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            attributes.add(this.getObjectClassAttribute());
            return attributes;
        }
        return null;
    }

    public final <T> T getAttributeValue(AttributeType attributeType, AttributeValueDecoder<T> decoder) throws DirectoryException {
        List<Attribute> attributes = this.getAttribute(attributeType, true);
        AttributeValueIterable values = new AttributeValueIterable(attributes);
        Iterator<AttributeValue> iterator = values.iterator();
        if (iterator.hasNext()) {
            return decoder.decode(iterator.next());
        }
        return null;
    }

    public final <T> Collection<T> getAttributeValues(AttributeType attributeType, AttributeValueDecoder<? extends T> decoder, Collection<T> collection) throws DirectoryException {
        List<Attribute> attributes = this.getAttribute(attributeType, true);
        AttributeValueIterable values = new AttributeValueIterable(attributes);
        for (AttributeValue value : values) {
            collection.add(decoder.decode(value));
        }
        return collection;
    }

    public boolean hasUserAttribute(AttributeType attributeType) {
        if (this.userAttributes.containsKey(attributeType)) {
            return true;
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                if (!this.userAttributes.containsKey(at)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType) {
        if (attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.userAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        return this.userAttributes.get(attributeType);
    }

    public List<Attribute> getUserAttribute(AttributeType attributeType, Set<String> options) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.userAttributes.get(attributeType);
        if (attrs != null) {
            attributes.addAll(attrs);
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.userAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasAllOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public boolean hasOperationalAttribute(AttributeType attributeType) {
        if (this.operationalAttributes.containsKey(attributeType)) {
            return true;
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                if (!this.operationalAttributes.containsKey(at)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType) {
        if (attributeType.mayHaveSubordinateTypes()) {
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            List<Attribute> attrs = this.operationalAttributes.get(attributeType);
            if (attrs != null) {
                attributes.addAll(attrs);
            }
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.operationalAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
            if (attributes.isEmpty()) {
                return null;
            }
            return attributes;
        }
        return this.operationalAttributes.get(attributeType);
    }

    public List<Attribute> getOperationalAttribute(AttributeType attributeType, Set<String> options) {
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        List<Attribute> attrs = this.operationalAttributes.get(attributeType);
        if (attrs != null) {
            attributes.addAll(attrs);
        }
        if (attributeType.mayHaveSubordinateTypes()) {
            for (AttributeType at : this.schema.getSubTypes(attributeType)) {
                attrs = this.operationalAttributes.get(at);
                if (attrs == null) continue;
                attributes.addAll(attrs);
            }
        }
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            if (a.hasAllOptions(options)) continue;
            iterator.remove();
        }
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public void putAttribute(AttributeType attributeType, List<Attribute> attributeList) {
        this.attachment = null;
        List<Attribute> attrList = this.userAttributes.get(attributeType);
        if (attrList != null) {
            this.userAttributes.put(attributeType, attributeList);
            return;
        }
        attrList = this.operationalAttributes.get(attributeType);
        if (attrList != null) {
            this.operationalAttributes.put(attributeType, attributeList);
            return;
        }
        if (attributeType.isOperational()) {
            this.operationalAttributes.put(attributeType, attributeList);
        } else {
            this.userAttributes.put(attributeType, attributeList);
        }
    }

    public void addAttribute(Attribute attribute, List<AttributeValue> duplicateValues) {
        this.setAttribute(attribute, duplicateValues, false);
    }

    public void replaceAttribute(Attribute attribute) {
        this.setAttribute(attribute, null, true);
    }

    public void incrementAttribute(Attribute attribute) throws DirectoryException {
        long increment;
        AttributeType attributeType = attribute.getAttributeType();
        Attribute a = this.getExactAttribute(attributeType, attribute.getOptions());
        if (a == null) {
            Message message = CoreMessages.ERR_ENTRY_INCREMENT_NO_SUCH_ATTRIBUTE.get(attribute.getName());
            throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
        }
        Iterator<AttributeValue> i = attribute.iterator();
        if (!i.hasNext()) {
            Message message = CoreMessages.ERR_ENTRY_INCREMENT_INVALID_VALUE_COUNT.get(attribute.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        String incrementValue = i.next().getValue().toString();
        try {
            increment = Long.parseLong(incrementValue);
        }
        catch (NumberFormatException e) {
            Message message = CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get(attribute.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (i.hasNext()) {
            Message message = CoreMessages.ERR_ENTRY_INCREMENT_INVALID_VALUE_COUNT.get(attribute.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        AttributeBuilder builder = new AttributeBuilder(a, true);
        for (AttributeValue v : a) {
            long currentValue;
            String s = v.getValue().toString();
            try {
                currentValue = Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                Message message = CoreMessages.ERR_ENTRY_INCREMENT_CANNOT_PARSE_AS_INT.get(attribute.getName());
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            long newValue = currentValue + increment;
            builder.add(AttributeValues.create(attributeType, String.valueOf(newValue)));
        }
        this.replaceAttribute(builder.toAttribute());
    }

    public boolean removeAttribute(AttributeType attributeType) {
        this.attachment = null;
        if (attributeType.isObjectClassType()) {
            this.objectClasses.clear();
            return true;
        }
        return this.userAttributes.remove(attributeType) != null || this.operationalAttributes.remove(attributeType) != null;
    }

    public boolean removeAttribute(Attribute attribute, List<AttributeValue> missingValues) {
        this.attachment = null;
        if (attribute.getAttributeType().isObjectClassType()) {
            if (attribute.isEmpty()) {
                this.objectClasses.clear();
                return true;
            }
            boolean allSuccessful = true;
            for (AttributeValue v : attribute) {
                String ocName;
                try {
                    ocName = v.getNormalizedValue().toString();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    ocName = StaticUtils.toLowerCase(v.getValue().toString());
                }
                boolean matchFound = false;
                for (ObjectClass oc : this.objectClasses.keySet()) {
                    if (!oc.hasNameOrOID(ocName)) continue;
                    matchFound = true;
                    this.objectClasses.remove(oc);
                    break;
                }
                if (matchFound) continue;
                allSuccessful = false;
                missingValues.add(v);
            }
            return allSuccessful;
        }
        AttributeType attributeType = attribute.getAttributeType();
        List<Attribute> attributes = attributeType.isOperational() ? this.operationalAttributes.get(attributeType) : this.userAttributes.get(attributeType);
        if (attributes == null) {
            for (AttributeValue v : attribute) {
                missingValues.add(v);
            }
            return false;
        }
        Set<String> options = attribute.getOptions();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = attributes.get(i);
            if (!a.optionsEqual(options)) continue;
            if (attribute.isEmpty()) {
                attributes.remove(i);
            } else {
                AttributeBuilder builder = new AttributeBuilder(a);
                for (AttributeValue v : attribute) {
                    if (builder.remove(v)) continue;
                    missingValues.add(v);
                }
                if (!builder.isEmpty()) {
                    attributes.set(i, builder.toAttribute());
                } else {
                    attributes.remove(i);
                }
            }
            if (attributes.isEmpty()) {
                if (attributeType.isOperational()) {
                    this.operationalAttributes.remove(attributeType);
                } else {
                    this.userAttributes.remove(attributeType);
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasValue(AttributeType attributeType, Set<String> options, AttributeValue value) {
        List<Attribute> attrList = this.getAttribute(attributeType, true);
        if (attrList == null || attrList.isEmpty()) {
            return false;
        }
        for (Attribute a : attrList) {
            if (!a.optionsEqual(options) || !a.contains(value)) continue;
            return true;
        }
        return false;
    }

    public void applyModification(Modification mod, boolean relaxConstraints) throws DirectoryException {
        Attribute a = mod.getAttribute();
        AttributeType t = a.getAttributeType();
        if (t.isObjectClassType()) {
            LinkedHashMap<ObjectClass, String> ocs = new LinkedHashMap<ObjectClass, String>();
            for (AttributeValue v : a) {
                String ocName = v.getValue().toString();
                String lowerName = StaticUtils.toLowerCase(ocName);
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                ocs.put(oc, ocName);
            }
            switch (mod.getModificationType()) {
                case ADD: {
                    Message message;
                    for (ObjectClass oc : ocs.keySet()) {
                        if (this.objectClasses.containsKey(oc)) {
                            if (relaxConstraints) continue;
                            message = CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get(a.getName());
                            throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message);
                        }
                        this.objectClasses.put(oc, ocs.get(oc));
                    }
                    this.objectClassAttribute = null;
                    break;
                }
                case DELETE: {
                    Message message;
                    for (ObjectClass oc : ocs.keySet()) {
                        if (this.objectClasses.remove(oc) != null || relaxConstraints) continue;
                        message = CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get(a.getName());
                        throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
                    }
                    this.objectClassAttribute = null;
                    break;
                }
                case REPLACE: {
                    this.objectClasses = ocs;
                    this.objectClassAttribute = null;
                    break;
                }
                case INCREMENT: {
                    Message message = CoreMessages.ERR_ENTRY_OC_INCREMENT_NOT_SUPPORTED.get();
                    throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                }
                default: {
                    Message message = CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get(String.valueOf((Object)mod.getModificationType()));
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
                }
            }
            return;
        }
        switch (mod.getModificationType()) {
            case ADD: {
                LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
                this.addAttribute(a, duplicateValues);
                if (duplicateValues.isEmpty() || relaxConstraints) break;
                Message message = CoreMessages.ERR_ENTRY_DUPLICATE_VALUES.get(a.getName());
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message);
            }
            case DELETE: {
                LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
                this.removeAttribute(a, missingValues);
                if (missingValues.isEmpty() || relaxConstraints) break;
                Message message = CoreMessages.ERR_ENTRY_NO_SUCH_VALUE.get(a.getName());
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
            }
            case REPLACE: {
                this.replaceAttribute(a);
                break;
            }
            case INCREMENT: {
                this.incrementAttribute(a);
                break;
            }
            default: {
                Message message = CoreMessages.ERR_ENTRY_UNKNOWN_MODIFICATION_TYPE.get(String.valueOf((Object)mod.getModificationType()));
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
        }
    }

    public void applyModification(Modification mod) throws DirectoryException {
        this.applyModification(mod, false);
    }

    public void applyModifications(List<Modification> mods) throws DirectoryException {
        for (Modification m : mods) {
            this.applyModification(m);
        }
    }

    public boolean conformsToSchema(Entry parentEntry, boolean parentProvided, boolean validateNameForms, boolean validateStructureRules, MessageBuilder invalidReason) {
        AcceptRejectWarn structuralPolicy = DirectoryServer.getSingleStructuralObjectClassPolicy();
        ObjectClass structuralClass = null;
        boolean multipleOCErrorLogged = false;
        for (ObjectClass oc : this.objectClasses.keySet()) {
            if (oc.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
            if (structuralClass == null || oc.isDescendantOf(structuralClass)) {
                structuralClass = oc;
                continue;
            }
            if (structuralClass.isDescendantOf(oc)) continue;
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get(String.valueOf(this.dn), structuralClass.getNameOrOID(), oc.getNameOrOID());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN || multipleOCErrorLogged) continue;
            ErrorLogger.logError(message);
            multipleOCErrorLogged = true;
        }
        NameForm nameForm = null;
        DITContentRule ditContentRule = null;
        DITStructureRule ditStructureRule = null;
        if (structuralClass == null) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get(String.valueOf(this.dn));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message);
            }
        } else {
            ditContentRule = DirectoryServer.getDITContentRule(structuralClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
            if (!this.checkAttributesAndObjectClasses(ditContentRule, structuralPolicy, invalidReason)) {
                return false;
            }
            if (validateNameForms) {
                List<NameForm> listForms = DirectoryServer.getNameForm(structuralClass);
                if (listForms != null) {
                    boolean matchFound = false;
                    boolean obsolete = true;
                    for (int index = 0; index < listForms.size(); ++index) {
                        NameForm nf = listForms.get(index);
                        if (nf.isObsolete()) continue;
                        obsolete = false;
                        matchFound = this.checkNameForm(nf, structuralPolicy, invalidReason);
                        if (matchFound) {
                            nameForm = nf;
                            break;
                        }
                        if (index == listForms.size() - 1) continue;
                        invalidReason.append(",");
                    }
                    if (!obsolete && !matchFound) {
                        return false;
                    }
                }
                if (validateStructureRules && nameForm != null && (ditStructureRule = DirectoryServer.getDITStructureRule(nameForm)) != null && ditStructureRule.isObsolete()) {
                    ditStructureRule = null;
                }
            }
        }
        if (ditContentRule != null && !this.checkDITContentRule(ditContentRule, structuralPolicy, invalidReason)) {
            return false;
        }
        return this.checkDITStructureRule(ditStructureRule, structuralClass, parentEntry, parentProvided, validateStructureRules, structuralPolicy, invalidReason);
    }

    private boolean checkAttributesAndObjectClasses(DITContentRule ditContentRule, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        for (ObjectClass o : this.objectClasses.keySet()) {
            Message message;
            if (DirectoryServer.getObjectClass(o.getOID()) == null) {
                message = CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OC.get(String.valueOf(this.dn), o.getNameOrOID());
                invalidReason.append(message);
                return false;
            }
            if (o.getObjectClassType() == ObjectClassType.AUXILIARY && ditContentRule != null && !ditContentRule.getAuxiliaryClasses().contains(o)) {
                message = CoreMessages.ERR_ENTRY_SCHEMA_DISALLOWED_AUXILIARY_CLASS.get(String.valueOf(this.dn), o.getNameOrOID(), ditContentRule.getName());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy == AcceptRejectWarn.WARN) {
                    ErrorLogger.logError(message);
                }
            }
            for (AttributeType t : o.getRequiredAttributes()) {
                if (this.userAttributes.containsKey(t) || this.operationalAttributes.containsKey(t) || t.isObjectClassType()) continue;
                Message message2 = CoreMessages.ERR_ENTRY_SCHEMA_MISSING_REQUIRED_ATTR_FOR_OC.get(String.valueOf(this.dn), t.getNameOrOID(), o.getNameOrOID());
                invalidReason.append(message2);
                return false;
            }
        }
        for (AttributeType t : this.userAttributes.keySet()) {
            boolean found = false;
            for (ObjectClass o : this.objectClasses.keySet()) {
                if (!o.isRequiredOrOptional(t)) continue;
                found = true;
                break;
            }
            if (!found && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                found = true;
            }
            if (!found) {
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_DISALLOWED_USER_ATTR_FOR_OC.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message);
                return false;
            }
            List<Attribute> attrList = this.userAttributes.get(t);
            if (attrList == null) continue;
            for (Attribute a : attrList) {
                if (a.isEmpty()) {
                    Message message = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_NO_VALUES.get(String.valueOf(this.dn), t.getNameOrOID());
                    invalidReason.append(message);
                    return false;
                }
                if (!t.isSingleValue() || a.size() == 1) continue;
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_SINGLE_VALUED.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message);
                return false;
            }
        }
        for (AttributeType t : this.operationalAttributes.keySet()) {
            List<Attribute> attrList;
            if (!t.isSingleValue() || (attrList = this.operationalAttributes.get(t)) == null) continue;
            for (Attribute a : attrList) {
                if (a.size() <= 1) continue;
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_ATTR_SINGLE_VALUED.get(String.valueOf(this.dn), t.getNameOrOID());
                invalidReason.append(message);
                return false;
            }
        }
        return true;
    }

    private boolean checkNameForm(NameForm nameForm, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        RDN rdn = this.dn.getRDN();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.hasAttributeType(t)) continue;
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_RDN_MISSING_REQUIRED_ATTR.get(String.valueOf(this.dn), t.getNameOrOID(), nameForm.getNameOrOID());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message);
            }
            int numAVAs = rdn.getNumValues();
            for (int i = 0; i < numAVAs; ++i) {
                AttributeType t = rdn.getAttributeType(i);
                if (nameForm.isRequiredOrOptional(t)) continue;
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_RDN_DISALLOWED_ATTR.get(String.valueOf(this.dn), t.getNameOrOID(), nameForm.getNameOrOID());
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message);
            }
        }
        return true;
    }

    private boolean checkDITContentRule(DITContentRule ditContentRule, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        Message message;
        for (AttributeType t : ditContentRule.getRequiredAttributes()) {
            if (this.userAttributes.containsKey(t) || this.operationalAttributes.containsKey(t) || t.isObjectClassType()) continue;
            message = CoreMessages.ERR_ENTRY_SCHEMA_MISSING_REQUIRED_ATTR_FOR_DCR.get(String.valueOf(this.dn), t.getNameOrOID(), ditContentRule.getName());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN) continue;
            ErrorLogger.logError(message);
        }
        for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
            if (!this.userAttributes.containsKey(t) && !this.operationalAttributes.containsKey(t)) continue;
            message = CoreMessages.ERR_ENTRY_SCHEMA_PROHIBITED_ATTR_FOR_DCR.get(String.valueOf(this.dn), t.getNameOrOID(), ditContentRule.getName());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN) continue;
            ErrorLogger.logError(message);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkDITStructureRule(DITStructureRule ditStructureRule, ObjectClass structuralClass, Entry parentEntry, boolean parentProvided, boolean validateStructureRules, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        DN parentDN;
        if (ditStructureRule != null && ditStructureRule.hasSuperiorRules()) {
            if (parentProvided) {
                boolean dsrValid;
                if (parentEntry == null || (dsrValid = this.validateDITStructureRule(ditStructureRule, structuralClass, parentEntry, structuralPolicy, invalidReason))) return true;
                return false;
            }
            DN parentDN2 = this.dn.getParentDNInSuffix();
            if (parentDN2 == null) return true;
            Lock lock = LockManager.lockRead(parentDN2);
            if (lock == null) {
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_COULD_NOT_LOCK_PARENT.get(String.valueOf(this.dn), String.valueOf(parentDN2));
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                ErrorLogger.logError(message);
                return true;
            } else {
                try {
                    parentEntry = DirectoryServer.getEntry(parentDN2);
                    if (parentEntry == null) {
                        Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_ENTRY.get(String.valueOf(this.dn), String.valueOf(parentDN2));
                        if (structuralPolicy == AcceptRejectWarn.REJECT) {
                            invalidReason.append(message);
                            boolean bl = false;
                            return bl;
                        }
                        if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                        ErrorLogger.logError(message);
                        return true;
                    }
                    boolean dsrValid = this.validateDITStructureRule(ditStructureRule, structuralClass, parentEntry, structuralPolicy, invalidReason);
                    if (dsrValid) return true;
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = CoreMessages.ERR_ENTRY_SCHEMA_COULD_NOT_CHECK_DSR.get(String.valueOf(this.dn), ditStructureRule.getNameOrRuleID(), StaticUtils.getExceptionMessage(e));
                    if (structuralPolicy == AcceptRejectWarn.REJECT) {
                        invalidReason.append(message);
                        boolean bl = false;
                        return bl;
                    }
                    if (structuralPolicy != AcceptRejectWarn.WARN) return true;
                    ErrorLogger.logError(message);
                    return true;
                }
                finally {
                    LockManager.unlock(parentDN2, lock);
                }
            }
        }
        if (!validateStructureRules) return true;
        boolean parentExists = false;
        ObjectClass parentStructuralClass = null;
        if (parentEntry != null) {
            parentExists = true;
            parentStructuralClass = parentEntry.getStructuralObjectClass();
        } else if (!parentProvided && (parentDN = this.getDN().getParentDNInSuffix()) != null) {
            Message message;
            Lock lock = LockManager.lockRead(parentDN);
            if (lock == null) {
                message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_COULD_NOT_LOCK_PARENT.get(String.valueOf(this.dn), String.valueOf(parentDN));
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy == AcceptRejectWarn.WARN) {
                    ErrorLogger.logError(message);
                }
            } else {
                try {
                    parentEntry = DirectoryServer.getEntry(parentDN);
                    if (parentEntry == null) {
                        message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_ENTRY.get(String.valueOf(this.dn), String.valueOf(parentDN));
                        if (structuralPolicy == AcceptRejectWarn.REJECT) {
                            invalidReason.append(message);
                            boolean bl = false;
                            return bl;
                        }
                        if (structuralPolicy == AcceptRejectWarn.WARN) {
                            ErrorLogger.logError(message);
                        }
                    } else {
                        parentExists = true;
                        parentStructuralClass = parentEntry.getStructuralObjectClass();
                    }
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message2 = CoreMessages.ERR_ENTRY_SCHEMA_COULD_NOT_CHECK_PARENT_DSR.get(String.valueOf(this.dn), StaticUtils.getExceptionMessage(e));
                    if (structuralPolicy == AcceptRejectWarn.REJECT) {
                        invalidReason.append(message2);
                        boolean bl = false;
                        return bl;
                    }
                    if (structuralPolicy == AcceptRejectWarn.WARN) {
                        ErrorLogger.logError(message2);
                    }
                }
                finally {
                    LockManager.unlock(parentDN, lock);
                }
            }
        }
        if (!parentExists) return true;
        if (parentStructuralClass == null) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy != AcceptRejectWarn.WARN) return true;
            ErrorLogger.logError(message);
            return true;
        } else {
            List<NameForm> allNFs = DirectoryServer.getNameForm(parentStructuralClass);
            if (allNFs == null) return true;
            for (NameForm parentNF : allNFs) {
                DITStructureRule parentDSR;
                if (parentNF == null || parentNF.isObsolete() || (parentDSR = DirectoryServer.getDITStructureRule(parentNF)) == null || parentDSR.isObsolete()) continue;
                Message message = CoreMessages.ERR_ENTRY_SCHEMA_VIOLATES_PARENT_DSR.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
                if (structuralPolicy == AcceptRejectWarn.REJECT) {
                    invalidReason.append(message);
                    return false;
                }
                if (structuralPolicy != AcceptRejectWarn.WARN) continue;
                ErrorLogger.logError(message);
            }
        }
        return true;
    }

    private boolean validateDITStructureRule(DITStructureRule dsr, ObjectClass structuralClass, Entry parentEntry, AcceptRejectWarn structuralPolicy, MessageBuilder invalidReason) {
        ObjectClass oc = parentEntry.getStructuralObjectClass();
        if (oc == null) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get(String.valueOf(this.dn), String.valueOf(parentEntry.getDN()));
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message);
            }
        }
        boolean matchFound = false;
        for (DITStructureRule dsr2 : dsr.getSuperiorRules()) {
            if (!dsr2.getStructuralClass().equals(oc)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            Message message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_DISALLOWED_SUPERIOR_OC.get(String.valueOf(this.dn), dsr.getNameOrRuleID(), structuralClass.getNameOrOID(), oc.getNameOrOID());
            if (structuralPolicy == AcceptRejectWarn.REJECT) {
                invalidReason.append(message);
                return false;
            }
            if (structuralPolicy == AcceptRejectWarn.WARN) {
                ErrorLogger.logError(message);
            }
        }
        return true;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Entry duplicate(boolean processVirtual) {
        HashMap<ObjectClass, String> objectClassesCopy = new HashMap<ObjectClass, String>(this.objectClasses);
        HashMap<AttributeType, List<Attribute>> userAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
        this.deepCopy(this.userAttributes, userAttrsCopy, false, false, false, true, false);
        HashMap<AttributeType, List<Attribute>> operationalAttrsCopy = new HashMap<AttributeType, List<Attribute>>(this.operationalAttributes.size());
        this.deepCopy(this.operationalAttributes, operationalAttrsCopy, false, false, false, true, false);
        for (AttributeType t : this.suppressedAttributes.keySet()) {
            List<Attribute> attrList = this.suppressedAttributes.get(t);
            if (t.isOperational()) {
                operationalAttrsCopy.put(t, attrList);
                continue;
            }
            userAttrsCopy.put(t, attrList);
        }
        Entry e = new Entry(this.dn, objectClassesCopy, userAttrsCopy, operationalAttrsCopy);
        if (processVirtual) {
            e.processVirtualAttributes();
        }
        return e;
    }

    private void deepCopy(Map<AttributeType, List<Attribute>> source, Map<AttributeType, List<Attribute>> target, boolean omitValues, boolean omitEmpty, boolean omitReal, boolean omitVirtual, boolean mergeDuplicates) {
        for (Map.Entry<AttributeType, List<Attribute>> mapEntry : source.entrySet()) {
            AttributeType t = mapEntry.getKey();
            List<Attribute> sourceList = mapEntry.getValue();
            ArrayList<Attribute> targetList = new ArrayList<Attribute>(sourceList.size());
            for (Attribute a : sourceList) {
                if (omitReal && !a.isVirtual() || omitVirtual && a.isVirtual() || omitEmpty && a.isEmpty()) continue;
                if (omitValues) {
                    a = Attributes.empty(a);
                }
                if (!targetList.isEmpty() && mergeDuplicates) {
                    boolean found = false;
                    for (int i = 0; i < targetList.size(); ++i) {
                        Attribute otherAttribute = (Attribute)targetList.get(i);
                        if (!otherAttribute.optionsEqual(a.getOptions())) continue;
                        targetList.set(i, Attributes.merge(a, otherAttribute));
                        found = true;
                    }
                    if (found) continue;
                    targetList.add(a);
                    continue;
                }
                targetList.add(a);
            }
            if (targetList.isEmpty()) continue;
            target.put(t, targetList);
        }
    }

    public boolean isReferral() {
        ObjectClass referralOC = DirectoryServer.getObjectClass("referral");
        if (referralOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "referral");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("referral")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(referralOC)) {
            return false;
        }
        AttributeType referralType = DirectoryServer.getAttributeType("ref");
        if (referralType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "ref");
            }
            return false;
        }
        return this.userAttributes.containsKey(referralType) || this.operationalAttributes.containsKey(referralType);
    }

    public LinkedHashSet<String> getReferralURLs() {
        AttributeType referralType = DirectoryServer.getAttributeType("ref");
        if (referralType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "ref");
            }
            return null;
        }
        List<Attribute> refAttrs = this.userAttributes.get(referralType);
        if (refAttrs == null && (refAttrs = this.operationalAttributes.get(referralType)) == null) {
            return null;
        }
        LinkedHashSet<String> referralURLs = new LinkedHashSet<String>();
        for (Attribute a : refAttrs) {
            for (AttributeValue v : a) {
                referralURLs.add(v.getValue().toString());
            }
        }
        return referralURLs;
    }

    public boolean isAlias() {
        ObjectClass aliasOC = DirectoryServer.getObjectClass("alias");
        if (aliasOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "alias");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("alias")) continue;
                return true;
            }
            return false;
        }
        if (!this.objectClasses.containsKey(aliasOC)) {
            return false;
        }
        AttributeType aliasType = DirectoryServer.getAttributeType("aliasedobjectname");
        if (aliasType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "aliasedobjectname");
            }
            return false;
        }
        return this.userAttributes.containsKey(aliasType) || this.operationalAttributes.containsKey(aliasType);
    }

    public DN getAliasedDN() throws DirectoryException {
        AttributeType aliasType = DirectoryServer.getAttributeType("ref");
        if (aliasType == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s attribute type is defined in the server schema.", "aliasedobjectname");
            }
            return null;
        }
        List<Attribute> aliasAttrs = this.userAttributes.get(aliasType);
        if (aliasAttrs == null && (aliasAttrs = this.operationalAttributes.get(aliasType)) == null) {
            return null;
        }
        if (aliasAttrs.isEmpty()) {
            return null;
        }
        Attribute aliasAttr = aliasAttrs.get(0);
        if (aliasAttr.isEmpty()) {
            return null;
        }
        return DN.decode(aliasAttr.iterator().next().getValue().toString());
    }

    public boolean isLDAPSubentry() {
        ObjectClass ldapSubentryOC = DirectoryServer.getObjectClass("ldapsubentry");
        if (ldapSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "ldapSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("ldapSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(ldapSubentryOC);
    }

    public boolean isSubentry() {
        ObjectClass subentryOC = DirectoryServer.getObjectClass("subentry");
        if (subentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "subentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("subentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(subentryOC);
    }

    public boolean isCollectiveAttributeSubentry() {
        ObjectClass collectiveAttributeSubentryOC = DirectoryServer.getObjectClass("collectiveattributesubentry");
        if (collectiveAttributeSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "collectiveAttributeSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("collectiveAttributeSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(collectiveAttributeSubentryOC);
    }

    public boolean isInheritedCollectiveAttributeSubentry() {
        ObjectClass inheritedCollectiveAttributeSubentryOC = DirectoryServer.getObjectClass("inheritedcollectiveattributesubentry");
        if (inheritedCollectiveAttributeSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "inheritedCollectiveAttributeSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("inheritedCollectiveAttributeSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(inheritedCollectiveAttributeSubentryOC);
    }

    public boolean isInheritedFromDNCollectiveAttributeSubentry() {
        ObjectClass inheritedFromDNCollectiveAttributeSubentryOC = DirectoryServer.getObjectClass("inheritedfromdncollectiveattributesubentry");
        if (inheritedFromDNCollectiveAttributeSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "inheritedFromDNCollectiveAttributeSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("inheritedFromDNCollectiveAttributeSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(inheritedFromDNCollectiveAttributeSubentryOC);
    }

    public boolean isInheritedFromRDNCollectiveAttributeSubentry() {
        ObjectClass inheritedFromRDNCollectiveAttributeSubentryOC = DirectoryServer.getObjectClass("inheritedfromrdncollectiveattributesubentry");
        if (inheritedFromRDNCollectiveAttributeSubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "inheritedFromRDNCollectiveAttributeSubentry");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("inheritedFromRDNCollectiveAttributeSubentry")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(inheritedFromRDNCollectiveAttributeSubentryOC);
    }

    public boolean isPasswordPolicySubentry() {
        ObjectClass passwordPolicySubentryOC = DirectoryServer.getObjectClass("pwdpolicy");
        if (passwordPolicySubentryOC == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("No %s objectclass is defined in the server schema.", "pwdPolicy");
            }
            for (String ocName : this.objectClasses.values()) {
                if (!ocName.equalsIgnoreCase("pwdPolicy")) continue;
                return true;
            }
            return false;
        }
        return this.objectClasses.containsKey(passwordPolicySubentryOC);
    }

    public boolean matchesBaseAndScope(DN baseDN, SearchScope scope) {
        return this.dn.matchesBaseAndScope(baseDN, scope);
    }

    private void processCollectiveAttributes() {
        if (this.isSubentry() || this.isLDAPSubentry()) {
            return;
        }
        SubentryManager manager = DirectoryServer.getSubentryManager();
        if (manager == null) {
            return;
        }
        List<SubEntry> collectiveAttrSubentries = manager.getCollectiveSubentries(this);
        if (collectiveAttrSubentries == null || collectiveAttrSubentries.isEmpty()) {
            return;
        }
        AttributeType exclusionsType = DirectoryServer.getAttributeType("collectiveexclusions");
        List<Attribute> exclusionsAttrList = this.operationalAttributes.get(exclusionsType);
        HashSet<String> exclusionsNameSet = new HashSet<String>();
        if (exclusionsAttrList != null && !exclusionsAttrList.isEmpty()) {
            for (Attribute attr : exclusionsAttrList) {
                for (AttributeValue attrValue : attr) {
                    String exclusionsName = attrValue.toString().toLowerCase();
                    if (exclusionsName.equals("excludeallcollectiveattributes") || exclusionsName.equals("2.5.18.0")) {
                        return;
                    }
                    exclusionsNameSet.add(exclusionsName);
                }
            }
        }
        for (SubEntry subEntry : collectiveAttrSubentries) {
            Entry inheritFromEntry;
            block23: {
                if (!subEntry.isCollective() && !subEntry.isInheritedCollective()) continue;
                inheritFromEntry = null;
                if (subEntry.isInheritedCollective()) {
                    AttributeValue value;
                    Iterator<AttributeValue> i$;
                    DN inheritFromDN;
                    if (subEntry.isInheritedFromDNCollective() && this.hasAttribute(subEntry.getInheritFromDNType())) {
                        try {
                            inheritFromDN = null;
                            for (Attribute attr : this.getAttribute(subEntry.getInheritFromDNType())) {
                                i$ = attr.iterator();
                                if (!i$.hasNext() || (inheritFromDN = DN.decode((value = i$.next()).getNormalizedValue())).isDescendantOf(subEntry.getDN().getParent())) continue;
                                inheritFromDN = null;
                            }
                            if (inheritFromDN == null) continue;
                            inheritFromEntry = DirectoryServer.getEntry(inheritFromDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            break block23;
                        }
                    }
                    if (subEntry.isInheritedFromRDNCollective() && this.hasAttribute(subEntry.getInheritFromRDNAttrType())) {
                        inheritFromDN = subEntry.getInheritFromBaseDN();
                        if (inheritFromDN == null) continue;
                        try {
                            for (Attribute attr : this.getAttribute(subEntry.getInheritFromRDNAttrType())) {
                                inheritFromDN = subEntry.getInheritFromBaseDN();
                                i$ = attr.iterator();
                                if (!i$.hasNext()) continue;
                                value = i$.next();
                                inheritFromDN = inheritFromDN.concat(RDN.create(subEntry.getInheritFromRDNType(), value));
                            }
                            inheritFromEntry = DirectoryServer.getEntry(inheritFromDN);
                        }
                        catch (DirectoryException de) {
                            if (!DebugLogger.debugEnabled()) break block23;
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                    }
                }
            }
            List<Attribute> collectiveAttrList = subEntry.getCollectiveAttributes();
            for (Attribute collectiveAttr : collectiveAttrList) {
                List<Attribute> attrList;
                AttributeType attributeType = collectiveAttr.getAttributeType();
                if (exclusionsNameSet.contains(attributeType.getNormalizedPrimaryNameOrOID())) continue;
                if (subEntry.isInheritedCollective()) {
                    if (inheritFromEntry == null || (collectiveAttr = inheritFromEntry.getExactAttribute(collectiveAttr.getAttributeType(), collectiveAttr.getOptions())) == null || collectiveAttr.isEmpty()) continue;
                    collectiveAttr = new CollectiveVirtualAttribute(collectiveAttr);
                }
                if ((attrList = this.userAttributes.get(attributeType)) == null || attrList.isEmpty()) {
                    attrList = this.operationalAttributes.get(attributeType);
                    if (attrList == null || attrList.isEmpty()) {
                        attrList = new LinkedList<Attribute>();
                        attrList.add(collectiveAttr);
                        if (attributeType.isOperational()) {
                            this.operationalAttributes.put(attributeType, attrList);
                            continue;
                        }
                        this.userAttributes.put(attributeType, attrList);
                        continue;
                    }
                    this.resolveCollectiveConflict(subEntry.getConflictBehavior(), collectiveAttr, attrList, this.operationalAttributes, attributeType);
                    continue;
                }
                this.resolveCollectiveConflict(subEntry.getConflictBehavior(), collectiveAttr, attrList, this.userAttributes, attributeType);
            }
        }
    }

    private void resolveCollectiveConflict(SubEntry.CollectiveConflictBehavior conflictBehavior, Attribute collectiveAttr, List<Attribute> attrList, Map<AttributeType, List<Attribute>> attributes, AttributeType attributeType) {
        if (attrList.get(0).isVirtual()) {
            return;
        }
        switch (conflictBehavior) {
            case REAL_OVERRIDES_VIRTUAL: {
                break;
            }
            case VIRTUAL_OVERRIDES_REAL: {
                this.suppressedAttributes.put(attributeType, attrList);
                attrList = new LinkedList<Attribute>();
                attrList.add(collectiveAttr);
                attributes.put(attributeType, attrList);
                break;
            }
            case MERGE_REAL_AND_VIRTUAL: {
                attrList.add(collectiveAttr);
            }
        }
    }

    public void processVirtualAttributes() {
        for (VirtualAttributeRule rule : DirectoryServer.getVirtualAttributes(this)) {
            AttributeType attributeType = rule.getAttributeType();
            List<Attribute> attrList = this.userAttributes.get(attributeType);
            if (attrList == null || attrList.isEmpty()) {
                attrList = this.operationalAttributes.get(attributeType);
                if (attrList == null || attrList.isEmpty()) {
                    attrList = new LinkedList<Attribute>();
                    attrList.add(new VirtualAttribute(attributeType, this, rule));
                    if (attributeType.isOperational()) {
                        this.operationalAttributes.put(attributeType, attrList);
                        continue;
                    }
                    this.userAttributes.put(attributeType, attrList);
                    continue;
                }
                this.resolveVirtualConflict(rule, attrList, this.operationalAttributes, attributeType);
                continue;
            }
            this.resolveVirtualConflict(rule, attrList, this.userAttributes, attributeType);
        }
        this.processCollectiveAttributes();
    }

    private void resolveVirtualConflict(VirtualAttributeRule rule, List<Attribute> attrList, Map<AttributeType, List<Attribute>> attributes, AttributeType attributeType) {
        if (attrList.get(0).isVirtual()) {
            return;
        }
        switch (rule.getConflictBehavior()) {
            case REAL_OVERRIDES_VIRTUAL: {
                break;
            }
            case VIRTUAL_OVERRIDES_REAL: {
                this.suppressedAttributes.put(attributeType, attrList);
                attrList = new LinkedList<Attribute>();
                attrList.add(new VirtualAttribute(attributeType, this, rule));
                attributes.put(attributeType, attrList);
                break;
            }
            case MERGE_REAL_AND_VIRTUAL: {
                attrList.add(new VirtualAttribute(attributeType, this, rule));
            }
        }
    }

    public void encode(ByteStringBuilder buffer, EntryEncodeConfig config) throws DirectoryException {
        this.encodeV3(buffer, config);
    }

    private void encodeV3(ByteStringBuilder buffer, EntryEncodeConfig config) throws DirectoryException {
        buffer.append((byte)3);
        config.encode(buffer);
        if (!config.excludeDN()) {
            byte[] dnBytes = StaticUtils.getBytes(this.dn.toString());
            buffer.appendBERLength(dnBytes.length);
            buffer.append(dnBytes);
        }
        if (config.compressObjectClassSets()) {
            config.getCompressedSchema().encodeObjectClasses(buffer, this.objectClasses);
        } else {
            buffer.appendBERLength(this.objectClasses.size());
            for (String ocName : this.objectClasses.values()) {
                buffer.append(ocName);
                buffer.append((byte)0);
            }
        }
        this.encodeAttributes(buffer, this.userAttributes, config);
        this.encodeAttributes(buffer, this.operationalAttributes, config);
    }

    private void encodeAttributes(ByteStringBuilder buffer, Map<AttributeType, List<Attribute>> attributes, EntryEncodeConfig config) throws DirectoryException {
        int numAttributes = 0;
        for (List<Attribute> attrList : attributes.values()) {
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute a = attrList.get(i);
                if (a.isVirtual() || a.isEmpty()) continue;
                ++numAttributes;
            }
        }
        buffer.appendBERLength(numAttributes);
        if (config.compressAttributeDescriptions()) {
            for (List<Attribute> attrList : attributes.values()) {
                for (Attribute a : attrList) {
                    if (a.isVirtual() || a.isEmpty()) continue;
                    config.getCompressedSchema().encodeAttribute(buffer, a);
                }
            }
        } else {
            for (List<Attribute> attrList : attributes.values()) {
                for (Attribute a : attrList) {
                    byte[] nameBytes = StaticUtils.getBytes(a.getNameWithOptions());
                    buffer.append(nameBytes);
                    buffer.append((byte)0);
                    buffer.appendBERLength(a.size());
                    for (AttributeValue v : a) {
                        buffer.appendBERLength(v.getValue().length());
                        buffer.append(v.getValue());
                    }
                }
            }
        }
    }

    public static Entry decode(ByteSequenceReader entryBuffer) throws DirectoryException {
        return Entry.decode(entryBuffer, DirectoryServer.getDefaultCompressedSchema());
    }

    public static Entry decode(ByteSequenceReader entryBuffer, CompressedSchema compressedSchema) throws DirectoryException {
        try {
            DN dn;
            EntryEncodeConfig config;
            Byte version = entryBuffer.get();
            if (version != 3 && version != 2 && version != 1) {
                Message message = CoreMessages.ERR_ENTRY_DECODE_UNRECOGNIZED_VERSION.get(StaticUtils.byteToHex(version));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
            }
            if (version != 1) {
                int configLength = entryBuffer.getBERLength();
                config = EntryEncodeConfig.decode(entryBuffer, configLength, compressedSchema);
            } else {
                config = EntryEncodeConfig.DEFAULT_CONFIG;
            }
            if (config.excludeDN()) {
                dn = DN.NULL_DN;
            } else {
                int dnLength = entryBuffer.getBERLength();
                ByteSequence dnBytes = entryBuffer.getByteSequence(dnLength);
                dn = DN.decode(dnBytes.toByteString());
            }
            Map<ObjectClass, String> objectClasses = Entry.decodeObjectClasses(version, entryBuffer, config);
            LinkedHashMap<AttributeType, List<Attribute>> userAttributes = Entry.decodeAttributes(version, entryBuffer, config);
            LinkedHashMap<AttributeType, List<Attribute>> operationalAttributes = Entry.decodeAttributes(version, entryBuffer, config);
            return new Entry(dn, objectClasses, userAttributes, operationalAttributes);
        }
        catch (DirectoryException de) {
            throw de;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_ENTRY_DECODE_EXCEPTION.get(StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private static Map<ObjectClass, String> decodeObjectClasses(byte ver, ByteSequenceReader entryBuffer, EntryEncodeConfig config) throws DirectoryException {
        Map<ObjectClass, String> objectClasses;
        if (config.compressObjectClassSets()) {
            objectClasses = config.getCompressedSchema().decodeObjectClasses(entryBuffer);
        } else if (ver < 3) {
            int endPos;
            int ocLength = entryBuffer.getBERLength();
            objectClasses = new LinkedHashMap<ObjectClass, String>();
            int startPos = entryBuffer.position();
            for (int i = 0; i < ocLength; ++i) {
                if (entryBuffer.get() != 0) continue;
                endPos = entryBuffer.position() - 1;
                entryBuffer.position(startPos);
                String name = entryBuffer.getString(endPos - startPos);
                String lowerName = StaticUtils.toLowerCase(name);
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                objectClasses.put(oc, name);
                entryBuffer.skip(1);
                startPos = entryBuffer.position();
            }
            endPos = entryBuffer.position();
            entryBuffer.position(startPos);
            String name = entryBuffer.getString(endPos - startPos);
            String lowerName = StaticUtils.toLowerCase(name);
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
            objectClasses.put(oc, name);
        } else {
            int numOC = entryBuffer.getBERLength();
            objectClasses = new LinkedHashMap<ObjectClass, String>(numOC);
            for (int i = 0; i < numOC; ++i) {
                int startPos = entryBuffer.position();
                while (entryBuffer.get() != 0) {
                }
                int endPos = entryBuffer.position() - 1;
                entryBuffer.position(startPos);
                String name = entryBuffer.getString(endPos - startPos);
                String lowerName = StaticUtils.toLowerCase(name);
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                objectClasses.put(oc, name);
                entryBuffer.skip(1);
            }
        }
        return objectClasses;
    }

    private static LinkedHashMap<AttributeType, List<Attribute>> decodeAttributes(Byte ver, ByteSequenceReader entryBuffer, EntryEncodeConfig config) throws DirectoryException {
        int attrs = entryBuffer.getBERLength();
        LinkedHashMap<AttributeType, List<Attribute>> attributes = new LinkedHashMap<AttributeType, List<Attribute>>(attrs);
        if (config.compressAttributeDescriptions()) {
            for (int i = 0; i < attrs; ++i) {
                Attribute a;
                List<Attribute> attrList;
                if (ver < 3) {
                    entryBuffer.getBERLength();
                }
                if ((attrList = attributes.get((a = config.getCompressedSchema().decodeAttribute(entryBuffer)).getAttributeType())) == null) {
                    attrList = new ArrayList<Attribute>(1);
                    attributes.put(a.getAttributeType(), attrList);
                }
                attrList.add(a);
            }
        } else {
            AttributeBuilder builder = new AttributeBuilder();
            for (int i = 0; i < attrs; ++i) {
                AttributeType attributeType;
                int startPos = entryBuffer.position();
                while (entryBuffer.get() != 0) {
                }
                int endPos = entryBuffer.position() - 1;
                entryBuffer.position(startPos);
                String name = entryBuffer.getString(endPos - startPos);
                entryBuffer.skip(1);
                int semicolonPos = name.indexOf(59);
                if (semicolonPos > 0) {
                    String option;
                    builder.setAttributeType(name.substring(0, semicolonPos));
                    attributeType = builder.getAttributeType();
                    int nextPos = name.indexOf(59, semicolonPos + 1);
                    while (nextPos > 0) {
                        option = name.substring(semicolonPos + 1, nextPos);
                        if (option.length() > 0) {
                            builder.setOption(option);
                        }
                        semicolonPos = nextPos;
                        nextPos = name.indexOf(59, semicolonPos + 1);
                    }
                    option = name.substring(semicolonPos + 1);
                    if (option.length() > 0) {
                        builder.setOption(option);
                    }
                } else {
                    builder.setAttributeType(name);
                    attributeType = builder.getAttributeType();
                }
                int numValues = entryBuffer.getBERLength();
                builder.setInitialCapacity(numValues);
                for (int j = 0; j < numValues; ++j) {
                    int valueLength = entryBuffer.getBERLength();
                    ByteString valueBytes = entryBuffer.getByteSequence(valueLength).toByteString();
                    builder.add(AttributeValues.create(attributeType, valueBytes));
                }
                Attribute a = builder.toAttribute();
                List<Attribute> attrList = attributes.get(attributeType);
                if (attrList == null) {
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(a);
                    attributes.put(attributeType, attrList);
                    continue;
                }
                attrList.add(a);
            }
        }
        return attributes;
    }

    public List<StringBuilder> toLDIF() {
        LinkedList<StringBuilder> ldifLines = new LinkedList<StringBuilder>();
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(this.dn.toString()));
        ldifLines.add(dnLine);
        for (String s : this.objectClasses.values()) {
            StringBuilder ocLine = new StringBuilder();
            ocLine.append("objectClass: ");
            ocLine.append(s);
            ldifLines.add(ocLine);
        }
        this.addLinesForAttributes(ldifLines, this.userAttributes);
        this.addLinesForAttributes(ldifLines, this.operationalAttributes);
        return ldifLines;
    }

    private void addLinesForAttributes(List<StringBuilder> ldifLines, Map<AttributeType, List<Attribute>> attributes) {
        for (List<Attribute> attrList : attributes.values()) {
            for (Attribute a : attrList) {
                StringBuilder attrName = new StringBuilder(a.getName());
                for (String o : a.getOptions()) {
                    attrName.append(";");
                    attrName.append(o);
                }
                for (AttributeValue v : a) {
                    StringBuilder attrLine = new StringBuilder(attrName);
                    LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue());
                    ldifLines.add(attrLine);
                }
            }
        }
    }

    public boolean toLDIF(LDIFExportConfig exportConfig) throws IOException, LDIFException {
        PluginConfigManager pluginConfigManager;
        PluginResult.ImportLDIF pluginResult;
        try {
            if (!exportConfig.includeEntry(this)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Skipping entry %s because of the export configuration.", String.valueOf(this.dn));
                }
                return false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = UtilityMessages.ERR_LDIF_COULD_NOT_EVALUATE_FILTERS_FOR_EXPORT.get(String.valueOf(this.dn), String.valueOf(e));
            throw new LDIFException(message, (Throwable)e);
        }
        if (exportConfig.invokeExportPlugins() && !(pluginResult = (pluginConfigManager = DirectoryServer.getPluginConfigManager()).invokeLDIFExportPlugins(exportConfig, this)).continueProcessing()) {
            return false;
        }
        BufferedWriter writer = exportConfig.getWriter();
        int wrapColumn = exportConfig.getWrapColumn();
        boolean wrapLines = wrapColumn > 1;
        StringBuilder dnLine = new StringBuilder();
        dnLine.append("dn");
        LDIFWriter.appendLDIFSeparatorAndValue(dnLine, ByteString.valueOf(this.dn.toString()));
        LDIFWriter.writeLDIFLine(dnLine, writer, wrapLines, wrapColumn);
        boolean typesOnly = exportConfig.typesOnly();
        if (exportConfig.includeObjectClasses()) {
            if (typesOnly) {
                StringBuilder ocLine = new StringBuilder("objectClass:");
                LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
            } else {
                for (String s : this.objectClasses.values()) {
                    StringBuilder ocLine = new StringBuilder();
                    ocLine.append("objectClass: ");
                    ocLine.append(s);
                    LDIFWriter.writeLDIFLine(ocLine, writer, wrapLines, wrapColumn);
                }
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Skipping objectclasses for entry %s because of the export configuration.", String.valueOf(this.dn));
        }
        this.writeLDIFLines(this.userAttributes, typesOnly, "user", exportConfig, writer, wrapColumn, wrapLines);
        if (exportConfig.includeOperationalAttributes()) {
            this.writeLDIFLines(this.operationalAttributes, typesOnly, "operational", exportConfig, writer, wrapColumn, wrapLines);
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("Skipping all operational attributes for entry %s because of the export configuration.", String.valueOf(this.dn));
        }
        if (!exportConfig.includeVirtualAttributes()) {
            for (AttributeType t : this.suppressedAttributes.keySet()) {
                if (!exportConfig.includeAttribute(t)) continue;
                for (Attribute a : this.suppressedAttributes.get(t)) {
                    this.writeLDIFLine(a, typesOnly, writer, wrapLines, wrapColumn);
                }
            }
        }
        writer.newLine();
        return true;
    }

    private void writeLDIFLines(Map<AttributeType, List<Attribute>> attributes, boolean typesOnly, String attributeType, LDIFExportConfig exportConfig, BufferedWriter writer, int wrapColumn, boolean wrapLines) throws IOException {
        for (AttributeType attrType : attributes.keySet()) {
            if (exportConfig.includeAttribute(attrType)) {
                List<Attribute> attrList = attributes.get(attrType);
                for (Attribute a : attrList) {
                    if (a.isVirtual() && !exportConfig.includeVirtualAttributes()) continue;
                    this.writeLDIFLine(a, typesOnly, writer, wrapLines, wrapColumn);
                }
                continue;
            }
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugVerbose("Skipping %s attribute %s for entry %s because of the export configuration.", attributeType, attrType.getNameOrOID(), String.valueOf(this.dn));
        }
    }

    private void writeLDIFLine(Attribute attribute, boolean typesOnly, BufferedWriter writer, boolean wrapLines, int wrapColumn) throws IOException {
        StringBuilder attrName = new StringBuilder(attribute.getName());
        for (String o : attribute.getOptions()) {
            attrName.append(";");
            attrName.append(o);
        }
        if (typesOnly) {
            attrName.append(":");
            LDIFWriter.writeLDIFLine(attrName, writer, wrapLines, wrapColumn);
        } else {
            for (AttributeValue v : attribute) {
                StringBuilder attrLine = new StringBuilder(attrName);
                LDIFWriter.appendLDIFSeparatorAndValue(attrLine, v.getValue());
                LDIFWriter.writeLDIFLine(attrLine, writer, wrapLines, wrapColumn);
            }
        }
    }

    @Override
    public String getProtocolElementName() {
        return "Entry";
    }

    public int hashCode() {
        int hashCode = this.dn.hashCode();
        for (ObjectClass objectClass : this.objectClasses.keySet()) {
            hashCode += objectClass.hashCode();
        }
        for (List list : this.userAttributes.values()) {
            for (Attribute a : list) {
                hashCode += a.hashCode();
            }
        }
        for (List list : this.operationalAttributes.values()) {
            for (Attribute a : list) {
                hashCode += a.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        List<Attribute> list2;
        List<Attribute> list1;
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry e = (Entry)o;
        if (!this.dn.equals(e.dn)) {
            return false;
        }
        if (!this.objectClasses.keySet().equals(e.objectClasses.keySet())) {
            return false;
        }
        for (AttributeType at : this.userAttributes.keySet()) {
            list1 = this.userAttributes.get(at);
            list2 = e.userAttributes.get(at);
            if (list2 == null || list1.size() != list2.size()) {
                return false;
            }
            for (Attribute a : list1) {
                if (list2.contains(a)) continue;
                return false;
            }
        }
        for (AttributeType at : this.operationalAttributes.keySet()) {
            list1 = this.operationalAttributes.get(at);
            list2 = e.operationalAttributes.get(at);
            if (list2 == null || list1.size() != list2.size()) {
                return false;
            }
            for (Attribute a : list1) {
                if (list2.contains(a)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toLDIFString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.toString());
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        for (StringBuilder b : this.toLDIF()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append((CharSequence)b);
            buffer.append(ServerConstants.EOL);
        }
    }

    public String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        for (StringBuilder ldifLine : this.toLDIF()) {
            buffer.append((CharSequence)ldifLine);
            buffer.append(ServerConstants.EOL);
        }
        return buffer.toString();
    }

    public String toSingleLineString() {
        StringBuilder buffer = new StringBuilder();
        this.toSingleLineString(buffer);
        return buffer.toString();
    }

    public void toSingleLineString(StringBuilder buffer) {
        Iterator<AttributeValue> valueIterator;
        buffer.append("Entry(dn=\"");
        this.dn.toString(buffer);
        buffer.append("\",objectClasses={");
        Iterator<String> iterator = this.objectClasses.values().iterator();
        if (iterator.hasNext()) {
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append(iterator.next());
            }
        }
        buffer.append("},userAttrs={");
        boolean firstAttr = true;
        for (List<Attribute> attrList : this.userAttributes.values()) {
            for (Attribute a : attrList) {
                if (firstAttr) {
                    firstAttr = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(a.getName());
                if (a.hasOptions()) {
                    for (String optionString : a.getOptions()) {
                        buffer.append(";");
                        buffer.append(optionString);
                    }
                }
                buffer.append("={");
                valueIterator = a.iterator();
                if (valueIterator.hasNext()) {
                    buffer.append(valueIterator.next().getValue().toString());
                    while (valueIterator.hasNext()) {
                        buffer.append(",");
                        buffer.append(valueIterator.next().getValue().toString());
                    }
                }
                buffer.append("}");
            }
        }
        buffer.append("},operationalAttrs={");
        for (List<Attribute> attrList : this.operationalAttributes.values()) {
            for (Attribute a : attrList) {
                if (firstAttr) {
                    firstAttr = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(a.getName());
                if (a.hasOptions()) {
                    for (String optionString : a.getOptions()) {
                        buffer.append(";");
                        buffer.append(optionString);
                    }
                }
                buffer.append("={");
                valueIterator = a.iterator();
                if (valueIterator.hasNext()) {
                    buffer.append(valueIterator.next().getValue().toString());
                    while (valueIterator.hasNext()) {
                        buffer.append(",");
                        buffer.append(valueIterator.next().getValue().toString());
                    }
                }
                buffer.append("}");
            }
        }
        buffer.append("})");
    }

    public Attribute getExactAttribute(AttributeType attributeType, Set<String> options) {
        List<Attribute> attributes = attributeType.isOperational() ? this.operationalAttributes.get(attributeType) : this.userAttributes.get(attributeType);
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                if (!attribute.optionsEqual(options)) continue;
                return attribute;
            }
        }
        return null;
    }

    private void setAttribute(Attribute attribute, List<AttributeValue> duplicateValues, boolean replace) {
        this.attachment = null;
        AttributeType attributeType = attribute.getAttributeType();
        if (attribute.getAttributeType().isObjectClassType()) {
            if (replace) {
                this.objectClasses.clear();
            }
            for (AttributeValue v : attribute) {
                String lowerName;
                String name = v.getValue().toString();
                try {
                    lowerName = v.getNormalizedValue().toString();
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    lowerName = StaticUtils.toLowerCase(v.getValue().toString());
                }
                ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                if (replace) {
                    this.objectClasses.put(oc, name);
                    continue;
                }
                if (this.objectClasses.containsKey(oc)) {
                    duplicateValues.add(v);
                    continue;
                }
                this.objectClasses.put(oc, name);
            }
            return;
        }
        List<Attribute> attributes = attributeType.isOperational() ? this.operationalAttributes.get(attributeType) : this.userAttributes.get(attributeType);
        if (attributes == null) {
            if (replace && attribute.isEmpty()) {
                return;
            }
            attributes = new ArrayList<Attribute>(1);
            attributes.add(attribute);
            if (attributeType.isOperational()) {
                this.operationalAttributes.put(attributeType, attributes);
            } else {
                this.userAttributes.put(attributeType, attributes);
            }
            return;
        }
        Set<String> options = attribute.getOptions();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute a = attributes.get(i);
            if (!a.optionsEqual(options)) continue;
            if (replace) {
                if (!attribute.isEmpty()) {
                    attributes.set(i, attribute);
                } else {
                    attributes.remove(i);
                    if (attributes.isEmpty()) {
                        if (attributeType.isOperational()) {
                            this.operationalAttributes.remove(attributeType);
                        } else {
                            this.userAttributes.remove(attributeType);
                        }
                    }
                }
            } else {
                AttributeBuilder builder = new AttributeBuilder(a);
                for (AttributeValue v : attribute) {
                    if (builder.add(v)) continue;
                    duplicateValues.add(v);
                }
                attributes.set(i, builder.toAttribute());
            }
            return;
        }
        if (replace && attribute.isEmpty()) {
            return;
        }
        attributes.add(attribute);
    }

    public Entry filterEntry(Set<String> attrNameList, boolean omitValues, boolean omitReal, boolean omitVirtual) {
        LinkedHashMap<Object, Object> objectClassesCopy;
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrsCopy;
        LinkedHashMap<AttributeType, List<Attribute>> userAttrsCopy;
        if (attrNameList == null || attrNameList.isEmpty()) {
            userAttrsCopy = new LinkedHashMap<AttributeType, List<Attribute>>(this.userAttributes.size());
            operationalAttrsCopy = new LinkedHashMap<AttributeType, List<Attribute>>(0);
            if (omitReal) {
                objectClassesCopy = new LinkedHashMap(0);
            } else if (omitValues) {
                objectClassesCopy = new LinkedHashMap(0);
                AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                ocList.add(Attributes.empty(ocType));
                userAttrsCopy.put(ocType, ocList);
            } else {
                objectClassesCopy = new LinkedHashMap<ObjectClass, String>(this.objectClasses);
                Attribute ocAttr = this.getObjectClassAttribute();
                if (ocAttr != null) {
                    AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                    ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                    ocList.add(ocAttr);
                    userAttrsCopy.put(ocType, ocList);
                }
            }
            this.deepCopy(this.userAttributes, userAttrsCopy, omitValues, true, omitReal, omitVirtual, true);
        } else {
            objectClassesCopy = omitReal || omitValues ? new LinkedHashMap(0) : new LinkedHashMap(this.objectClasses.size());
            userAttrsCopy = new LinkedHashMap(this.userAttributes.size());
            operationalAttrsCopy = new LinkedHashMap(this.operationalAttributes.size());
            for (String attrName : attrNameList) {
                HashSet<String> options;
                String lowerName;
                if (attrName.equals("*")) {
                    if (!omitReal) {
                        if (omitValues) {
                            AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                            ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                            ocList.add(Attributes.empty(ocType));
                            userAttrsCopy.put(ocType, ocList);
                        } else {
                            objectClassesCopy.putAll(this.objectClasses);
                            Attribute ocAttr = this.getObjectClassAttribute();
                            if (ocAttr != null) {
                                AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                                ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                                ocList.add(ocAttr);
                                userAttrsCopy.put(ocType, ocList);
                            }
                        }
                    }
                    this.deepCopy(this.userAttributes, userAttrsCopy, omitValues, true, omitReal, omitVirtual, true);
                    continue;
                }
                if (attrName.equals("+")) {
                    this.deepCopy(this.operationalAttributes, operationalAttrsCopy, omitValues, true, omitReal, omitVirtual, true);
                    continue;
                }
                int semicolonPos = attrName.indexOf(59);
                if (semicolonPos > 0) {
                    String tmpName = attrName.substring(0, semicolonPos);
                    lowerName = StaticUtils.toLowerCase(tmpName);
                    int nextPos = attrName.indexOf(59, semicolonPos + 1);
                    options = new HashSet<String>();
                    while (nextPos > 0) {
                        options.add(attrName.substring(semicolonPos + 1, nextPos));
                        semicolonPos = nextPos;
                        nextPos = attrName.indexOf(59, semicolonPos + 1);
                    }
                    options.add(attrName.substring(semicolonPos + 1));
                    attrName = tmpName;
                } else {
                    lowerName = StaticUtils.toLowerCase(attrName);
                    options = null;
                }
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName);
                if (attrType == null) {
                    AttributeType t;
                    for (Map.Entry<AttributeType, List<Attribute>> e : this.userAttributes.entrySet()) {
                        t = e.getKey();
                        if (!t.hasNameOrOID(lowerName)) continue;
                        this.mergeAttributeLists(e.getValue(), userAttrsCopy, t, attrName, options, omitValues, omitReal, omitVirtual);
                    }
                    for (Map.Entry<AttributeType, List<Attribute>> e : this.operationalAttributes.entrySet()) {
                        t = e.getKey();
                        if (!t.hasNameOrOID(lowerName)) continue;
                        this.mergeAttributeLists(e.getValue(), operationalAttrsCopy, t, attrName, options, omitValues, omitReal, omitVirtual);
                    }
                    continue;
                }
                if (attrType.isObjectClassType()) {
                    if (omitReal) continue;
                    if (omitValues) {
                        AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                        ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                        ocList.add(Attributes.empty(ocType, attrName));
                        userAttrsCopy.put(ocType, ocList);
                        continue;
                    }
                    Attribute ocAttr = this.getObjectClassAttribute();
                    if (ocAttr == null) continue;
                    AttributeType ocType = DirectoryServer.getObjectClassAttributeType();
                    if (!attrName.equals(ocAttr.getName())) {
                        AttributeBuilder builder = new AttributeBuilder(ocAttr);
                        builder.setAttributeType(ocType, attrName);
                        ocAttr = builder.toAttribute();
                    }
                    ArrayList<Attribute> ocList = new ArrayList<Attribute>(1);
                    ocList.add(ocAttr);
                    userAttrsCopy.put(ocType, ocList);
                    continue;
                }
                List<Attribute> attrList = this.getUserAttribute(attrType);
                if (attrList != null) {
                    this.mergeAttributeLists(attrList, userAttrsCopy, attrType, attrName, options, omitValues, omitReal, omitVirtual);
                    continue;
                }
                attrList = this.getOperationalAttribute(attrType);
                if (attrList == null) continue;
                this.mergeAttributeLists(attrList, operationalAttrsCopy, attrType, attrName, options, omitValues, omitReal, omitVirtual);
            }
        }
        return new Entry(this.dn, objectClassesCopy, userAttrsCopy, operationalAttrsCopy);
    }

    private void mergeAttributeLists(List<Attribute> sourceList, HashMap<AttributeType, List<Attribute>> destMap, AttributeType attrType, String attrName, HashSet<String> options, boolean omitValues, boolean omitReal, boolean omitVirtual) {
        if (sourceList == null) {
            return;
        }
        for (Attribute attribute : sourceList) {
            if (attribute.isEmpty() || omitReal && !attribute.isVirtual() || omitVirtual && attribute.isVirtual() || !attribute.hasAllOptions(options)) continue;
            AttributeType subAttrType = attribute.getAttributeType();
            if (attrName != null && !attrName.equals(attribute.getName()) || options != null && !options.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder();
                if (attrName == null || !subAttrType.equals(attrType)) {
                    builder.setAttributeType(attribute.getAttributeType(), attribute.getName());
                } else {
                    builder.setAttributeType(attribute.getAttributeType(), attrName);
                }
                if (options != null) {
                    builder.setOptions(options);
                }
                builder.setOptions(attribute.getOptions());
                if (!omitValues) {
                    builder.addAll(attribute);
                }
                attribute = builder.toAttribute();
            } else if (omitValues) {
                attribute = Attributes.empty(attribute);
            }
            List<Attribute> attrList = destMap.get(subAttrType);
            if (attrList == null) {
                attrList = new ArrayList<Attribute>(sourceList.size());
                attrList.add(attribute);
                destMap.put(subAttrType, attrList);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute otherAttribute = attrList.get(i);
                if (!otherAttribute.optionsEqual(attribute.getOptions())) continue;
                attrList.set(i, Attributes.merge(attribute, otherAttribute));
                found = true;
            }
            if (found) continue;
            attrList.add(attribute);
        }
    }
}

