/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public class FilePermission {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int OWNER_READABLE = 256;
    public static final int OWNER_WRITABLE = 128;
    public static final int OWNER_EXECUTABLE = 64;
    public static final int GROUP_READABLE = 32;
    public static final int GROUP_WRITABLE = 16;
    public static final int GROUP_EXECUTABLE = 8;
    public static final int OTHER_READABLE = 4;
    public static final int OTHER_WRITABLE = 2;
    public static final int OTHER_EXECUTABLE = 1;
    private static boolean useNIO;
    private static Method toPath;
    private static Method setPosixFilePermissions;
    private static Method getFileAttributeView;
    private static Method fromString;
    private static Method asFileAttribute;
    private static Class<?> posixView;
    private static Class<?> aclView;
    private static Class<?> linkOption;
    private int encodedPermission;

    public FilePermission(int encodedPermission) {
        this.encodedPermission = encodedPermission;
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
    }

    public FilePermission(boolean ownerReadable, boolean ownerWritable, boolean ownerExecutable, boolean groupReadable, boolean groupWritable, boolean groupExecutable, boolean otherReadable, boolean otherWritable, boolean otherExecutable) {
        this.encodedPermission = 0;
        if (ownerReadable) {
            this.encodedPermission |= 0x100;
        }
        if (ownerWritable) {
            this.encodedPermission |= 0x80;
        }
        if (ownerExecutable) {
            this.encodedPermission |= 0x40;
        }
        if (groupReadable) {
            this.encodedPermission |= 0x20;
        }
        if (groupWritable) {
            this.encodedPermission |= 0x10;
        }
        if (groupExecutable) {
            this.encodedPermission |= 8;
        }
        if (otherReadable) {
            this.encodedPermission |= 4;
        }
        if (otherWritable) {
            this.encodedPermission |= 2;
        }
        if (otherExecutable) {
            this.encodedPermission |= 1;
        }
    }

    public boolean isOwnerReadable() {
        return (this.encodedPermission & 0x100) == 256;
    }

    public boolean isOwnerWritable() {
        return (this.encodedPermission & 0x80) == 128;
    }

    public boolean isOwnerExecutable() {
        return (this.encodedPermission & 0x40) == 64;
    }

    public boolean isGroupReadable() {
        return (this.encodedPermission & 0x20) == 32;
    }

    public boolean isGroupWritable() {
        return (this.encodedPermission & 0x10) == 16;
    }

    public boolean isGroupExecutable() {
        return (this.encodedPermission & 8) == 8;
    }

    public boolean isOtherReadable() {
        return (this.encodedPermission & 4) == 4;
    }

    public boolean isOtherWritable() {
        return (this.encodedPermission & 2) == 2;
    }

    public boolean isOtherExecutable() {
        return (this.encodedPermission & 1) == 1;
    }

    public static boolean canSetPermissions() {
        if (useNIO) {
            return true;
        }
        return true;
    }

    public static boolean setPermissions(File f, FilePermission p) throws FileNotFoundException, DirectoryException {
        if (!f.exists()) {
            Message message = UtilityMessages.ERR_FILEPERM_SET_NO_SUCH_FILE.get(f.getAbsolutePath());
            throw new FileNotFoundException(message.toString());
        }
        if (useNIO) {
            return FilePermission.setUsingJava7(f, p);
        }
        return FilePermission.setUsingJava6(f, p);
    }

    public static boolean setSafePermissions(File f, Integer p) {
        if (useNIO) {
            return FilePermission.setUsingJava7(f, new FilePermission(p));
        }
        try {
            return FilePermission.setUsingJava6(f, new FilePermission(p));
        }
        catch (DirectoryException e) {
            return false;
        }
    }

    private static boolean setUsingJava7(File f, FilePermission p) {
        block4: {
            try {
                Object path = toPath.invoke((Object)f, new Object[0]);
                Object posix = getFileAttributeView.invoke(null, path, posixView, Array.newInstance(linkOption, 0));
                if (posix != null) {
                    StringBuilder posixMode = new StringBuilder();
                    FilePermission.toPOSIXString(p, posixMode, "", "", "");
                    Object perms = fromString.invoke(null, posixMode.toString());
                    setPosixFilePermissions.invoke(null, path, perms);
                    return true;
                }
                Object acl = getFileAttributeView.invoke(null, path, aclView, Array.newInstance(linkOption, 0));
                if (acl != null) {
                    return true;
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block4;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return false;
    }

    private static boolean setUsingJava6(File f, FilePermission p) throws DirectoryException {
        boolean ignoreSetWritableFailures;
        boolean anySuccessful = false;
        boolean anyFailed = false;
        boolean exceptionThrown = false;
        if (p.isOwnerReadable() && !p.isOtherReadable()) {
            try {
                if (f.setReadable(false, false)) {
                    anySuccessful = true;
                } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly;
            boolean bl = ownerOnly = p.isOwnerReadable() != p.isOtherReadable();
            if (f.setReadable(p.isOwnerReadable(), ownerOnly)) {
                anySuccessful = true;
            } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) || p.isOwnerReadable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        boolean bl = ignoreSetWritableFailures = DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) && f.isDirectory();
        if (p.isOwnerWritable() && !p.isOtherWritable()) {
            try {
                if (f.setWritable(false, false)) {
                    anySuccessful = true;
                } else if (!ignoreSetWritableFailures) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly;
            boolean bl2 = ownerOnly = p.isOwnerWritable() != p.isOtherWritable();
            if (f.setWritable(p.isOwnerWritable(), ownerOnly)) {
                anySuccessful = true;
            } else if (!ignoreSetWritableFailures) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (p.isOwnerExecutable() && !p.isOtherExecutable()) {
            try {
                if (f.setExecutable(false, false)) {
                    anySuccessful = true;
                } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS)) {
                    anyFailed = true;
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                exceptionThrown = true;
            }
        }
        try {
            boolean ownerOnly;
            boolean bl3 = ownerOnly = p.isOwnerExecutable() != p.isOtherExecutable();
            if (f.setExecutable(p.isOwnerExecutable(), ownerOnly)) {
                anySuccessful = true;
            } else if (!DirectoryServer.getOperatingSystem().equals((Object)OperatingSystem.WINDOWS) || p.isOwnerExecutable()) {
                anyFailed = true;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            exceptionThrown = true;
        }
        if (exceptionThrown) {
            Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_EXCEPTION.get(f.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        if (anyFailed) {
            if (anySuccessful) {
                Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_FAILED_ALTERED.get(f.getAbsolutePath());
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            Message message = UtilityMessages.ERR_FILEPERM_SET_JAVA_FAILED_UNALTERED.get(f.getAbsolutePath());
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        return anySuccessful;
    }

    public static String toUNIXMode(FilePermission p) {
        StringBuilder buffer = new StringBuilder(3);
        FilePermission.toUNIXMode(buffer, p);
        return buffer.toString();
    }

    public static void toUNIXMode(StringBuilder buffer, FilePermission p) {
        int modeByte = 0;
        if (p.isOwnerReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOwnerWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOwnerExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isGroupReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isGroupWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isGroupExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
        modeByte = 0;
        if (p.isOtherReadable()) {
            modeByte = (byte)(modeByte | 4);
        }
        if (p.isOtherWritable()) {
            modeByte = (byte)(modeByte | 2);
        }
        if (p.isOtherExecutable()) {
            modeByte = (byte)(modeByte | 1);
        }
        buffer.append(String.valueOf(modeByte));
    }

    public static FilePermission decodeUNIXMode(String modeString) throws DirectoryException {
        if (modeString == null || modeString.length() != 3) {
            Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        int encodedPermission = 0;
        switch (modeString.charAt(0)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 0x40;
                break;
            }
            case '2': {
                encodedPermission |= 0x80;
                break;
            }
            case '3': {
                encodedPermission |= 0xC0;
                break;
            }
            case '4': {
                encodedPermission |= 0x100;
                break;
            }
            case '5': {
                encodedPermission |= 0x140;
                break;
            }
            case '6': {
                encodedPermission |= 0x180;
                break;
            }
            case '7': {
                encodedPermission |= 0x1C0;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        switch (modeString.charAt(1)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 8;
                break;
            }
            case '2': {
                encodedPermission |= 0x10;
                break;
            }
            case '3': {
                encodedPermission |= 0x18;
                break;
            }
            case '4': {
                encodedPermission |= 0x20;
                break;
            }
            case '5': {
                encodedPermission |= 0x28;
                break;
            }
            case '6': {
                encodedPermission |= 0x30;
                break;
            }
            case '7': {
                encodedPermission |= 0x38;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        switch (modeString.charAt(2)) {
            case '0': {
                break;
            }
            case '1': {
                encodedPermission |= 1;
                break;
            }
            case '2': {
                encodedPermission |= 2;
                break;
            }
            case '3': {
                encodedPermission |= 3;
                break;
            }
            case '4': {
                encodedPermission |= 4;
                break;
            }
            case '5': {
                encodedPermission |= 5;
                break;
            }
            case '6': {
                encodedPermission |= 6;
                break;
            }
            case '7': {
                encodedPermission |= 7;
                break;
            }
            default: {
                Message message = UtilityMessages.ERR_FILEPERM_INVALID_UNIX_MODE_STRING.get(String.valueOf(modeString));
                throw new DirectoryException(ResultCode.OTHER, message);
            }
        }
        return new FilePermission(encodedPermission);
    }

    private static void toPOSIXString(FilePermission p, StringBuilder buffer, String owner, String group, String other) {
        buffer.append(owner);
        buffer.append(p.isOwnerReadable() ? "r" : "-");
        buffer.append(p.isOwnerWritable() ? "w" : "-");
        buffer.append(p.isOwnerExecutable() ? "x" : "-");
        buffer.append(group);
        buffer.append(p.isGroupReadable() ? "r" : "-");
        buffer.append(p.isGroupWritable() ? "w" : "-");
        buffer.append(p.isGroupExecutable() ? "x" : "-");
        buffer.append(other);
        buffer.append(p.isOtherReadable() ? "r" : "-");
        buffer.append(p.isOtherWritable() ? "w" : "-");
        buffer.append(p.isOtherExecutable() ? "x" : "-");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        FilePermission.toPOSIXString(this, buffer, "Owner=", ", Group=", ", Other=");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<?>[] argTypes;
            String name;
            useNIO = false;
            toPath = null;
            setPosixFilePermissions = null;
            getFileAttributeView = null;
            fromString = null;
            asFileAttribute = null;
            posixView = null;
            aclView = null;
            linkOption = null;
            Class<?> c = Class.forName("java.io.File");
            for (Method m : c.getMethods()) {
                name = m.getName();
                argTypes = m.getParameterTypes();
                if (!name.equals("toPath") || argTypes.length != 0) continue;
                toPath = m;
            }
            if (toPath == null) {
                throw new NoSuchMethodException("java.io.File.toPath");
            }
            c = Class.forName("java.nio.file.attribute.PosixFilePermissions");
            for (Method m : c.getMethods()) {
                name = m.getName();
                argTypes = m.getParameterTypes();
                if (name.equals("fromString") && argTypes.length == 1) {
                    fromString = m;
                }
                if (!name.equals("asFileAttribute") || argTypes.length != 1) continue;
                asFileAttribute = m;
            }
            if (fromString == null) {
                throw new NoSuchMethodException("java.nio.file.attribute.PosixFilePermissions.fromString");
            }
            if (asFileAttribute == null) {
                throw new NoSuchMethodException("java.nio.file.attribute.PosixFilePermissions.asFileAttribute");
            }
            c = Class.forName("java.nio.file.Files");
            for (Method m : c.getMethods()) {
                name = m.getName();
                argTypes = m.getParameterTypes();
                if (name.equals("setPosixFilePermissions") && argTypes.length == 2) {
                    setPosixFilePermissions = m;
                }
                if (!name.equals("getFileAttributeView") || argTypes.length != 3) continue;
                getFileAttributeView = m;
            }
            if (setPosixFilePermissions == null) {
                throw new NoSuchMethodException("java.nio.file.Files.setPosixFilePermissions");
            }
            if (getFileAttributeView == null) {
                throw new NoSuchMethodException("java.nio.file.Files.getFileAttributeView");
            }
            posixView = Class.forName("java.nio.file.attribute.PosixFileAttributeView");
            aclView = Class.forName("java.nio.file.attribute.AclFileAttributeView");
            linkOption = Class.forName("java.nio.file.LinkOption");
            useNIO = true;
        }
        catch (NoSuchMethodException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.INFO, e);
            }
        }
        catch (ClassNotFoundException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.INFO, e);
            }
        }
        finally {
            if (!useNIO) {
                toPath = null;
                setPosixFilePermissions = null;
                getFileAttributeView = null;
                fromString = null;
                asFileAttribute = null;
                posixView = null;
                aclView = null;
                linkOption = null;
            }
        }
    }
}

