/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.security.SecureRandom;
import java.util.Random;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.messages.UtilityMessages;
import org.opends.server.config.ConfigException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class NamedCharacterSet {
    private char[] characters;
    private Random random;
    private String name;

    public NamedCharacterSet(String name, char[] characters) throws ConfigException {
        this.name = name;
        this.characters = characters;
        this.random = new SecureRandom();
        if (name == null || name.length() == 0) {
            Message message = UtilityMessages.ERR_CHARSET_CONSTRUCTOR_NO_NAME.get();
            throw new ConfigException(message);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (StaticUtils.isAlpha(name.charAt(i))) continue;
            Message message = UtilityMessages.ERR_CHARSET_CONSTRUCTOR_INVALID_NAME_CHAR.get(String.valueOf(name.charAt(i)), i);
            throw new ConfigException(message);
        }
    }

    public NamedCharacterSet(String name, char[] characters, Random random) throws ConfigException {
        this.name = name;
        this.characters = characters;
        this.random = random;
        if (name == null || name.length() == 0) {
            Message message = UtilityMessages.ERR_CHARSET_CONSTRUCTOR_NO_NAME.get();
            throw new ConfigException(message);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (StaticUtils.isAlpha(name.charAt(i))) continue;
            Message message = UtilityMessages.ERR_CHARSET_CONSTRUCTOR_INVALID_NAME_CHAR.get(String.valueOf(name.charAt(i)), i);
            throw new ConfigException(message);
        }
    }

    public String getName() {
        return this.name;
    }

    public char[] getCharacters() {
        return this.characters;
    }

    public char getRandomCharacter() {
        if (this.characters == null || this.characters.length == 0) {
            return '\u0000';
        }
        return this.characters[this.random.nextInt(this.characters.length)];
    }

    public void getRandomCharacters(StringBuilder buffer, int count) {
        if (this.characters == null || this.characters.length == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            buffer.append(this.characters[this.random.nextInt(this.characters.length)]);
        }
    }

    public String encode() {
        return this.name + ":" + new String(this.characters);
    }

    public static NamedCharacterSet[] decodeCharacterSets(SortedSet<String> values) throws ConfigException {
        NamedCharacterSet[] sets = new NamedCharacterSet[values.size()];
        int i = 0;
        for (String value : values) {
            Message message;
            int colonPos = value.indexOf(58);
            if (colonPos < 0) {
                message = UtilityMessages.ERR_CHARSET_NO_COLON.get(String.valueOf(value));
                throw new ConfigException(message);
            }
            if (colonPos == 0) {
                message = UtilityMessages.ERR_CHARSET_NO_NAME.get(String.valueOf(value));
                throw new ConfigException(message);
            }
            if (colonPos == value.length() - 1) {
                message = UtilityMessages.ERR_CHARSET_NO_CHARS.get(String.valueOf(value));
                throw new ConfigException(message);
            }
            String name = value.substring(0, colonPos);
            char[] characters = value.substring(colonPos + 1).toCharArray();
            sets[i] = new NamedCharacterSet(name, characters);
            ++i;
        }
        return sets;
    }
}

