/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum ResultCode {
    UNDEFINED(-1, CoreMessages.INFO_RESULT_UNDEFINED.get()),
    SUCCESS(0, CoreMessages.INFO_RESULT_SUCCESS.get()),
    OPERATIONS_ERROR(1, CoreMessages.INFO_RESULT_OPERATIONS_ERROR.get()),
    PROTOCOL_ERROR(2, CoreMessages.INFO_RESULT_PROTOCOL_ERROR.get()),
    TIME_LIMIT_EXCEEDED(3, CoreMessages.INFO_RESULT_TIME_LIMIT_EXCEEDED.get()),
    SIZE_LIMIT_EXCEEDED(4, CoreMessages.INFO_RESULT_SIZE_LIMIT_EXCEEDED.get()),
    COMPARE_FALSE(5, CoreMessages.INFO_RESULT_COMPARE_FALSE.get()),
    COMPARE_TRUE(6, CoreMessages.INFO_RESULT_COMPARE_TRUE.get()),
    AUTH_METHOD_NOT_SUPPORTED(7, CoreMessages.INFO_RESULT_AUTH_METHOD_NOT_SUPPORTED.get()),
    STRONG_AUTH_REQUIRED(8, CoreMessages.INFO_RESULT_STRONG_AUTH_REQUIRED.get()),
    REFERRAL(10, CoreMessages.INFO_RESULT_REFERRAL.get()),
    ADMIN_LIMIT_EXCEEDED(11, CoreMessages.INFO_RESULT_ADMIN_LIMIT_EXCEEDED.get()),
    UNAVAILABLE_CRITICAL_EXTENSION(12, CoreMessages.INFO_RESULT_UNAVAILABLE_CRITICAL_EXTENSION.get()),
    CONFIDENTIALITY_REQUIRED(13, CoreMessages.INFO_RESULT_CONFIDENTIALITY_REQUIRED.get()),
    SASL_BIND_IN_PROGRESS(14, CoreMessages.INFO_RESULT_SASL_BIND_IN_PROGRESS.get()),
    NO_SUCH_ATTRIBUTE(16, CoreMessages.INFO_RESULT_NO_SUCH_ATTRIBUTE.get()),
    UNDEFINED_ATTRIBUTE_TYPE(17, CoreMessages.INFO_RESULT_UNDEFINED_ATTRIBUTE_TYPE.get()),
    INAPPROPRIATE_MATCHING(18, CoreMessages.INFO_RESULT_INAPPROPRIATE_MATCHING.get()),
    CONSTRAINT_VIOLATION(19, CoreMessages.INFO_RESULT_CONSTRAINT_VIOLATION.get()),
    ATTRIBUTE_OR_VALUE_EXISTS(20, CoreMessages.INFO_RESULT_ATTRIBUTE_OR_VALUE_EXISTS.get()),
    INVALID_ATTRIBUTE_SYNTAX(21, CoreMessages.INFO_RESULT_INVALID_ATTRIBUTE_SYNTAX.get()),
    NO_SUCH_OBJECT(32, CoreMessages.INFO_RESULT_NO_SUCH_OBJECT.get()),
    ALIAS_PROBLEM(33, CoreMessages.INFO_RESULT_ALIAS_PROBLEM.get()),
    INVALID_DN_SYNTAX(34, CoreMessages.INFO_RESULT_INVALID_DN_SYNTAX.get()),
    ALIAS_DEREFERENCING_PROBLEM(36, CoreMessages.INFO_RESULT_ALIAS_DEREFERENCING_PROBLEM.get()),
    INAPPROPRIATE_AUTHENTICATION(48, CoreMessages.INFO_RESULT_INAPPROPRIATE_AUTHENTICATION.get()),
    INVALID_CREDENTIALS(49, CoreMessages.INFO_RESULT_INVALID_CREDENTIALS.get()),
    INSUFFICIENT_ACCESS_RIGHTS(50, CoreMessages.INFO_RESULT_INSUFFICIENT_ACCESS_RIGHTS.get()),
    BUSY(51, CoreMessages.INFO_RESULT_BUSY.get()),
    UNAVAILABLE(52, CoreMessages.INFO_RESULT_UNAVAILABLE.get()),
    UNWILLING_TO_PERFORM(53, CoreMessages.INFO_RESULT_UNWILLING_TO_PERFORM.get()),
    LOOP_DETECT(54, CoreMessages.INFO_RESULT_LOOP_DETECT.get()),
    SORT_CONTROL_MISSING(60, CoreMessages.INFO_RESULT_SORT_CONTROL_MISSING.get()),
    OFFSET_RANGE_ERROR(61, CoreMessages.INFO_RESULT_OFFSET_RANGE_ERROR.get()),
    NAMING_VIOLATION(64, CoreMessages.INFO_RESULT_NAMING_VIOLATION.get()),
    OBJECTCLASS_VIOLATION(65, CoreMessages.INFO_RESULT_OBJECTCLASS_VIOLATION.get()),
    NOT_ALLOWED_ON_NONLEAF(66, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_NONLEAF.get()),
    NOT_ALLOWED_ON_RDN(67, CoreMessages.INFO_RESULT_NOT_ALLOWED_ON_RDN.get()),
    ENTRY_ALREADY_EXISTS(68, CoreMessages.INFO_RESULT_ENTRY_ALREADY_EXISTS.get()),
    OBJECTCLASS_MODS_PROHIBITED(69, CoreMessages.INFO_RESULT_OBJECTCLASS_MODS_PROHIBITED.get()),
    AFFECTS_MULTIPLE_DSAS(71, CoreMessages.INFO_RESULT_AFFECTS_MULTIPLE_DSAS.get()),
    VIRTUAL_LIST_VIEW_ERROR(76, CoreMessages.INFO_RESULT_VIRTUAL_LIST_VIEW_ERROR.get()),
    OTHER(80, CoreMessages.INFO_RESULT_OTHER.get()),
    CLIENT_SIDE_SERVER_DOWN(81, CoreMessages.INFO_RESULT_CLIENT_SIDE_SERVER_DOWN.get()),
    CLIENT_SIDE_LOCAL_ERROR(82, CoreMessages.INFO_RESULT_CLIENT_SIDE_LOCAL_ERROR.get()),
    CLIENT_SIDE_ENCODING_ERROR(83, CoreMessages.INFO_RESULT_CLIENT_SIDE_ENCODING_ERROR.get()),
    CLIENT_SIDE_DECODING_ERROR(84, CoreMessages.INFO_RESULT_CLIENT_SIDE_DECODING_ERROR.get()),
    CLIENT_SIDE_TIMEOUT(85, CoreMessages.INFO_RESULT_CLIENT_SIDE_TIMEOUT.get()),
    CLIENT_SIDE_AUTH_UNKNOWN(86, CoreMessages.INFO_RESULT_CLIENT_SIDE_AUTH_UNKNOWN.get()),
    CLIENT_SIDE_FILTER_ERROR(87, CoreMessages.INFO_RESULT_CLIENT_SIDE_FILTER_ERROR.get()),
    CLIENT_SIDE_USER_CANCELLED(88, CoreMessages.INFO_RESULT_CLIENT_SIDE_USER_CANCELLED.get()),
    CLIENT_SIDE_PARAM_ERROR(89, CoreMessages.INFO_RESULT_CLIENT_SIDE_PARAM_ERROR.get()),
    CLIENT_SIDE_NO_MEMORY(90, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_MEMORY.get()),
    CLIENT_SIDE_CONNECT_ERROR(91, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONNECT_ERROR.get()),
    CLIENT_SIDE_NOT_SUPPORTED(92, CoreMessages.INFO_RESULT_CLIENT_SIDE_NOT_SUPPORTED.get()),
    CLIENT_SIDE_CONTROL_NOT_FOUND(93, CoreMessages.INFO_RESULT_CLIENT_SIDE_CONTROL_NOT_FOUND.get()),
    CLIENT_SIDE_NO_RESULTS_RETURNED(94, CoreMessages.INFO_RESULT_CLIENT_SIDE_NO_RESULTS_RETURNED.get()),
    CLIENT_SIDE_MORE_RESULTS_TO_RETURN(95, CoreMessages.INFO_RESULT_CLIENT_SIDE_MORE_RESULTS_TO_RETURN.get()),
    CLIENT_SIDE_CLIENT_LOOP(96, CoreMessages.INFO_RESULT_CLIENT_SIDE_CLIENT_LOOP.get()),
    CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED(97, CoreMessages.INFO_RESULT_CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED.get()),
    CANCELED(118, CoreMessages.INFO_RESULT_CANCELED.get()),
    NO_SUCH_OPERATION(119, CoreMessages.INFO_RESULT_NO_SUCH_OPERATION.get()),
    TOO_LATE(120, CoreMessages.INFO_RESULT_TOO_LATE.get()),
    CANNOT_CANCEL(121, CoreMessages.INFO_RESULT_CANNOT_CANCEL.get()),
    ASSERTION_FAILED(122, CoreMessages.INFO_RESULT_ASSERTION_FAILED.get()),
    AUTHORIZATION_DENIED(123, CoreMessages.INFO_RESULT_AUTHORIZATION_DENIED.get()),
    NO_OPERATION(16654, CoreMessages.INFO_RESULT_NO_OPERATION.get());

    private int intValue;
    private Message resultCodeName;

    private ResultCode(int intValue, Message name) {
        Validator.ensureNotNull(name);
        this.intValue = intValue;
        this.resultCodeName = name;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static ResultCode valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OPERATIONS_ERROR;
            }
            case 2: {
                return PROTOCOL_ERROR;
            }
            case 3: {
                return TIME_LIMIT_EXCEEDED;
            }
            case 4: {
                return SIZE_LIMIT_EXCEEDED;
            }
            case 5: {
                return COMPARE_FALSE;
            }
            case 6: {
                return COMPARE_TRUE;
            }
            case 7: {
                return AUTH_METHOD_NOT_SUPPORTED;
            }
            case 8: {
                return STRONG_AUTH_REQUIRED;
            }
            case 10: {
                return REFERRAL;
            }
            case 11: {
                return ADMIN_LIMIT_EXCEEDED;
            }
            case 12: {
                return UNAVAILABLE_CRITICAL_EXTENSION;
            }
            case 13: {
                return CONFIDENTIALITY_REQUIRED;
            }
            case 14: {
                return SASL_BIND_IN_PROGRESS;
            }
            case 16: {
                return NO_SUCH_ATTRIBUTE;
            }
            case 17: {
                return UNDEFINED_ATTRIBUTE_TYPE;
            }
            case 18: {
                return INAPPROPRIATE_MATCHING;
            }
            case 19: {
                return CONSTRAINT_VIOLATION;
            }
            case 20: {
                return ATTRIBUTE_OR_VALUE_EXISTS;
            }
            case 21: {
                return INVALID_ATTRIBUTE_SYNTAX;
            }
            case 32: {
                return NO_SUCH_OBJECT;
            }
            case 33: {
                return ALIAS_PROBLEM;
            }
            case 34: {
                return INVALID_DN_SYNTAX;
            }
            case 36: {
                return ALIAS_DEREFERENCING_PROBLEM;
            }
            case 48: {
                return INAPPROPRIATE_AUTHENTICATION;
            }
            case 49: {
                return INVALID_CREDENTIALS;
            }
            case 50: {
                return INSUFFICIENT_ACCESS_RIGHTS;
            }
            case 51: {
                return BUSY;
            }
            case 52: {
                return UNAVAILABLE;
            }
            case 53: {
                return UNWILLING_TO_PERFORM;
            }
            case 54: {
                return LOOP_DETECT;
            }
            case 60: {
                return SORT_CONTROL_MISSING;
            }
            case 61: {
                return OFFSET_RANGE_ERROR;
            }
            case 64: {
                return NAMING_VIOLATION;
            }
            case 65: {
                return OBJECTCLASS_VIOLATION;
            }
            case 66: {
                return NOT_ALLOWED_ON_NONLEAF;
            }
            case 67: {
                return NOT_ALLOWED_ON_RDN;
            }
            case 68: {
                return ENTRY_ALREADY_EXISTS;
            }
            case 69: {
                return OBJECTCLASS_MODS_PROHIBITED;
            }
            case 71: {
                return AFFECTS_MULTIPLE_DSAS;
            }
            case 76: {
                return VIRTUAL_LIST_VIEW_ERROR;
            }
            case 81: {
                return CLIENT_SIDE_SERVER_DOWN;
            }
            case 82: {
                return CLIENT_SIDE_LOCAL_ERROR;
            }
            case 83: {
                return CLIENT_SIDE_ENCODING_ERROR;
            }
            case 84: {
                return CLIENT_SIDE_DECODING_ERROR;
            }
            case 85: {
                return CLIENT_SIDE_TIMEOUT;
            }
            case 86: {
                return CLIENT_SIDE_AUTH_UNKNOWN;
            }
            case 87: {
                return CLIENT_SIDE_FILTER_ERROR;
            }
            case 88: {
                return CLIENT_SIDE_USER_CANCELLED;
            }
            case 89: {
                return CLIENT_SIDE_PARAM_ERROR;
            }
            case 90: {
                return CLIENT_SIDE_NO_MEMORY;
            }
            case 91: {
                return CLIENT_SIDE_CONNECT_ERROR;
            }
            case 92: {
                return CLIENT_SIDE_NOT_SUPPORTED;
            }
            case 93: {
                return CLIENT_SIDE_CONTROL_NOT_FOUND;
            }
            case 94: {
                return CLIENT_SIDE_NO_RESULTS_RETURNED;
            }
            case 95: {
                return CLIENT_SIDE_MORE_RESULTS_TO_RETURN;
            }
            case 96: {
                return CLIENT_SIDE_CLIENT_LOOP;
            }
            case 97: {
                return CLIENT_SIDE_REFERRAL_LIMIT_EXCEEDED;
            }
            case 118: {
                return CANCELED;
            }
            case 119: {
                return NO_SUCH_OPERATION;
            }
            case 120: {
                return TOO_LATE;
            }
            case 121: {
                return CANNOT_CANCEL;
            }
            case 122: {
                return ASSERTION_FAILED;
            }
            case 123: {
                return AUTHORIZATION_DENIED;
            }
            case 16654: {
                return NO_OPERATION;
            }
        }
        return OTHER;
    }

    public Message getResultCodeName() {
        return this.resultCodeName;
    }

    public String toString() {
        return this.resultCodeName.toString();
    }
}

