/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public enum WritabilityMode {
    ENABLED("enabled"),
    DISABLED("disabled"),
    INTERNAL_ONLY("internal-only");

    private String modeName;

    private WritabilityMode(String modeName) {
        this.modeName = modeName;
    }

    public static WritabilityMode modeForName(String modeName) {
        String lowerName = StaticUtils.toLowerCase(modeName);
        if (lowerName.equals("enabled")) {
            return ENABLED;
        }
        if (lowerName.equals("disabled")) {
            return DISABLED;
        }
        if (lowerName.equals("internal-only")) {
            return INTERNAL_ONLY;
        }
        return null;
    }

    public String toString() {
        return this.modeName;
    }
}

