/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.StringArgument;

public class ArgumentParser {
    private StringArgument filePropertiesPathArgument;
    private BooleanArgument noPropertiesFileArgument;
    private Argument usageArgument;
    private Argument versionArgument;
    private ArrayList<String> trailingArguments;
    private boolean allowsTrailingArguments;
    private boolean longArgumentsCaseSensitive;
    private boolean usageOrVersionDisplayed;
    private boolean versionPresent;
    private HashMap<Character, Argument> shortIDMap;
    private HashMap<String, Argument> argumentMap;
    private HashMap<String, Argument> longIDMap;
    private int maxTrailingArguments;
    private int minTrailingArguments;
    private LinkedList<Argument> argumentList;
    private OutputStream usageOutputStream;
    private String mainClassName;
    private Message toolDescription;
    private String trailingArgsDisplayName;
    private String[] rawArguments;
    protected Set<ArgumentGroup> argumentGroups;
    protected ArgumentGroup defaultArgGroup = new ArgumentGroup(Message.EMPTY, Integer.MAX_VALUE);
    protected ArgumentGroup ldapArgGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_LDAP_CONNECTION_ARGS.get(), -2147483646);
    protected ArgumentGroup ioArgGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_IO_ARGS.get(), -2147483647);
    protected ArgumentGroup generalArgGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_GENERAL_ARGS.get(), Integer.MIN_VALUE);
    private static final String INDENT = "    ";
    private static final int MAX_LENGTH = SetupUtils.isWindows() ? 79 : 80;

    public ArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.allowsTrailingArguments = false;
        this.usageOrVersionDisplayed = false;
        this.versionPresent = false;
        this.trailingArgsDisplayName = null;
        this.maxTrailingArguments = 0;
        this.minTrailingArguments = 0;
        this.trailingArguments = new ArrayList();
        this.rawArguments = null;
        this.usageArgument = null;
        this.filePropertiesPathArgument = null;
        this.noPropertiesFileArgument = null;
        this.usageOutputStream = System.out;
        this.initGroups();
    }

    public ArgumentParser(String mainClassName, Message toolDescription, boolean longArgumentsCaseSensitive, boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName) {
        this.mainClassName = mainClassName;
        this.toolDescription = toolDescription;
        this.longArgumentsCaseSensitive = longArgumentsCaseSensitive;
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
        this.argumentList = new LinkedList();
        this.argumentMap = new HashMap();
        this.shortIDMap = new HashMap();
        this.longIDMap = new HashMap();
        this.trailingArguments = new ArrayList();
        this.usageOrVersionDisplayed = false;
        this.versionPresent = false;
        this.rawArguments = null;
        this.usageArgument = null;
        this.usageOutputStream = System.out;
        this.initGroups();
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public Message getToolDescription() {
        return this.toolDescription;
    }

    public boolean allowsTrailingArguments() {
        return this.allowsTrailingArguments;
    }

    public int getMinTrailingArguments() {
        return this.minTrailingArguments;
    }

    public int getMaxTrailingArguments() {
        return this.maxTrailingArguments;
    }

    public LinkedList<Argument> getArgumentList() {
        return this.argumentList;
    }

    public Argument getArgument(String name) {
        return this.argumentMap.get(name);
    }

    public HashMap<Character, Argument> getArgumentsByShortID() {
        return this.shortIDMap;
    }

    public Argument getArgumentForShortID(Character shortID) {
        return this.shortIDMap.get(shortID);
    }

    public HashMap<String, Argument> getArgumentsByLongID() {
        return this.longIDMap;
    }

    public Argument getArgumentForLongID(String longID) {
        return this.longIDMap.get(longID);
    }

    public ArrayList<String> getTrailingArguments() {
        return this.trailingArguments;
    }

    public String[] getRawArguments() {
        return this.rawArguments;
    }

    public void setDefaultArgumentGroupDescription(Message description) {
        this.defaultArgGroup.setDescription(description);
    }

    public void setLdapArgumentGroupDescription(Message description) {
        this.ldapArgGroup.setDescription(description);
    }

    public void setInputOutputArgumentGroupDescription(Message description) {
        this.ioArgGroup.setDescription(description);
    }

    public void setGeneralArgumentGroupDescription(Message description) {
        this.generalArgGroup.setDescription(description);
    }

    public void addArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, null);
    }

    public void addDefaultArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.defaultArgGroup);
    }

    public void addLdapConnectionArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.ldapArgGroup);
    }

    public void addInputOutputArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.ioArgGroup);
    }

    public void addGeneralArgument(Argument argument) throws ArgumentException {
        this.addArgument(argument, this.generalArgGroup);
    }

    public void addArgument(Argument argument, ArgumentGroup group) throws ArgumentException {
        String longID;
        Character shortID = argument.getShortIdentifier();
        if (shortID != null && this.shortIDMap.containsKey(shortID)) {
            String conflictingName = this.shortIDMap.get(shortID).getName();
            Message message = UtilityMessages.ERR_ARGPARSER_DUPLICATE_SHORT_ID.get(argument.getName(), String.valueOf(shortID), conflictingName);
            throw new ArgumentException(message);
        }
        if (this.versionArgument != null && shortID != null && shortID.equals(this.versionArgument.getShortIdentifier())) {
            try {
                this.versionArgument = new BooleanArgument("version", null, "version", ToolMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get());
                this.generalArgGroup.addArgument(this.versionArgument);
            }
            catch (ArgumentException conflictingName) {
                // empty catch block
            }
        }
        if ((longID = argument.getLongIdentifier()) != null) {
            if (!this.longArgumentsCaseSensitive) {
                longID = StaticUtils.toLowerCase(longID);
            }
            if (this.longIDMap.containsKey(longID)) {
                String conflictingName = this.longIDMap.get(longID).getName();
                Message message = UtilityMessages.ERR_ARGPARSER_DUPLICATE_LONG_ID.get(argument.getName(), argument.getLongIdentifier(), conflictingName);
                throw new ArgumentException(message);
            }
        }
        if (shortID != null) {
            this.shortIDMap.put(shortID, argument);
        }
        if (longID != null) {
            this.longIDMap.put(longID, argument);
        }
        this.argumentList.add(argument);
        if (group == null) {
            group = this.getStandardGroup(argument);
        }
        group.addArgument(argument);
        this.argumentGroups.add(group);
    }

    public void setUsageArgument(Argument argument) {
        this.usageArgument = argument;
        this.usageOutputStream = System.out;
    }

    public void setUsageArgument(Argument argument, OutputStream outputStream) {
        this.usageArgument = argument;
        this.usageOutputStream = outputStream;
    }

    public void setFilePropertiesArgument(StringArgument argument) {
        this.filePropertiesPathArgument = argument;
    }

    public void setNoPropertiesFileArgument(BooleanArgument argument) {
        this.noPropertiesFileArgument = argument;
    }

    public void parseArguments(String[] rawArguments) throws ArgumentException {
        this.parseArguments(rawArguments, null);
    }

    public void parseArguments(String[] rawArguments, String propertiesFile, boolean requirePropertiesFile) throws ArgumentException {
        Properties argumentProperties;
        block2: {
            this.rawArguments = rawArguments;
            argumentProperties = null;
            try {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(propertiesFile);
                p.load(fis);
                fis.close();
                argumentProperties = p;
            }
            catch (Exception e) {
                if (!requirePropertiesFile) break block2;
                Message message = UtilityMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get(String.valueOf(propertiesFile), StaticUtils.getExceptionMessage(e));
                throw new ArgumentException(message, (Throwable)e);
            }
        }
        this.parseArguments(rawArguments, argumentProperties);
    }

    public void parseArguments(String[] rawArguments, Properties argumentProperties) throws ArgumentException {
        this.rawArguments = rawArguments;
        boolean inTrailingArgs = false;
        int numArguments = rawArguments.length;
        for (int i = 0; i < numArguments; ++i) {
            String argValue;
            String arg = rawArguments[i];
            if (inTrailingArgs) {
                this.trailingArguments.add(arg);
                if (this.maxTrailingArguments <= 0 || this.trailingArguments.size() <= this.maxTrailingArguments) continue;
                Message message = UtilityMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get(this.maxTrailingArguments);
                throw new ArgumentException(message);
            }
            if (arg.equals("--")) {
                inTrailingArgs = true;
                continue;
            }
            if (arg.startsWith("--")) {
                Argument a;
                String argName = arg.substring(2);
                argValue = null;
                int equalPos = argName.indexOf(61);
                if (equalPos >= 0) {
                    if (equalPos == 0) {
                        Message message = UtilityMessages.ERR_ARGPARSER_LONG_ARG_WITHOUT_NAME.get(arg);
                        throw new ArgumentException(message);
                    }
                    argValue = argName.substring(equalPos + 1);
                    argName = argName.substring(0, equalPos);
                }
                String origArgName = argName;
                if (!this.longArgumentsCaseSensitive) {
                    argName = StaticUtils.toLowerCase(argName);
                }
                if ((a = this.longIDMap.get(argName)) == null) {
                    if (argName.equals("help")) {
                        try {
                            this.getUsage(this.usageOutputStream);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    if (argName.equals("version")) {
                        this.usageOrVersionDisplayed = true;
                        this.versionPresent = true;
                        try {
                            DirectoryServer.printVersion(this.usageOutputStream);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return;
                    }
                    Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_LONG_ID.get(origArgName);
                    throw new ArgumentException(message);
                }
                a.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception message) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    Message message;
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message2 = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_LONG_ID.get(origArgName);
                            throw new ArgumentException(message2);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        message = UtilityMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_LONG_ID.get(argValue, origArgName, invalidReason.toString());
                        throw new ArgumentException(message);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        message = UtilityMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_LONG_ID.get(origArgName);
                        throw new ArgumentException(message);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                Message message = UtilityMessages.ERR_ARGPARSER_ARG_FOR_LONG_ID_DOESNT_TAKE_VALUE.get(origArgName);
                throw new ArgumentException(message);
            }
            if (arg.startsWith("-")) {
                if (arg.equals("-")) {
                    Message message = UtilityMessages.ERR_ARGPARSER_INVALID_DASH_AS_ARGUMENT.get();
                    throw new ArgumentException(message);
                }
                char argCharacter = arg.charAt(1);
                argValue = arg.length() > 2 ? arg.substring(2) : null;
                Argument a = this.shortIDMap.get(Character.valueOf(argCharacter));
                if (a == null) {
                    if (argCharacter == '?') {
                        try {
                            this.getUsage(this.usageOutputStream);
                        }
                        catch (Exception origArgName) {
                            // empty catch block
                        }
                        return;
                    }
                    if (argCharacter == 'V' && !this.shortIDMap.containsKey(Character.valueOf('V'))) {
                        this.usageOrVersionDisplayed = true;
                        this.versionPresent = true;
                        try {
                            DirectoryServer.printVersion(this.usageOutputStream);
                        }
                        catch (Exception origArgName) {
                            // empty catch block
                        }
                        return;
                    }
                    Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                    throw new ArgumentException(message);
                }
                a.setPresent(true);
                if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception message) {
                        // empty catch block
                    }
                    return;
                }
                if (a.needsValue()) {
                    Message message;
                    MessageBuilder invalidReason;
                    if (argValue == null) {
                        if (i + 1 == numArguments) {
                            Message message3 = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                            throw new ArgumentException(message3);
                        }
                        argValue = rawArguments[++i];
                    }
                    if (!a.valueIsAcceptable(argValue, invalidReason = new MessageBuilder())) {
                        message = UtilityMessages.ERR_ARGPARSER_VALUE_UNACCEPTABLE_FOR_SHORT_ID.get(argValue, String.valueOf(argCharacter), invalidReason.toString());
                        throw new ArgumentException(message);
                    }
                    if (a.hasValue() && !a.isMultiValued()) {
                        message = UtilityMessages.ERR_ARGPARSER_NOT_MULTIVALUED_FOR_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message);
                    }
                    a.addValue(argValue);
                    continue;
                }
                if (argValue == null) continue;
                int valueLength = argValue.length();
                for (int j = 0; j < valueLength; ++j) {
                    char c = argValue.charAt(j);
                    Argument b = this.shortIDMap.get(Character.valueOf(c));
                    if (b == null) {
                        Message message = UtilityMessages.ERR_ARGPARSER_NO_ARGUMENT_WITH_SHORT_ID.get(String.valueOf(argCharacter));
                        throw new ArgumentException(message);
                    }
                    if (b.needsValue()) {
                        Message message = UtilityMessages.ERR_ARGPARSER_CANT_MIX_ARGS_WITH_VALUES.get(String.valueOf(argCharacter), argValue, String.valueOf(c));
                        throw new ArgumentException(message);
                    }
                    b.setPresent(true);
                    if (this.usageArgument == null || !this.usageArgument.getName().equals(b.getName())) continue;
                    try {
                        this.getUsage(this.usageOutputStream);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                continue;
            }
            if (this.allowsTrailingArguments) {
                inTrailingArgs = true;
                this.trailingArguments.add(arg);
                continue;
            }
            Message message = UtilityMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get(arg);
            throw new ArgumentException(message);
        }
        if (this.allowsTrailingArguments && this.minTrailingArguments > 0 && this.trailingArguments.size() < this.minTrailingArguments) {
            Message message = UtilityMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get(this.minTrailingArguments);
            throw new ArgumentException(message);
        }
        if (argumentProperties == null) {
            argumentProperties = this.checkExternalProperties();
        }
        for (Argument a : this.argumentList) {
            if (!a.isPresent() && argumentProperties != null && a.getPropertyName() != null) {
                String value = argumentProperties.getProperty(a.getPropertyName().toLowerCase());
                MessageBuilder invalidReason = new MessageBuilder();
                if (value != null) {
                    Boolean addValue = true;
                    if (!(a instanceof BooleanArgument)) {
                        addValue = a.valueIsAcceptable(value, invalidReason);
                    }
                    if (addValue.booleanValue()) {
                        a.addValue(value);
                        if (a.needsValue()) {
                            a.setPresent(true);
                        }
                        a.setValueSetByProperty(true);
                    }
                }
            }
            if (a.isPresent() || !a.needsValue()) continue;
            if (a.getDefaultValue() != null) {
                a.addValue(a.getDefaultValue());
            }
            if (a.hasValue() || !a.isRequired()) continue;
            Message message = UtilityMessages.ERR_ARGPARSER_NO_VALUE_FOR_REQUIRED_ARG.get(a.getName());
            throw new ArgumentException(message);
        }
    }

    protected Properties checkExternalProperties() throws ArgumentException {
        if (this.noPropertiesFileArgument != null && this.noPropertiesFileArgument.isPresent()) {
            return null;
        }
        if (this.filePropertiesPathArgument == null) {
            return null;
        }
        String propertiesFilePath = null;
        if (this.filePropertiesPathArgument.isPresent()) {
            propertiesFilePath = this.filePropertiesPathArgument.getValue();
        } else {
            String userDir = System.getProperty("user.home");
            propertiesFilePath = this.findPropertiesFile(userDir + File.separator + ".opendj");
            if (propertiesFilePath == null) {
                String instanceDir = DirectoryServer.getInstanceRoot();
                propertiesFilePath = this.findPropertiesFile(instanceDir + File.separator + "config");
            }
        }
        if (propertiesFilePath == null) {
            return null;
        }
        Properties argumentProperties = new Properties();
        String scriptName = System.getProperty("org.opends.server.scriptName");
        try {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(propertiesFilePath);
            p.load(fis);
            fis.close();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String currentPropertyName;
                String propertyName = currentPropertyName = (String)e.nextElement();
                if (scriptName != null) {
                    if (currentPropertyName.startsWith(scriptName)) {
                        propertyName = currentPropertyName.substring(scriptName.length() + 1);
                    } else if (p.containsKey(scriptName + "." + currentPropertyName)) continue;
                }
                argumentProperties.setProperty(propertyName.toLowerCase(), p.getProperty(currentPropertyName));
            }
        }
        catch (Exception e) {
            Message message = UtilityMessages.ERR_ARGPARSER_CANNOT_READ_PROPERTIES_FILE.get(String.valueOf(propertiesFilePath), StaticUtils.getExceptionMessage(e));
            throw new ArgumentException(message, (Throwable)e);
        }
        return argumentProperties;
    }

    private String findPropertiesFile(String directory) {
        File f = new File(directory, "tools.properties");
        if (f.exists() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public void getUsage(StringBuilder buffer) {
        String scriptName;
        this.usageOrVersionDisplayed = true;
        if (this.toolDescription != null && this.toolDescription.length() > 0) {
            buffer.append(StaticUtils.wrapText(this.toolDescription.toString(), MAX_LENGTH - 1));
            buffer.append(ServerConstants.EOL);
            buffer.append(ServerConstants.EOL);
        }
        if ((scriptName = System.getProperty("org.opends.server.scriptName")) == null || scriptName.length() == 0) {
            buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE_JAVA_CLASSNAME.get(this.mainClassName));
        } else {
            buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE_JAVA_SCRIPTNAME.get(scriptName));
        }
        if (this.allowsTrailingArguments) {
            if (this.trailingArgsDisplayName == null) {
                buffer.append(" ");
                buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE_TRAILINGARGS.get());
            } else {
                buffer.append(" ");
                buffer.append(this.trailingArgsDisplayName);
            }
        }
        buffer.append(ServerConstants.EOL);
        buffer.append(UtilityMessages.INFO_SUBCMDPARSER_WHERE_OPTIONS_INCLUDE.get());
        buffer.append(ServerConstants.EOL);
        buffer.append(ServerConstants.EOL);
        Argument helpArgument = null;
        boolean printHeaders = this.printUsageGroupHeaders();
        for (ArgumentGroup argGroup : this.argumentGroups) {
            Message groupDesc;
            if (argGroup.containsArguments() && printHeaders && (groupDesc = argGroup.getDescription()) != null && !Message.EMPTY.equals(groupDesc)) {
                buffer.append(ServerConstants.EOL);
                buffer.append(StaticUtils.wrapText(groupDesc.toString(), MAX_LENGTH - 1));
                buffer.append(ServerConstants.EOL);
                buffer.append(ServerConstants.EOL);
            }
            for (Argument a : argGroup.getArguments()) {
                if (a.isHidden()) continue;
                if (this.usageArgument != null && this.usageArgument.getName().equals(a.getName())) {
                    helpArgument = a;
                    continue;
                }
                this.printArgumentUsage(a, buffer);
            }
        }
        if (helpArgument != null) {
            this.printArgumentUsage(helpArgument, buffer);
        } else {
            buffer.append(ServerConstants.EOL);
            buffer.append("-?");
            buffer.append(ServerConstants.EOL);
        }
    }

    public Message getUsageMessage() {
        StringBuilder buffer = new StringBuilder();
        this.getUsage(buffer);
        return Message.raw(buffer.toString(), new Object[0]);
    }

    public String getUsage() {
        StringBuilder buffer = new StringBuilder();
        this.getUsage(buffer);
        return buffer.toString();
    }

    public void getUsage(OutputStream outputStream) throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.getUsage(buffer);
        outputStream.write(buffer.toString().getBytes());
    }

    public boolean usageOrVersionDisplayed() {
        return this.usageOrVersionDisplayed;
    }

    private void printArgumentUsage(Argument a, StringBuilder buffer) {
        int indentLength = INDENT.length();
        Character shortID = a.getShortIdentifier();
        String longID = a.getLongIdentifier();
        if (shortID != null) {
            int currentLength = buffer.length();
            if (this.usageArgument.getName().equals(a.getName())) {
                buffer.append("-?, ");
            }
            buffer.append("-");
            buffer.append(shortID.charValue());
            if (a.needsValue() && longID == null) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            if (longID != null) {
                int lineLength;
                StringBuilder newBuffer = new StringBuilder();
                newBuffer.append(", --");
                newBuffer.append(longID);
                if (a.needsValue()) {
                    newBuffer.append(" ");
                    newBuffer.append(a.getValuePlaceholder());
                }
                if ((lineLength = buffer.length() - currentLength + newBuffer.length()) > MAX_LENGTH) {
                    buffer.append(ServerConstants.EOL);
                    buffer.append(newBuffer.toString());
                } else {
                    buffer.append(newBuffer.toString());
                }
            }
            buffer.append(ServerConstants.EOL);
        } else if (longID != null) {
            if (this.usageArgument.getName().equals(a.getName())) {
                buffer.append("-?, ");
            }
            buffer.append("--");
            buffer.append(longID);
            if (a.needsValue()) {
                buffer.append(" ");
                buffer.append(a.getValuePlaceholder());
            }
            buffer.append(ServerConstants.EOL);
        }
        Message description = a.getDescription();
        int descMaxLength = MAX_LENGTH - indentLength - 1;
        if (description.length() <= descMaxLength) {
            buffer.append(INDENT);
            buffer.append(description);
            buffer.append(ServerConstants.EOL);
        } else {
            String s = description.toString();
            while (s.length() > descMaxLength) {
                int spacePos = s.lastIndexOf(32, descMaxLength);
                if (spacePos > 0) {
                    buffer.append(INDENT);
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                spacePos = s.indexOf(32);
                if (spacePos > 0) {
                    buffer.append(INDENT);
                    buffer.append(s.substring(0, spacePos).trim());
                    s = s.substring(spacePos + 1).trim();
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(INDENT);
                buffer.append(s);
                s = "";
                buffer.append(ServerConstants.EOL);
            }
            if (s.length() > 0) {
                buffer.append(INDENT);
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
        if (a.needsValue() && a.getDefaultValue() != null && a.getDefaultValue().length() > 0) {
            buffer.append(INDENT);
            buffer.append(UtilityMessages.INFO_ARGPARSER_USAGE_DEFAULT_VALUE.get(a.getDefaultValue()).toString());
            buffer.append(ServerConstants.EOL);
        }
    }

    protected ArgumentGroup getStandardGroup(Argument argument) {
        ArgumentGroup group = this.isInputOutputArgument(argument) ? this.ioArgGroup : (this.isGeneralArgument(argument) ? this.generalArgGroup : (this.isLdapConnectionArgument(argument) ? this.ldapArgGroup : this.defaultArgGroup));
        return group;
    }

    protected boolean printUsageGroupHeaders() {
        int groupsContainingArgs = 0;
        for (ArgumentGroup argGroup : this.argumentGroups) {
            if (!argGroup.containsNonHiddenArguments()) continue;
            ++groupsContainingArgs;
        }
        return groupsContainingArgs > 1;
    }

    private void initGroups() {
        this.argumentGroups = new TreeSet<ArgumentGroup>();
        this.argumentGroups.add(this.defaultArgGroup);
        this.argumentGroups.add(this.ldapArgGroup);
        this.argumentGroups.add(this.generalArgGroup);
        this.argumentGroups.add(this.ioArgGroup);
        try {
            this.versionArgument = new BooleanArgument("version", Character.valueOf('V'), "version", ToolMessages.INFO_DESCRIPTION_PRODUCT_VERSION.get());
            this.generalArgGroup.addArgument(this.versionArgument);
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
    }

    private boolean isInputOutputArgument(Argument arg) {
        boolean io = false;
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            io = "verbose".equals(longId) || "quiet".equals(longId) || "no-prompt".equals(longId) || "propertiesFilePath".equals(longId) || "noPropertiesFile".equals(longId) || "script-friendly".equals(longId) || "dontWrap".equals(longId) || "encoding".equals(longId) || "displayCommand".equals(longId) || "commandFilePath".equals(longId) || "batchFilePath".equals(longId);
        }
        return io;
    }

    private boolean isLdapConnectionArgument(Argument arg) {
        boolean ldap = false;
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            ldap = "useSSL".equals(longId) || "useStartTLS".equals(longId) || "hostname".equals(longId) || "port".equals(longId) || "bindDN".equals(longId) || "bindPassword".equals(longId) || "bindPasswordFile".equals(longId) || "saslOption".equals(longId) || "trustAll".equals(longId) || "trustStorePath".equals(longId) || "trustStorePassword".equals(longId) || "trustStorePasswordFile".equals(longId) || "keyStorePath".equals(longId) || "keyStorePassword".equals(longId) || "keyStorePasswordFile".equals(longId) || "certNickname".equals(longId) || "referencedHostName".equals(longId) || "adminUID".equals(longId) || "adminPassword".equals(longId) || "adminPasswordFile".equals(longId) || "reportAuthzID".equals(longId) || "usePasswordPolicyControl".equals(longId) || "useSASLExternal".equals(longId) || "ldapVersion".equals(longId) || "connectTimeout".equals(longId);
        }
        return ldap;
    }

    private boolean isGeneralArgument(Argument arg) {
        boolean general = false;
        if (arg != null) {
            String longId = arg.getLongIdentifier();
            general = "help".equals(longId) || "version".equals(longId);
        }
        return general;
    }

    public boolean isUsageArgumentPresent() {
        boolean isUsageArgumentPresent = false;
        if (this.usageArgument != null) {
            isUsageArgumentPresent = this.usageArgument.isPresent();
        }
        return isUsageArgumentPresent;
    }

    public boolean isVersionArgumentPresent() {
        return this.versionPresent;
    }

    public static String getBindPassword(StringArgument clearArg, FileBasedArgument fileArg) {
        String pwd = clearArg.isPresent() ? clearArg.getValue() : (fileArg.isPresent() ? fileArg.getValue() : null);
        return pwd;
    }
}

