/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

public class BooleanArgument
extends Argument {
    public BooleanArgument(String name, Character shortIdentifier, String longIdentifier, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, false, false, false, null, String.valueOf(false), null, description);
    }

    @Override
    public boolean valueIsAcceptable(String valueString, MessageBuilder invalidReason) {
        invalidReason.append(UtilityMessages.ERR_BOOLEANARG_NO_VALUE_ALLOWED.get(this.getName()));
        return false;
    }

    @Override
    public final void addValue(String valueString) {
        if (valueString != null) {
            this.clearValues();
            super.addValue(valueString);
            super.setPresent(Boolean.valueOf(valueString));
        }
    }

    @Override
    public final void setPresent(boolean isPresent) {
        this.addValue(String.valueOf(isPresent));
    }
}

