/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.args;

import java.util.HashSet;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.UtilityMessages;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;

public class MultiChoiceArgument
extends Argument {
    private boolean caseSensitive;
    private HashSet<String> allowedValues;

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean needsValue, Message valuePlaceholder, HashSet<String> allowedValues, boolean caseSensitive, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, false, needsValue, valuePlaceholder, null, null, description);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public MultiChoiceArgument(String name, Character shortIdentifier, String longIdentifier, boolean isRequired, boolean isMultiValued, boolean needsValue, Message valuePlaceholder, String defaultValue, String propertyName, HashSet<String> allowedValues, boolean caseSensitive, Message description) throws ArgumentException {
        super(name, shortIdentifier, longIdentifier, isRequired, isMultiValued, needsValue, valuePlaceholder, defaultValue, propertyName, description);
        this.allowedValues = allowedValues;
        this.caseSensitive = caseSensitive;
    }

    public HashSet<String> getAllowedValues() {
        return this.allowedValues;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean valueIsAcceptable(String valueString, MessageBuilder invalidReason) {
        if (this.caseSensitive) {
            if (!this.allowedValues.contains(valueString)) {
                invalidReason.append(UtilityMessages.ERR_MCARG_VALUE_NOT_ALLOWED.get(this.getName(), valueString));
                return false;
            }
        } else if (!this.allowedValues.contains(StaticUtils.toLowerCase(valueString))) {
            invalidReason.append(UtilityMessages.ERR_MCARG_VALUE_NOT_ALLOWED.get(this.getName(), valueString));
            return false;
        }
        return true;
    }
}

