/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.ldap.InitialLdapContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.OpendsCertificateException;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.tools.ClientException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.ValidationCallback;

public abstract class ConsoleApplication {
    private final PrintStream err;
    private final BufferedReader in;
    private final PrintStream out;
    protected static final int CONFIRMATION_MAX_TRIES = 5;
    private static final String COMMENT_SHELL_UNIX = "# ";
    private static final String COMMENT_BATCH_WINDOWS = "rem ";
    protected static final String SHELL_COMMENT_SEPARATOR = SetupUtils.isWindows() ? "rem " : "# ";

    protected ConsoleApplication(BufferedReader in, PrintStream out, PrintStream err) {
        this.in = in != null ? in : new BufferedReader(new NullReader());
        this.out = NullOutputStream.wrapOrNullStream(out);
        this.err = NullOutputStream.wrapOrNullStream(err);
    }

    protected ConsoleApplication(InputStream in, OutputStream out, OutputStream err) {
        this.in = in != null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new NullReader());
        this.out = NullOutputStream.wrapOrNullStream(out);
        this.err = NullOutputStream.wrapOrNullStream(err);
    }

    public final boolean confirmAction(Message prompt, final boolean defaultValue) throws CLIException {
        if (!this.isInteractive()) {
            return defaultValue;
        }
        final Message yes = UtilityMessages.INFO_GENERAL_YES.get();
        final Message no = UtilityMessages.INFO_GENERAL_NO.get();
        final Message errMsg = UtilityMessages.ERR_CONSOLE_APP_CONFIRM.get(yes, no);
        prompt = UtilityMessages.INFO_MENU_PROMPT_CONFIRM.get(prompt, yes, no, defaultValue ? yes : no);
        ValidationCallback<Boolean> validator = new ValidationCallback<Boolean>(){

            @Override
            public Boolean validate(ConsoleApplication app, String input) {
                String ninput = input.toLowerCase().trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                if (no.toString().toLowerCase().startsWith(ninput)) {
                    return false;
                }
                if (yes.toString().toLowerCase().startsWith(ninput)) {
                    return true;
                }
                app.println();
                app.println(errMsg);
                app.println();
                return null;
            }
        };
        return this.readValidatedInput(prompt, validator, 5);
    }

    public final PrintStream getErrorStream() {
        return this.err;
    }

    public final BufferedReader getInputStream() {
        return this.in;
    }

    public final PrintStream getOutputStream() {
        return this.out;
    }

    public abstract boolean isAdvancedMode();

    public abstract boolean isInteractive();

    public abstract boolean isMenuDrivenMode();

    public abstract boolean isQuiet();

    public abstract boolean isScriptFriendly();

    public abstract boolean isVerbose();

    public final void pressReturnToContinue() {
        Message msg = UtilityMessages.INFO_MENU_PROMPT_RETURN_TO_CONTINUE.get();
        try {
            this.readLineOfInput(msg);
        }
        catch (CLIException cLIException) {
            // empty catch block
        }
    }

    public final void println() {
        this.err.println();
    }

    public final void println(Message msg) {
        this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
    }

    public final void print(Message msg) {
        this.err.print(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
    }

    public final void println(Message msg, int indent) {
        this.println(Style.NORMAL, msg, indent);
    }

    public final void println(Style msgStyle, Message msg, int indent) {
        if (!this.isQuiet()) {
            switch (msgStyle) {
                case TITLE: {
                    this.out.println();
                    this.out.println(">>>> " + StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case SUBTITLE: {
                    this.out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case NOTICE: {
                    this.out.println(StaticUtils.wrapText("* " + msg, ServerConstants.MAX_LINE_WIDTH, indent));
                    break;
                }
                case ERROR: {
                    this.out.println();
                    this.out.println(StaticUtils.wrapText("** " + msg, ServerConstants.MAX_LINE_WIDTH, indent));
                    this.out.println();
                    break;
                }
                case WARNING: {
                    this.out.println(StaticUtils.wrapText("[!] " + msg, ServerConstants.MAX_LINE_WIDTH, indent));
                    break;
                }
                default: {
                    this.out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH, indent));
                }
            }
        }
    }

    public final void printlnProgress() {
        if (!this.isQuiet()) {
            this.out.println();
        }
    }

    public final void printlnProgress(Message msg) {
        if (!this.isQuiet()) {
            this.out.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    public final void printProgress(Message msg) {
        if (!this.isQuiet()) {
            this.out.print(msg);
        }
    }

    public final void printProgressBar(int linePos, int progress) {
        if (!this.isQuiet()) {
            int spacesLeft = ServerConstants.MAX_LINE_WIDTH - linePos - 10;
            StringBuilder bar = new StringBuilder();
            if (progress != 0) {
                for (int i = 0; i < 50; ++i) {
                    if (i >= Math.abs(progress) / 2 || bar.length() >= spacesLeft) continue;
                    bar.append(".");
                }
            }
            bar.append(".   ");
            if (progress >= 0) {
                bar.append(progress).append("%     ");
            } else {
                bar.append("FAIL");
            }
            int endBuilder = linePos + bar.length();
            for (int i = 0; i < endBuilder; ++i) {
                bar.append("\b");
            }
            if (progress >= 100 || progress < 0) {
                bar.append(ServerConstants.EOL);
            }
            this.out.print(bar.toString());
        }
    }

    public final void printlnBatchProgress(String s) {
        if (!this.isQuiet()) {
            this.err.println(s);
        }
    }

    public final void printErrln(Message msg, int indent) {
        this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH, indent));
    }

    public final void printVerboseMessage(Message msg) {
        if (this.isVerbose() || this.isInteractive()) {
            this.err.println(StaticUtils.wrapText(msg, ServerConstants.MAX_LINE_WIDTH));
        }
    }

    public final String readLineOfInput(Message prompt) throws CLIException {
        if (prompt != null) {
            this.err.print(StaticUtils.wrapText(prompt, ServerConstants.MAX_LINE_WIDTH));
            this.err.print(" ");
        }
        try {
            String s = this.in.readLine();
            if (s == null) {
                throw CLIException.adaptInputException(new EOFException("End of input"));
            }
            return s;
        }
        catch (IOException e) {
            throw CLIException.adaptInputException(e);
        }
    }

    public final String readInput(Message prompt, String defaultValue, Style msgStyle) throws CLIException {
        String answer = null;
        Message messageToDisplay = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), defaultValue);
        if (msgStyle == Style.TITLE) {
            this.println();
        }
        this.print(messageToDisplay);
        this.out.print(" ");
        try {
            answer = this.in.readLine();
        }
        catch (IOException e) {
            throw CLIException.adaptInputException(e);
        }
        if (msgStyle == Style.TITLE || msgStyle == Style.SUBTITLE) {
            this.println();
        }
        if ("".equals(answer)) {
            if (defaultValue == null) {
                this.println(QuickSetupMessages.INFO_ERROR_EMPTY_RESPONSE.get());
            } else {
                return defaultValue;
            }
        }
        return answer;
    }

    public String readInput(Message prompt, String defaultValue) throws CLIException {
        String response;
        block2: {
            while (true) {
                if (defaultValue != null) {
                    prompt = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), defaultValue);
                }
                if (!"".equals(response = this.readLineOfInput(prompt))) break block2;
                if (defaultValue != null) break;
                this.println(QuickSetupMessages.INFO_ERROR_EMPTY_RESPONSE.get());
            }
            return defaultValue;
        }
        return response;
    }

    public String readInput(Message prompt, String defaultValue, Logger logger) {
        String s = defaultValue;
        try {
            s = this.readInput(prompt, defaultValue);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    public final String readPassword(Message prompt) throws CLIException {
        char[] pwChars;
        this.err.print(StaticUtils.wrapText(prompt + " ", ServerConstants.MAX_LINE_WIDTH));
        try {
            pwChars = PasswordReader.readPassword();
        }
        catch (Exception e) {
            throw CLIException.adaptInputException(e);
        }
        return new String(pwChars);
    }

    protected final String readPassword(Message prompt, Logger logger) {
        String pwd = null;
        try {
            pwd = this.readPassword(prompt);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return pwd;
    }

    public final int readPort(Message prompt, final int defaultValue) throws CLIException {
        ValidationCallback<Integer> callback = new ValidationCallback<Integer>(){

            @Override
            public Integer validate(ConsoleApplication app, String input) throws CLIException {
                String ninput = input.trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                try {
                    int i = Integer.parseInt(ninput);
                    if (i < 1 || i > 65535) {
                        throw new NumberFormatException();
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    app.println();
                    app.println(UtilityMessages.ERR_LDAP_CONN_BAD_PORT_NUMBER.get(ninput));
                    app.println();
                    return null;
                }
            }
        };
        if (defaultValue != -1) {
            prompt = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), String.valueOf(defaultValue));
        }
        return this.readValidatedInput(prompt, callback, 5);
    }

    protected Message getMessageForException(NamingException ne, String hostPort) {
        return Utils.getMessageForException(ne, hostPort);
    }

    protected int askPort(Message prompt, int defaultValue, Logger logger) {
        int port = -1;
        while (port == -1) {
            try {
                port = this.readPort(prompt, defaultValue);
            }
            catch (CLIException ce) {
                port = -1;
                logger.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
        }
        return port;
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator) throws CLIException {
        String response;
        T value;
        while ((value = validator.validate(this, response = this.readLineOfInput(prompt))) == null) {
        }
        return value;
    }

    public final <T> T readValidatedInput(Message prompt, ValidationCallback<T> validator, int maxTries) throws CLIException {
        for (int nTries = 0; nTries < maxTries; ++nTries) {
            String response = this.readLineOfInput(prompt);
            T value = validator.validate(this, response);
            if (value == null) continue;
            return value;
        }
        throw new CLIException(UtilityMessages.ERR_TRIES_LIMIT_REACHED.get(maxTries));
    }

    protected final boolean askConfirmation(Message prompt, boolean defaultValue, Logger logger) throws CLIException {
        boolean v = defaultValue;
        boolean done = false;
        int nTries = 0;
        while (!done && nTries < 5) {
            ++nTries;
            try {
                v = this.confirmAction(prompt, defaultValue);
                done = true;
            }
            catch (CLIException ce) {
                if (ce.getMessageObject().getDescriptor().equals(UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED) || ce.getMessageObject().getDescriptor().equals(UtilityMessages.ERR_TRIES_LIMIT_REACHED)) {
                    throw ce;
                }
                logger.log(Level.WARNING, "Error reading input: " + ce, ce);
                this.println();
            }
        }
        if (!done) {
            throw new CLIException(UtilityMessages.ERR_CONFIRMATION_TRIES_LIMIT_REACHED.get(5));
        }
        return v;
    }

    protected InitialLdapContext createAdministrativeContext(String host, int port, boolean useSSL, boolean useStartTLS, String bindDn, String pwd, int connectTimeout, ApplicationTrustManager trustManager) throws NamingException {
        String ldapUrl = ConnectionUtils.getLDAPUrl(host, port, useSSL);
        InitialLdapContext ctx = useSSL ? Utils.createLdapsContext(ldapUrl, bindDn, pwd, connectTimeout, null, trustManager) : (useStartTLS ? Utils.createStartTLSContext(ldapUrl, bindDn, pwd, connectTimeout, null, trustManager, null) : Utils.createLdapContext(ldapUrl, bindDn, pwd, connectTimeout, null));
        if (!ConnectionUtils.connectedAsAdministrativeUser(ctx)) {
            throw new NoPermissionException(AdminToolMessages.ERR_NOT_ADMINISTRATIVE_USER.get().toString());
        }
        return ctx;
    }

    protected InitialLdapContext createInitialLdapContextInteracting(LDAPConnectionConsoleInteraction ci) throws ClientException {
        return this.createInitialLdapContextInteracting(ci, this.isInteractive() && ci.isTrustStoreInMemory());
    }

    protected InitialLdapContext createInitialLdapContextInteracting(LDAPConnectionConsoleInteraction ci, boolean promptForCertificate) throws ClientException {
        InitialLdapContext ctx;
        block20: {
            String hostName = ConnectionUtils.getHostNameForLdapUrl(ci.getHostName());
            Integer portNumber = ci.getPortNumber();
            String bindDN = ci.getBindDN();
            String bindPassword = ci.getBindPassword();
            ApplicationTrustManager trustManager = ci.getTrustManager();
            KeyManager keyManager = ci.getKeyManager();
            if (ci.useSSL()) {
                String ldapsUrl = "ldaps://" + hostName + ":" + portNumber;
                while (true) {
                    try {
                        ctx = ConnectionUtils.createLdapsContext(ldapsUrl, bindDN, bindPassword, ci.getConnectTimeout(), null, trustManager, keyManager);
                        ctx.reconnect(null);
                        break block20;
                    }
                    catch (NamingException e) {
                        OpendsCertificateException oce;
                        if (promptForCertificate && (oce = this.getCertificateRootException(e)) != null) {
                            String authType = null;
                            if (trustManager instanceof ApplicationTrustManager) {
                                ApplicationTrustManager appTrustManager = trustManager;
                                authType = appTrustManager.getLastRefusedAuthType();
                            }
                            if (ci.checkServerCertificate(oce.getChain(), authType, hostName)) {
                                trustManager = ci.getTrustManager();
                                continue;
                            }
                            return null;
                        }
                        if (e.getCause() != null) {
                            Message message;
                            if (!(this.isInteractive() || ci.isTrustAll() || this.getCertificateRootException(e) == null && !(e.getCause() instanceof SSLHandshakeException))) {
                                message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_NOT_TRUSTED.get(hostName, String.valueOf(portNumber));
                                throw new ClientException(91, message);
                            }
                            if (e.getCause() instanceof SSLException) {
                                message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT_WRONG_PORT.get(hostName, String.valueOf(portNumber));
                                throw new ClientException(91, message);
                            }
                        }
                        String hostPort = ServerDescriptor.getServerRepresentation(hostName, portNumber);
                        Message message = Utils.getMessageForException(e, hostPort);
                        throw new ClientException(91, message);
                    }
                    break;
                }
            }
            if (ci.useStartTLS()) {
                String ldapUrl = "ldap://" + hostName + ":" + portNumber;
                while (true) {
                    try {
                        ctx = ConnectionUtils.createStartTLSContext(ldapUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null, trustManager, keyManager, null);
                        ctx.reconnect(null);
                        break block20;
                    }
                    catch (NamingException e) {
                        if (promptForCertificate) {
                            OpendsCertificateException oce = this.getCertificateRootException(e);
                            if (oce != null) {
                                String authType = null;
                                if (trustManager instanceof ApplicationTrustManager) {
                                    ApplicationTrustManager appTrustManager = trustManager;
                                    authType = appTrustManager.getLastRefusedAuthType();
                                }
                                if (ci.checkServerCertificate(oce.getChain(), authType, hostName)) {
                                    trustManager = ci.getTrustManager();
                                    continue;
                                }
                                return null;
                            }
                            Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                            throw new ClientException(91, message);
                        }
                        Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                        throw new ClientException(91, message);
                    }
                    break;
                }
            }
            String ldapUrl = "ldap://" + hostName + ":" + portNumber;
            try {
                ctx = ConnectionUtils.createLdapContext(ldapUrl, bindDN, bindPassword, ConnectionUtils.getDefaultLDAPTimeout(), null);
                ctx.reconnect(null);
            }
            catch (NamingException e) {
                Message message = DSConfigMessages.ERR_DSCFG_ERROR_LDAP_FAILED_TO_CONNECT.get(hostName, String.valueOf(portNumber));
                throw new ClientException(91, message);
            }
        }
        return ctx;
    }

    protected String getCurrentOperationDateMessage() {
        String date = this.formatDateTimeStringForEquivalentCommand(new Date());
        return AdminToolMessages.INFO_OPERATION_START_TIME_MESSAGE.get(date).toString();
    }

    protected String formatDateTimeStringForEquivalentCommand(Date date) {
        String timeStr = null;
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            timeStr = dateFormat.format(date);
        }
        return timeStr;
    }

    protected String askForAdministratorUID(String defaultValue, Logger logger) {
        String s = defaultValue;
        try {
            s = this.readInput(AdminToolMessages.INFO_ADMINISTRATOR_UID_PROMPT.get(), defaultValue);
        }
        catch (CLIException ce) {
            logger.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    protected String askForAdministratorPwd(Logger logger) {
        String pwd = this.readPassword(AdminToolMessages.INFO_ADMINISTRATOR_PWD_PROMPT.get(), logger);
        return pwd;
    }

    private OpendsCertificateException getCertificateRootException(Throwable t) {
        OpendsCertificateException oce = null;
        while (t != null && oce == null) {
            if (!((t = t.getCause()) instanceof OpendsCertificateException)) continue;
            oce = (OpendsCertificateException)t;
        }
        return oce;
    }

    protected int askInteger(Message prompt, int defaultValue, Logger logger) {
        int newInt = -1;
        while (newInt == -1) {
            try {
                newInt = this.readInteger(prompt, defaultValue);
            }
            catch (CLIException ce) {
                newInt = -1;
                logger.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
        }
        return newInt;
    }

    public final int readInteger(Message prompt, final int defaultValue) throws CLIException {
        ValidationCallback<Integer> callback = new ValidationCallback<Integer>(){

            @Override
            public Integer validate(ConsoleApplication app, String input) throws CLIException {
                String ninput = input.trim();
                if (ninput.length() == 0) {
                    return defaultValue;
                }
                try {
                    int i = Integer.parseInt(ninput);
                    if (i < 1) {
                        throw new NumberFormatException();
                    }
                    return i;
                }
                catch (NumberFormatException e) {
                    app.println();
                    app.println(UtilityMessages.ERR_LDAP_CONN_BAD_INTEGER.get(ninput));
                    app.println();
                    return null;
                }
            }
        };
        if (defaultValue != -1) {
            prompt = UtilityMessages.INFO_PROMPT_SINGLE_DEFAULT.get(prompt.toString(), String.valueOf(defaultValue));
        }
        return this.readValidatedInput(prompt, callback, 5);
    }

    public static enum Style {
        TITLE,
        SUBTITLE,
        NOTICE,
        NORMAL,
        ERROR,
        WARNING;

    }

    private static final class NullReader
    extends Reader {
        private NullReader() {
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return -1;
        }
    }
}

