/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.http;

import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.UriBuilder;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.innate.http.SniConfigurator;
import org.glassfish.jersey.internal.PropertiesResolver;

public final class SSLParamConfigurator {
    private final URI uri;
    private final Optional<SniConfigurator> sniConfigurator;
    private static final SSLParamConfiguratorConfiguration DEFAULT_CONFIGURATION = new SSLParamConfiguratorConfiguration(){};

    private SSLParamConfigurator(Builder builder) {
        this.uri = builder.uri;
        this.sniConfigurator = builder.sniHostPrecedence == null ? SniConfigurator.createWhenHostHeader(this.uri, builder.sniHostNameHeader, builder.setAlways) : SniConfigurator.createWhenHostHeader(this.uri, builder.sniHostPrecedence, false);
    }

    public static Builder builder() {
        return new Builder(DEFAULT_CONFIGURATION);
    }

    public static Builder builder(SSLParamConfiguratorConfiguration configuration) {
        return new Builder(configuration);
    }

    public String getSNIHostName() {
        return this.sniConfigurator.isPresent() ? this.sniConfigurator.get().getHostName() : this.uri.getHost();
    }

    public URI toIPRequestUri() {
        String host = this.uri.getHost();
        try {
            InetAddress ip = InetAddress.getByName(host);
            Object hostAddress = ip instanceof Inet6Address ? "[" + ip.getHostAddress() + "]" : ip.getHostAddress();
            return UriBuilder.fromUri(this.uri).host((String)hostAddress).build(new Object[0]);
        }
        catch (UnknownHostException e) {
            return this.uri;
        }
    }

    public boolean isSNIRequired() {
        return this.sniConfigurator.isPresent();
    }

    public URI getSNIUri() {
        return this.sniConfigurator.isPresent() ? UriBuilder.fromUri(this.uri).host(this.getSNIHostName()).build(new Object[0]) : this.uri;
    }

    public void setSNIServerName(SSLEngine sslEngine) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslEngine));
    }

    public void setSNIServerName(SSLSocket sslSocket) {
        this.sniConfigurator.ifPresent(sni -> sni.setServerNames(sslSocket));
    }

    public void setSNIServerName(SSLParameters parameters) {
        this.sniConfigurator.ifPresent(sni -> sni.updateSSLParameters(parameters));
    }

    public void setEndpointIdentificationAlgorithm(SSLEngine sslEngine) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslEngine.setSSLParameters(sslParameters);
    }

    public static final class Builder {
        private URI uri;
        private String sniHostNameHeader = null;
        private String sniHostPrecedence = null;
        private boolean setAlways = false;
        private final SSLParamConfiguratorConfiguration configConfiguration;

        public Builder(SSLParamConfiguratorConfiguration configuration) {
            this.configConfiguration = configuration;
        }

        public Builder request(ClientRequest clientRequest) {
            this.sniHostNameHeader = Builder.getSniHostNameHeader(clientRequest.getHeaders());
            this.sniHostPrecedence = this.configConfiguration.resolveSniHostNameProperty(clientRequest);
            this.uri = clientRequest.getUri();
            return this;
        }

        public Builder configuration(Configuration configuration) {
            this.sniHostPrecedence = this.configConfiguration.getSniHostNameProperty(configuration);
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder headers(Map<String, List<Object>> httpHeaders) {
            this.sniHostNameHeader = Builder.getSniHostNameHeader(httpHeaders);
            return this;
        }

        public Builder setSNIAlways(boolean setAlways) {
            this.setAlways = setAlways;
            return this;
        }

        public Builder setSNIHostName(String hostName) {
            this.sniHostPrecedence = hostName;
            return this;
        }

        public Builder setSNIHostName(Configuration configuration) {
            return this.setSNIHostName(this.configConfiguration.getSniHostNameProperty(configuration));
        }

        public Builder setSNIHostName(PropertiesResolver resolver) {
            return this.setSNIHostName(this.configConfiguration.resolveSniHostNameProperty(resolver));
        }

        public SSLParamConfigurator build() {
            return new SSLParamConfigurator(this);
        }

        private static String getSniHostNameHeader(Map<String, List<Object>> httpHeaders) {
            List<Object> hostHeaders = httpHeaders.get("Host");
            if (hostHeaders == null || hostHeaders.get(0) == null) {
                return null;
            }
            String hostHeader = hostHeaders.get(0).toString();
            return hostHeader;
        }
    }

    public static interface SSLParamConfiguratorConfiguration {
        default public String getSniHostNameProperty(Configuration configuration) {
            Object property = configuration.getProperty("jersey.config.client.snihostname");
            if (property == null) {
                property = configuration.getProperty("jersey.config.client.snihostname".toLowerCase(Locale.ROOT));
            }
            return (String)property;
        }

        default public String resolveSniHostNameProperty(PropertiesResolver resolver) {
            String property = (String)((Object)resolver.resolveProperty("jersey.config.client.snihostname", String.class));
            if (property == null) {
                property = (String)((Object)resolver.resolveProperty("jersey.config.client.snihostname".toLowerCase(Locale.ROOT), String.class));
            }
            return property;
        }
    }
}

