/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.internal;

import jakarta.ws.rs.core.Configuration;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.innate.ConnectorConfiguration;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.internal.util.collection.Ref;

public abstract class HttpUrlConnectorConfiguration<C extends HttpUrlConnectorConfiguration<C>>
extends ConnectorConfiguration<C> {
    private static final Logger LOGGER = Logger.getLogger(HttpUrlConnectorConfiguration.class.getName());
    static final String ALLOW_RESTRICTED_HEADERS_SYSTEM_PROPERTY = "sun.net.http.allowRestrictedHeaders";
    protected static final HttpUrlConnectorProvider.ConnectionFactory DEFAULT_CONNECTION_FACTORY = new DefaultConnectionFactory();
    protected ConnectorConfiguration.NullableRef<HttpUrlConnectorProvider.ConnectionFactory> connectionFactory = ConnectorConfiguration.NullableRef.empty();
    protected Ref<Integer> chunkSize = ConnectorConfiguration.NullableRef.empty();
    Ref<Boolean> isRestrictedHeaderPropertySet = ConnectorConfiguration.NullableRef.empty();
    protected Ref<Boolean> useFixedLengthStreaming = ConnectorConfiguration.NullableRef.empty();
    protected Ref<Boolean> useSetMethodWorkaround = ConnectorConfiguration.NullableRef.empty();

    protected void preInit(Map<String, Object> properties) {
        this.connectionFactory.ifEmptySet(DEFAULT_CONNECTION_FACTORY);
        ((ConnectorConfiguration.NullableRef)this.chunkSize).ifEmptySet(4096);
        ((ConnectorConfiguration.NullableRef)this.useFixedLengthStreaming).ifEmptySet(Boolean.FALSE);
        ((ConnectorConfiguration.NullableRef)this.useSetMethodWorkaround).ifEmptySet(Boolean.FALSE);
        int computedChunkSize = ClientProperties.getValue(properties, this._prefixed("jersey.config.client.chunkedEncodingSize"), (Integer)this.chunkSize.get(), Integer.class);
        if (computedChunkSize < 0) {
            LOGGER.warning(LocalizationMessages.NEGATIVE_CHUNK_SIZE(computedChunkSize, this.chunkSize.get()));
        } else {
            this.chunkSize.set(computedChunkSize);
        }
        this.useFixedLengthStreaming(ClientProperties.getValue(properties, this._prefixed("jersey.config.client.httpUrlConnector.useFixedLengthStreaming"), (Boolean)this.useFixedLengthStreaming.get(), Boolean.class));
        this.useSetMethodWorkaround(ClientProperties.getValue(properties, this._prefixed("jersey.config.client.httpUrlConnection.setMethodWorkaround"), (Boolean)this.useSetMethodWorkaround.get(), Boolean.class));
    }

    private String _prefixed(String property) {
        return this.prefix.ifPresentOrElse("") + property;
    }

    public C connectionFactory(HttpUrlConnectorProvider.ConnectionFactory connectionFactory) {
        if (connectionFactory == null) {
            throw new NullPointerException(LocalizationMessages.NULL_INPUT_PARAMETER("connectionFactory"));
        }
        this.connectionFactory.set(connectionFactory);
        return (C)((HttpUrlConnectorConfiguration)this.self());
    }

    public C chunkSize(int chunkSize) {
        if (chunkSize < 0) {
            throw new IllegalArgumentException(LocalizationMessages.NEGATIVE_INPUT_PARAMETER("chunkSize"));
        }
        this.chunkSize.set(chunkSize);
        return (C)((HttpUrlConnectorConfiguration)this.self());
    }

    public C useFixedLengthStreaming(boolean use) {
        this.useFixedLengthStreaming.set(use);
        return (C)((HttpUrlConnectorConfiguration)this.self());
    }

    public C useSetMethodWorkaround(boolean use) {
        this.useSetMethodWorkaround.set(use);
        return (C)((HttpUrlConnectorConfiguration)this.self());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpUrlConnectorConfiguration that = (HttpUrlConnectorConfiguration)o;
        if (!this.chunkSize.equals(that.chunkSize)) {
            return false;
        }
        if (!this.useFixedLengthStreaming.equals(that.useFixedLengthStreaming)) {
            return false;
        }
        if (!this.useSetMethodWorkaround.equals(that.useSetMethodWorkaround)) {
            return false;
        }
        if (!this.isRestrictedHeaderPropertySet.equals(that.isRestrictedHeaderPropertySet)) {
            return false;
        }
        return this.connectionFactory.equals(that.connectionFactory);
    }

    public int hashCode() {
        return Objects.hash(this.connectionFactory, this.chunkSize, this.useFixedLengthStreaming, this.useSetMethodWorkaround, this.isRestrictedHeaderPropertySet);
    }

    ReadWrite rw() {
        ReadWrite readWrite = this instanceof ReadWrite ? ((ReadWrite)this).instance() : new ReadWrite();
        readWrite.setNonEmpty(this);
        return readWrite;
    }

    protected static class ReadWrite
    extends HttpUrlConnectorConfiguration<ReadWrite>
    implements ConnectorConfiguration.Read<ReadWrite> {
        protected ReadWrite() {
        }

        @Override
        public <X extends ConnectorConfiguration<?>> void setNonEmpty(X otherC) {
            HttpUrlConnectorConfiguration other = (HttpUrlConnectorConfiguration)otherC;
            ConnectorConfiguration.Read.super.setNonEmpty(other);
            this.connectionFactory.setNonEmpty(other.connectionFactory);
            ((ConnectorConfiguration.NullableRef)this.chunkSize).setNonEmpty((ConnectorConfiguration.NullableRef)other.chunkSize);
            ((ConnectorConfiguration.NullableRef)this.isRestrictedHeaderPropertySet).setNonEmpty((ConnectorConfiguration.NullableRef)other.isRestrictedHeaderPropertySet);
            ((ConnectorConfiguration.NullableRef)this.useFixedLengthStreaming).setNonEmpty((ConnectorConfiguration.NullableRef)other.useFixedLengthStreaming);
            ((ConnectorConfiguration.NullableRef)this.useSetMethodWorkaround).setNonEmpty((ConnectorConfiguration.NullableRef)other.useSetMethodWorkaround);
        }

        @Override
        public ReadWrite init() {
            ConnectorConfiguration.Read.super.init();
            this.preInit(Collections.emptyMap());
            this.isRestrictedHeaderPropertySet.set(Boolean.FALSE);
            return this.self();
        }

        ReadWrite fromClient(Configuration configuration) {
            ReadWrite clientConfiguration = (ReadWrite)this.copyFromClient(configuration);
            clientConfiguration.preInit(configuration.getProperties());
            this.isRestrictedHeaderPropertySet.set(Boolean.valueOf(AccessController.doPrivileged(PropertiesHelper.getSystemProperty(HttpUrlConnectorConfiguration.ALLOW_RESTRICTED_HEADERS_SYSTEM_PROPERTY, "false"))));
            LOGGER.config((Boolean)this.isRestrictedHeaderPropertySet.get() != false ? LocalizationMessages.RESTRICTED_HEADER_PROPERTY_SETTING_TRUE(HttpUrlConnectorConfiguration.ALLOW_RESTRICTED_HEADERS_SYSTEM_PROPERTY) : LocalizationMessages.RESTRICTED_HEADER_PROPERTY_SETTING_FALSE(HttpUrlConnectorConfiguration.ALLOW_RESTRICTED_HEADERS_SYSTEM_PROPERTY));
            return clientConfiguration;
        }

        ReadWrite fromRequest(ClientRequest request) {
            ReadWrite requestConfiguration = (ReadWrite)this.copyFromRequest(request);
            requestConfiguration.chunkSize(request.resolveProperty(this.prefixed("jersey.config.client.chunkedEncodingSize"), (Integer)requestConfiguration.chunkSize.get()));
            requestConfiguration.useFixedLengthStreaming(request.resolveProperty(this.prefixed("jersey.config.client.httpUrlConnector.useFixedLengthStreaming"), (Boolean)requestConfiguration.useFixedLengthStreaming.get()));
            requestConfiguration.useSetMethodWorkaround(request.resolveProperty(this.prefixed("jersey.config.client.httpUrlConnection.setMethodWorkaround"), (Boolean)requestConfiguration.useSetMethodWorkaround.get()));
            return requestConfiguration;
        }

        @Override
        public ReadWrite instance() {
            return new ReadWrite();
        }

        @Override
        public ReadWrite me() {
            return this;
        }

        public boolean isMethodWorkaround(ClientRequest request) {
            return request.resolveProperty(this.prefixed("jersey.config.client.httpUrlConnection.setMethodWorkaround"), (Boolean)this.useSetMethodWorkaround.get());
        }

        public boolean isPrefixed() {
            return !((String)this.prefix.get()).isEmpty();
        }

        public boolean isSslContextSupplier() {
            return this.sslContextSupplier.get() != null;
        }

        public Supplier<SSLContext> sslContext(ClientRequest request) {
            Supplier supplier = (Supplier)((Object)request.resolveProperty(this.prefixed("jersey.config.client.ssl.context.supplier"), Supplier.class));
            if (supplier == null) {
                supplier = (Supplier)this.self().sslContextSupplier.get();
            }
            return supplier;
        }

        @Override
        public ReadWrite self() {
            return this;
        }
    }

    private static class DefaultConnectionFactory
    implements HttpUrlConnectorProvider.ConnectionFactory {
        private DefaultConnectionFactory() {
        }

        @Override
        public HttpURLConnection getConnection(URL url) throws IOException {
            return this.connect(url, null);
        }

        @Override
        public HttpURLConnection getConnection(URL url, Proxy proxy) throws IOException {
            return this.connect(url, proxy);
        }

        private HttpURLConnection connect(URL url, Proxy proxy) throws IOException {
            return proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        }
    }
}

