/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.http;

import jakarta.ws.rs.core.Cookie;
import java.util.Objects;
import org.glassfish.jersey.http.VersionOptional;

public final class JerseyCookie
extends Cookie
implements VersionOptional {
    private final Integer version;

    private JerseyCookie(Builder builder) throws IllegalArgumentException {
        super(builder);
        this.version = builder.version;
    }

    @Override
    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != Cookie.class && obj.getClass() != JerseyCookie.class) {
            return false;
        }
        Cookie other = (Cookie)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getValue(), other.getValue())) {
            return false;
        }
        if (!Objects.equals(this.getVersion(), other.getVersion())) {
            return false;
        }
        if (!Objects.equals(this.getPath(), other.getPath())) {
            return false;
        }
        return Objects.equals(this.getDomain(), other.getDomain());
    }

    public static final class Builder
    extends Cookie.AbstractCookieBuilder<Builder> {
        private Integer version;

        public Builder(String name) {
            super(name);
        }

        @Override
        public Builder version(int version) {
            super.version(version);
            this.version = version;
            return this;
        }

        public Builder version(Integer version) {
            super.version(version == null ? 0 : version);
            this.version = version;
            return this;
        }

        @Override
        public Cookie build() {
            return new JerseyCookie(this);
        }
    }
}

