/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.innate;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.glassfish.jersey.innate.VirtualThreadSupport;
import org.glassfish.jersey.innate.virtual.LoomishExecutors;
import org.glassfish.jersey.innate.virtual.ThreadFactoryBuilder;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class VirtualThreadSupport {
    private static final LoomishExecutors VIRTUAL_THREADS = new Java21LoomishExecutors(Thread.ofVirtual().factory());
    private static final LoomishExecutors NON_VIRTUAL_THREADS = new NonLoomishExecutors(Executors.defaultThreadFactory());

    private VirtualThreadSupport() {
        throw new IllegalStateException();
    }

    public static boolean isVirtualThread() {
        return Thread.currentThread().isVirtual();
    }

    public static LoomishExecutors allowVirtual(boolean bl) {
        return bl ? VIRTUAL_THREADS : NON_VIRTUAL_THREADS;
    }

    public static LoomishExecutors allowVirtual(boolean bl, ThreadFactory threadFactory) {
        return bl ? new Java21LoomishExecutors(threadFactory) : new NonLoomishExecutors(threadFactory);
    }

    public static LoomishExecutors allowVirtual(boolean bl, ThreadFactoryBuilder threadFactoryBuilder) {
        return bl ? VirtualThreadSupport.loomish(threadFactoryBuilder) : VirtualThreadSupport.nonLoomish(threadFactoryBuilder);
    }

    private static LoomishExecutors nonLoomish(ThreadFactoryBuilder threadFactoryBuilder) {
        return new NonLoomishExecutors(Thread.ofPlatform().name(threadFactoryBuilder.prefix(), threadFactoryBuilder.start()).factory());
    }

    private static LoomishExecutors loomish(ThreadFactoryBuilder threadFactoryBuilder) {
        return new Java21LoomishExecutors(Thread.ofVirtual().name(threadFactoryBuilder.prefix(), threadFactoryBuilder.start()).factory());
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class NonLoomishExecutors
    implements LoomishExecutors {
        private final ThreadFactory threadFactory;

        private NonLoomishExecutors(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public ExecutorService newCachedThreadPool() {
            return Executors.newCachedThreadPool(this.getThreadFactory());
        }

        @Override
        public ExecutorService newFixedThreadPool(int n) {
            return Executors.newFixedThreadPool(n, this.getThreadFactory());
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public boolean isVirtual() {
            return false;
        }
    }
}

