/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jdk.connector.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.jersey.jdk.connector.internal.AsynchronousBodyInputStream;

class HttpResponse {
    private final String protocolVersion;
    private final int statusCode;
    private final String reasonPhrase;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> trailerHeaders = new HashMap<String, List<String>>(0);
    private final AsynchronousBodyInputStream bodyStream;
    private volatile boolean hasContent = true;

    HttpResponse(String protocolVersion, int statusCode, String reasonPhrase) {
        this.protocolVersion = protocolVersion;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.bodyStream = new AsynchronousBodyInputStream();
    }

    String getProtocolVersion() {
        return this.protocolVersion;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    String getReasonPhrase() {
        return this.reasonPhrase;
    }

    void setHasContent(boolean hasContent) {
        this.hasContent = hasContent;
    }

    boolean getHasContent() {
        return this.hasContent;
    }

    Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    List<String> getHeader(String name) {
        for (String headerName : this.headers.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return this.headers.get(headerName);
        }
        return null;
    }

    void addHeader(String name, String value) {
        List<String> values = this.getHeader(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.headers.put(name, values);
        }
        values.add(value);
    }

    List<String> getTrailerHeader(String name) {
        for (String headerName : this.trailerHeaders.keySet()) {
            if (!headerName.equalsIgnoreCase(name)) continue;
            return this.trailerHeaders.get(headerName);
        }
        return null;
    }

    void addTrailerHeader(String name, String value) {
        List<String> values = this.getTrailerHeader(name);
        if (values == null) {
            values = new ArrayList<String>(1);
            this.trailerHeaders.put(name, values);
        }
        values.add(value);
    }

    AsynchronousBodyInputStream getBodyStream() {
        return this.bodyStream;
    }
}

