/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.plugins.connectors.fusiondirectory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.ConnectionType;
import org.lsc.configuration.ValuesType;
import org.lsc.exception.LscServiceCommunicationException;
import org.lsc.exception.LscServiceException;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryDao;
import org.lsc.plugins.connectors.fusiondirectory.generated.Attribute;
import org.lsc.plugins.connectors.fusiondirectory.generated.Attributes;
import org.lsc.plugins.connectors.fusiondirectory.generated.AttributesTab;
import org.lsc.service.IService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FusionDirectoryAbstractService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionDirectoryAbstractService.class);
    protected static final String DN = "dn";
    protected FusionDirectoryDao dao;
    protected Class<IBean> beanClass;
    protected String entity;
    protected Optional<String> base;
    protected Optional<String> pivot;
    protected Optional<String> filter;
    protected Optional<String> allFilter;
    protected Optional<String> oneFilter;
    protected Optional<String> cleanFilter;
    protected Optional<String> template;
    protected Attributes attributesSettings;

    public Map<String, LscDatasets> getListPivots() throws LscServiceException {
        try {
            return this.getList();
        }
        catch (Exception e) {
            LOGGER.error(String.format("Error while getting pivot list (%s)", e));
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceCommunicationException(e);
        }
    }

    protected Map<String, LscDatasets> getList() throws LscServiceException {
        return this.getList(this.allFilter.isPresent() ? this.allFilter : this.filter);
    }

    private Map<String, LscDatasets> getList(Optional<String> computedFilter) throws LscServiceException {
        LinkedHashMap<String, LscDatasets> resources = new LinkedHashMap<String, LscDatasets>();
        ObjectNode root = this.dao.getList(this.entity, this.base, this.pivot, computedFilter);
        if (root != null) {
            Iterator iter = root.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Iterator iter2 = ((JsonNode)entry.getValue()).fields();
                while (iter2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iter2.next();
                    String pivotValue = ((ArrayNode)entry2.getValue()).get(0).textValue();
                    LscDatasets datasets = new LscDatasets();
                    datasets.put(DN, entry.getKey());
                    datasets.put((String)entry2.getKey(), (Object)pivotValue);
                    resources.put(pivotValue, datasets);
                }
            }
        }
        return resources;
    }

    protected Optional<Map.Entry<String, LscDatasets>> findFirstByPivots(LscDatasets pivots, boolean clean) throws LscServiceException {
        Optional<String> computedFilter;
        Optional<String> optional = computedFilter = clean ? this.cleanFilter : this.oneFilter;
        if (computedFilter.isPresent()) {
            for (String somePivot : pivots.getAttributesNames()) {
                computedFilter = Optional.of(Pattern.compile("\\{" + somePivot + "\\}", 2).matcher(computedFilter.get()).replaceAll(Matcher.quoteReplacement(pivots.getValueForFilter(somePivot.toLowerCase()))));
            }
        } else {
            StringBuilder pivotFilter = new StringBuilder("(|");
            for (String somePivot : pivots.getAttributesNames()) {
                pivotFilter.append("(").append(this.getPivotName()).append("=").append(pivots.getValueForFilter(somePivot.toLowerCase())).append(")");
            }
            pivotFilter.append(")");
            computedFilter = Optional.of(this.filter.map(f -> "(&" + f + pivotFilter.toString() + ")").orElse(pivotFilter.toString()));
        }
        return this.getList(computedFilter).entrySet().stream().findFirst();
    }

    protected String getPivotName() {
        return this.dao.getPivotName(this.pivot);
    }

    protected Optional<Map.Entry<String, LscDatasets>> findFirstByPivot(String pivotValue) throws LscServiceException {
        StringBuilder pivotFilter = new StringBuilder();
        pivotFilter.append("(").append(this.dao.getPivotName(this.pivot)).append("=").append(pivotValue).append(")");
        return this.getList(Optional.of(pivotFilter.toString())).entrySet().stream().findFirst();
    }

    protected boolean create(Map<String, List<Object>> modificationsItemsByHash) throws LscServiceException {
        return this.dao.create(this.entity, this.prepareAttributes(modificationsItemsByHash), this.template);
    }

    public boolean modify(String mainIdentifier, Map<String, List<Object>> modificationsItemsByHash) throws LscServiceException {
        Optional<Map.Entry<String, LscDatasets>> entry = this.findFirstByPivot(mainIdentifier);
        if (entry.isPresent()) {
            return this.dao.modify(this.entity, entry.get().getValue().getStringValueAttribute(DN), this.prepareAttributes(modificationsItemsByHash), this.prepareAttributesToDelete(modificationsItemsByHash));
        }
        throw new LscServiceException(String.format("Cannot find entity %s", mainIdentifier));
    }

    public boolean delete(String mainIdentifier) throws LscServiceException {
        Optional<Map.Entry<String, LscDatasets>> entry = this.findFirstByPivot(mainIdentifier);
        if (entry.isPresent()) {
            return this.dao.delete(this.entity, entry.get().getValue().getStringValueAttribute(DN));
        }
        throw new LscServiceException(String.format("Cannot find entity %s", mainIdentifier));
    }

    protected ValuesType getAttributes() {
        ValuesType flatAttributes = new ValuesType();
        for (AttributesTab attributesTab : this.attributesSettings.getTab()) {
            for (Attribute attribute : attributesTab.getAttribute()) {
                flatAttributes.getString().add(attribute.getValue());
            }
        }
        return flatAttributes;
    }

    protected Map<String, Object> getDetails(String dn) throws LscServiceException {
        return this.dao.getDetails(dn, this.entity, this.attributesSettings);
    }

    protected Optional<String> getStringParameter(String parameter) {
        return Optional.ofNullable(parameter).filter(f -> !f.trim().isEmpty());
    }

    private Map<String, Map<String, Object>> prepareAttributes(Map<String, List<Object>> modificationsItemsByHash) throws LscServiceException {
        HashMap<String, Map<String, Object>> attrs = new HashMap<String, Map<String, Object>>();
        for (String attribute : modificationsItemsByHash.keySet()) {
            TabAttribute tabAttribute = this.getTabAttribute(attribute);
            if (modificationsItemsByHash.get(attribute) instanceof ArrayList) {
                ArrayList list = (ArrayList)modificationsItemsByHash.get(attribute);
                if (list.isEmpty() && !tabAttribute.getAttribute().isMultiple() && !tabAttribute.isOption()) continue;
                if (attrs.get(tabAttribute.getTab()) == null) {
                    attrs.put(tabAttribute.getTab(), new HashMap());
                }
                if (tabAttribute.isOption()) {
                    String attributeShortName = tabAttribute.stripOptionFromAttributeName();
                    ((Map)attrs.get(tabAttribute.getTab())).put(attributeShortName, tabAttribute.getOptionValues(((Map)attrs.get(tabAttribute.getTab())).get(attributeShortName), list));
                    continue;
                }
                if (tabAttribute.getAttribute().isMultiple()) {
                    ((Map)attrs.get(tabAttribute.getTab())).put(tabAttribute.getAttribute().getValue(), list);
                    continue;
                }
                if (tabAttribute.getAttribute().getPasswordHash() != null) {
                    ((Map)attrs.get(tabAttribute.getTab())).put(tabAttribute.getAttribute().getValue(), this.getPasswordArray(list.get(0), tabAttribute.getAttribute().getPasswordHash()));
                    continue;
                }
                ((Map)attrs.get(tabAttribute.getTab())).put(tabAttribute.getAttribute().getValue(), list.get(0));
                continue;
            }
            throw new LscServiceException(String.format("%s is not a supported type for attribute %s", modificationsItemsByHash.get(attribute).getClass().toString(), attribute));
        }
        return attrs;
    }

    private List<String> prepareAttributesToDelete(Map<String, List<Object>> modificationsItemsByHash) throws LscServiceException {
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String attribute : modificationsItemsByHash.keySet()) {
            TabAttribute tabAttribute = this.getTabAttribute(attribute);
            if (modificationsItemsByHash.get(attribute) instanceof ArrayList) {
                if (!((ArrayList)modificationsItemsByHash.get(attribute)).isEmpty() || tabAttribute.getAttribute().isMultiple() || tabAttribute.isOption()) continue;
                toDelete.add(tabAttribute.getTab() + "/" + tabAttribute.getAttribute().getValue());
                continue;
            }
            throw new LscServiceException(String.format("%s is not a supported type for attribute %s", modificationsItemsByHash.get(attribute).getClass().toString(), attribute));
        }
        return toDelete;
    }

    private String[] getPasswordArray(Object somePassword, String passwordHash) {
        String userPassword = somePassword instanceof String ? (String)somePassword : (somePassword instanceof byte[] ? new String((byte[])somePassword) : somePassword.toString());
        String[] passwordArr = new String[]{passwordHash, userPassword, userPassword, "", ""};
        return passwordArr;
    }

    private TabAttribute getTabAttribute(String attribute) throws LscServiceException {
        TabAttribute tabAttribute = null;
        for (AttributesTab attributesTab : this.attributesSettings.getTab()) {
            for (Attribute someAttribute : attributesTab.getAttribute()) {
                if (!someAttribute.getValue().equalsIgnoreCase(attribute)) continue;
                tabAttribute = new TabAttribute(this, attributesTab.getName(), someAttribute);
            }
        }
        if (tabAttribute == null) {
            throw new LscServiceException(String.format("Cannot find tab for attribute %s", attribute));
        }
        return tabAttribute;
    }

    public Collection<Class<? extends ConnectionType>> getSupportedConnectionType() {
        ArrayList<Class<? extends ConnectionType>> list = new ArrayList<Class<? extends ConnectionType>>();
        return list;
    }

    private class TabAttribute {
        String tab;
        Attribute attribute;

        public TabAttribute(FusionDirectoryAbstractService fusionDirectoryAbstractService, String tab, Attribute attribute) {
            this.tab = tab;
            this.attribute = attribute;
        }

        public String getTab() {
            return this.tab;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public boolean isOption() {
            return FusionDirectoryDao.isOptionAttribute(this.attribute.getValue());
        }

        public String stripOptionFromAttributeName() {
            return FusionDirectoryDao.stripOptionFromAttributeName(this.attribute.getValue());
        }

        public Object getOptionValues(Object currentValues, ArrayList<?> list) {
            ArrayList<Object> newValues = new ArrayList<Object>();
            Matcher mopt = FusionDirectoryDao.PATTERN_ATTR_OPT.matcher(this.attribute.getValue());
            if (mopt.matches()) {
                String option = mopt.group(2);
                if (currentValues != null) {
                    if (currentValues instanceof String) {
                        newValues.add((String)currentValues);
                    } else if (currentValues instanceof List) {
                        newValues.addAll((List)currentValues);
                    }
                }
                for (Object value : list) {
                    newValues.add(option.toLowerCase() + ";" + (String)value);
                }
            }
            return newValues;
        }
    }
}

