/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.plugins.connectors.fusiondirectory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.jdk.connector.JdkConnectorProvider;
import org.lsc.exception.LscServiceException;
import org.lsc.plugins.connectors.fusiondirectory.beans.Login;
import org.lsc.plugins.connectors.fusiondirectory.beans.Tab;
import org.lsc.plugins.connectors.fusiondirectory.beans.Token;
import org.lsc.plugins.connectors.fusiondirectory.generated.Attribute;
import org.lsc.plugins.connectors.fusiondirectory.generated.Attributes;
import org.lsc.plugins.connectors.fusiondirectory.generated.AttributesTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionDirectoryDao {
    private static final String UID = "uid";
    private static final String DN = "dn";
    private static final String DEFAULT = "default";
    private static final String SESSION_TOKEN = "Session-Token";
    private static final String OBJECTS = "objects";
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionDirectoryDao.class);
    public static final Pattern PATTERN_ATTR_OPT = Pattern.compile("^(\\w+);(.*)$");
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 1000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 5000;
    private final String username;
    private final String password;
    private final int sessionLifetime;
    private final String directory;
    private WebTarget target;
    private ObjectMapper mapper = new ObjectMapper();
    private Map<String, Token> tokenCache;

    public FusionDirectoryDao(String url, String username, String password, int sessionLifetime, Optional<String> directory) {
        this.username = username;
        this.password = password;
        this.sessionLifetime = sessionLifetime;
        this.directory = this.getDirectory(directory);
        this.target = this.clientBuilder().build().target(url);
        this.tokenCache = new HashMap<String, Token>();
    }

    private JerseyClientBuilder clientBuilder() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.connectorProvider(new JdkConnectorProvider()).register(new JacksonFeature()).property("jersey.config.client.connectTimeout", 1000).property("jersey.config.client.readTimeout", 5000);
        return new JerseyClientBuilder().withConfig(clientConfig);
    }

    private String getDirectory(Optional<String> directory) {
        return directory.orElse(DEFAULT);
    }

    public String getPivotName(Optional<String> pivot) {
        return pivot.orElse(UID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token startSession() throws LscServiceException {
        try (Response response = null;){
            Login login = new Login();
            login.setUser(this.username);
            login.setPassword(this.password);
            login.setDirectory(this.directory);
            WebTarget currentTarget = this.target.path("login");
            LOGGER.info(String.format("Login to FusionDirectory %s as %s for thread %s ... ", currentTarget.getUri().toString(), this.username, Thread.currentThread().threadId()));
            response = currentTarget.request().post(Entity.entity(login, "application/json"));
            if (!FusionDirectoryDao.checkResponse(response)) {
                String errorMessage = String.format("Cannot log in Fusiondirectory, message: %s", response.readEntity(String.class));
                LOGGER.error(errorMessage);
                throw new LscServiceException(errorMessage);
            }
            Token token = new Token(response.readEntity(String.class).replaceAll("\n", "").replaceAll("\"", ""));
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession(Token token) {
        try (Response response = null;){
            WebTarget currentTarget = this.target.path("logout");
            LOGGER.info(String.format("Logout from FusionDirectory %s as %s for thread %s", currentTarget.getUri().toString(), this.username, Thread.currentThread().threadId()));
            response = currentTarget.request().header(SESSION_TOKEN, token.getSessionId()).post(Entity.json(null));
            if (!FusionDirectoryDao.checkResponse(response)) {
                String warnMessage = String.format("Cannot logout from Fusiondirectory, message: %s", response.readEntity(String.class));
                LOGGER.warn(warnMessage);
            }
            response.readEntity(String.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Token getToken(boolean resetSession) throws LscServiceException {
        if (resetSession) {
            LOGGER.info(String.format("Reset FusionDirectory session as %s for thread %s", this.username, Thread.currentThread().threadId()));
        }
        Map<String, Token> map = this.tokenCache;
        synchronized (map) {
            Token token = this.tokenCache.get(String.valueOf(Thread.currentThread().threadId()));
            if (token != null && token.hasExpired(this.sessionLifetime)) {
                LOGGER.info(String.format("Expire FusionDirectory session for thread %s after %s seconds.", Thread.currentThread().threadId(), this.sessionLifetime));
                this.closeSession(token);
                resetSession = true;
            }
            if (token == null || resetSession) {
                token = this.startSession();
                this.tokenCache.put(String.valueOf(Thread.currentThread().threadId()), token);
            }
            return token;
        }
    }

    private Response httpGet(WebTarget webTarget) throws LscServiceException {
        return this.httpGet(webTarget, false);
    }

    private Response httpGet(WebTarget webTarget, boolean resetSession) throws LscServiceException {
        Response response = webTarget.request().accept("application/json").header(SESSION_TOKEN, this.getToken(resetSession).getSessionId()).get(Response.class);
        if (!resetSession && Response.Status.fromStatusCode(response.getStatus()) == Response.Status.UNAUTHORIZED) {
            response.close();
            return this.httpGet(webTarget, true);
        }
        if (!FusionDirectoryDao.checkResponse(response)) {
            String errorMessage = String.format("status: %d, message: %s", response.getStatus(), response.readEntity(String.class));
            response.close();
            LOGGER.error(errorMessage);
            throw new LscServiceException(errorMessage);
        }
        return response;
    }

    private Response httpPost(WebTarget webTarget, Entity<?> entity) throws LscServiceException {
        return this.httpPost(webTarget, entity, false);
    }

    private Response httpPost(WebTarget webTarget, Entity<?> entity, boolean resetSession) throws LscServiceException {
        Response response = webTarget.request().header(SESSION_TOKEN, this.getToken(resetSession).getSessionId()).post(entity);
        if (!resetSession && Response.Status.fromStatusCode(response.getStatus()) == Response.Status.UNAUTHORIZED) {
            response.close();
            return this.httpPost(webTarget, entity, true);
        }
        if (!FusionDirectoryDao.checkResponse(response)) {
            String errorMessage = String.format("status: %d, message: %s", response.getStatus(), response.readEntity(String.class));
            response.close();
            LOGGER.error(errorMessage);
            throw new LscServiceException(errorMessage);
        }
        return response;
    }

    private Response httpPatch(WebTarget webTarget, Entity<?> entity) throws LscServiceException {
        return this.httpPatch(webTarget, entity, false);
    }

    private Response httpPatch(WebTarget webTarget, Entity<?> entity, boolean resetSession) throws LscServiceException {
        Response response = webTarget.request().header(SESSION_TOKEN, this.getToken(resetSession).getSessionId()).method("PATCH", entity);
        if (!resetSession && Response.Status.fromStatusCode(response.getStatus()) == Response.Status.UNAUTHORIZED) {
            response.close();
            return this.httpPatch(webTarget, entity, true);
        }
        if (!FusionDirectoryDao.checkResponse(response)) {
            String errorMessage = String.format("status: %d, message: %s", response.getStatus(), response.readEntity(String.class));
            LOGGER.error(errorMessage);
            response.close();
            throw new LscServiceException(errorMessage);
        }
        return response;
    }

    private Response httpPut(WebTarget webTarget, Entity<?> entity) throws LscServiceException {
        return this.httpPut(webTarget, entity, false);
    }

    private Response httpPut(WebTarget webTarget, Entity<?> entity, boolean resetSession) throws LscServiceException {
        Response response = webTarget.request().header(SESSION_TOKEN, this.getToken(resetSession).getSessionId()).put(entity);
        if (!resetSession && Response.Status.fromStatusCode(response.getStatus()) == Response.Status.UNAUTHORIZED) {
            response.close();
            return this.httpPut(webTarget, entity, true);
        }
        if (!FusionDirectoryDao.checkResponse(response)) {
            String errorMessage = String.format("status: %d, message: %s", response.getStatus(), response.readEntity(String.class));
            LOGGER.error(errorMessage);
            response.close();
            throw new LscServiceException(errorMessage);
        }
        return response;
    }

    private Response httpDelete(WebTarget webTarget) throws LscServiceException {
        return this.httpDelete(webTarget, false);
    }

    private Response httpDelete(WebTarget webTarget, boolean resetSession) throws LscServiceException {
        Response response = webTarget.request().header(SESSION_TOKEN, this.getToken(resetSession).getSessionId()).delete();
        if (!resetSession && Response.Status.fromStatusCode(response.getStatus()) == Response.Status.UNAUTHORIZED) {
            response.close();
            return this.httpDelete(webTarget, true);
        }
        if (!FusionDirectoryDao.checkResponse(response)) {
            String errorMessage = String.format("status: %d, message: %s", response.getStatus(), response.readEntity(String.class));
            response.close();
            LOGGER.error(errorMessage);
            throw new LscServiceException(errorMessage);
        }
        return response;
    }

    public ObjectNode getList(String entity, Optional<String> base, Optional<String> pivot, Optional<String> computedFilter) throws LscServiceException {
        try (Response response = null;){
            WebTarget currentTarget = this.target.path(OBJECTS).path(entity);
            if (base.isPresent()) {
                currentTarget = currentTarget.queryParam("base", base.get());
            }
            if (computedFilter.isPresent()) {
                currentTarget = currentTarget.queryParam("filter", computedFilter.get());
            }
            if (pivot.isPresent()) {
                currentTarget = currentTarget.queryParam("attrs[" + this.getPivotName(pivot) + "]", "*");
            }
            LOGGER.debug(String.format("Search %s from: %s with filter %s ", entity, currentTarget.getUri().toString(), computedFilter));
            ObjectNode objectNode = (ObjectNode)this.mapper.readTree(this.httpGet(currentTarget).readEntity(String.class));
            return objectNode;
        }
    }

    private static boolean checkResponse(Response response) {
        return Response.Status.Family.familyOf(response.getStatus()) == Response.Status.Family.SUCCESSFUL;
    }

    public Map<String, Object> getDetails(String dn, String entity, Attributes attributesSettings) throws LscServiceException {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put(DN, dn);
        List<Tab> tabs = this.getEntityTabs(dn, entity);
        for (AttributesTab attributesTab : attributesSettings.getTab()) {
            Optional<Tab> tab = tabs.stream().filter(p -> p.getClass_().equals(attributesTab.getName())).findFirst();
            if (!tab.isPresent()) {
                String errorMessage = String.format("Tab %s do not exists for object %s", attributesTab.getName(), entity);
                LOGGER.error(errorMessage);
                throw new LscServiceException(errorMessage);
            }
            if (!tab.get().getActive()) continue;
            WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn).path(attributesTab.getName());
            Response response = null;
            try {
                response = this.httpGet(currentTarget);
                Map raw = (Map)this.mapper.readValue(response.readEntity(String.class), Map.class);
                for (Attribute attribute : attributesTab.getAttribute()) {
                    if (FusionDirectoryDao.isOptionAttribute(attribute.getValue())) {
                        String shortAttributeName = FusionDirectoryDao.stripOptionFromAttributeName(attribute.getValue());
                        Object rawValues = raw.get(shortAttributeName);
                        if (rawValues == null) {
                            throw new LscServiceException(String.format("Attribute %s could not be found in tab %s", shortAttributeName, attributesTab.getName()));
                        }
                        List<String> value = this.filterAndStripOptionFromValues(attribute.getValue(), rawValues);
                        if (value == null) continue;
                        results.put(attribute.getValue(), value);
                        continue;
                    }
                    Object value = raw.get(attribute.getValue());
                    if (value == null) {
                        throw new LscServiceException(String.format("Attribute %s could not be found in tab %s", attribute.getValue(), attributesTab.getName()));
                    }
                    if (value instanceof String && ((String)value).isEmpty()) continue;
                    if (value instanceof Long) {
                        value = ((Long)value).toString();
                    }
                    results.put(attribute.getValue(), value);
                }
            }
            catch (JsonProcessingException e) {
                throw new LscServiceException((Exception)e);
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        return results;
    }

    public static boolean isOptionAttribute(String attribute) {
        return PATTERN_ATTR_OPT.matcher(attribute).matches();
    }

    public static String stripOptionFromAttributeName(String attribute) {
        Matcher mopt = PATTERN_ATTR_OPT.matcher(attribute);
        if (mopt.matches()) {
            return mopt.group(1);
        }
        return attribute;
    }

    private List<String> filterAndStripOptionFromValues(String attribute, Object rawValues) {
        Matcher mopt = PATTERN_ATTR_OPT.matcher(attribute);
        ArrayList<String> values = new ArrayList<String>();
        if (mopt.matches()) {
            String option = mopt.group(2);
            if (rawValues instanceof String && ((String)rawValues).toLowerCase().startsWith(option.toLowerCase() + ";")) {
                values.add(((String)rawValues).replaceAll("(?i)" + option + ";", ""));
            } else if (rawValues instanceof List) {
                for (Object rawValue : (List)rawValues) {
                    if (!((String)rawValue).toLowerCase().startsWith(option.toLowerCase() + ";")) continue;
                    values.add(((String)rawValue).replaceAll("(?i)" + option + ";", ""));
                }
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(String entity, Map<String, Map<String, Object>> attributes, Optional<String> template) throws LscServiceException {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("attrs", attributes);
        if (template.isPresent()) {
            payload.put("template", template.get());
        }
        WebTarget currentTarget = this.target.path(OBJECTS).path(entity);
        try (Response response = null;){
            response = this.httpPost(currentTarget, Entity.entity(payload, "application/json"));
            response.readEntity(String.class);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modify(String entity, String dn, Map<String, Map<String, Object>> updateAttributes, List<String> deleteAttributes) throws LscServiceException {
        if (updateAttributes.size() > 0) {
            WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn);
            try (Response response = null;){
                response = this.httpPatch(currentTarget, Entity.entity(updateAttributes, "application/json"));
            }
        }
        for (String deleteAttr : deleteAttributes) {
            Response response = null;
            try {
                WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn).path(deleteAttr);
                response = this.httpDelete(currentTarget);
                response.readEntity(String.class);
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String entity, String dn) throws LscServiceException {
        LOGGER.debug(String.format("Deleting %s with dn=%s", entity, dn));
        WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn);
        try (Response response = null;){
            response = this.httpDelete(currentTarget);
        }
        return true;
    }

    private List<Tab> getEntityTabs(String dn, String entity) throws LscServiceException {
        try (Response response = null;){
            WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn);
            response = this.httpGet(currentTarget);
            List<Tab> list = Arrays.asList((Tab[])this.mapper.readValue(response.readEntity(String.class), Tab[].class));
            return list;
        }
    }

    public List<String> getAttribute(String entity, String dn, String attribute) throws LscServiceException {
        ArrayList<String> results = new ArrayList<String>();
        ObjectMapper mapper = new ObjectMapper();
        try (Response response = null;){
            WebTarget currentTarget = this.target.path(OBJECTS).path(entity);
            currentTarget = currentTarget.queryParam("base", dn);
            currentTarget = currentTarget.queryParam("attrs[" + attribute + "]", "*");
            response = this.httpGet(currentTarget);
            ObjectNode root = (ObjectNode)mapper.readTree(response.readEntity(String.class));
            Iterator iter = root.fields();
            if (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Iterator iter2 = ((JsonNode)entry.getValue()).fields();
                while (iter2.hasNext()) {
                    Map.Entry entry2 = (Map.Entry)iter2.next();
                    ArrayNode attributes = (ArrayNode)entry2.getValue();
                    attributes.forEach(jsonNode -> results.add(jsonNode.asText()));
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String entity, String dn, String tab, String attribute, List<String> values, boolean isMultiple) throws LscServiceException {
        List<String> payload = isMultiple ? values : "\"" + values.get(0) + "\"";
        WebTarget currentTarget = this.target.path(OBJECTS).path(entity).path(dn).path(tab).path(attribute);
        try (Response response = null;){
            response = this.httpPut(currentTarget, Entity.entity(payload, "application/json"));
        }
    }
}

