/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.plugins.connectors.fusiondirectory;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.lsc.LscDatasets;
import org.lsc.LscModifications;
import org.lsc.beans.IBean;
import org.lsc.configuration.PluginConnectionType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryAbstractService;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryDao;
import org.lsc.plugins.connectors.fusiondirectory.generated.ServiceSettings;
import org.lsc.service.IWritableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionDirectoryDstService
extends FusionDirectoryAbstractService
implements IWritableService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionDirectoryDstService.class);

    public FusionDirectoryDstService(TaskType task) throws LscServiceConfigurationException {
        try {
            if (task.getPluginDestinationService().getAny() == null || task.getPluginDestinationService().getAny().size() != 1 || !(task.getPluginDestinationService().getAny().get(0) instanceof ServiceSettings)) {
                throw new LscServiceConfigurationException("Unable to identify the " + this.getClass().toString() + " configuration settings inside task: " + task.getName());
            }
            ServiceSettings settings = (ServiceSettings)((Object)task.getPluginDestinationService().getAny().get(0));
            PluginConnectionType connection = (PluginConnectionType)task.getPluginDestinationService().getConnection().getReference();
            if (connection == null) {
                throw new LscServiceConfigurationException("Unable to identify the " + this.getClass().toString() + " connection settings inside task: " + task.getName());
            }
            this.beanClass = Class.forName(task.getBean());
            this.dao = new FusionDirectoryDao(connection.getUrl(), connection.getUsername(), connection.getPassword(), settings.getSessionLifetime(), this.getStringParameter(settings.getDirectory()));
            this.entity = settings.getEntity();
            this.pivot = this.getStringParameter(settings.getPivot());
            this.base = this.getStringParameter(settings.getBase());
            this.filter = this.getStringParameter(settings.getFilter());
            this.allFilter = this.getStringParameter(settings.getAllFilter());
            this.oneFilter = this.getStringParameter(settings.getOneFilter());
            this.cleanFilter = this.getStringParameter(settings.getCleanFilter());
            this.template = this.getStringParameter(settings.getTemplate());
            this.attributesSettings = settings.getAttributes();
        }
        catch (Exception e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public IBean getBean(String pivotValue, LscDatasets lscDatasets, boolean fromSameService) throws LscServiceException {
        LOGGER.debug(String.format("Call to getBean(%s, %s, %b)", pivotValue, lscDatasets, fromSameService));
        String pivotName = this.getPivotName();
        try {
            Optional<Map.Entry<String, LscDatasets>> entity = this.findFirstByPivots(lscDatasets, false);
            if (entity.isPresent()) {
                String dn = entity.get().getValue().getStringValueAttribute("dn");
                Map<String, Object> details = this.getDetails(dn);
                IBean bean = (IBean)this.beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bean.setMainIdentifier(entity.get().getValue().getStringValueAttribute(pivotName));
                LscDatasets datasets = new LscDatasets();
                details.entrySet().stream().forEach(entry -> datasets.put((String)entry.getKey(), entry.getValue() == null ? new LinkedHashSet() : entry.getValue()));
                bean.setDatasets(datasets);
                return bean;
            }
            return null;
        }
        catch (ProcessingException | WebApplicationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(String.format("Exception while getting bean %s/%s (%s)", pivotName, pivotValue, e));
            LOGGER.error(e.toString(), (Throwable)e);
            throw new LscServiceException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + String.valueOf(e) + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException((Exception)e);
        }
    }

    public boolean apply(LscModifications lm) throws LscServiceException {
        try {
            switch (lm.getOperation()) {
                case CHANGE_ID: {
                    LOGGER.warn("Trying to change ID of a fusiondirectory object, impossible operation, ignored.");
                    return true;
                }
                case CREATE_OBJECT: {
                    LOGGER.debug("Creating fusiondirectory object with: " + String.valueOf(lm.getModificationsItemsByHash()));
                    return this.create(lm.getModificationsItemsByHash());
                }
                case UPDATE_OBJECT: {
                    LOGGER.debug("Modifying fusiondirectory object: " + lm.getMainIdentifier() + " with: " + String.valueOf(lm.getModificationsItemsByHash()));
                    return this.modify(lm.getMainIdentifier(), lm.getModificationsItemsByHash());
                }
                case DELETE_OBJECT: {
                    LOGGER.debug("Deleting fusiondirectory object: " + lm.getMainIdentifier());
                    return this.delete(lm.getMainIdentifier());
                }
            }
            LOGGER.error(String.format("Unknown operation %s", lm.getOperation()));
            return false;
        }
        catch (ProcessingException e) {
            LOGGER.error(String.format("ProcessingException while writing (%s)", e));
            LOGGER.debug(e.toString(), (Throwable)e);
            return false;
        }
    }

    public List<String> getWriteDatasetIds() {
        return this.getAttributes().getString();
    }
}

