/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.plugins.connectors.fusiondirectory;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import org.lsc.LscDatasets;
import org.lsc.beans.IBean;
import org.lsc.configuration.PluginConnectionType;
import org.lsc.configuration.TaskType;
import org.lsc.exception.LscServiceConfigurationException;
import org.lsc.exception.LscServiceException;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryAbstractService;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryDao;
import org.lsc.plugins.connectors.fusiondirectory.generated.ServiceSettings;
import org.lsc.service.IService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionDirectorySrcService
extends FusionDirectoryAbstractService
implements IService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(FusionDirectorySrcService.class);

    public FusionDirectorySrcService(TaskType task) throws LscServiceConfigurationException {
        try {
            if (task.getPluginSourceService().getAny() == null || task.getPluginSourceService().getAny().size() != 1 || !(task.getPluginSourceService().getAny().get(0) instanceof ServiceSettings)) {
                throw new LscServiceConfigurationException("Unable to identify the fusiondirectory service configuration inside the plugin source node of the task: " + task.getName());
            }
            ServiceSettings settings = (ServiceSettings)((Object)task.getPluginSourceService().getAny().get(0));
            PluginConnectionType connection = (PluginConnectionType)task.getPluginSourceService().getConnection().getReference();
            if (connection == null) {
                throw new LscServiceConfigurationException("Unable to identify the " + this.getClass().toString() + " connection settings inside task: " + task.getName());
            }
            this.beanClass = Class.forName(task.getBean());
            this.dao = new FusionDirectoryDao(connection.getUrl(), connection.getUsername(), connection.getPassword(), settings.getSessionLifetime(), this.getStringParameter(settings.getDirectory()));
            this.entity = settings.getEntity();
            this.pivot = this.getStringParameter(settings.getPivot());
            this.base = this.getStringParameter(settings.getBase());
            this.filter = this.getStringParameter(settings.getFilter());
            this.allFilter = this.getStringParameter(settings.getAllFilter());
            this.oneFilter = this.getStringParameter(settings.getOneFilter());
            this.cleanFilter = this.getStringParameter(settings.getCleanFilter());
            this.template = this.getStringParameter(settings.getTemplate());
            this.attributesSettings = settings.getAttributes();
        }
        catch (Exception e) {
            throw new LscServiceConfigurationException(e);
        }
    }

    public IBean getBean(String pivotRawValue, LscDatasets lscDatasets, boolean fromSameService) throws LscServiceException {
        LOGGER.debug(String.format("Call to getBean(%s, %s, %b)", pivotRawValue, lscDatasets, fromSameService));
        if (lscDatasets.getAttributesNames().size() < 1) {
            return null;
        }
        if (fromSameService) {
            return this.getBeanFromSameService(pivotRawValue, lscDatasets.getStringValueAttribute("dn"));
        }
        return this.getBeanForClean(lscDatasets.getStringValueAttribute(this.getPivotName()), lscDatasets);
    }

    private IBean getBeanFromSameService(String pivotValue, String dn) throws LscServiceException {
        if (dn == null) {
            return null;
        }
        try {
            Map<String, Object> entity = this.getDetails(dn);
            IBean bean = (IBean)this.beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            bean.setMainIdentifier(pivotValue);
            LscDatasets datasets = new LscDatasets();
            entity.entrySet().stream().forEach(entry -> datasets.put((String)entry.getKey(), entry.getValue() == null ? new LinkedHashSet() : entry.getValue()));
            bean.setDatasets(datasets);
            return bean;
        }
        catch (NotFoundException e) {
            LOGGER.debug(String.format("dn %s not found", dn));
            return null;
        }
        catch (ProcessingException | WebApplicationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(String.format("Exception while getting bean with dn %s (%s)", dn, e));
            LOGGER.error(e.toString(), (Throwable)e);
            throw new LscServiceException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + String.valueOf(e) + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException((Exception)e);
        }
    }

    private IBean getBeanForClean(String pivotValue, LscDatasets pivots) throws LscServiceException {
        String pivotName = this.getPivotName();
        try {
            Optional<Map.Entry<String, LscDatasets>> entity = this.findFirstByPivots(pivots, true);
            if (entity.isPresent()) {
                IBean bean = (IBean)this.beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                bean.setMainIdentifier(entity.get().getKey().toString());
                bean.setDatasets(entity.get().getValue());
                return bean;
            }
            return null;
        }
        catch (NotFoundException e) {
            LOGGER.debug(String.format("%s %s not found", pivotName, pivotValue));
            return null;
        }
        catch (ProcessingException | WebApplicationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.error(String.format("Exception while getting bean %s/%s (%s)", pivotName, pivotValue, e));
            LOGGER.error(e.toString(), (Throwable)e);
            throw new LscServiceException(e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error("Bad class name: " + this.beanClass.getName() + "(" + String.valueOf(e) + ")");
            LOGGER.debug(e.toString(), (Throwable)e);
            throw new LscServiceException((Exception)e);
        }
    }
}

