/*
 * Decompiled with CFR 0.152.
 */
package org.lsc.plugins.connectors.fusiondirectory.utils;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.lsc.exception.LscServiceException;
import org.lsc.plugins.connectors.fusiondirectory.FusionDirectoryDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionDirectoryAPI {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionDirectoryAPI.class);
    private FusionDirectoryDao dao;

    public FusionDirectoryAPI() {
        LOGGER.info("starting FD API utils !");
    }

    public void connect(String endpoint, String username, String password) throws LscServiceException {
        this.connect(endpoint, username, password, -1);
    }

    public void connect(String endpoint, String username, String password, int sessionLifetime) throws LscServiceException {
        this.connect(endpoint, username, password, sessionLifetime, null);
    }

    public synchronized void connect(String endpoint, String username, String password, int sessionLifetime, String directory) throws LscServiceException {
        if (this.dao == null) {
            LOGGER.debug(" connect to " + endpoint + " as " + username + " with sslt " + sessionLifetime + " and dir " + directory);
            this.dao = new FusionDirectoryDao(endpoint, username, password, sessionLifetime, Optional.ofNullable(directory));
        }
    }

    public List<String> search(String entity) throws LscServiceException {
        return this.search(entity, null);
    }

    public List<String> search(String entity, String baseString) throws LscServiceException {
        return this.search(entity, baseString, null);
    }

    public List<String> search(String entity, String baseString, String filterString) throws LscServiceException {
        Optional<String> base = Optional.ofNullable(baseString).filter(f -> !f.trim().isEmpty());
        Optional<String> filter = Optional.ofNullable(filterString).filter(f -> !f.trim().isEmpty());
        ArrayList<String> results = new ArrayList<String>();
        ObjectNode root = this.dao.getList(entity, base, Optional.empty(), filter);
        if (root != null) {
            Iterator iter = root.fields();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                results.add((String)entry.getKey());
            }
        }
        return results;
    }

    public List<String> getAttribute(String entity, String dn, String attribute) throws LscServiceException {
        return this.dao.getAttribute(entity, dn, attribute);
    }

    public void setAttribute(String entity, String dn, String tab, String attribute, String value) throws LscServiceException {
        this.setAttribute(entity, dn, tab, attribute, Arrays.asList(value), false);
    }

    public void setAttribute(String entity, String dn, String tab, String attribute, List<String> values) throws LscServiceException {
        this.setAttribute(entity, dn, tab, attribute, values, true);
    }

    private void setAttribute(String entity, String dn, String tab, String attribute, List<String> values, boolean isMultiple) throws LscServiceException {
        this.dao.setAttribute(entity, dn, tab, attribute, values, isMultiple);
    }
}

